<?php $__env->startSection('content'); ?>
<style>
    .is-invalid {
        border-color: #dc3545;
    }
    .error-message {
        margin-top: 2px;
        font-size: 15px;
        color: #dc3545;
    }
    .day-row {
        margin-bottom: 15px;
    }
    .time-inputs {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .table-abcent-list table {
        width: 100%;
        border-collapse: collapse;
    }
    .table-abcent-list tr {
        border-bottom: 1px solid #eee;
    }
    .table-abcent-list td {
        padding: 10px;
        vertical-align: middle;
    }
    .abcent-name {
        font-weight: bold;
        width: 30%;
    }
    .abcent-date {
        width: 25%;
    }
    .abcent-total {
        width: 25%;
    }
    .delete-last {
        width: 20%;
        text-align: right;
    }
    .delete-ico, .edit-ico {
        color: #dc3545;
        cursor: pointer;
        display: inline-block;
        padding: 5px;
    }
    .edit-ico {
        color: #0d6efd;
    }
    .delete-ico:hover {
        color: #c82333;
    }
    .edit-ico:hover {
        color: #0b5ed7;
    }
    .add-holiday-modal .modal-content {
        border-radius: 10px;
    }
    .add-holiday-modal .modal-header {
        border-bottom: 1px solid #dee2e6;
        padding: 1rem;
    }
    .add-holiday-modal .modal-body {
        padding: 1.5rem;
    }
    .password-toggle {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
    }
    .password-input-container {
        position: relative;
    }

</style>

<div class="col-9 main-dash-left">
    <div class="name-head">
        <h2>Add New SPO</h2>
    </div>
    
    <div class="add-user-form sora-font SPO-mang sora-font">
        <form class="validation row g-3" method="POST" action="<?php echo e(route('admin.spo.store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            
            <div class="col-md-12">
                <h4 class="mb-3">Basic Information</h4>
            </div>
            
            <div class="col-md-12">
                <div class="profile-pic">
                    <label class="-label" for="file">
                        <span class="glyphicon glyphicon-camera"><i class="fas fa-camera"></i></span>
                    </label>
                    <input name="profile_image" type="file" id="file" accept="image/*" class="form-control" onchange="previewImage(event)">
                    <figure class="profile-img"><img id="preview" src="<?php echo e(asset('admin/images/profile.png')); ?>" alt=""></figure>
                    <div id="profile_image_error" class="error-message"></div>
                </div>
            </div>
            
            <div class="col-md-1">
                <div class="comn-input-select">
                    <label for="title" class="form-label">Title*</label>
                    <select id="title" class="form-select required" name="title" >
                        <option value="mr">Mr.</option>
                        <option value="mrs">Mrs.</option>
                        <option value="ms">Ms.</option>
                    </select>
                </div>
            </div>
            

            <div class="col-md-5">
                <div class="comn-input-select">
                    <label for="first_name" class="form-label">First Name*</label>
                    <input type="text" class="form-control required" placeholder="First Name" id="first_name" name="first_name" value="<?php echo e(old('first_name')); ?>">
                    <div id="first_name_error" class="error-message"></div>
                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="last_name" class="form-label">Last Name*</label>
                    <input type="text" class="form-control required" placeholder="Last Name" id="last_name" name="last_name"  value="<?php echo e(old('last_name')); ?>">
                    <div id="last_name_error" class="error-message"></div>
                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            
            <div class="col-md-6 password-input-container">
                <div class="comn-input-select">
                    <label for="password" class="form-label">Create Password</label>
                    <input type="password" class="form-control required" id="password" placeholder="Enter Your Password" name="password"  value="<?php echo e(old('password')); ?>">
                    <i class="fas fa-eye password-toggle" onclick="togglePassword('password')"></i>
                    <div id="password_error" class="error-message"></div>
                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6 password-input-container">
                <div class="comn-input-select">
                    <label for="password_confirmation" class="form-label">Confirm Password*</label>
                    <input type="password" class="form-control required" id="password_confirmation" placeholder="enter Confirm Password" name="password_confirmation" >
                    <i class="fas fa-eye password-toggle" onclick="togglePassword('password_confirmation')"></i>
                    <div id="password_confirmation_error" class="error-message"></div>
                </div>
            </div>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3">Contact Information</h4>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="street" class="form-label">Street, House Number*</label>
                    <input type="text" class="form-control required" placeholder="Enter Street, House Number" id="street" name="street"  value="<?php echo e(old('street')); ?>">
                    <div id="street_error" class="error-message"></div>
                    <?php $__errorArgs = ['street'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="zip_code" class="form-label">Zip Code*</label>
                    <input type="text" class="form-control required" id="zip_code" placeholder="Select zip Code" name="zip_code" value="<?php echo e(old('zip_code')); ?>">
                    <div id="zip_code_error" class="error-message"></div>
                    <?php $__errorArgs = ['zip_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="city" class="form-label">City*</label>
                    <input type="text" class="form-control required" id="city" name="city" placeholder="Enter City"  value="<?php echo e(old('city')); ?>">
                    <div id="city_error" class="error-message"></div>
                    <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="country" class="form-label">Country*</label>
                    <select id="country" class="form-select required" name="country"  value="<?php echo e(old('country')); ?>">
                        <option value="Germany">Germany</option>
                        <option value="Austria">Austria</option>
                        <option value="Switzerland">Switzerland</option>
                    </select>
                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="email" class="form-label">Email Address*</label>
                    <input type="email" class="form-control required" id="email" placeholder="Enter Email Address" name="email" value="<?php echo e(old('email')); ?>">
                    <div id="email_error" class="error-message"></div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="phone" class="form-label">Phone Number*</label>
                    <div class="numer-input d-flex">
                        <select name="country_code" class="form-select country_code_custom required"  id="country_code">
                            <option value="+49" data-image="https://flagcdn.com/16x12/de.png"  >+49</option>
                            <option value="+43" data-image="https://flagcdn.com/16x12/at.png" >+43</option>
                            <option value="+41"  data-image="https://flagcdn.com/16x12/ch.png">+41</option>
                        </select>
                            
                        <input type="text" class="form-control required" id="phone" aria-placeholder="Enter Phone Number" name="number" placeholder="Phone number" value="<?php echo e(old('number')); ?>">
                    </div>
                    <div id="phone_error" class="error-message"></div>
                    <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3">Business Information</h4>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="business_type" class="form-label">Business Type*</label>
                    <select id="business_type" class="form-select required" name="business_type" >
                        <option value="Own Location">Own Location</option>
                        <option value="Franchiser">Franchiser</option>
                        <option value="Partner">Partner</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="business_model" class="form-label">Business Model*</label>
                    <select id="business_model" class="form-select required" name="business_model" >
                        <option value="Fulltimer">Fulltimer</option>
                        <option value="Side Business">Side Business</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="contact_person" class="form-label">Name of the Contract Person*</label>
                    <select id="business_type" class="form-select required" name="contact_person" >
                        <option value="Franchiser">Franchiser</option>
                        <option value="Partner">Partner</option>
                        <option value="Test Location">Test Location</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="size_of_location" class="form-label">Size of Location*</label>
                    <select id="size_of_location" class="form-select required" name="size_of_location" >
                        <option value="Beginner">Beginner</option>
                        <option value="Small (> 5)">Small (> 5)</option>
                        <option value="Middle (6 - 15)">Middle (6 - 15)</option>
                        <option value="Large (16-35)">Large (16-35)</option>
                        <option value="XXL (>30)">XXL (>30)</option>
                    </select>
                </div>
            </div>
            
         
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3">Tax & Banking Information</h4>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="tax_number" class="form-label">Tax Number*</label>
                    <input type="text" class="form-control " id="tax_number" placeholder="Enter Tax Number" name="tax_number" value="<?php echo e(old('tax_number')); ?>">
                    <div id="tax_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['tax_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="tax_id" class="form-label">Tax ID (UMSt.-ID)*</label>
                    <input type="text" class="form-control required" id="tax_id" placeholder="Enter Tax ID" name="tax_id" pattern="^.{11}$" maxlength="11" value="<?php echo e(old('tax_id')); ?>">
                    <div id="tax_id_error" class="error-message"></div>
                    <?php $__errorArgs = ['tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="bank_name" class="form-label">Bank Name*</label>
                    <input type="text" class="form-control required" id="bank_name" placeholder="Enter Bank Name" name="bank_name" value="<?php echo e(old('bank_name')); ?>">
                    <div id="bank_name_error" class="error-message"></div>
                    <?php $__errorArgs = ['bank_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="account_owner" class="form-label">Bank Account Owner*</label>
                    <input type="text" class="form-control required" id="account_owner" placeholder="Enter Bank Account Owner" name="account_owner" value="<?php echo e(old('account_owner')); ?>">
                    <div id="account_owner_error" class="error-message"></div>
                    <?php $__errorArgs = ['account_owner'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="account_number" class="form-label">Bank Account Number*</label>
                    <input type="text" class="form-control required" id="account_number" placeholder="Enter Bank Account Number" name="account_number" value="<?php echo e(old('account_number')); ?>">
                    <div id="account_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="bic_number" class="form-label">BIC Number*</label>
                    <input type="text" class="form-control required" id="bic_number" placeholder="Enter BIC Number" name="bic_number" value="<?php echo e(old('bic_number')); ?>">
                    <div id="bic_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['bic_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="iban_number" class="form-label">IBAN Number*</label>
                    <input type="text" class="form-control required" id="iban_number" placeholder="Enter IBAN" name="iban_number" value="<?php echo e(old('iban_number')); ?>">
                    <div id="iban_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['iban_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="backend-error-message"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3">Working Hours</h4>
            </div>
            
            <?php
                $days = ['mo' => 'Monday', 'di' => 'Tuesday', 'mi' => 'Wednesday', 
                         'do' => 'Thursday', 'fr' => 'Friday', 'sa' => 'Saturday', 'so' => 'Sunday'];
            ?>
            
            <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $short => $full): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-12 day-row">
                <div class="d-flex align-items-center gap-3">
                    <div class="form-check">
                        <label class="form-check-label" for="closed_<?php echo e($short); ?>">
                            <?php echo e($full); ?>

                        </label>
                    </div>
                    
                    <div class="time-inputs">
                        <input type="time" class="form-control <?php echo e($short); ?>_from" name="<?php echo e($short); ?>_from">
                        <span>to</span>
                        <input type="time" class="form-control <?php echo e($short); ?>_to" name="<?php echo e($short); ?>_to">
                    </div>
                    <div class="form-check">
                        <input class="form-check-input day-closed" type="checkbox" name="days_closed[]" value="<?php echo e($short); ?>" id="closed_<?php echo e($short); ?>">
                        <label class="form-check-label" for="closed_<?php echo e($short); ?>">
                            Closed
                        </label>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3">Holidays/Absent Days</h4>
                
                <div class="abcent-days">
                    <div class="head-abcent-days">
                        <button class="add-notification-btn" type="button" data-bs-toggle="modal"
                            data-bs-target="#holidayModal">Add Holiday</button>
                    </div>
                    
                    <div class="table-abcent-list">
                        <table id="holidaysTable">
                            <tr id="noHolidaysRow">
                                <td colspan="4" class="text-center">No Holidays Available</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col-12 mt-4">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Create SPO</button>
                    <button type="button" class="cancel-btn" onclick="window.history.back()">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal add-holiday-modal fade" id="holidayModal" tabindex="-1" aria-labelledby="holidayModalLabel"
    aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title" id="holidayModalLabel">Add Holiday</h1>
            </div>
            <div class="modal-body">
                <form id="holidayForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="edit_holiday_id" value="">
                    <div class="mb-3 comn-input-select">
                        <label for="holiday_name" class="col-form-label">Holiday Name*</label>
                        <input type="text" class="form-control" id="holiday_name" name="holiday_name" >
                        <div id="holiday_name_error" class="error-message"></div>
                    </div>
                    <div class="mb-3 comn-input-select">
                        <label for="holiday_date" class="col-form-label">Date*</label>
                        <input class="form-control" id="holiday_date" type="date" name="holiday_date" >
                        <div id="holiday_date_error" class="error-message"></div>
                    </div>
                    <div class="upper-main-btn-last-comn d-flex">
                        <button type="button" class="add-user" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="cancel-btn" id="saveHoliday">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
<script>
    let holidays = [];
    let editingHolidayId = null;

    $(document).ready(function() {
       

        $('.day-closed').change(function() {
            const dayPrefix = $(this).val();
            const isClosed = $(this).is(':checked');
            
            $(`.${dayPrefix}_from, .${dayPrefix}_to`).prop('disabled', isClosed);
            
            if (isClosed) {
                $(`.${dayPrefix}_from, .${dayPrefix}_to`).val('');
            }
        });

        $('#holidayModal').on('hidden.bs.modal', function() {
            $('#holidayForm')[0].reset();
            $('#edit_holiday_id').val('');
            editingHolidayId = null;
            clearHolidayErrors();
        });

        $('#saveHoliday').click(function() {
            const holidayName = $('#holiday_name').val();
            const holidayDate = $('#holiday_date').val();
            
            clearHolidayErrors();
            
            if (!holidayName) {
                $('#holiday_name_error').text('Please enter holiday name');
                return;
            }
            
            if (!holidayDate) {
                $('#holiday_date_error').text('Please select holiday date');
                return;
            }

            if (editingHolidayId) {
                const index = holidays.findIndex(h => h.id == editingHolidayId);
                if (index !== -1) {
                    holidays[index] = {
                        id: editingHolidayId,
                        name: holidayName,
                        date: holidayDate
                    };
                }
            } else {
                holidays.push({
                    name: holidayName,
                    date: holidayDate,
                    id: Date.now()
                });
            }

            updateHolidaysTable();
            $('#holidayModal').modal('hide');
        });

        updateHolidaysTable();
    });

    function updateHolidaysTable() {
        const table = $('#holidaysTable');
        const noHolidaysRow = $('#noHolidaysRow');
        
        table.find('tr:not(#noHolidaysRow)').remove();
        
        if (holidays.length === 0) {
            noHolidaysRow.show();
            return;
        }
        
        noHolidaysRow.hide();
        
        holidays.forEach(holiday => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            
            const holidayDate = new Date(holiday.date + 'T00:00:00');
            holidayDate.setHours(0, 0, 0, 0);
            
            const timeDiff = holidayDate - today;
            const daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));
            
            const daysLeftText = daysLeft > 0 ? `in ${daysLeft} Tagen` : 
                            daysLeft === 0 ? "Today" : 
                            `vor ${Math.abs(daysLeft)} Tagen`;
            
            const formattedDate = holidayDate.toLocaleDateString('de-DE', {
                weekday: 'short',
                day: '2-digit',
                month: '2-digit',
                year: 'numeric'
            }).replace(/\//g, '.');
            
            const row = $(`
                <tr data-id="${holiday.id}">
                    <td class="abcent-name">${holiday.name}</td>
                    <td class="abcent-date" data-date="${holiday.date}">${formattedDate}</td>
                    <td class="abcent-total">${daysLeftText}</td>
                    <td class="delete-last">
                        <div class="edit-ico" data-id="${holiday.id}">
                            <i class="fas fa-edit" data-id="${holiday.id}"></i>
                        </div>
                        <div class="delete-ico" data-id="${holiday.id}">
                            <i class="fa-solid fa-trash" data-id="${holiday.id}"></i>
                        </div>
                    </td>
                </tr>
            `);
            
            table.append(row);
        });
        
        $('.delete-ico').click(function() {
            const holidayId = parseInt($(this).data('id'));
            holidays = holidays.filter(h => h.id !== holidayId);
            updateHolidaysTable();
        });
        
        $('.edit-ico').click(function() {
            const holidayId = parseInt($(this).data('id'));
            const holiday = holidays.find(h => h.id === holidayId);
            
            if (holiday) {
                editingHolidayId = holidayId;
                $('#edit_holiday_id').val(holidayId);
                $('#holiday_name').val(holiday.name);
                $('#holiday_date').val(holiday.date);
                $('#holidayModalLabel').text('Edit Holiday');
                $('#holidayModal').modal('show');
            }
        });
    }

    function clearHolidayErrors() {
        $('#holiday_name_error').text('');
        $('#holiday_date_error').text('');
    }

    function togglePassword(fieldId) {
        const field = document.getElementById(fieldId);
        const icon = field.nextElementSibling;
        
        if (field.type === 'password') {
            field.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            field.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }

    function previewImage(event) {
        const input = event.target;
        const file = input.files[0];
        const preview = document.getElementById('preview');
        
        if (file) {
            const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/jpg'];
            
            if (!validTypes.includes(file.type)) {
                $('#profile_image_error').text('Please select a valid image file (jpg, jpeg, png, gif, webp)');
                input.value = '';
                preview.src = "<?php echo e(asset('admin/images/profile.png')); ?>";
                return;
            }
            
            $('#profile_image_error').text('');
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    }

    $(document).ready(function() {
        $('.required').on('input', function() {
            const fieldId = $(this).attr('id');
            console.log(fieldId);
            const errorElement = $(`#${fieldId}_error`);
            
            if ($(this).val().trim() === '') {
                $(this).addClass('is-invalid');
                errorElement.text(`Please enter ${$(this).attr('placeholder') || fieldId.replace('_', ' ')}`);
            } else {
                $(this).removeClass('is-invalid');
                errorElement.text('');
                
                if (fieldId === 'tax_id' && $(this).val().length !== 11) {
                    $(this).addClass('is-invalid');
                    errorElement.text('Tax ID must be exactly 11 characters');
                }
                
                if (fieldId === 'password' && $(this).val().length < 8) {
                    $(this).addClass('is-invalid');
                    errorElement.text('Password must be at least 8 characters');
                }
                
                if (fieldId === 'password_confirmation' && $(this).val() !== $('#password').val()) {
                    $(this).addClass('is-invalid');
                    errorElement.text('Passwords do not match');
                }
            }
        });

        $('#password').on('input', function() {
            if ($('#password_confirmation').val() && $('#password_confirmation').val() !== $(this).val()) {
                $('#password_confirmation').addClass('is-invalid');
                $('#password_confirmation_error').text('Passwords do not match');
            } else {
                $('#password_confirmation').removeClass('is-invalid');
                $('#password_confirmation_error').text('');
            }
        });

        $('form.validation').on('submit', function(e) {
            let isValid = true;
            
            $('.required').each(function() {
                const fieldId = $(this).attr('id');
                const errorElement = $(`#${fieldId}_error`);
                
                if ($(this).val().trim() === '') {
                    $(this).addClass('is-invalid');
                    errorElement.text(`Please enter ${$(this).attr('placeholder') || fieldId.replace('_', ' ')}`);
                    isValid = false;
                }
            });

            if ($('#password').val() !== $('#password_confirmation').val()) {
                $('#password_confirmation').addClass('is-invalid');
                $('#password_confirmation_error').text('Passwords do not match');
                isValid = false;
            }

            if ($('#password').val().length < 8) {
                $('#password').addClass('is-invalid');
                $('#password_error').text('Password must be at least 8 characters');
                isValid = false;
            }

            if ($('#tax_id').val().length !== 11) {
                $('#tax_id').addClass('is-invalid');
                $('#tax_id_error').text('Tax ID must be exactly 11 characters');
                isValid = false;
            }

            if (!isValid) {
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $('.is-invalid').first().offset().top - 100
                }, 500);
            } else {
                holidays.forEach((holiday, index) => {
                    $(this).append(
                        `<input type="hidden" name="holidays[${index}][name]" value="${holiday.name}">` +
                        `<input type="hidden" name="holidays[${index}][date]" value="${holiday.date}">`
                    );
                });
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/spo/create.blade.php ENDPATH**/ ?>