<!DOCTYPE html>
<html>
<head>
    <title>Bookings Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Bookings Report</h1>
        <div class="filter-info">
            <strong>Time Filter:</strong> <?php echo e(ucfirst($timeFilter)); ?> |
            <strong>Status Filter:</strong> <?php echo e($statusFilter === 'all' ? 'All Statuses' : ucfirst($statusFilter)); ?> |
            <strong>Vendor Filter:</strong> <?php echo e($vendorFilter === null ? 'Admin' : ucfirst($selectedVendor->first_name . ' ' . $selectedVendor->last_name )); ?>

        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Invoice #</th>
                <th>Customer Name</th>
                <th>Car</th>
                <th>Roof Type</th>
                <th>Trailer Hitch</th>
                <th>Product</th>
                <th>Color</th>
                <th>Size/Variation</th>
                <th>Insured Included</th>
                <th>Carrier Length</th>
                <th>Foot SKU</th>
                <th>Foot Kit SKU</th>
                <th>Pickup Date/Time</th>
                <th>Dropoff Date/Time</th>
                <th>New Dropoff Date/Time</th>
                
               
            </tr>
        </thead>
        
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>#<?php echo e($booking->id); ?></td>
                        <td><?php echo e($booking->invoice_number ?? 'N/A'); ?></td>
                        <td><?php echo e($booking->userDetails->first_name ?? ''); ?> <?php echo e($booking->userDetails->last_name ?? ''); ?></td>
                        <td><?php echo e($item->car_name); ?> <?php echo e($item->car_year); ?> <?php echo e($item->model); ?></td>
                        <td><?php echo e($item->roof_type); ?> </td>
                        <td><?php echo e($item->trailer_hitch ? 'Yes' : 'No'); ?> </td>

                        <td><?php echo e($item->product_name); ?></td>
                        <td><?php echo e($item->color); ?></td>
                        <td><?php echo e($item->size); ?></td>
                        <td><?php echo e($item->is_insured ? 'Yes' : 'No'); ?></td>
                        <td><?php echo e($item->carrier_length); ?></td>
                        <td><?php echo e($item->foot_sku); ?></td>
                        <td><?php echo e($item->footkit_sku); ?></td>
                        <td>
                            <?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y')); ?> -  <?php echo e(\Carbon\Carbon::parse($item->first()->pickup_time)->format('H:i')); ?>


                        </td>
                        
                        <td>
                            <?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?> -  <?php echo e(\Carbon\Carbon::parse($item->dropoff_time)->format('H:i')); ?>


                        </td>
                        <td>
                            <?php if($item->new_dropoff_date): ?>
                            <?php echo e(\Carbon\Carbon::parse($item->new_dropoff_date)->format('d.m.Y')); ?> -  <?php echo e(\Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i')); ?>

                            <?php else: ?>
                                 N/A
                             <?php endif; ?>
                        </td>

                      
                       
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/booking/pdf.blade.php ENDPATH**/ ?>