<!DOCTYPE html>
<html>
<head>
    <title>Invoice <?php echo e($invoice_number); ?></title>
    <style>
        body { 
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .header { 
            margin-bottom: 20px;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        .issuer, .recipient { 
            width: 45%; 
            float: left; 
            margin-bottom: 30px; 
        }
        .recipient { 
            float: right; 
        }
        .clear { 
            clear: both; 
        }
        table { 
            width: 100%; 
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 8px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
            font-weight: bold;
        }
        .totals { 
            float: right; 
            width: 300px; 
            margin-top: 20px; 
        }
        .footer { 
            margin-top: 50px; 
            font-size: 10px;
            border-top: 1px solid #eee;
            padding-top: 10px;
        }
        .invoice-title {
            font-size: 24px;
            color: #333;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 class="invoice-title">Invoice <?php echo e($invoice_number); ?></h1>
        <p><strong>Date:</strong> <?php echo e($invoice_date->format('d.m.Y')); ?></p>
    </div>

    <div class="issuer">
        <h3>Issuer:</h3>
        <p><strong><?php echo e($issuer['name']); ?></strong></p>
        <p><?php echo e($issuer['address']); ?></p>
        <p>Tax Number: <?php echo e($issuer['tax_number']); ?></p>
        <p>VAT ID: <?php echo e($issuer['vat_number']); ?></p>
    </div>

    <div class="recipient">
        <h3>Recipient:</h3>
        <p><strong><?php echo e($recipient['name']); ?></strong></p>
        <p><?php echo e($recipient['address']); ?></p>
        <p><?php echo e($recipient['zip']); ?> <?php echo e($recipient['city']); ?></p>
        <p><?php echo e($recipient['country']); ?></p>
        <p>Email: <?php echo e($recipient['email']); ?></p>
        <p>Phone: <?php echo e($recipient['phone']); ?></p>
    </div>

    <div class="clear"></div>

    <h3>Booking Details:</h3>
    <p><strong>Booking Date:</strong> <?php echo e($booking_date->format('d.m.Y H:i')); ?></p>
    <p><strong>Payment Method:</strong> <?php echo e(ucfirst($payment_method)); ?></p>

    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Car Details</th>
                <th>Insurance</th>
                <th>Carrier</th>
                <th>Pickup Date/Time</th>
                <th>Dropoff Date/Time</th>
                <th>Price (€)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $booking_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($item['product_name']); ?> (<?php echo e($item['size']); ?>)</td>
                <td>
                    <?php echo e($item['car_name']); ?> <?php echo e($item['car_year']); ?> <?php echo e($item['model']); ?><br>
                    Color: <?php echo e($item['color']); ?><br>
                    Roof: <?php echo e($item['roof_type']); ?>

                </td>
                <td><?php echo e($item['is_insured'] ? 'Yes' : 'No'); ?></td>
                <td><?php echo e($item['is_carrier_included'] ? 'Yes' : 'No'); ?></td>
                <td><?php echo e(Carbon\Carbon::parse($item['pickup_date'])->format('d.m.y')); ?><br>
                    <?php echo e($item['pickup_time'] ? Carbon\Carbon::parse($item['pickup_time'])->format('H:i') : ''); ?>

                </td>
                <td><?php echo e(Carbon\Carbon::parse($item['dropoff_date'])->format('d.m.y')); ?><br>
                    <?php echo e($item['dropoff_time'] ? Carbon\Carbon::parse($item['dropoff_time'])->format('H:i') : ''); ?>

                </td>
                <td><?php echo e(number_format($item['calculated_rent'], 2, ',', '.')); ?>€</td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="totals">
        <table>
            <tr>
                <td>Subtotal (Net):</td>
                <td><?php echo e(number_format($subtotal, 2, ',', '.')); ?>€</td>
            </tr>
            <?php if($booking->discount > 0): ?>
            <tr>
                <td>Discount:</td>
                <td>-<?php echo e(number_format($booking->discount, 2, ',', '.')); ?>€</td>
            </tr>
            <?php endif; ?>
            <tr>
                <td>VAT (19%):</td>
                <td><?php echo e(number_format($tax, 2, ',', '.')); ?>€</td>
            </tr>
            <tr>
                <td><strong>Total:</strong></td>
                <td><strong><?php echo e(number_format($total, 2, ',', '.')); ?>€</strong></td>
            </tr>
        </table>
    </div>

    <div class="clear"></div>

    <div class="footer">
        <p><strong>Payment Terms:</strong> Payment due immediately upon receipt</p>
        <p><strong>Cancellation Policy:</strong> Free cancellation up to 48 hours before pickup</p>
        <p>Thank you for choosing <?php echo e($issuer['name']); ?>!</p>
    </div>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/payment/invoice/invoice.blade.php ENDPATH**/ ?>