<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">


<div class="notification-block">
    <div class="d-flex justify-content-between align-items-center mb-3 noti-inner">
        <h4 class="mb-0">All Notifications</h4>
        <?php if($notifications->where('is_read', false)->count() > 0): ?>
            <form action="<?php echo e(route('admin.notifications.read.all')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="noti-btn">
                    <i class="fas fa-check-circle me-1"></i> Mark All as Read
                </button>
            </form>
        <?php endif; ?>
    </div>

    <?php if($notifications->isEmpty()): ?>
        <p class="text-muted">No notifications found.</p>
    <?php else: ?>
        <ul class="list-group">
            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item d-flex justify-content-between align-items-start <?php echo e($notification->is_read ? '' : 'fw-bold bg-light'); ?>">
                <img src="<?php echo e($notification->user?->profile_image ? asset('storage/' . $notification->user->profile_image) : asset('frontend/images/default-user.png')); ?>"
                    alt="User"
                    class="rounded-circle me-3"
                    width="50"
                    height="50">
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between align-items-center bk-title">
                            <div>
                                <span class="badge bg-secondary me-2 text-uppercase"><?php echo e($notification->type); ?></span>
                                <?php echo e($notification->title); ?>

                            </div>
                            <?php if(!$notification->is_read): ?>
                                <form method="POST" action="<?php echo e(route('admin.notifications.read', $notification->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-sm btn-outline-success" title="Mark as Read">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>

                        <p class="description">
                            <?php echo e($notification->customer_name); ?> - <?php echo e($notification->customer_email); ?> - <?php echo e($notification->customer_phone); ?>

                        </p>

                        <?php if(is_array($notification->data)): ?>
                            
                            <ul class="bk-details">
                                <?php $__currentLoopData = $notification->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><strong><?php echo e(ucwords(str_replace('_', ' ', $key))); ?>:</strong> <?php echo e($value); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php else: ?>
                            <div class="small text-muted mt-2"><?php echo e($notification->data); ?></div>
                        <?php endif; ?>
                    </div>
                    <small class="time"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        <div class="mt-4">
            <?php echo e($notifications->links()); ?>

        </div>
    <?php endif; ?>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/notifications/index.blade.php ENDPATH**/ ?>