<div class="inner-login vendor">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="<?php echo e(asset('frontend/images/login.png')); ?>" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="<?php echo e(asset('frontend/images/login-logo.png')); ?>" alt="">
                            </div>
                            <h2><?php echo e(__('messages.login_to_your_account')); ?></h2>

                            <h3><?php echo e(__('messages.service_point_operator')); ?></h3>
                        </div>

                        <form method="POST" action="<?php echo e(route('vendor.login.submit')); ?>" class="email-login" id="login-form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-12 inner-main-input">
                                    <label for="email" class="form-label"><?php echo e(__('messages.email_address')); ?></label>
                                    <input id="email" type="text" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('messages.email_placeholder')); ?>">
                                    <div class="invalid-feedback">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php else: ?> <?php echo e(__('messages.please_enter_valid_email_address')); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-md-12 inner-main-input mb-3 position-relative">
                                    <label for="password" class="form-label"><?php echo e(__('messages.password')); ?></label>
                                    <div class="input-pass-show">
                                        <input id="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" placeholder="<?php echo e(__('messages.enter_password')); ?>">
                                        <span class="toggle-password" toggle="#password">
                                            <i class="fa fa-eye-slash"></i>
                                        </span>
                                        <div class="invalid-feedback">
                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php else: ?> <?php echo e(__('messages.please_enter_password')); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="remember-main-marg d-flex">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remember"><?php echo e(__('messages.remember_me')); ?></label>
                                </div>
                                
                            </div>

                            <button type="submit" class="btn primary-btn w-100"><?php echo e(__('messages.login')); ?></button>

                            <p class="not-yet"><?php echo e(__('messages.not_registered_yet')); ?>

                                <a href="<?php echo e(route('vendor.register.view')); ?>"><?php echo e(__('messages.create_an_account')); ?></a>
                            </p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('login-form');
        const emailInput = document.getElementById('email');
        const passwordInput = document.getElementById('password');
    
        // Toggle password visibility
        document.querySelector('.toggle-password').addEventListener('click', function () {
            const input = document.querySelector(this.getAttribute('toggle'));
            const icon = this.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            }
        });
    
        // Simple email format check
        function validateEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }
    
        form.addEventListener('submit', function (e) {
    e.preventDefault();
    let isValid = true;

    emailInput.classList.remove('is-invalid');
    passwordInput.classList.remove('is-invalid');

    // Get feedback elements correctly
    const emailError = emailInput.closest('.inner-main-input').querySelector('.invalid-feedback');
    const passwordError = passwordInput.closest('.input-pass-show').querySelector('.invalid-feedback');

    // Validate email
    if (!emailInput.value.trim()) {
        emailError.textContent =  "<?php echo e(__('messages.please_enter_email_address')); ?>";
        emailInput.classList.add('is-invalid');
        isValid = false;
    } else if (!validateEmail(emailInput.value.trim())) {
        emailError.textContent = "<?php echo e(__('messages.please_enter_valid_email_address')); ?>";
        emailInput.classList.add('is-invalid');
        isValid = false;
    }

    // Validate password
    if (!passwordInput.value.trim()) {
        passwordError.textContent =  "<?php echo e(__('messages.please_enter_password')); ?>";
        passwordInput.classList.add('is-invalid');
        isValid = false;
    }

    if (isValid) {
        form.submit();
    } else {
        const firstInvalid = document.querySelector('.is-invalid');
        if (firstInvalid) {
            firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
            firstInvalid.focus();
        }
    }
});
    
        // Blur event (email)
        emailInput.addEventListener('blur', function () {
    const emailError = this.closest('.inner-main-input').querySelector('.invalid-feedback');
    if (!this.value.trim()) {
        emailError.textContent = "<?php echo e(__('messages.please_enter_email_address')); ?>";
        this.classList.add('is-invalid');
    } else if (!validateEmail(this.value.trim())) {
        emailError.textContent = "<?php echo e(__('messages.please_enter_valid_email_address')); ?>";
        this.classList.add('is-invalid');
    } else {
        this.classList.remove('is-invalid');
    }
});

passwordInput.addEventListener('blur', function () {
    const passwordError = this.closest('.input-pass-show').querySelector('.invalid-feedback');
    if (!this.value.trim()) {
        passwordError.textContent = "<?php echo e(__('messages.please_enter_password')); ?>";
        this.classList.add('is-invalid');
    } else {
        this.classList.remove('is-invalid');
    }
});
    });
</script>

<style>
    .is-invalid {
        border-color: #dc3545 !important;
    }
    .invalid-feedback {
        display: none;
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 0.25rem;
    }
    .is-invalid ~ .invalid-feedback {
        display: block;
    }
    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 0.75rem 1.25rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 0.25rem;
    }
    .alert-danger p {
        margin: 0;
    }
    .input-pass-show .toggle-password i {
    font-family: var(--fa-style-family,"Font Awesome 6 Free") !important;
}
</style>
<?php echo $__env->make('frontend.include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/vendor/auth/login.blade.php ENDPATH**/ ?>