<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('vendor.booking.index')); ?>">Booking management</a>
            <a class="active" href="">View Booking Details </a>
        </div>
        <?php if($booking->payment_status !== 'paid' && 
    (!empty($booking->last_payment_link_sent_at) && now()->diffInHours($booking->last_payment_link_sent_at) >= 24)): ?>
    <div class="mt-4 resend-payment">
        <form action="<?php echo e(route('vendor.booking.resend-payment-link', $booking->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <button type="submit" class="add-notification-btn mb-3">Resend Payment Link</button>
        </form>
    </div>
    <?php endif; ?>
</div>

    <div class="add-user-form">
        <h2 class="head-mian-all-payment">View Booking Details </h2>
        <div class="main-show-detail-viwe">
            <!-- User Details Section -->
            <div class="inner-pack-view">
                <h3>User Details:</h3>
                
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Customer ID</h5>
                        <p>#<?php echo e($booking->user_id ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Customer Name</h5>
                        <p>
                            <?php if($booking->userDetails): ?>
                                <?php echo e($booking->userDetails->first_name); ?> <?php echo e($booking->userDetails->last_name); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Street, house number:</h5>
                        <p><?php echo e($booking->userDetails->address ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Zip Code</h5>
                        <p><?php echo e($booking->userDetails->zip ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>City</h5>
                        <p><?php echo e($booking->userDetails->city ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Country</h5>
                        <p><?php echo e($booking->userDetails->country ?? 'N/A'); ?></p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Email Address</h5>
                        <p><?php echo e($booking->userDetails->email ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Phone Number</h5>
                        <p><?php echo e($booking->userDetails->phone ?? 'N/A'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Car Details Section - Displaying first item's car details -->
            <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="inner-pack-view">
                <h3>Car Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Brand</h5>
                        <p><?php echo e(explode(' ', $item->car_name)[0]); ?></p> <!-- Gets first word as brand -->
                    </div>
                    <div class="patient-anme-view">
                        <h5>Year</h5>
                        <p><?php echo e($item->car_year); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Model</h5>
                        <p><?php echo e($item->model); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Trailer Hitch</h5>
                        <p><?php echo e($item->trailer_hitch ? 'Yes' : 'No'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Roof Type</h5>
                        <p><?php echo e($item->roof_type); ?></p>
                    </div>
                </div>
            </div>

            <div class="inner-pack-view">
                <h3>Product Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Product ID</h5>
                        <p>#<?php echo e($item->product_id); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Product Name</h5>
                        <p><?php echo e($item->product_name); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Size/ Variation</h5>
                        <p><?php echo e($item->size); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Color</h5>
                        <p><?php echo e($item->color); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Insurance</h5>
                        <p><?php echo e($item->is_insured ? 'Yes' : 'No'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Roof Rack Included</h5>
                        <p><?php echo e($item->is_carrier_included ? 'Yes' : 'No'); ?></p>
                    </div>
                </div>
        
            </div>
            

            <!-- Booking Details Section -->
            <div class="inner-pack-view">
                <h3>Booking Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Booking No.</h5>
                        <p>#<?php echo e($booking->id); ?></p>
                    </div>
                    <?php if($booking->items->isNotEmpty()): ?>
                    <div class="patient-anme-view">
                        <h5>Rental Period</h5>
                        <p>
                            <?php echo e($booking->items->first()->pickup_date->format('d.m.Y')); ?> - 
                            <?php echo e($booking->items->first()->dropoff_date->format('d.m.Y')); ?>

                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Rental Days</h5>
                        <p><?php echo e($booking->items->first()->days); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Pick-Up Date/Time</h5>
                        <p>
                            <?php echo e($booking->items->first()->pickup_date->format('d.m.Y')); ?> | 
                            <?php echo e(\Carbon\Carbon::parse($booking->items->first()->pickup_time)->format('h:iA')); ?>

                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Drop-off Date/Time</h5>
                        <p>
                            <?php echo e($booking->items->first()->dropoff_date->format('d.m.Y')); ?> | 
                            <?php echo e(\Carbon\Carbon::parse($booking->items->first()->dropoff_time)->format('h:iA')); ?>

                        </p>
                    </div>
                    <?php endif; ?>
                    
                </div>
                <div class="patient-age-name d-flex">
                    <?php if($booking->items->isNotEmpty()): ?>
                    <div class="patient-anme-view">
                        <h5>Carrier Included</h5>
                        <p>
                            Length: <?php echo e(preg_replace('/\s*mm$/i', '', $booking->items->first()->carrier_length ?? 'N/A')); ?>

                            <?php if($booking->items->first()->footkit_sku): ?>
                                <span>Foot Kit: <?php echo e($booking->items->first()->footkit_sku); ?></span>
                            <?php endif; ?>
                            <?php if($booking->items->first()->foot_sku): ?>
                                Foot: <?php echo e($booking->items->first()->foot_sku); ?>

                            <?php endif; ?>
                        </p>
                    </div>
                    <?php endif; ?>
                    <div class="patient-anme-view">
                        <h5>Payment Method</h5>
                        <p><?php echo e(ucfirst($booking->payment_method)); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Payment Status</h5>
                        <p><?php echo e(ucfirst($booking->payment_status)); ?>

                            <?php if($item->user_timing == 1): ?>
                            <span class="text-danger me-1" title="Customer requested timing change">
                                <i class="fa-solid fa-flag"></i>
                            </span>
                        <?php endif; ?>
                    </p>
                        
                    </div>
                    <div class="patient-anme-view">
                        <h5>Booking Status</h5>
                        <p><?php echo e(ucfirst($booking->status)); ?></p>
                    </div>

                </div>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Total Amount</h5>
                        <p>€<?php echo e(number_format($booking->total, 2, ',' , '.')); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Discount</h5>
                        <p>€<?php echo e(number_format($booking->discount, 2 , ',' , '.')); ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/vendor/booking/booking_detail.blade.php ENDPATH**/ ?>