<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('vendor.booking.index')); ?>"><?php echo app('translator')->get('messages.booking_management'); ?></a>
            <a class="active" href=""><?php echo app('translator')->get('messages.view_booking_details'); ?></a>
        </div>
        <?php if($booking->payment_status !== 'paid' && 
    (!empty($booking->last_payment_link_sent_at) && now()->diffInHours($booking->last_payment_link_sent_at) >= 24)): ?>
    <div class="mt-4 resend-payment">
        <form action="<?php echo e(route('vendor.booking.resend-payment-link', $booking->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <button type="submit" class="add-notification-btn mb-3"><?php echo app('translator')->get('messages.resend_payment_link'); ?></button>
        </form>
    </div>
    <?php endif; ?>
</div>

    <div class="add-user-form">
        <h2 class="head-mian-all-payment"><?php echo app('translator')->get('messages.view_booking_details'); ?></h2>
        <div class="main-show-detail-viwe">
            <!-- User Details Section -->
            <div class="inner-pack-view">
                <h3><?php echo app('translator')->get('messages.user_details'); ?></h3>
                
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.customer_id'); ?></h5>
                        <p>#<?php echo e($booking->user_id ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.customer_name'); ?></h5>
                        <p>
                            <?php if($booking->userDetails): ?>
                            <?php echo e(trim($booking->userDetails->first_name . ' ' . $booking->userDetails->last_name) ?: 'N/A'); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.street_house_number'); ?></h5>
                        <p><?php echo e($booking->userDetails->address ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.zip_code'); ?></h5>
                        <p><?php echo e($booking->userDetails->zip ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.city'); ?></h5>
                        <p><?php echo e($booking->userDetails->city ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.country'); ?></h5>
                        <p><?php echo e($booking->userDetails->country ?? 'N/A'); ?></p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.email_address'); ?></h5>
                        <p style="text-transform: lowercase;"><?php echo e($booking->userDetails->email ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.phone_number'); ?></h5>
                        <p><?php echo e($booking->userDetails->phone ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">

                        <h5><?php echo app('translator')->get('messages.note'); ?></h5>
    
                        <p><?php echo e($booking->notes ?? 'N/A'); ?></p>
    
                    </div>
                </div>
            </div>

            <!-- Car Details Section - Displaying first item's car details -->
            <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!$item->related_item): ?>
            <div class="car-details-wrap">

                <!-- Car Details -->
                <div class="inner-pack-view">
                    <h3>Car Details:</h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.brand'); ?></h5>
                            <p><?php echo e($item->car_name ? explode(' ', $item->car_name)[0] : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.year'); ?></h5>
                            <p><?php echo e($item->car_year ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.model'); ?></h5>
                            <p><?php echo e($item->model ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.trailer_hitch'); ?></h5>
                            <p><?php echo e(isset($item->trailer_hitch) ? ($item->trailer_hitch ? 'Yes' : 'No') : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.roof_type'); ?></h5>
                            <p><?php echo e($item->roof_type ?? 'N/A'); ?></p>
                        </div>
                    </div>
                </div>

                <div class="inner-pack-view">
                    <h3><?php echo app('translator')->get('messages.product_details'); ?></h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.product_id'); ?></h5>
                            <p>#<?php echo e($item->product_id ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.product_name'); ?></h5>
                            <p><?php echo e($item->product_name ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.size_variation'); ?></h5>
                            <p><?php echo e($item->size ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.color'); ?></h5>
                            <p><?php echo e($item->color ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.quantity'); ?></h5>
                            <p><?php echo e($item->quantity ?? 1); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.insurance'); ?></h5>
                            <p><?php echo e(isset($item->is_insured) ? ($item->is_insured ? 'Yes' : 'No') : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5><?php echo app('translator')->get('messages.roof_rack_included'); ?></h5>
                            <p><?php echo e(isset($item->is_carrier_included) ? ($item->is_carrier_included ? 'Yes' : 'No') : 'N/A'); ?></p>
                        </div>
                    </div>
                </div>
            

            <!-- Booking Details Section -->
            <div class="inner-pack-view">
                <h3><?php echo app('translator')->get('messages.booking_details'); ?></h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.booking_no'); ?></h5>
                        <p>#<?php echo e($booking->id ?? 'N/A'); ?>

                            <?php if(!empty($item->vendor_id)): ?>
                                <span class="text-secondary me-1" title="Includes vendor item"><i class="fa-solid fa-flag"></i></span>
                            <?php endif; ?>
                            <?php if($item->user_timing==1): ?>
                                <span class="text-primary me-1" title="Customer requested timing change"><i class="fa-solid fa-flag"></i></span>
                            <?php endif; ?>
                            <?php if($booking->delay || $item->damage == 1): ?>
                                <span class="text-danger me-1" title="Delay or Damage reported"><i class="fa-solid fa-flag"></i></span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.rental_period'); ?></h5>
                        <p>
                            <?php echo e($item->pickup_date ? $item->pickup_date->format('d.m.Y') : 'N/A'); ?> -
                            <?php echo e($item->dropoff_date ? $item->dropoff_date->format('d.m.Y') : 'N/A'); ?>

                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.rental_days'); ?></h5>
                        <p><?php echo e($item->days ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.pickup_datetime'); ?></h5>
                        <p>
                            <?php echo e($item->pickup_date ? $item->pickup_date->format('d.m.Y') : 'N/A'); ?> |
                            <?php echo e(!empty($item->pickup_time) ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : 'N/A'); ?>

                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.dropoff_datetime'); ?></h5>
                        <p>
                            <?php echo e($item->dropoff_date ? $item->dropoff_date->format('d.m.Y') : 'N/A'); ?> |
                            <?php echo e(!empty($item->dropoff_time) ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : 'N/A'); ?>

                        </p>
                    </div>
                </div>

                <div class="patient-anme-view" style="margin-bottom : 30px">
                    <h5><?php echo app('translator')->get('messages.sa_spo_change_reason'); ?></h5>
                    <p><?php echo e($item->change_reason ?? 'N/A'); ?></p>
                </div>

                <div class="patient-age-name d-flex mt-3">
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.roof_rack_information'); ?></h5>
                        <p>
                            <?php echo app('translator')->get('messages.length'); ?>: <?php echo e(!empty($item->carrier_length) ? preg_replace('/\s*mm$/i', '', $item->carrier_length) : 'N/A'); ?>

                            <?php if(!empty($item->foot_sku)): ?>
                                <?php echo app('translator')->get('messages.foot'); ?>: <?php echo e($item->foot_sku); ?>

                            <?php endif; ?>
                            <?php if(!empty($item->footkit_sku)): ?>
                                <span><?php echo app('translator')->get('messages.foot_kit'); ?>: <?php echo e($item->footkit_sku); ?></span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.payment_method'); ?></h5>
                        <p><?php echo e($booking->payment_method ? ($booking->payment_method === 'stripe' ? 'Credit Card' : ucfirst($booking->payment_method)) : 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.payment_status'); ?></h5>
                        <p><?php echo e($booking->payment_status ? ucfirst($booking->payment_status) : 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.booking_status'); ?></h5>
                        <p><?php echo e($booking->status ? ucfirst($booking->status) : 'N/A'); ?></p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.total_amount'); ?></h5>
                        <p>€<?php echo e(number_format($booking->total ?? 0, 2, ',' , '.')); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.discount'); ?></h5>
                        <p>€<?php echo e(number_format($booking->discount ?? 0, 2 , ',' , '.')); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.pickup_location'); ?></h5>
                        <?php 
                            $pickupAddress = 'N/A';
                            $vendorId = (int) ($item->vendor_id ?? 0);
                            if ($vendorId) {
                                $v = $vendors->where('id', $vendorId)->first();
                                if ($v) {
                                    $pickupAddress = "{$v->street} {$v->zip_code} {$v->city}";
                                }
                            } else {
                                $pickupAddress = 'Esperantostr. 10, 70197 Stuttgart';
                            }
                        ?>
                        <p><?php echo e($pickupAddress ?? 'N/A'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Return Info -->
            <div class="inner-pack-view mt-4">
                <h3><?php echo app('translator')->get('messages.return_information'); ?></h3>
                <?php
                    $hasAlreadyBooked = $booking->items->contains(fn($i) => !empty($i->already_booked) && $i->already_booked == true);
                ?>
                <?php if($hasAlreadyBooked): ?>
                <p style="color:red;"><?php echo app('translator')->get('messages.already_booked_warning'); ?></p>
            <?php endif; ?>
                <div class="patient-age-name d-flex">
                     <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.damaged_products'); ?></h5>
                        <p>
                                <?php
                                    $damagedProducts = $booking->items->where('damage', 1)->pluck('product_name')->toArray();
                                ?>
                                <?php echo e(!empty($damagedProducts) ? implode(', ', $damagedProducts) : 'N/A'); ?>

                            </p>
                        </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.new_dropoff_date'); ?></h5>
                        <p><?php echo e($booking->new_dropoff_date ? \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y') : 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.new_dropoff_time'); ?></h5>
                        <p><?php echo e(!empty($booking->items->first()->new_dropoff_time) ? \Carbon\Carbon::parse($booking->items->first()->new_dropoff_time)->format('H:i') : 'N/A'); ?></p>
                    </div>
                   
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.delay_fees'); ?></h5>
                        <p>€<?php echo e(number_format($booking->delay_fees ?? 0, 2, ',', '.')); ?></p>
                    </div>
                    
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.additional_days'); ?></h5>
                        <p><?php echo e($booking->additional_days ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.additional_days_rent'); ?></h5>
                        <p>€<?php echo e(number_format($booking->additional_days_rent ?? 0, 2, ',', '.')); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5><?php echo app('translator')->get('messages.extra_costs_paid'); ?></h5>
                        <p>
                            <?php if(($booking->additional_days_rent + $booking->delay_fees) == 0): ?>
                                N/A
                            <?php elseif(isset($booking->delay_fees_paid)): ?>
                                <?php echo e($booking->delay_fees_paid ? 'Paid' : 'Pending'); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>

        </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="upper-main-btn-last-comn d-flex">
        
        <a href="<?php echo e(route('vendor.booking.index')); ?>" class="cancel-btn">
            <?php echo app('translator')->get('messages.back_to_list'); ?>
        </a>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/vendor/booking/booking_detail.blade.php ENDPATH**/ ?>