<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Daily Tasks Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; table-layout: fixed; }
        th, td { border: 1px solid #ddd; padding: 4px; text-align: left; word-wrap: break-word; font-size: 9px; }
        th { background-color: #f2f2f2; }
    </style>
    
</head>
<body>
    <h1>Daily Tasks Report</h1>
    
    <div class="report-period">
        <?php if($fromDate || $toDate): ?>
            <p>
                Report Period: 
                <?php echo e($fromDate ? \Carbon\Carbon::parse($fromDate)->format('d.m.Y') : 'Start'); ?> 
                to 
                <?php echo e($toDate ? \Carbon\Carbon::parse($toDate)->format('d.m.Y') : 'End'); ?>

            </p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Activity</th>
                <th>Date</th>
                <th>Time</th>
                <th>Product</th>
                <th>Size</th>
                <th>Insurance</th>
                <th>Customer</th>
                <th>Vehicle</th>
                <th>Roof Type</th>
                <th>Roof Carrier</th>
                <th>Traverse Length</th>
                <th>Foot SKU</th>
                <th>Footkit SKU</th>
                <th>BookingID</th>
                <th>Invoicenumber</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!$item->related_item): ?>
                    <?php
                        $rows = [];
                        $rangeStart = $fromDate ? \Carbon\Carbon::parse($fromDate) : null;
                        $rangeEnd   = $toDate   ? \Carbon\Carbon::parse($toDate)   : null;

                        $inRange = function($date) use ($rangeStart, $rangeEnd) {
                            return $date && (!$rangeStart || !$rangeEnd || \Carbon\Carbon::parse($date)->between($rangeStart, $rangeEnd, true));
                        };

                        if ($inRange($item->pickup_date)) {
                            $rows[] = ['activity' => 'Pick-Up', 'date' => $item->pickup_date, 'time' => $item->pickup_time];
                        }

                        if ($item->new_dropoff_date) {
                            if ($inRange($item->new_dropoff_date)) {
                                $rows[] = ['activity' => 'Drop-Off (Delayed)', 'date' => $item->new_dropoff_date, 'time' => $item->new_dropoff_time];
                            }
                        } elseif ($inRange($item->dropoff_date)) {
                            $rows[] = ['activity' => 'Drop-Off', 'date' => $item->dropoff_date, 'time' => $item->dropoff_time];
                        }
                    ?>

                    <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($row['activity']); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($row['date'])->format('d.m.Y')); ?></td>
                            <td><?php echo e($row['time'] ? \Carbon\Carbon::parse($row['time'])->format('H:i') : 'N/A'); ?></td>
                            <td><?php echo e($item->product_name ?? 'N/A'); ?></td>
                            <td><?php echo e($item->size ?? 'N/A'); ?></td>
                            <td><?php echo e($item->is_insured ? 'Yes' : 'No'); ?></td>
                            <td><?php echo e($booking->userDetails ? $booking->userDetails->first_name.' '.$booking->userDetails->last_name : 'N/A'); ?></td>
                            <td><?php echo e($item->car_name); ?> <?php echo e($item->car_year); ?> <?php echo e($item->model); ?></td>
                            <td><?php echo e($item->roof_type); ?></td>
                            <td><?php echo e($item->is_carrier_included ? 'Yes' : 'No'); ?></td>
                            <td><?php echo e($item->carrier_length); ?></td>
                            <td><?php echo e($item->foot_sku); ?></td>
                            <td><?php echo e($item->footkit_sku); ?></td>
                            <td><?php echo e($booking->id); ?></td>
                            <td><?php echo e($booking->invoice_number ?? 'N/A'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/report/daily_tasks_pdf.blade.php ENDPATH**/ ?>