<!DOCTYPE html>
<html>
<head>
    <title>SPO Product Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; 
            margin: 10mm; 
        }
    </style>
</head>
<body>
    <h2>SPO Product Report</h2>
    <table>
        <thead>
            <tr>
                <th>SPO ID</th>
                <th>SPO Name</th>
                <th>City</th>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($product->name); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>#<?php echo e($vendor->id); ?></td>
                    <td><?php echo e($vendor->first_name); ?> <?php echo e($vendor->last_name); ?></td>
                    <td><?php echo e($vendor->city); ?></td>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $key = $vendor->id . '-' . $product->id;
                            $qty = $quantities[$key]->total_quantity ?? 0;
                        ?>
                        <td><?php echo e($qty); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/spoProduct/pdf.blade.php ENDPATH**/ ?>