<!DOCTYPE html>
<html>
<head>
    <title>Bookings for <?php echo e($date); ?></title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Calendar Report for <?php echo e(\Carbon\Carbon::parse($date)->format('F j, Y')); ?></h1>
    
    <table>
        <thead>
            <tr>
                <th>Booking ID</th>
                <th>Client Name</th>
                <th>Email</th>
                <th>Phone Number</th>
                <th>No. Of Times Changed</th>
                <th>Reason</th>
                <th>Pick-Up Date/Time</th>
                <th>Drop-Off Date/Time</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(!$item->related_item): ?>
                    <tr>
                        <td><?php echo e($booking->id); ?></td>
                        <td><?php echo e($booking->userDetails->first_name ?? ''); ?> <?php echo e($booking->userDetails->last_name ?? ''); ?></td>
                        <td><?php echo e($booking->userDetails->email ?? ''); ?></td>
                        <td> <?php echo e(preg_replace('/^(\+\d{0,2})(\d+)/', '$1 $2', $booking->userDetails->phone)); ?></td>
                        <td><?php echo e($activityCounts[$booking->id] ?? 0); ?></td>
                        <td>
                            <?php
                                $reasons = \App\Models\ActivityLog::where('action', 'appointment_change')
                                    ->where('description', 'like', '%booking #' . $booking->id . '%')
                                    ->orderByDesc('created_at')
                                    ->pluck('details');
                            ?>

                            <?php if($reasons->isNotEmpty()): ?>
                                <?php echo $reasons->map(fn($r) => e($r))->implode('<br>'); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($item->pickup_date ? \Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y') : '-'); ?> /
                            <?php echo e($item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '-'); ?>

                        </td>
                        <td>
                            <?php echo e($item->dropoff_date ? \Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y') : '-'); ?> /
                            <?php echo e($item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '-'); ?>

                        </td>
                        <td><?php echo e(ucfirst($booking->status)); ?></td>
                    </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8">No bookings found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/calendar/pdf.blade.php ENDPATH**/ ?>