<style>
    .error{
        color: red !important;;
    }
</style>
<div class="inner-login">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="<?php echo e(asset('frontend/images/login.png')); ?>" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="<?php echo e(asset('frontend/images/login-logo.png')); ?>" alt="">
                            </div>
                            <h2><?php echo e(__('messages.reset_password')); ?></h2>

                        <form method="POST" action="<?php echo e(route('reset.password')); ?>" class="email-login" id="login-form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-12 inner-main-input mb-3">
                                    <input type="hidden" name="token" value="<?php echo e($usertoken); ?>">
                                    <label for="password" class="form-label"><?php echo e(__('messages.new_password')); ?></label>
                                    <div class="input-pass-show">
                                        <input id="password" type="password" class="form-control" name="password"
                                               placeholder="<?php echo e(__('messages.enter_new_password')); ?>" required>
                                        <span class="toggle-password" toggle="#password">
                                            <i class="fa fa-eye-slash"></i>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="col-md-12 inner-main-input mb-3">
                                    <label for="confirm_password" class="form-label"><?php echo e(__('messages.confirm_new_password')); ?></label>
                                    <div class="input-pass-show">
                                        <input id="confirm_password" type="password" class="form-control" name="confirm_password"
                                               placeholder="<?php echo e(__('messages.enter_confirm_new_password')); ?>" required>
                                        <span class="toggle-password" toggle="#password">
                                            <i class="fa fa-eye-slash"></i>
                                        </span>
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn primary-btn w-100">
                                    <?php echo e(__('messages.reset_password')); ?>

                                </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- jQuery and Validation Plugin -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<script>
    $(document).ready(function() {
        // Add custom password rule
        $.validator.addMethod("strongPassword", function(value, element) {
            return this.optional(element) || /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*#?&])[\S]{8,}$/.test(value);
        }, <?php echo e(__('messages.strong_password_rule')); ?>);
    
        $("#login-form").validate({
            rules: {
                password: {
                    required: true,
                    strongPassword: true
                },
                confirm_password: {
                    required: true,
                    equalTo: "#password"
                }
            },
            messages: {
                password: {
                    required: "<?php echo e(__('messages.enter_new_password_error')); ?>"
                    strongPassword: <?php echo e(__('messages.strong_password_rule')); ?>

                },
                confirm_password: {
                    required: "<?php echo e(__('messages.enter_confirm_new_password_error')); ?>",
                    equalTo: "<?php echo e(__('messages.new_passwords_must_match')); ?>"

                }
            },
            errorElement: "div",
            errorClass: "error"
        });
    });
    </script>

<script>
    $(document).ready(function () {
        $('.toggle-password').on('click', function () {
            const input = $(this).siblings('input');
            const icon = $(this).find('i');

            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            } else {
                input.attr('type', 'password');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            }
        });
    });
</script>
<?php echo $__env->make('frontend.include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/auth/reset-password.blade.php ENDPATH**/ ?>