<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Bootstrap demo</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

    <!-- ===============owl============ -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/responsive.css')); ?>">
</head>

<body>

    <section>
        <div class="inner-login">
            <div class="row">
                <div class="col-md-6">
                    <div class="inner-login-img">
                        <figure>
                            <img src="<?php echo e(asset('admin/images/forget.png')); ?>" alt="">
                        </figure>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="upper-high-main">
                        <div class="inner-login-input-form">
                            <div class="inner-login-page">
                                <div class="inner-login-wrapper">
                                    <div class="logo-login">
                                        <img src="<?php echo e(asset('admin/images/login-logo.png')); ?>" alt="">
                                    </div>
                                    <h2>Forget Your Password?</h2>
                                    <p class="pls-enter">Please enter your email address. You will receive a link to
                                        create a new password via email</p>
                                </div>
                                <form class="email-login" id="resetPasswordForm" method="Post" action="<?php echo e(route('admin.forgot.password')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-12 inner-main-input">
                                            <label for="inputEmail4" class="form-label">Email Address</label>
                                            <input type="email" class="form-control" placeholder="Enter email address"
                                                id="inputEmail4" name="email">
                                            <div class="invalid-feedback" id="emailError">Please enter a valid email address.</div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn primary-btn w-100">
                                        Reset Password
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

    <script>
        document.getElementById("resetPasswordForm").addEventListener("submit", function (event) {
            let emailInput = document.getElementById("inputEmail4");
            let emailError = document.getElementById("emailError");
            let emailPattern = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/; // Regex for valid email

            if (!emailInput.value.trim()) {
                emailError.textContent = "Please enter email address.";
                emailInput.classList.add("is-invalid");
                event.preventDefault(); // Prevent form submission
            } else if (!emailPattern.test(emailInput.value)) {
                emailError.textContent = "Please enter a valid email address.";
                emailInput.classList.add("is-invalid");
                event.preventDefault();
            } else {
                emailInput.classList.remove("is-invalid");
            }
        });
    </script>

</body>

</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/auth/forgot-password.blade.php ENDPATH**/ ?>