<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Bootstrap demo</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

    <!-- ===============owl============ -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="./assets/css/style.css">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/responsive.css')); ?>">

</head>

<body>


    <section>
    <div class="inner-login">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="<?php echo e(asset('frontend/images/login.png')); ?>" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="<?php echo e(asset('frontend/images/login-logo.png')); ?>" alt="">
                            </div>
                            <h2>Reset Password</h2>

                        <form method="POST" action="<?php echo e(route('admin.password-reset-admin.update')); ?>" class="email-login" id="login-form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-12 inner-main-input mb-3">
                                    <input type="hidden" name="token" value="<?php echo e($token); ?>">
                                    <label for="password" class="form-label">New Password</label>
                                    <input id="password" type="password" class="form-control" name="password" placeholder="Enter your New Password">
                                </div>
                                <div class="col-md-12 inner-main-input mb-3">
                                    <label for="confirm_password" class="form-label">Confirm New Password</label>
                                    <input id="confirm_password" type="password" class="form-control" name="confirmed" placeholder="Enter your Confirm Password">
                                </div>
                            </div>
                            <button type="submit" class="btn primary-btn w-100">
                                Reset Password
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    </section>



    <!-- jQuery -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <!-- jQuery Validation Plugin -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.getElementById('login-form');
        const password = document.getElementById('password');
        const confirmPassword = document.getElementById('confirm_password');
    
        form.addEventListener('submit', function (e) {
            document.querySelectorAll('.error-msg').forEach(el => el.remove());
    
            let valid = true;
    
            if(password.value.trim().length == 0){
                showError(password,'Please enter new password.');
                valid = false;
            }
            else if (password.value.trim().length < 8) {
                showError(password, "Password must be at least 8 characters long");
                valid = false;
            }
    
            if(confirmPassword.value.trim().length == 0){
                showError(confirmPassword,'Please enter confirm new password.');
                valid = false;
            }
            else if (confirmPassword.value.trim().length < 8) {
                showError(confirmPassword, "New Confirm password must be at least 8 characters long");
                valid = false;
            } else if (password.value !== confirmPassword.value) {
                showError(confirmPassword, "New password and confirm new password does not match.");
                valid = false;
            }
    
            if (!valid) e.preventDefault();
        });
    
        function showError(input, message) {
            const error = document.createElement('div');
            error.className = 'error-msg error mt-1';
            error.innerText = message;
            input.parentNode.appendChild(error);
            input.classList.add('is-invalid');
            input.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    });
    </script>


</body>

</html><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/auth/reset-password.blade.php ENDPATH**/ ?>