<?php $__env->startSection('content'); ?>
<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1><?php echo e(__('messages.add_new_address')); ?></h1>

                </div>
            </div>
        </div>
    </section>

<div class="prof-main">
    <section class="comn-padd">
      <div class="container">
        <div class="inner-acount">
          <div class="row">
            <div class="col-lg-3">
                <div class="inner-left-tabs">
                    <?php echo $__env->make('frontend.user.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="col-lg-9">              
              <section id="add-new-address">
                <div class="comm_border_box">
                  <h3 class="main-head-pro"><?php echo e(__('messages.add_new_address')); ?> </h3>
                  <div class="upper-form-main">
                    <div class="add_profile_form">
                      <form class="row comm_form" method="POST" action="<?php echo e(route('user.billing-address.store')); ?>" id="addressForm">
                        <?php echo csrf_field(); ?>
                    
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label"><?php echo e(__('messages.title')); ?></label>
                                    <select class="form-select" name="title" id="title">
                                        <option value="">Select</option>
                                        <option value="Mr." <?php echo e(old('title') == 'Mr.' ? 'selected' : ''); ?>><?php echo e(__('messages.title_mr')); ?></option>
                                        <option value="Mrs." <?php echo e(old('title') == 'Mrs.' ? 'selected' : ''); ?>><?php echo e(__('messages.title_mrs')); ?></option>
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__('messages.select_title_error')); ?></div>
                                </div>
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                                    <input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" value="<?php echo e(old('first_name')); ?>">
                                    <div class="invalid-feedback"><?php echo e(__('messages.first_name_error')); ?></div>
                                </div>
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.last_name')); ?></label>
                                <input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?php echo e(__('messages.enter_surname')); ?>" value="<?php echo e(old('last_name')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.last_name_error')); ?></div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.street')); ?></label>
                                <input type="text" class="form-control" name="street" id="street" placeholder="<?php echo e(__('messages.enter_address')); ?>" value="<?php echo e(old('street')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.street_error')); ?></div>
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.zip_code')); ?></label>
                                <input type="text" class="form-control" name="zipcode" id="zipcode" placeholder="<?php echo e(__('messages.enter_zip_code')); ?>" value="<?php echo e(old('zipcode')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.zip_code_error')); ?></div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.city')); ?></label>
                                <input type="text" class="form-control" name="city" id="city" placeholder="<?php echo e(__('messages.enter_city')); ?>" value="<?php echo e(old('city')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.city_error')); ?></div>
                            </div>
                        </div>
                        
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.state_region')); ?></label>
                                <select class="form-select" name="state" id="state">
                                <option value=""><?php echo e(__('messages.select_state')); ?></option>

                                <?php $__currentLoopData = __('messages.regions'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php echo e(old('state') == $key ? 'selected' : ''); ?>>
                                        <?php echo e($label); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                                <div class="invalid-feedback"><?php echo e(__('messages.state_error')); ?></div>

                                
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.email')); ?></label>
                                <input type="email" class="form-control" name="email" id="email" placeholder="<?php echo e(__('messages.email_enter')); ?>" value="<?php echo e(old('email')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.email_error')); ?></div>
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label"><?php echo e(__('messages.country_code')); ?></label>
                                    
                                    <select name="country_code" class="form-select country_code_custom" id="country_code">
                                        <option value="+49" data-image="https://flagcdn.com/16x12/de.png" <?php echo e(old('country_code') == '+49' ? 'selected' : ''); ?>>+49</option>
                                        <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e(old('country_code') == '+43' ? 'selected' : ''); ?>>+93</option>
                                        <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  <?php echo e(old('country_code') == '+41' ? 'selected' : ''); ?>>+41</option>
                                    </select>
                                    <div class="invalid-feedback"><?php echo e(__('messages.select_country_code_error')); ?></div>
                                </div>
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label disapear">Phone</label>
                                    <input type="text" class="form-control" name="contact_number" id="contact_number" placeholder="<?php echo e(__('messages.phone_placeholder')); ?>" value="<?php echo e(old('contact_number')); ?>">
                                    <div class="invalid-feedback"><?php echo e(__('messages.phone_error')); ?></div>
                                </div>
                            </div>
                        </div>
                    
                        <div class="col-12 mt-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_default" id="is_default" <?php echo e(old('is_default') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="is_default">
                                    <?php echo e(__('messages.make_default_billing')); ?>

                                </label>
                            </div>
                        </div>
                    
                        <div class="comm_profile_two_btns mt-4">
                            <button type="submit" class="primary-btn"><?php echo e(__('messages.add_address')); ?></button>
                            <a href="<?php echo e(route('user.billingAddress')); ?>" class="secondary-btn"><?php echo e(__('messages.cancel_button')); ?></a>
                        </div>
                    </form>
                  </div>
                </div>
              </section>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('addressForm');
    
    // Validation functions
    function validateName(name) {
        return name.length >= 2 && name.length <= 50 && /^[a-zA-Z\s\-']+$/.test(name);
    }
    
    function validateStreet(street) {
        return street.length >= 5 && street.length <= 100;
    }
    
    function validateZip(zip) {
        return /^[a-zA-Z0-9\s\-]{4,10}$/.test(zip);
    }
    
    function validateCity(city) {
        return city.length >= 2 && city.length <= 50;
    }
    
    function validatePhone(phone) {
        return /^[0-9\s\-]{8,15}$/.test(phone);
    }
    
    function validateEmail(email) {
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
    }
    
    // Form submission handler
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        let isValid = true;
        
        // Reset validation
        document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
        
        // Validate title
        if (!document.getElementById('title').value) {
            document.getElementById('title').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate first name
        const firstName = document.getElementById('first_name').value.trim();
        if (!validateName(firstName)) {
            document.getElementById('first_name').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate last name
        const lastName = document.getElementById('last_name').value.trim();
        if (!validateName(lastName)) {
            document.getElementById('last_name').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate street
        const street = document.getElementById('street').value.trim();
        if (!validateStreet(street)) {
            document.getElementById('street').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate zip code
        const zipcode = document.getElementById('zipcode').value.trim();
        if (!validateZip(zipcode)) {
            document.getElementById('zipcode').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate city
        const city = document.getElementById('city').value.trim();
        if (!validateCity(city)) {
            document.getElementById('city').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate state
        if (!document.getElementById('state').value) {
            document.getElementById('state').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate email
        const email = document.getElementById('email').value.trim();
        if (!validateEmail(email)) {
            document.getElementById('email').classList.add('is-invalid');
            isValid = false;
        }
        
        // Validate phone
        const phone = document.getElementById('contact_number').value.trim();
        if (!validatePhone(phone)) {
            document.getElementById('contact_number').classList.add('is-invalid');
            isValid = false;
        }

        const phone_code = document.getElementById('country_code').value.trim();
        if(phone_code.length == 0){
            document.getElementById('country_code').classList.add('is-invalid');
            isValid = false;
        }
        
        if (isValid) {
            form.submit();
        } else {
            // Scroll to first invalid field
            const firstInvalid = document.querySelector('.is-invalid');
            if (firstInvalid) {
                firstInvalid.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                });
                firstInvalid.focus();
            }
        }
    });
    
    // Real-time validation on blur
    document.getElementById('first_name').addEventListener('blur', function() {
        if (!validateName(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('last_name').addEventListener('blur', function() {
        if (!validateName(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('street').addEventListener('blur', function() {
        if (!validateStreet(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('zipcode').addEventListener('blur', function() {
        if (!validateZip(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('city').addEventListener('blur', function() {
        if (!validateCity(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('email').addEventListener('blur', function() {
        if (!validateEmail(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('contact_number').addEventListener('blur', function() {
        if (!validatePhone(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
});
</script>

<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/user/billing-address/create.blade.php ENDPATH**/ ?>