<?php $__env->startSection('content'); ?>
    <div class="col-9 main-dash-left">
        <div class="upper-main-user-navigation">
            <div class="user-manage">
                <a href="<?php echo e(route('vendor.booking.index')); ?>">Booking Management</a>
                <a class="active" href="">Add Booking</a>
            </div>
        </div>

        <div class="add-user-form add-booking">
            <h3>Add Booking</h3>
            <form class="row mb-5">
                <div class="col-md-1">
                    <div class="comn-input-select">
                        <label for="inputtitle" class="form-label">Title</label>
                        <select id="inputtitle" class="form-select">
                            <option value="Mr.">Mr.</option>
                            <option value="Mrs.">Mrs.</option>
                            <option value="Ms.">Ms.</option>
                            <option value="Dr.">Dr.</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="comn-input-select">
                        <label class="form-label">First Name</label>
                        <input type="text" name="first_name" id="first_name" class="form-control"
                            value="<?php echo e(old('first_name', $user->first_name ?? '')); ?>" placeholder="Enter first name"
                            required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Last Name</label>
                        <input type="text" name="last_name" id="last_name" class="form-control"
                            value="<?php echo e(old('last_name', $user->last_name ?? '')); ?>" placeholder="Enter Last Name" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Street, House Number</label>
                        <input type="text" name="address" id="address" class="form-control"
                            value="<?php echo e(old('address', $user->street ?? '')); ?>" placeholder="Enter your address" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Zip Code</label>
                        <input type="text" name="zip" id="zip" class="form-control"
                            value="<?php echo e(old('zip', $user->zip_code ?? '')); ?>" placeholder="Enter Zip Code" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">City</label>
                        <input type="text" name="city" id="city" class="form-control"
                            value="<?php echo e(old('city', $user->city ?? '')); ?>" placeholder="City" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label for="inputState" class="form-label">Region/State</label>
                        <select id="region" class="form-select" name="region">
                            <option value="">Select..</option>
                            <option value="Baden-Württemberg" <?php echo e(old('region', $user->region ?? '') == 'Baden-Württemberg' ? 'selected' : ''); ?>>Baden-Württemberg</option>
                            <option value="Bavaria" <?php echo e(old('region', $user->region ?? '') == 'Bavaria' ? 'selected' : ''); ?>>Bavaria</option>
                            <option value="Berlin" <?php echo e(old('region', $user->region ?? '') == 'Berlin' ? 'selected' : ''); ?>>Berlin</option>
                            <option value="Brandenburg" <?php echo e(old('region', $user->region ?? '') == 'Brandenburg' ? 'selected' : ''); ?>>Brandenburg</option>
                            <option value="Bremen" <?php echo e(old('region', $user->region ?? '') == 'Bremen' ? 'selected' : ''); ?>>Bremen</option>
                            <option value="Hamburg" <?php echo e(old('region', $user->region ?? '') == 'Hamburg' ? 'selected' : ''); ?>>Hamburg</option>
                            <option value="Hesse" <?php echo e(old('region', $user->region ?? '') == 'Hesse' ? 'selected' : ''); ?>>Hesse</option>
                            <option value="Lower Saxony" <?php echo e(old('region', $user->region ?? '') == 'Lower Saxony' ? 'selected' : ''); ?>>Lower Saxony</option>
                            <option value="Mecklenburg-Vorpommern" <?php echo e(old('region', $user->region ?? '') == 'Mecklenburg-Vorpommern' ? 'selected' : ''); ?>>Mecklenburg-Vorpommern</option>
                            <option value="North Rhine-Westphalia" <?php echo e(old('region', $user->region ?? '') == 'North Rhine-Westphalia' ? 'selected' : ''); ?>>North Rhine-Westphalia</option>
                            <option value="Rhineland-Palatinate" <?php echo e(old('region', $user->region ?? '') == 'Rhineland-Palatinate' ? 'selected' : ''); ?>>Rhineland-Palatinate</option>
                            <option value="Saarland" <?php echo e(old('region', $user->region ?? '') == 'Saarland' ? 'selected' : ''); ?>>Saarland</option>
                            <option value="Saxony" <?php echo e(old('region', $user->region ?? '') == 'Saxony' ? 'selected' : ''); ?>>Saxony</option>
                            <option value="Saxony-Anhalt" <?php echo e(old('region', $user->region ?? '') == 'Saxony-Anhalt' ? 'selected' : ''); ?>>Saxony-Anhalt</option>
                            <option value="Schleswig-Holstein" <?php echo e(old('region', $user->region ?? '') == 'Schleswig-Holstein' ? 'selected' : ''); ?>>Schleswig-Holstein</option>
                            <option value="Thuringia" <?php echo e(old('region', $user->region ?? '') == 'Thuringia' ? 'selected' : ''); ?>>Thuringia</option>
                        </select>
                        
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" id="email" class="form-control"
                            value="<?php echo e(old('email', $user->email ?? '')); ?>" placeholder="Enter email address" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label for="phone-number" class="form-label">Phone Number</label>
                        <div class="numer-input d-flex">

                            <select class="form-select country_code_custom" name="phone_code" id="country_code" style="width: 80px;">
                        
                                <option value="+49"  data-image="https://flagcdn.com/16x12/de.png" <?php echo e(old('phone_code', $user->phone_code ?? '') == '+49' ? 'selected' : ''); ?>> +49</option>
                                <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" <?php echo e(old('phone_code', $user->phone_code ?? '') == '+41' ? 'selected' : ''); ?>> +41</option>
                                <option value="+43" data-image="https://flagcdn.com/16x12/at.png"  <?php echo e(old('phone_code', $user->phone_code ?? '') == '+43' ? 'selected' : ''); ?>> +91</option>
                            </select>

                            <input type="tel" name="phone_number" id="phone_number" class="form-control"
                                value="<?php echo e(old('phone_number', $user->phone_number ?? '')); ?>" placeholder="Phone Number"
                                required>

                        </div>
                        <div class="invalid-feedback" bis_skin_checked="1" style="display:none;">This field is required
                        </div>
                    </div>
                </div>
            </form>
            <h3>Product Details</h3>
            <form class="row mb-5">
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Product</label>
                        <select class="form-select" id="product-select" required>
                            <option value="">Select Product</option>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($product->id); ?>" data-slug="<?php echo e($product->category->slug); ?>"
                                    data-name="<?php echo e($product->name); ?>">
                                    <?php echo e($product->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </form>
            <h3>Car Details</h3>
            <form class="row mb-5" id="car-form">
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Manufacturer</label>
                        <select class="form-select car_detail_disabled" id="manufacturer" name="manufacturer" disabled required>
                            <option selected disabled>Select</option>
                            <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($manufacturer); ?>"><?php echo e($manufacturer); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-6 inner-main-input">
                    <label class="form-label">Model</label>
                    <select class="form-select" id="model" name="model" disabled></select>
                </div>

                <div class="col-md-6 inner-main-input">
                    <label class="form-label">Year of Make</label>
                    <select class="form-select" id="year" name="year" disabled></select>
                </div>

                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Trailer Hitch</label>
                        <select class="form-select car_detail_disabled" id="trailer_hitch" name="trailer_hitch" disabled data-product-name="" required>
                            <option value="" selected >Select</option>
                            <option value="yes">Yes</option>
                            <option value="no">No</option>
                        </select>
                    </div>
                </div>
                <div id="result" class="mt-3"></div>
            </form>
            <div class="row">
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Railing Type</label>
                        <div id="roof-types-container" style="display: none;">
                            <?php $__currentLoopData = $roofTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roofType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="roof-name-detail" id="roof-type-<?php echo e(Str::slug($roofType)); ?>">
                                    <figure>
                                        <?php
                                            $imageName = strtolower(str_replace(' ', '-', $roofType)) . '.jpg';
                                        ?>
                                        <img src="<?php echo e(asset('frontend/images/' . $imageName)); ?>"
                                            alt="<?php echo e($roofType); ?>">
                                    </figure>
                                    <h4><?php echo e($roofType); ?></h4>
                                            <?php if($roofType == 'Normal Roof'): ?>
                                            <p>A smooth roof surface without side mounts or rails</p>
                                            <?php elseif($roofType == 'Normal roof without glass roof'): ?>
                                            <p>A smooth roof surface without side mounts or rails</p>
                                            <?php elseif($roofType == 'Normal Roof with glass roof'): ?>
                                            <p>A smooth roof surface without side mounts or rails and with a glass roof</p>
                                            <?php elseif($roofType == 'Fixpoints'): ?>
                                            <p>A car roof with fixed points has integrated mounting points for roof racks</p>
                                            <?php elseif($roofType == 'Fixpoints without glass roof'): ?>
                                            <p>A car roof with fixed points has integrated mounting points for roof racks</p>
                                            <?php elseif($roofType == 'Fixpoints with glass roof'): ?>
                                            <p>A car roof with fixed points has integrated mounting points for roof racks and with a glass roof</p>
                                            <?php elseif($roofType == 'Integrated Roof Railing'): ?>
                                            <p>A car roof with flush roof rails features low-profile, seamlessly integrated rails</p>
                                            <?php elseif($roofType == 'Elevated Roof Rails'): ?>
                                            <p>A car roof with open rails has mounted roof rails raised above the roof surface </p>
                                            <?php elseif($roofType == 'T-Profile'): ?>
                                            <p>A car roof with a T-slot profile has integrated T-slots for mounting roof racks </p>
                                            <?php elseif($roofType == 'Raingutter'): ?>
                                            <p>A car roof with a rain gutter has side channels for water drainage and roof rack mounting</p>
                                            <?php endif; ?>
                                    </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
           


            <form class="row mb-5" id="booking-details-form">
                <h3>Booking Details</h3>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Pick-up Date</label>
                        <input class="form-control booking_detail_disabled" id="rental_from" disabled required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Drop-off Date</label>
                        <input class="form-control booking_detail_disabled" id="rental_to" disabled required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Rental Days</label>
                        <input type="text" class="form-control" id="rental-days" readonly>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="comn-input-select">
                        <label class="form-label">Calculated Rent</label>
                        <input type="text" class="form-control" id="calculated-rent" readonly>
                    </div>
                </div>


                <h3>Color</h3>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label class="form-label">Color</label>
                                <select class="form-select" id="color-select" disabled required>
                                    <option selected disabled>Select</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label class="form-label">Size/Variation</label>
                                <div class="row row-gap-4" id="size-container">
                                    <!-- Sizes will be populated dynamically -->
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-12">
                    <div class="upper-check-main-book d-flex">

                        <div class="form-check" style="display:none;" id="roof_rack_contanier">
                            <input type="checkbox" class="form-check-input" id="roof_rack_checkbox">
                            <label class="form-check-label" for="roof_rack_checkbox">Roof Rack Included</label>
                        </div>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="insurance_checkbox">
                            <label class="form-check-label" for="insurance_checkbox">Volkassko Insurance 25 €</label>
                        </div>
                    </div>
                </div>
            </form>

            <h3>Add Coupon</h3>
            <form class="row mb-5">
                <div class="col-md-6">
                    <div class="comn-input-select main-add-bk">
                        <label for="coupon_code" class="form-label">Coupon Code</label>
                        <select class="form-control select2" id="coupon_code" name="coupon_code" style="width: 100%;">
                            <option value="">Select a coupon</option>
                            <!-- Options will be populated dynamically -->
                        </select>
                    </div>
                </div>
                <div class="col-md-6 coupn_input_wrap">
                    <div class="comn-input-select">
                        <label class="form-label" style="visibility: hidden;">Apply</label>
                        <button type="button" class="add-notification-btn" id="apply_coupon">Apply</button>
                    </div>
                </div>
            </form>

            <h3>Booking Amount</h3>
            <div class="sub-total">
                <div class="main-inner-sub">
                    <p>Subtotal</p>
                    <h6 id="subtotal-amount">0 €</h6>
                </div>
                <div class="main-inner-sub">
                    <p>Discount</p>
                    <h6 id="discount-amount">0 €</h6>
                </div>
                <div class="main-inner-sub">
                    <p>Insurance</p>
                    <h6 id="insurance-amount">0 €</h6>
                </div>
                <div class="main-inner-sub">
                    <p>Tax(19%)</p>
                    <h6 id="tax-amount">0 €</h6>
                </div>
                <div class="main-inner-sub">
                    <p>Net Price</p>
                    <h6 id="net-price">0 €</h6>
                </div>
                <div class="main-inner-sub tota-main-price">
                    <p>Total Price</p>
                    <h6 id="total-price">0 €</h6>
                </div>

                <div class="upper-main-btn-last-comn main-book-last d-flex">
                    <button type="button" id="add-booking-btn" class="add-user">Add Booking</button>
                    <button type="button" class="cancel-btn"
                        onclick="window.location.href='<?php echo e(route('vendor.booking.index')); ?>'">Back</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
                <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">Not Bookable</h5>
              <p> The product is not bookable without a trailer hitch.</p>
              <button type="button" class="btn primary-btn" data-bs-dismiss="modal">OK</button>
            </div>
          </div>
        </div>
    </div>

    <?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            var baseUrl = '';
            let selectedProduct = null;
            let selectedColor = null;
            let selectedSize = null;
            let selectedRecommendation = null;
            let currentRecommendation = null;
            let currentRecommendationMap = {};
            let dailyPrices = [];
            let roofRackPrices = [];
            const insuranceFlatFee = 25.00;
            let discountAmount = 0;

            // Initialize datepickers
            // $("#rental_from, #rental_to").datepicker({
            //     dateFormat: 'yy-mm-dd',
            //     minDate: 0,
            //     beforeShowDay: function(date) {
            //         const day = date.getDay();
            //         return [(day !== 0 && day !== 6), ''];
            //     },
            //     onSelect: calculateRent
            // });

            // $(function() {
            //     const holidays = <?php echo json_encode($holidays, 15, 512) ?>;
            //     function disableWeekendsAndHolidays(date) {
            //         const day = date.getDay();
            //         const formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            //         const isWeekend = (day === 0 || day === 6);
            //         const isHoliday = holidays.includes(formattedDate);

            //         if (isWeekend || isHoliday) {
            //             return [false, ''];
            //         }
            //         return [true, ''];
            //     }

            //         $("#rental_from, #rental_to").datepicker({
            //             dateFormat: 'yy-mm-dd',
            //             minDate: 0,
            //             firstDay: 1, // Week starts on Monday
            //             beforeShowDay: disableWeekendsAndHolidays,
            //             onSelect: function () {
            //                 var colorId = $('#color-select').val();
            //                 var colorName = $('#color-select option:selected').data('color-name');
            //                 if (colorId && colorId !== 'Select') {
            //                     checkAvailability(colorId, colorName);
            //                 }
            //                 calculateRent();
            //             }
            //         });
            //     });

                $(function () {
                    const holidays = <?php echo json_encode($holidays, 15, 512) ?>;

                    function disableWeekendsAndHolidays(date) {
                        const day = date.getDay();
                        const formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

                        const isWeekend = (day === 0 || day === 6);
                        const isHoliday = holidays.includes(formattedDate);

                        if (isWeekend || isHoliday) {
                            return [false, ''];
                        }
                        return [true, ''];
                    }

                    $("#rental_from").datepicker({
                        dateFormat: 'yy-mm-dd',
                        minDate: 0,
                        firstDay: 1,
                        beforeShowDay: disableWeekendsAndHolidays,
                        onSelect: function (selectedDate) {
                            const startDate = $(this).datepicker('getDate');
                            $("#rental_to").datepicker("option", "minDate", startDate);

                            var colorId = $('#color-select').val();
                            var colorName = $('#color-select option:selected').data('color-name');
                            if (colorId && colorId !== 'Select') {
                                checkAvailability(colorId, colorName);
                            }
                            calculateRent();
                        }
                    });

                    $("#rental_to").datepicker({
                        dateFormat: 'yy-mm-dd',
                        minDate: 0,
                        firstDay: 1,
                        beforeShowDay: disableWeekendsAndHolidays,
                        onSelect: function () {
                            var colorId = $('#color-select').val();
                            var colorName = $('#color-select option:selected').data('color-name');
                            if (colorId && colorId !== 'Select') {
                                checkAvailability(colorId, colorName);
                            }
                            calculateRent();
                        }
                    });
                });

            // Manufacturer change handler
            // $('#manufacturer').change(function() {
            //     $('#year').prop('disabled', true).html('<option>Loading...</option>');
            //     $('#model').prop('disabled', true).html('<option>Select</option>');
            //     let manufacturer = $(this).val();

            //     $.get(`${baseUrl}/car/years`, {
            //         manufacturer
            //     }, function(data) {
            //         $('#year').prop('disabled', false).html(
            //             '<option selected disabled>Select</option>');
            //         data.forEach(year => {
            //             $('#year').append(`<option value="${year}">${year}</option>`);
            //         });
            //     });
            // });

            // // Year change handler
            // $('#year').change(function() {
            //     $('#model').prop('disabled', true).html('<option>Loading...</option>');
            //     let manufacturer = $('#manufacturer').val();
            //     let year = $(this).val();

            //     $.get(`${baseUrl}/car/models`, {
            //         manufacturer,
            //         year
            //     }, function(data) {
            //         $('#model').prop('disabled', false).html(
            //             '<option selected disabled>Select</option>');
            //         data.forEach(model => {
            //             $('#model').append(`<option value="${model}">${model}</option>`);
            //         });
            //     });
            // });


            $('#manufacturer').change(function() {
                $('#model').prop('disabled', true).html('<option>Loading...</option>');
                $('#year').prop('disabled', true).html('<option>Select</option>');
                
                let manufacturer = $(this).val();

                $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
                    $('#model').prop('disabled', false).html('<option selected disabled>Select</option>');
                    data.forEach(model => {
                        $('#model').append(`<option value="${model}">${model}</option>`);
                    });
                });
            });

            $('#model').change(function() {
                $('#year').prop('disabled', true).html('<option>Loading...</option>');
                
                let manufacturer = $('#manufacturer').val();
                let model = $(this).val();

                $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
                    $('#year').prop('disabled', false).html('<option selected disabled>Select</option>');
                    data.forEach(year => {
                        $('#year').append(`<option value="${year}">${year}</option>`);
                    });
                });
            });
// Variable to store available coupons
let availableCoupons = [];

// Function to load coupons for selected product
function loadCouponsForProduct(productId) {
    if (!productId) {
        $('#coupon_code').empty().append('<option value="">Select a coupon</option>');
        $('#coupon_code').val('').trigger('change');
        return;
    }

    $.ajax({
        url: '<?php echo e(route("vendor.booking.get_coupons")); ?>',
        type: 'GET',
        data: {
            product_id: productId
        },
        dataType: 'json',
        success: function(response) {
            availableCoupons = response.coupons;
            $('#coupon_code').empty().append('<option value="">Select a coupon</option>');
            
            response.coupons.forEach(function(coupon) {
                let optionText = `${coupon.code} - `;
                if (coupon.type == 1) {
                    optionText += `€${coupon.max_discount} off`;
                } else {
                    optionText += `${coupon.max_discount}% off`;
                }
                
                if (coupon.min_order_value > 0) {
                    optionText += ` (Min. order: €${coupon.min_order_value})`;
                }
                
                $('#coupon_code').append(new Option(optionText, coupon.code));
            });
            
            // Reinitialize Select2
            $('#coupon_code').select2({
                placeholder: "Select a coupon",
                allowClear: true
            });
        },
        error: function(xhr) {
            console.error('Error loading coupons');
        }
    });
}
            // Product select change handler
            $('#product-select').change(function() {
       
                $('.car_detail_disabled').attr('disabled',false);

                const productId = $(this).val();
                const productName = $(this).find('option:selected').data('name');
                const slug = $(this).find('option:selected').data('slug');

                loadCouponsForProduct(productId);

                $('#trailer_hitch').attr('data-product-name', productName);
                $('#roof_rack_contanier').hide();
                if (productName == 'Roof Box' || productName == 'Roof Bike Carrier') {
                    $('#roof_rack_contanier').show();
                }
                if (!productId) {
                    $('#color-select').prop('disabled', true);
                    return;
                }

                // Get product details
                $.get(`${baseUrl}/vendor/products/${slug}/details`, function(product) {
                    console.log(product);
                    
                    selectedProduct = product;
                    dailyPrices = product.dailyPrices;
                    roofRackPrices = product.roofRackPrices;
                    console.log(roofRackPrices);

                    // Populate colors
                    $('#color-select').empty().append('<option selected disabled>Select</option>');
                    product.colors.forEach(color => {
                        $('#color-select').append(
                            `<option value="${color.id}" data-color-name="${color.name}">${color.name}</option>`
                        );
                    });
                    $('#color-select').prop('disabled', false);

                       $('#size-container').empty();
                    product.variations_product.forEach(size => {
                        // const isAvailable = availability[size.id] > 0;
                        if (product.name == 'Roof Bike Carrier') {
    sunroofImg = `<figure><img src="${baseUrl}/frontend/images/roof-bike.png" alt=""></figure>`;
} else if(product.name == 'Clutch Bike Carrier') {
    sunroofImg = `<figure><img src="${baseUrl}/frontend/images/${size.name}.png" alt=""></figure>`;
}
                        if (size.id) {
                            $('#size-container').append(`
                        <div class="col-md-4">
                            <div class="inner-size-card " 
                                data-size-id="${size.id}"
                                data-size-name="${size.name}">
                                <div class="upper-img-sunroof">
                                   ${sunroofImg}
                                </div>
                                <div class="size-sunreef">
                                    <p>${size.name} </p>
                                    <span class="badge ">
                                          <span class="badge bg-secondary">Select color first</span>
                                          <span class="recommended bg-secondary d-none"></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    `);

                        }
                    });
                    product.sizes.forEach(size => {
                        // const isAvailable = availability[size.id] > 0;
                        // const text = getSizeText(size.name);
                        if (product.name == 'Roof Box') {
    sunroofImg = `<figure><img src="${baseUrl}/frontend/images/${size.name}.png" alt=""></figure>`;
} else if(product.name == 'Rear Box') {
    sunroofImg = `<figure><img src="${baseUrl}/frontend/images/rear-box.png" alt=""></figure>`;
}
                        if (size.id) {
                            $('#size-container').append(`
                        <div class="col-md-4">
                            <div class="inner-size-card " 
                                data-size-id="${size.id}"
                                data-size-name="${size.name}">
                                <div class="upper-img-sunroof">
                                    ${sunroofImg}
                                </div>
                                <div class="size-sunreef">
                                    <p>${size.name} </p>
                                    <span class="badge bg-secondary">Select color first</span>
                                    <span class="recommended bg-secondary d-none"></span>
                                </div>
                            </div>
                        </div>
                    `);

                        }
                    });
              
                });
            });

            // Color select change handler
            // $('#color-select').change(function() {
            //     const colorId = $(this).val();
            //     selectedColor = colorId;

            //     if (!colorId || !selectedProduct) return;

            //     // Get availability and populate sizes
            //     $.get(`${baseUrl}/product/${selectedProduct.id}/availability`, {
            //         color_id: colorId
            //     }, function(availability) {
            //         $('#size-container').empty();

            //         // Add regular sizes
            //         console.log(selectedProduct)
            //         selectedProduct.sizes.forEach(size => {
            //             const isAvailable = availability[size.id] > 0;
            //             const text = getSizeText(size.name);
            //             if (size.id) {
            //                 $('#size-container').append(`
            //             <div class="col-md-4">
            //                 <div class="inner-size-card ${isAvailable ? 'available' : 'unavailable'}" 
            //                      data-size-id="${size.id}"
            //                      data-size-name="${size.name}">
            //                     <div class="upper-img-sunroof">
            //                         <figure>
            //                             <img src="${baseUrl}/frontend/images/sunroof.png" alt="">
            //                         </figure>
            //                     </div>
            //                     <div class="size-sunreef">
            //                         <p>${size.name} ${text}</p>
            //                         <span class="badge ${isAvailable ? 'bg-success' : 'bg-danger'}">
            //                             ${isAvailable ? 'Available' : 'Unavailable'}
            //                         </span>
            //                     </div>
            //                 </div>
            //             </div>
            //         `);

            //             }
            //         });


            //         // Add variations
            //         console.log(selectedProduct.variations.variation_id)

            //         if (selectedProduct.variations) {
            //             selectedProduct.variations.forEach(variation => {
            //                 const isAvailable = availability[variation.id] > 0;
            //                 if (variation.variation_id) {
            //                     $('#size-container').append(`
            //                <div class="col-md-4">
            //                    <div class="inner-size-card ${isAvailable ? 'available' : 'unavailable'}" 
            //                         data-variation-id="${variation.id}"
            //                         data-size-name="${variation.name}">
            //                        <div class="upper-img-sunroof">
            //                            <figure>
            //                                <img src="${baseUrl}/frontend/images/sunroof.png" alt="">
            //                            </figure>
            //                        </div>
            //                        <div class="size-sunreef">
            //                            <p>${variation.name}</p>
            //                            <span class="badge ${isAvailable ? 'bg-success' : 'bg-danger'}">
            //                                ${isAvailable ? 'Available' : 'Unavailable'}
            //                            </span>
            //                        </div>
            //                    </div>
            //                </div>
            //            `);

            //                 }

            //             });

            //         }

            //         if (currentRecommendation) {
            //             highlightRecommendedSizes(currentRecommendation);
            //         }
            //     });
            // });


            function checkAvailability(colorId,colorName) {
                const fromDate = $('#rental_from').val();
                const toDate = $('#rental_to').val();
                
                const params = {
                    color_id: colorId,
                    from_date: fromDate,
                    to_date: toDate,
                    color_name : colorName
                };

                if(!fromDate || !toDate ||  !colorId){
                    return; 
                }
                
                $.get(`${baseUrl}/product/${selectedProduct.id}/availability`, params, function(availability) {
                    // $('#size-container').empty();

                    $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            const isAvailable = availability[sizeId] > 0;
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? 'Available' : 'Unavailable');
        });
        

                   

                    if (currentRecommendation) {
                        highlightRecommendedSizes(currentRecommendation);
                    }
                });
            }

            $('#color-select').on('change', function() {
                const colorId = $(this).val();
                const colorName = $('#color-select option:selected').data('color-name');
                console.log(colorName)
                const fromDate = $('#rental_from').val();
                const toDate = $('#rental_to').val();
                
                if (colorId && colorId !== 'Select' && fromDate && toDate) {
                    checkAvailability(colorId,colorName);
                }
            });

            // Size selection handler
            $(document).on('click', '.inner-size-card', function() {
                if (!$(this).hasClass('available')) return;

                $('.inner-size-card').removeClass('selected');
                $(this).addClass('selected');

                selectedSize = {
                    id: $(this).data('size-id') || $(this).data('variation-id'),
                    name: $(this).data('size-name')
                };
            });

            // Model and trailer hitch change handler
            $('#year, #trailer_hitch').change(function() {
                let manufacturer = $('#manufacturer').val();
                let year = $('#year').val();
                let model = $('#model').val();
                let trailer_hitch = $('#trailer_hitch').val();

                if (!manufacturer || !year || !model || !trailer_hitch) return;
                const productName = $('#trailer_hitch').data('product-name');
                console.log(productName);
                
                const selectedValue = $('#trailer_hitch').val();
                const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier');
                console.log(hitchRequired);
                
                if (selectedValue === 'no' && !hitchRequired) {
                    $('#trailer_hitch').val('');

                    const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
                    modal.show();
                    return;
                }


                if (manufacturer && year && model && trailer_hitch) {
                    $.get(`${baseUrl}/car/recommendation`, {
                        manufacturer,
                        year,
                        model,
                        trailer_hitch
                    }, function(data) {
                        currentRecommendation = data;
                        currentRecommendationMap = {};

                        if (data.length === 0) {
                            $('#result').html('<p>No recommendations found.</p>');
                            return;
                        }
                        $('.roof-name-detail').hide();
                        // Populate roof types
                        // $('#roof-types-container').empty().show();
                        $('#roof-types-container').show();
                        data.forEach((item, index) => {
                            const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(
                                / /g, '-');

                            // $('#roof-types-container').append(`
                        //     <div class="roof-name-detail clickable-roof" id="roof-type-${roofTypeSlug}" 
                        //          data-rooftype-slug="${roofTypeSlug}">
                        //         <figure>
                        //             <img src="${baseUrl}/frontend/images/${roofTypeSlug}.jpg" alt="${item.rooftype_eng}">
                        //         </figure>
                        //         <h4>${item.rooftype_eng}</h4>
                        //         <p>${item.rooftype_ger}</p>
                        //     </div>
                        // `);

                            
                            $(`#roof-type-${roofTypeSlug}`).show();
                            $(`#roof-type-${roofTypeSlug}`)
                                .addClass('clickable-roof')
                                .attr('data-rooftype-slug', roofTypeSlug);
                            currentRecommendationMap[roofTypeSlug] = item;
                        });
                        // $('#result').html(html);

                        if (selectedColor) {
                            highlightRecommendedSizes(data);
                        }
                    });
                }
            });

            // Roof type selection handler
            $(document).on('click', '.clickable-roof', function() {
                $('.clickable-roof').removeClass('selected');
                $(this).addClass('selected');
                $('.booking_detail_disabled').attr('disabled',false)
                const slug = $(this).data('rooftype-slug');
                selectedRecommendation = currentRecommendationMap[slug];
            });

            // Calculate rent function
            function calculateRent() {
                const from = new Date($('#rental_from').val());
                const to = new Date($('#rental_to').val());

                if (isNaN(from) || isNaN(to) || to < from) {
                    $('#rental-days').val('');
                    $('#calculated-rent').val('');
                    updateBookingAmount(0);
                    return;
                }

                const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;
                $('#rental-days').val(days);

                let totalRent = 0;

                for (let i = 0; i < days && i < dailyPrices.length; i++) {
                    totalRent += dailyPrices[i];
                    console.log(roofRackPrices);
                    if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                        totalRent += roofRackPrices[i];
                    }
                }

                if ($('#insurance_checkbox').is(':checked')) {
                    totalRent += insuranceFlatFee;
                }

                $('#calculated-rent').val(totalRent.toFixed(2) + ' €');
                updateBookingAmount(totalRent);
            }

            // Update booking amount summary
            // function updateBookingAmount(subtotal) {
            //     const insurance = $('#insurance_checkbox').is(':checked') ? insuranceFlatFee : 0;
            //     const tax = subtotal * 0.19;
            //     const netPrice = subtotal - discountAmount;
            //     const total = netPrice + tax;

            //     $('#subtotal-amount').text(subtotal.toFixed(2) + ' €');
            //     $('#discount-amount').text(discountAmount.toFixed(2) + ' €');
            //     $('#insurance-amount').text(insurance.toFixed(2) + ' €');
            //     $('#tax-amount').text(tax.toFixed(2) + ' €');
            //     $('#net-price').text(netPrice.toFixed(2) + ' €');
            //     $('#total-price').text(total.toFixed(2) + ' €');
            // }

            // Apply coupon handler
            $('#apply-coupon').click(function() {
                const couponCode = $('#coupon').val();

                if (!couponCode) return;

                $.post(`${baseUrl}/coupons/validate`, {
                    code: couponCode
                }, function(response) {
                    if (response.valid) {
                        discountAmount = response.discount;
                        calculateRent();
                        alert('Coupon applied successfully!');
                    } else {
                        alert('Invalid coupon code');
                    }
                }).fail(function() {
                    alert('Error validating coupon');
                });
            });

            $('#insurance_checkbox').on('change', function() {
                calculateRent();
            });

            $('#roof_rack_checkbox').on('change', function() {
                // console.log(roofRackPrices);

                calculateRent();

            });


            // Add booking handler
            $('#add-booking-btn').click(function() {
                var $button = $(this);
                if (!validateForm()) {
                    $('html, body').animate({
                        scrollTop: $('.is-invalid').first().offset().top - 100
                    }, 500);
                    return;
                }
                $button.prop('disabled', true);
                $button.text('Loading...');
                const formData = {
                    title: $('#inputtitle').val(),
                    first_name: $('#first_name').val(),
                    last_name: $('#last_name').val(),
                    address: $('#address').val(),
                    zip_code: $('#zip').val(),
                    city: $('#city').val(),
                    country: $('#region').val(),
                    email: $('#email').val(),
                    phone: $('#phone_number').val(),
                    product_id: $('#product-select').val(),
                    product_name: $('#product-select option:selected').data('name'),
                    manufacturer: $('#manufacturer').val(),
                    car_year: $('#year').val(),
                    model: $('#model').val(),
                    trailer_hitch: $('#trailer_hitch').val() == 'yes' ? 1 : 0,
                    roof_type: selectedRecommendation?.rooftype_eng || '',
                    color_id: $('#color-select').val(),
                    color_name: $('#color-select option:selected').data('color-name'),
                    size_id: $('.inner-size-card.selected').data('size-id') || $(
                        '.inner-size-card.selected').data('variation-id'),
                    size_name: $('.inner-size-card.selected').data('size-name'),
                    rental_from: $('#rental_from').val(),
                    rental_to: $('#rental_to').val(),
                    days: $('#rental-days').val(),
                    calculated_rent: $('#calculated-rent').val().replace(' €', ''),
                    is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                    is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                    discount: discountAmount,
                    coupon_code: $('#coupon_code').val(),
                    _token: '<?php echo e(csrf_token()); ?>'
                };

                $.post(`${baseUrl}/vendor/save/bookings`, formData, function(response) {
                    if (response.success) {
                        $button.prop('disabled', false);
                        $button.text('Add Booking');
                        Swal.fire({
                            icon: 'success',
                            title: 'Booking',
                            text: 'Booking created successfully!',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href =
                                "<?php echo e(route('vendor.booking.index')); ?>";
                            }
                        });

                        // alert('Booking created successfully!');
                        // window.location.href = "<?php echo e(route('admin.booking.index')); ?>";
                    } else {
                        $button.prop('disabled', false);
                        $button.text('Add Booking');
                        Swal.fire({
                            icon: 'error',
                            title: 'Booking',
                            text: 'Error creating booking: ' + response.message,
                        });

                        // alert('Error creating booking: ' + response.message);
                    }
                }).fail(function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        for (const field in errors) {
                            $(`#${field}`).addClass('is-invalid');
                            $(`#${field}`).after(
                                `<div class="invalid-feedback">${errors[field][0]}</div>`);
                        }
                    } else {
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Booking',
                            text: 'Error creating booking',
                        });
                        $button.prop('disabled', false);
                        $button.text('Add Booking');
                        // alert('Error creating booking');
                    }
                });
            });

            // Form validation
            function validateForm() {
    let isValid = true;

    $('.is-invalid').removeClass('is-invalid');
    $('.invalid-feedback').remove();

    // Validate customer details
    const requiredFields = [
        {id: 'first_name', message: 'Please enter first name'},
        {id: 'last_name', message: 'Please enter last name'},
        {id: 'address', message: 'Please enter street address'},
        {id: 'zip', message: 'Please enter zip code'},
        {id: 'city', message: 'Please enter city'},
        {id: 'email', message: 'Please enter email address'},
        {id: 'phone_number', message: 'Please enter phone number'}
    ];

    requiredFields.forEach(field => {
        const $input = $(`#${field.id}`);
        const value = $input.val();

        if (!value) {
            $input.addClass('is-invalid');

            // Custom handling for phone_number
            if (field.id === 'phone_number') {
                const $container = $input.closest('.comn-input-select');
                $container.find('.invalid-feedback').remove();
                $container.append(`<div class="invalid-feedback d-block">${field.message}</div>`);
            } else {
                $input.siblings('.invalid-feedback').remove();
                $input.after(`<div class="invalid-feedback">${field.message}</div>`);
            }

            isValid = false;
        } else {
            $input.removeClass('is-invalid');
            $input.siblings('.invalid-feedback').remove();

            if (field.id === 'phone_number') {
                $input.closest('.comn-input-select').find('.invalid-feedback').remove();
            }
        }
    });

    // Validate car details
    if (!$('#manufacturer').val()) {
        $('#manufacturer').addClass('is-invalid');
        $('#manufacturer').parent().append(
            '<div class="invalid-feedback">Please select manufacturer</div>');
        isValid = false;
    }

    if (!$('#year').val()) {
        $('#year').addClass('is-invalid');
        $('#year').parent().append('<div class="invalid-feedback">Please select year</div>');
        isValid = false;
    }

    if (!$('#model').val()) {
        $('#model').addClass('is-invalid');
        $('#model').parent().append('<div class="invalid-feedback">Please select model</div>');
        isValid = false;
    }

    if (!$('#trailer_hitch').val()) {
        $('#trailer_hitch').addClass('is-invalid');
        $('#trailer_hitch').parent().append(
            '<div class="invalid-feedback">Please select trailer hitch option</div>');
        isValid = false;
    }

    // Validate product details
    if (!$('#product-select').val()) {
        $('#product-select').addClass('is-invalid');
        $('#product-select').parent().append('<div class="invalid-feedback">Please select a product</div>');
        isValid = false;
    }

    if (!$('#color-select').val()) {
        $('#color-select').addClass('is-invalid');
        $('#color-select').parent().append('<div class="invalid-feedback">Please select a color</div>');
        isValid = false;
    }

    if (!$('.inner-size-card.selected').length) {
        $('#size-container').after(
            '<div class="invalid-feedback d-block">Please select a size/variation</div>');
        isValid = false;
    }

    // Validate booking dates
    if (!$('#rental_from').val()) {
        $('#rental_from').addClass('is-invalid');
        $('#rental_from').after('<div class="invalid-feedback">Please select pick-up date</div>');
        isValid = false;
    }

    if (!$('#rental_to').val()) {
        $('#rental_to').addClass('is-invalid');
        $('#rental_to').after('<div class="invalid-feedback">Please select drop-off date</div>');
        isValid = false;
    }

    if ($('#rental_from').val() && $('#rental_to').val()) {
        const from = new Date($('#rental_from').val());
        const to = new Date($('#rental_to').val());

        if (to < from) {
            $('#rental_to').addClass('is-invalid');
            $('#rental_to').after(
                '<div class="invalid-feedback">Drop-off date must be after pick-up date</div>');
            isValid = false;
        }
    }

    if ($('#coupon_code').val() && $('#coupon_code').is(':disabled')) {
        const originalProduct = $('#product-select').data('original-product');
        if (originalProduct && originalProduct !== $('#product-select').val()) {
            isValid = false;
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'You changed the product after applying a coupon. Please re-apply the coupon.',
                confirmButtonColor: '#5BC0DE',
            });
        }
    }

    return isValid;
}

            // Helper function to get size text
            function getSizeText(size) {
                switch (size) {
                    case 'S':
                        return '>400l';
                    case 'M':
                        return '400l - 420l';
                    case 'L':
                        return '450l - 480l';
                    case 'XL':
                        return '500l - 524l';
                    case 'XXL':
                        return '600l';
                    default:
                        return '';
                }
            }

            // Helper function to highlight recommended sizes
            function highlightRecommendedSizes(recommendation) {
                $('.inner-size-card').removeClass('recommended-size');

                recommendation.forEach(item => {
                    $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`)
                        .addClass('recommended-size')
                        .find('.badge').text('Recommended');
                });
               
            }

            $('#apply_coupon').click(function() {
    var couponCode = $('#coupon_code').val().trim();
    var productId = $('#product-select').val();
    var subtotal = parseFloat($('#subtotal-amount').text().replace(' €', ''));

    if (!couponCode) {
        Swal.fire({
            icon: 'warning',
            title: 'Error',
            text: 'Please enter a coupon code',
            confirmButtonColor: '#5BC0DE',
        });
        return;
    }

    if (!productId) {
        Swal.fire({
            icon: 'warning',
            title: 'Error',
            text: 'Please select a product first',
            confirmButtonColor: '#5BC0DE',
        });
        return;
    }

    $.ajax({
        url: '<?php echo e(route("vendor.booking.apply_coupon")); ?>',
        type: 'POST',
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            coupon_code: couponCode,
            product_id: productId,
            subtotal: subtotal,
        },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                // Update discount amount and recalculate totals
                discountAmount = response.discount;
                console.log(discountAmount);
                
                calculateRent();
                
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: response.message,
                    confirmButtonColor: '#5BC0DE',
                });
                
                // Optionally disable coupon input after successful application
                $('#coupon_code').prop('disabled', true);
                $('#apply_coupon').prop('disabled', true);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message,
                    confirmButtonColor: '#5BC0DE',
                });
            }
        },
        error: function(xhr) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred. Please try again.',
                confirmButtonColor: '#5BC0DE',
            });
        }
    });
});
function updateBookingAmount(subtotal) {
    // Ensure these are floats
    const insurance = $('#insurance_checkbox').is(':checked') ? parseFloat(insuranceFlatFee) : 0;
    const discountAmountFloat = parseFloat(discountAmount); // Ensure discountAmount is a float
    const subtotalFloat = parseFloat(subtotal); // Ensure subtotal is a float
    // console.log(subtotalFloat);
    
    const tax = (subtotalFloat - discountAmountFloat) * 0.19; // Tax is calculated after discount
    const netPrice = subtotalFloat - discountAmountFloat;
    const total = netPrice + tax;
    console.log(tax, netPrice, total);
    
    discountAmount = discountAmountFloat;
    // Update the UI with formatted values, ensuring floats are rounded to two decimal places
    $('#subtotal-amount').text(subtotalFloat.toFixed(2) + ' €');
    $('#discount-amount').text(discountAmountFloat.toFixed(2) + ' €');
    $('#insurance-amount').text(insurance.toFixed(2) + ' €');
    $('#tax-amount').text(tax.toFixed(2) + ' €');
    $('#net-price').text(netPrice.toFixed(2) + ' €');
    $('#total-price').text(total.toFixed(2) + ' €');
}


// Initialize Select2
$('.select2').select2({
    placeholder: "Select a coupon",
    allowClear: true
});
        });

//         $('#apply_coupon').click(function() {
//     var couponCode = $('#coupon_code').val().trim();
//     var subTotal = $('#cart_sub_total').text().replace(' €', '').replace(',', '.');
    
//     if (!couponCode) {
//         $('#coupon_message').html('<div class="alert alert-danger">Please enter a coupon code</div>');
//         return;
//     }

//     $.ajax({
//         url: '<?php echo e(route("cart.apply_coupon")); ?>',
//         type: 'POST',
//         data: {
//             _token: '<?php echo e(csrf_token()); ?>',
//             coupon_code: couponCode,
//             sub_total: subTotal,
//         },
//         dataType: 'json',
//         success: function(response) {
//             if (response.success) {
//                 // Show success message
//                 $('#coupon_message').html('<div class="alert alert-success">' + response.message + '</div>');
                
//                 // Hide input and show applied coupon
//                 $('.coupn_input_wrap').hide();
//                 $('#applied_coupon_section').show();
//                 $('.applied-coupon-code').text(couponCode);
                
//                 // Update cart totals
//                 if (response.discount) {
//                     $('.discount-amount').text('-$' + response.discount.toFixed(2));
//                     $('.total-amount').text('$' + response.new_total.toFixed(2));
//                 }
//                 window.location.reload()
//             } else {
//                 $('#coupon_message').html('<div class="alert alert-danger">' + response.message + '</div>');
                
//             }
//         },
//         error: function(xhr) {
//             $('#coupon_message').html('<div class="alert alert-danger">An error occurred. Please try again.</div>');
//         }
//     });
// });



    </script>
    <script>
        function formatFlag(option) {
            if (!option.id) return option.text;
            const imageUrl = $(option.element).data('image');
            const text = option.text;
            if (imageUrl) {
                return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
            }
            return text;
        }
    
        $(document).ready(function () {
            $('#country_code').select2({
                templateResult: formatFlag,
                templateSelection: formatFlag,
                minimumResultsForSearch: -1 
            });
        });
    </script>
    
<?php $__env->stopPush(); ?>
    <style>
        .clickable-roof {
            border: 2px solid transparent;
            cursor: pointer;
            transition: 0.2s;
            margin-bottom: 15px;
        }

        .clickable-roof:hover {
            border-color: #007bff;
        }

        .clickable-roof.selected {
            border-color: #007bff;
            background-color: #e9f5ff;
        }

        .inner-size-card {
            cursor: pointer;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        .inner-size-card.selected {
            border-color: #007bff;
            background-color: #e9f5ff;
        }

        .inner-size-card.unavailable {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .inner-size-card.recommended-size {
            border-color: #28a745;
        }

        .badge.bg-success {
            background-color: #28a745 !important;
        }

        .invalid-feedback {
            color: #dc3545;
            font-size: 0.875em;
        }

        .is-invalid {
            border-color: #dc3545 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/vendor/booking/add_booking.blade.php ENDPATH**/ ?>