<?php $__env->startSection('content'); ?>
<style>
    .working-hours-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    .working-hours-table th, 
    .working-hours-table td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }
    .working-hours-table th {
        background-color: #f8f9fa;
        font-weight: 600;
    }
    .closed-day {
        color: #dc3545;
        font-weight: 500;
    }
    .holiday-list {
        margin-top: 20px;
    }
    .holiday-item {
        display: flex;
        justify-content: space-between;
        padding: 10px 15px;
        border-bottom: 1px solid #eee;
        align-items: center;
    }
    .holiday-name {
        font-weight: 500;
    }
    .holiday-date {
        color: #6c757d;
    }
    .profile-image-container {
        width: 150px;
        height: 150px;
        border-radius: 50%;
        overflow: hidden;
        margin-bottom: 20px;
        border: 3px solid #f1f1f1;
    }
    .profile-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .detail-section {
        margin-bottom: 30px;
        padding-bottom: 20px;
        border-bottom: 1px solid #eee;
    }
    .detail-section h2 {
        margin-bottom: 20px;
        color: #333;
        font-weight: 600;
    }
    .detail-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
    }
    .detail-item {
        margin-bottom: 15px;
    }
    .detail-item h5 {
        font-size: 14px;
        color: #6c757d;
        margin-bottom: 5px;
    }
    .detail-item p {
        font-size: 16px;
        color: #333;
        font-weight: 500;
    }
    .status-active {
        color: #28a745;
        font-weight: 500;
    }
    .status-inactive {
        color: #dc3545;
        font-weight: 500;
    }
</style>

<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('admin.commission.index')); ?>">Commission Management</a>
            <a class="active">Commission Details</a>
        </div>
    </div>
    
    <div class="add-user-form sora-font">
        <div class="main-show-detail-viwe">
            <!-- Profile Section -->
            <div class="detail-section">
                <h2>Commission Details</h2>
                <div class="d-flex align-items-center gap-4">
                    <div class="profile-image-container">
                        <img src="<?php echo e($vendor->profile_image ? asset('storage/' . $vendor->profile_image) : ''); ?>" alt="">
                    </div>
                    <div class="user-data">
                        <div class="spo-name">
                            <h2>SPO Name</h2>
                            <h4><?php echo e(ucfirst($vendor->title)); ?>. <?php echo e($vendor->first_name); ?> <?php echo e($vendor->last_name); ?></h4>
                        </div>
                        <div class="spo-id">
                            <h2>SPO ID</h2>
                            <h4>#<?php echo e($vendor->id); ?></h4>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Basic Information -->
           
            
            <!-- Contact Information -->
            <div class="detail-section">
                <h2>Address</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <h5>Street, House Number</h5>
                        <p><?php echo e($vendor->street ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Zip Code</h5>
                        <p><?php echo e($vendor->zip_code ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>City</h5>
                        <p><?php echo e($vendor->city ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Country</h5>
                        <p><?php echo e($vendor->country ?? 'Germany'); ?></p>
                    </div>
                </div>
            </div>

            <div class="detail-section">
                <h2>SPO Details</h2>
                <div class="detail-grid">

                    <div class="detail-item">
                        <h5>Email Address</h5>
                        <p><?php echo e($vendor->email ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Phone Number</h5>
                        <p><?php echo e(($vendor->country_code ?? '') . ' ' . ($vendor->number ?? 'N/A')); ?></p>
                    </div>
                </div>
            </div>
            
            <!-- Business Information -->
            <div class="detail-section">
                <h2>Business Details</h2>
                <div class="detail-grid">
                     <div class="detail-item">
                        <h5>New In Business</h5>
                        <p><?php echo e($vendor->new_in_business ? 'Yes' : 'No'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Business Type</h5>
                        <p><?php echo e($vendor->business_type ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Business Model</h5>
                        <p><?php echo e($vendor->business_model ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Name Of The Contract</h5>
                        <p><?php echo e($vendor->contact_person ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Size of Location</h5>
                        <p><?php echo e($vendor->size_of_location ?? 'N/A'); ?></p>
                    </div>
                   
                    <div class="detail-item">
                        <h5>Status</h5>
                        <p class="
                            <?php if($vendor->status === 'active'): ?> status-active
                            <?php elseif($vendor->status === 'inactive'): ?> status-inactive
                            <?php elseif($vendor->status === 'closed'): ?> status-closed
                            <?php else: ?> '' <?php endif; ?>
                        ">
                            <?php echo e(ucfirst($vendor->status)); ?>

                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-12 mt-3 detail-section">
                <h2 class="mb-5">Conditions:</h2>
                <table class="table table-bordered" id="existingCommissionTable">
                    <thead>
                        <tr>
                            <th>Sales Tier</th>
                            
                            <th>Commission %</th>
                            <th>Shop Fee </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($vendor->commission_rate) && is_array($vendor->commission_rate)): ?>
                            <?php $__currentLoopData = $vendor->commission_rate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $range => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $parts = explode('-', $range);
                                $from = $parts[0];
                                $to = $parts[1] ?? 'Above';
                                $commission = $data['commission'] ?? '';
                                $shop_fee = $data['shop_fee'] ?? '';
                            ?>
                               <tr>
                                    <td><?php echo e(number_format($from, 2, ',', '.')); ?>€ - <?php echo e(number_format($to, 2, ',', '.')); ?>€</td>
                                    <td><?php echo e($commission); ?>%</td>
                                    <td><?php echo e(number_format($shop_fee, 2, ',', '.')); ?>€</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Tax & Banking Information -->
            <div class="detail-section">
                <h2>Bank Details</h2>
                <div class="detail-grid">
                    
                    <div class="detail-item">
                        <h5>Bank Name</h5>
                        <p><?php echo e($vendor->bank_name ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Bank Account Number</h5>
                        <p><?php echo e($vendor->account_number ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>IBAN Number</h5>
                        <p><?php echo e($vendor->iban_number ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Bank Account Owner</h5>
                        <p><?php echo e($vendor->account_owner ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>BIC Number</h5>
                        <p><?php echo e($vendor->bic_number ?? 'N/A'); ?></p>
                    </div>
                    
                   
                </div>
            </div>

            <div class="detail-section">
                <h2>Tax Related Information</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <h5>Tax Number</h5>
                        <p><?php echo e($vendor->tax_number ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Tax ID (UMSt.-ID)</h5>
                        <p><?php echo e($vendor->tax_id ?? 'N/A'); ?></p>
                    </div>
                    
                   
                </div>
            </div>
            <h2>Revenue Growth</h2>
            <div class="table-wrappe">
                <div class="year-block d-flex gap-4">
                            <div class="sownload-cv-pdf ">
                                <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
                                <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
                            </div>
                            <form method="GET" class="d-flex align-items-start gap-4">
                                <select name="year" class="form-select" onchange="this.form.submit()">
                                    <?php for($y = now()->year; $y >= now()->year - 3; $y--): ?>
                                        <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </form>
                        </div>

                        <table id="vendorMonthlyTable" class="table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Month</th>
                                    <th>Total Revenue</th>
                                    <th>Cancellation Rate </th>
                                    <th>Commission Rate </th>
                                    <th>Commission</th>
                                    <th>Shop Fee</th>
                                    <th>Total Fee</th>
                                    <th>Total Fee Net Amount</th>
                                    <th>Total Fee Tax Amount</th>
                                    <th>Payout</th>
                                    <th>Payout Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $monthlyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(substr($month, 0, 3)); ?></td>

                                        <td><?php echo e(number_format($data['total_revenue'], 2, ',', '.')); ?>€</td>
                                        <td ><?php echo e(number_format($data['cancellation_rate'], 2, ',', '.')); ?>%</td>
                                        <td><?php echo e(number_format($data['commission_rate'], 2, ',', '.')); ?>%</td>
                                        <td><?php echo e(number_format($data['commission'], 2, ',', '.')); ?>€</td>
                                        <td><?php echo e(number_format($data['shop_fee'], 2, ',', '.')); ?>€</td>
                                        <td><?php echo e(number_format($data['totalFee'], 2, ',', '.')); ?>€</td>
                                        <td><?php echo e(number_format($data['totalFeeNetAmount'], 2, ',', '.')); ?>€</td>
                                        <td><?php echo e(number_format($data['totalFeeTaxAmount'], 2, ',', '.')); ?>€</td>
                                        <td class="fw-bold "><?php echo e($data['payout'] > 0 ?  number_format($data['payout'], 2, ',', '.') : number_format(0, 2, ',', '.')); ?>€</td>
                                        <td>
                                            <?php echo e($data['payout_date'] ? \Carbon\Carbon::parse($data['payout_date'])->format('d.m.Y') : ''); ?>

                                        </td>
                                        
                                        <td>
                                            <a href="#" class="edit-btn-eye" onclick="openPayoutModal('<?php echo e($month); ?>', '<?php echo e($vendor->id); ?>')">
                                                <i class="fa-solid fa-pen-to-square"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot class="fw-bold table-secondary">
                                <tr>
                                    <td>Total</td>
                                    <td id="total_total_revenue"></td>
                                    <td>-</td>
                                    <td >-</td>
                                    <td id="total_commission"></td>
                                    <td id="total_shop_fee"></td>
                                    <td id="total_fee"></td>
                                    <td id="total_fee_net_amount"></td>
                                    <td id="total_fee_tax_amount"></td>
                                    <td id="total_payout"></td>
                                    <td>-</td>
                                    <td>-</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                        
                        
                        
                        <div class="upper-main-btn-last-comn d-flex">
                        
                            <a href="<?php echo e(route('admin.commission.index')); ?>">
                                <button type="button" class="cancel-btn">Back to List</button>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade modal-delete-logout" id="payoutModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="payoutModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="p-0 modal-body">
                            <div class="inner-body-delete-logout">
                                <h4 id="payout-modal-text">Enter Payout Date</h4>
                                <div id="refund-amount-group" class="mb-3" >
                                    <label for="payout-date" class="form-label">Payout Date for <span id="payout-month-name"></span></label>
                                    <input type="date"  class="form-control"  id="payout-date"  name="payout-date"required>
                                    <input type="hidden" id="payout-year" value="<?php echo e($year); ?>">

                                </div>
                                <div class="upper-btns-modal-pair">
                                    <button type="button" class="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                                    <button type="button" class="add-user" id="savePayoutDate">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.8.2/jspdf.plugin.autotable.min.js"></script>
<script>
    $(document).ready(function() {
        const table = $('#vendorMonthlyTable').DataTable({
            paging: false,
            searching: false,
            ordering: false,
            info: false,
            footerCallback: function(row, data, start, end, display) {
                const api = this.api();
    
                const parseValue = (val) => {
                    if (typeof val === 'number') return val;
                    val = (val ?? '').toString().trim();
                    if (val === '' || val === '-' ) return 0;
                    val = val.replace(/[^\d\-,.]/g, '');
                    if (val.indexOf('.') !== -1 && val.indexOf(',') !== -1) {
                        val = val.replace(/\./g, '').replace(/,/g, '.');
                    } else if (val.indexOf(',') !== -1) {
                        val = val.replace(/,/g, '.');
                    }
                    return parseFloat(val) || 0;
                };
    
            
                const colsToSum = [1, 4, 5, 6, 7, 8, 9];
    
                colsToSum.forEach((colIdx) => {
                    const total = api.column(colIdx, { page: 'current' }).data()
                        .reduce((a, b) => a + parseValue(b), 0);
    
                    const formatted = total.toLocaleString('de-DE', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    });
    
                    const footerCell = $(api.column(colIdx).footer());
                    footerCell.html(formatted + ' €');
                });

                const avgCols = [2, 3];
                    avgCols.forEach((colIdx) => {
                        const total = api.column(colIdx, { page: 'current' }).data()
                            .reduce((a, b) => a + parseValue(b), 0);

                        const avg = total / 12; // divide by 12 months

                        const formatted = avg.toLocaleString('de-DE', {
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2
                        });

                        $(api.column(colIdx).footer()).html(formatted + (colIdx === 2 ? ' %' : ' %'));
                    });
            }
        });
    });
    </script>

<script>
    const baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";

    let selectedMonth = '';
    let selectedVendorId = '';

    function openPayoutModal(month, vendorId) {
        selectedMonth = month;
        selectedVendorId = vendorId;
        document.getElementById('payout-month-name').textContent = month;
        document.getElementById('payout-date').value = ''; // reset
        const modal = new bootstrap.Modal(document.getElementById('payoutModal'));
        modal.show();
    }

    document.getElementById('savePayoutDate').addEventListener('click', function(e) {
        e.preventDefault();
        const payoutDate = document.getElementById('payout-date').value;
        if(!payoutDate) {
            alert('Please select a date');
            return;
        }

        fetch(`${baseUrl}/admin/spo/${selectedVendorId}/payout-date`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                month: selectedMonth,
                year: document.getElementById('payout-year').value,
                payout_date: payoutDate
            })
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                location.reload();
            } else {
                alert('Failed to update payout date');
            }
        })
        .catch(() => alert('Something went wrong'))
    });


    function exportData(type) {
        const table = document.getElementById("vendorMonthlyTable");
        const rows = Array.from(table.querySelectorAll("tr"));
        const data = [];

        rows.forEach(row => {
            const cols = Array.from(row.querySelectorAll("th, td"));
            const rowData = cols.map(col => col.innerText.trim())
                                .filter(text => text.toLowerCase() !== 'action');
            data.push(rowData);
        });

        if (type === 'csv') {
            exportCSV(data);
        } else if (type === 'pdf') {
            exportPDF(data);
        }
    }

    function exportCSV(data) {
        let csvContent = "";
        data.forEach(rowArray => {
            const row = rowArray.map(cell => `"${cell.replace(/"/g, '""')}"`).join(",");
            csvContent += row + "\r\n";
        });

        const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
        const link = document.createElement("a");
        link.href = URL.createObjectURL(blob);
        link.download = "<?php echo e(ucfirst($vendor->title)); ?> <?php echo e($vendor->first_name); ?> <?php echo e($vendor->last_name); ?> SPO<?php echo e($vendor->id); ?> commission_report.csv";
        link.click();
    }

    function exportPDF() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('l', 'pt', 'a4');

    const vendorName = "<?php echo e(ucfirst($vendor->title)); ?> <?php echo e($vendor->first_name); ?> <?php echo e($vendor->last_name); ?> SPO<?php echo e($vendor->id); ?>";

    doc.setFontSize(18);
    doc.setFont('helvetica', 'bold');
    doc.text('Commission Report', doc.internal.pageSize.getWidth() / 2, 30, { align: 'center' });

    doc.setFontSize(12);
    doc.setFont('helvetica', 'normal');
    doc.text('Vendor: ' + vendorName, doc.internal.pageSize.getWidth() / 2, 50, { align: 'center' });

    const headers = [];
    $('#vendorMonthlyTable thead th').each(function(index) {
        let text = $(this).text().trim();
        if(text.toLowerCase() !== 'action') {
            // Add Euro sign only in headers for these columns
            if(['shop fee','total fee','payout'].includes(text.toLowerCase())) {
                text += ' (€)';
            }
            headers.push(text);
        }
    });

    const body = [];
    $('#vendorMonthlyTable tbody tr').each(function() {
        const row = [];
        $(this).find('td').each(function(index) {
            let text = $(this).text().trim();
            const headerText = $('#vendorMonthlyTable thead th').eq(index).text().trim().toLowerCase();

            // Remove € symbol from numeric cells for PDF rows
            if(['shop fee','total fee','payout'].includes(headerText)) {
                text = text.replace('€', '').trim();
            }
            if(headerText !== 'action') row.push(text);
        });
        body.push(row);
    });

    const footerRow = [];
    $('#vendorMonthlyTable tfoot tr td').each(function(index) {
        let text = $(this).text().trim();
        const headerText = $('#vendorMonthlyTable thead th').eq(index).text().trim().toLowerCase();

        if(['shop fee','total fee','payout'].includes(headerText)) {
            text = text.replace('€', '').trim();
        }
        if(headerText !== 'action') footerRow.push(text);
    });
    if (footerRow.length) body.push(footerRow);

    doc.autoTable({
        head: [headers],
        body: body,
        startY: 70,
        theme: 'grid',
        headStyles: { fillColor: [242, 242, 242], textColor: [0, 0, 0], lineColor: [0,0,0], lineWidth: 0.5, cellPadding: 8 },
        styles: { fontSize: 10, textColor: [0,0,0], lineColor: [0,0,0], lineWidth: 0.5, cellPadding: 8 },
        tableLineColor: [0,0,0],
        tableLineWidth: 0.5
    });

    doc.save('vendor_commission.pdf');
}



    </script>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/commission/detail.blade.php ENDPATH**/ ?>