<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Daily Tasks Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; table-layout: fixed; }
        th, td { border: 1px solid #ddd; padding: 4px; text-align: left; word-wrap: break-word; font-size: 9px; }
        th { background-color: #f2f2f2; }
    </style>
    
</head>
<body>
    <h1>Daily Tasks Report</h1>
    
    <div class="report-period">
        <?php if($fromDate || $toDate): ?>
            <p>
                Report Period: 
                <?php echo e($fromDate ? \Carbon\Carbon::parse($fromDate)->format('d.m.Y') : 'Start'); ?> 
                to 
                <?php echo e($toDate ? \Carbon\Carbon::parse($toDate)->format('d.m.Y') : 'End'); ?>

            </p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Activity</th>
                <th>Date</th>
                <th>Time</th>
                <th>Product</th>
                <th>Size</th>
                <th>Insurance</th>
                <th>Customer</th>
                <th>Vehicle</th>
                <th>Roof Type</th>
                <th>Roof Carrier</th>
                <th>Traverse Length</th>
                <th>Foot SKU</th>
                <th>Footkit SKU</th>
                <th>BookingID</th>
                <th>Invoicenumber</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $item = $booking->items->first();
                    if ($fromDate && $toDate) {
                        $rangeStart = \Carbon\Carbon::parse($fromDate);
                        $rangeEnd = \Carbon\Carbon::parse($toDate);
                        if ($item->pickup_date && \Carbon\Carbon::parse($item->pickup_date)->between($rangeStart, $rangeEnd,true)) {
                            $activity = 'Pick-Up';
                        } elseif ($item->dropoff_date && \Carbon\Carbon::parse($item->dropoff_date)->between($rangeStart, $rangeEnd,true)) {
                            $activity = 'Drop-Off';
                        } else {
                            $activity = 'Other';
                        }
                    } else {
                        $activity = 'Other';
                    }
                ?>
                <tr>
                    <td><?php echo e($activity); ?></td>
                    <td><?php echo e($activity == 'Pick-Up' ? \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') : \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y')); ?></td>
                    <td><?php echo e($activity == 'Pick-Up' ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : ($activity == 'Drop-Off' ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : 'N/A')); ?></td>
                    <td><?php echo e($item->product_name ?? 'N/A'); ?></td>
                    <td><?php echo e($item->size ?? 'N/A'); ?></td>
                    <td><?php echo e($item->is_insured ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e($booking->userDetails ? $booking->userDetails->first_name.' '.$booking->userDetails->last_name : 'N/A'); ?></td>
                    <td><?php echo e($item->car_name); ?> <?php echo e($item->car_year); ?> <?php echo e($item->model); ?></td>
                    <td><?php echo e($item->roof_type); ?></td>
                    <td><?php echo e($item->is_carrier_included ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e($item->carrier_length); ?></td>
                    <td><?php echo e($item->foot_sku); ?></td>
                    <td><?php echo e($item->footkit_sku); ?></td>
                    <td><?php echo e($booking->id); ?></td>
                    <td><?php echo e($booking->invoice_number ?? 'N/A'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/report/daily_tasks_pdf.blade.php ENDPATH**/ ?>