<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('admin.voucher.index')); ?>">Voucher management</a>
            <a class="active" href="">Create Voucher</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>Create Voucher</h3>
        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form id="voucherForm" class="row" method="POST" action="<?php echo e(route('admin.store.voucher')); ?>">
            <?php echo csrf_field(); ?>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="name" class="form-label">Voucher Name *</label>
                    <input type="text" placeholder="Enter Voucher Name" class="form-control"
                        id="name" name="name" value="<?php echo e(old('name')); ?>">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="code" class="form-label">Voucher Code *</label>
                    <input type="text" placeholder="Voucher Code" class="form-control" 
                        id="code" name="code" value="<?php echo e(old('code')); ?>">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="min_order_value" class="form-label">Min. Order Value *</label>
                    <input type="number" step="0.01" class="form-control" 
                        id="min_order_value" name="min_order_value" 
                        placeholder="Enter Minimum Order Value" value="<?php echo e(old('min_order_value')); ?>">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="max_discount" class="form-label">Max. Discount *</label>
                    <input type="number" step="0.01" class="form-control" 
                        id="max_discount" name="max_discount" 
                        placeholder="Enter Maximum Discount" value="<?php echo e(old('max_discount')); ?>">
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="start_date" class="form-label">Start Date *</label>
                    <input type="text" class="form-control datepicker" 
                        id="start_date" name="start_date" value="<?php echo e(old('start_date')); ?>"
                        autocomplete="off" readonly>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="expiration_date" class="form-label">Expiration Date *</label>
                    <input type="text" class="form-control datepicker" 
                        id="expiration_date" name="expiration_date" value="<?php echo e(old('expiration_date')); ?>"
                        autocomplete="off" readonly>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select main-all-select-2">
                    <label for="applied_to" class="form-label">Applied to</label>
                    <select id="applied_to" name="applied_to[]" class="form-select" multiple>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($product->id); ?>"
                                <?php echo e(collect(old('applied_to'))->contains($product->id) ? 'selected' : ''); ?>>
                                <?php echo e($product->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="type" class="form-label">Select Type *</label>
                    <select id="type" class="form-select" name="type">
                        <option value="1" <?php echo e(old('type') == '1' ? 'selected' : ''); ?>>Fixed</option>
                        <option value="2" <?php echo e(old('type') == '2' ? 'selected' : ''); ?>>Percentage</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="customer_type" class="form-label">Select Customer Type *</label>
                    <select id="customer_type" class="form-select" name="customer_type">
                        <option value="" disabled selected>Select customer type</option>
                        <option value="all" <?php echo e(old('customer_type') == 'all' ? 'selected' : ''); ?>>All</option>
                        <option value="new" <?php echo e(old('customer_type') == 'new' ? 'selected' : ''); ?>>New Customers</option>
                        <option value="existing" <?php echo e(old('customer_type') == 'existing' ? 'selected' : ''); ?>>Existing Customers</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="voucher_value" class="form-label">Voucher Value*</label>
                    <input type="number" step="1.00" min="1" class="form-control" 
                        id="voucher_value" name="voucher_value" 
                        placeholder="Enter Voucher Value" value="<?php echo e(old('voucher_value')); ?>">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="combine_with_other_vouchers" class="form-label">Combination with other Voucher *</label>
                    <select id="combine_with_other_vouchers" class="form-select" name="combine_with_other_vouchers">
                        <option value="" disabled selected>Select option</option>
                        <option value="1" <?php echo e(old('combine_with_other_vouchers', 1) == 1 ? 'selected' : ''); ?>>YES</option>
                        <option value="0" <?php echo e(old('combine_with_other_vouchers', 1) == 0 ? 'selected' : ''); ?>>No</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="redemption_limit" class="form-label">Set Limit for voucher Redemption</label>
                    <input 
                    type="number" 
                    class="form-control" 
                    id="redemption_limit" 
                    name="redemption_limit" 
                    placeholder="Set Limit (leave empty for no limit)" 
                    min="1" 
                    max="50" 
                    oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);" 
                    value="<?php echo e(old('redemption_limit')); ?>">
                
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Create Voucher</button>
                    <a href="<?php echo e(route('admin.voucher.index')); ?>" class="cancel-btn">Cancel</a>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->startPush('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
     $('#applied_to').select2({
        placeholder: "Select products",
        allowClear: true,
        width: '100%'
    });
$('.datepicker').datepicker({
        
        autoclose: true,
        todayHighlight: true,
        dateFormat: 'dd.mm.yy',
                minDate: 0,
                beforeShowDay: function(date) {
                    const day = date.getDay();
                    return [(day !== 0 && day !== 6), ''];
                },
    });

    // Set expiration date min date based on start date
    $('#start_date').on('changeDate', function(e) {
        $('#expiration_date').datepicker('setStartDate', e.date);
        $('#expiration_date').val('').datepicker('update');
        $('#expiration_date').focus();
    });

    // Reset expiration date if start date is cleared
    $('#start_date').on('clearDate', function() {
        $('#expiration_date').datepicker('setStartDate', new Date());
        $('#expiration_date').val('').datepicker('update');
    });
    
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Validation rules
    const validationRules = {
        name: {
            required: true,
            minlength: 3,
            maxlength: 255
        },
        code: {
            required: true,
            minlength: 5,
            maxlength: 50,
            pattern: /^[A-Za-z0-9\-_]+$/
        },
        min_order_value: {
            required: true,
            min: 0
        },
        max_discount: {
            required: true,
            min: 0
        },
        voucher_value: {
            required: true,
            min: 1
        },
        start_date: {
            required: true,
            date: true
        },
        expiration_date: {
            required: true,
            date: true,
            greaterThanStart: true
        },
        customer_type: {
            required: true
        },
        combine_with_other_vouchers: {
            required: true
        },
        redemption_limit: {
            required: true,
            min: 1
        }
    };

    $.validator.addMethod("greaterThanStart", function(value, element) {
        if (!value) return true; // Skip if empty
        const startDate = new Date($('#start_date').val());
        const endDate = new Date(value);
        return endDate > startDate;
    }, "Expiration date must be after start date");

    // Custom validation method for voucher code format
    $.validator.addMethod("pattern", function(value, element, param) {
        return this.optional(element) || param.test(value);
    }, "Invalid format");

    // Initialize validation
    $('#voucherForm').validate({
        rules: validationRules,
        messages: {
            name: {
                required: "Please enter voucher name",
                minlength: "Voucher name must be at least 3 characters",
                maxlength: "Voucher name cannot exceed 255 characters"
            },
            code: {
                required: "Please enter Voucher code",
                minlength: "Voucher code must be at least 5 characters",
                maxlength: "Voucher code cannot exceed 50 characters",
                pattern: "Voucher code can only contain letters, numbers, hyphens, and underscores"
            },
            min_order_value: {
                required: "Please enter Minimum order value",
                min: "Minimum order value must be a positive number"
            },
            max_discount: {
                required: "Please enter Maximum discount",
                min: "Maximum discount must be a positive number"
            },
            start_date: {
                required: "Please enter Start date",
                date: "Please enter a valid date"
            },
            expiration_date: {
                required: "Please enter Expiration date",
                date: 'Please enter a valid date',
             
            },
            customer_type: {
                required: "Please enter Customer type"
            },
            combine_with_other_vouchers: {
                required: "Please specify if this voucher can be combined with others"
            },
            redemption_limit: {
                min: "Redemption limit must be at least 1 if specified"
            }
        },
        errorElement: "div",
        errorClass: "error-message",
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        highlight: function(element, errorClass) {
            $(element).addClass('is-invalid').removeClass('is-valid');
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass('is-invalid').addClass('is-valid');
        },
        submitHandler: function(form) {
            // Check if voucher code is unique before submission
            checkVoucherCodeUniqueness().then(function(isUnique) {
                if (isUnique) {
                    form.submit();
                } else {
                    $('#code').addClass('is-invalid');
                    $('#code').next('.error-message').text('This voucher code already exists');
                }
            });
            return false;
        }
    });

    // Real-time validation on blur
    $('input, select').blur(function() {
        $(this).valid();
    });
    $('.datepicker').on('changeDate', function() {
        $(this).valid();
    });

    // Check voucher code uniqueness via AJAX
    $('#code').on('blur', function() {
        if ($('#code').valid()) {
            checkVoucherCodeUniqueness().then(function(isUnique) {
                $('#code').addClass('is-valid');
                $('#code').next('.error-message').text('');
                if (!isUnique) {
                    $('#code').addClass('is-invalid');
                    $('#code').next('.error-message').text('This voucher code already exists');
                }
            });
        }
    });

    // Function to check voucher code uniqueness
    function checkVoucherCodeUniqueness() {
        return new Promise(function(resolve) {
            if ($('#code').val().length >= 5) {
                $.ajax({
                    url: '<?php echo e(route("admin.vouchers.check.code")); ?>',
                    method: 'POST',
                    data: {
                        code: $('#code').val()
                    },
                    success: function(response) {
                  
                        
                        resolve(!response.exists);
                    },
                    error: function() {
                        resolve(true); // Assume unique if error occurs
                    }
                });
            } else {
                resolve(true); // Assume unique if code is too short
            }
        });
    }

</script>
<?php $__env->stopPush(); ?>
<style>
    .datepicker {
        z-index: 9999 !important;
    }
    /* Your existing validation styles */
    .is-invalid {
        border-color: #dc3545 !important;
    }
    /* .is-valid {
        border-color: #28a745 !important;
    } */
    .error-message {
        color: #dc3545;
        font-size: 1.4em;
        margin-top: 0.25rem;
    }
    </style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/voucher/create_voucher.blade.php ENDPATH**/ ?>