<?php $__env->startSection('content'); ?>
    <h1>Product Analytics Report</h1>
    <p>Generated on: <?php echo e(now()->format('d.m.Y')); ?></p>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Category</th>
                <th>SKU</th>
                <th>Size/Variation</th>
                <th>Color</th>
                <th>Total Quantity</th>
                <th>Remaining Quantity</th>
                <th>Dimensions (LxWxH)</th>
                <th>Weight</th>
                <th>Volume</th>
                <th>Max Load</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($product->variations->isEmpty()): ?>
                    <tr>
                        <td><?php echo e($product->id); ?></td>
                        <td><?php echo e($product->name); ?></td>
                        <td><?php echo e($product->category->name ?? '-'); ?></td>
                        <td><?php echo e($product->sku ?? '-'); ?></td>
                        <td>-</td>
                        <td><?php echo e($product->color->name ?? '-'); ?></td>
                        <td><?php echo e($product->quantity); ?></td> 
                        <td><?php echo e($product->total_quantity ?? $product->quantity); ?></td> 
                        <td><?php echo e($product->length.'x'.$product->width.'x'.$product->height); ?></td>
                        <td><?php echo e($product->weight); ?></td>
                        <td><?php echo e($product->volume); ?></td>
                        <td><?php echo e($product->max_load); ?></td>
                        <td><?php echo e($product->status); ?></td>
                    </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $variation->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($product->id); ?></td>
                                <td><?php echo e($product->name); ?></td>
                                <td><?php echo e($product->category->name ?? '-'); ?></td>
                                <td><?php echo e($option->sku); ?></td>
                                <td><?php echo e($variation->size->name ?? $variation->variation->name ?? '-'); ?></td>
                                <td><?php echo e($option->color->name ?? '-'); ?></td>
                                <td><?php echo e($option->quantity); ?></td> 
                                <td><?php echo e($option->total_quantity ?? $option->quantity); ?></td> 
                                <td><?php echo e($variation->length.'x'.$variation->width.'x'.$variation->height); ?></td>
                                <td><?php echo e($variation->weight); ?></td>
                                <td><?php echo e($variation->volume); ?></td>
                                <td><?php echo e($variation->max_load); ?></td>
                                <td><?php echo e($variation->status); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        
    </table>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.pdf', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/product/pdf.blade.php ENDPATH**/ ?>