<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

  <title>Dachboxmiete</title>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

  <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&family=Montserrat:ital,wght@0,100..900;1,100..900&family=Oswald:wght@200..700&display=swap" rel="stylesheet">

  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">


  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">


  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">
  <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" />
  <!-- ===============owl============ -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css">

  <link rel="stylesheet" href="<?php echo e(asset('frontend/css/main.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('frontend/css/responsive.css')); ?>">
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script> 
  <script src="<?php echo e(asset('frontend/js/main.js')); ?>"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <?php echo $__env->yieldContent('style'); ?>
</head>
<header>
  <div class="top-header">
    <img src="<?php echo e(asset('frontend/images/google-img.svg')); ?>" alt="Google Logo">
    <p><?php echo e(__('messages.overall')); ?> <span class="txt-600"><?php echo e(__('messages.rating')); ?></span></p>
    <div class="icon">
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
    </div>
    <p><span class="txt-600">5.0</span> <?php echo e(__('messages.out_of')); ?> <span class="txt-600">5</span>, <?php echo e(__('messages.based_on')); ?> <span class="txt-600"><?php echo e(GetMetaData('total_reviews', 'home')); ?>  <?php echo e(__('messages.reviews')); ?></span></p>

  </div>


  <div class="main-header">
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
      <a class="navbar-brand" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('frontend/images/logo.svg')); ?>" alt=""></a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="menu collapse navbar-collapse" id="navbarNavAltMarkup">
        <div class="navbar-nav">
          <a class="nav-item nav-link active" href="<?php echo e(route('home')); ?>"><?php echo e(__('messages.home')); ?> <span class="sr-only">(current)</span></a>
          <?php if(getHeaderLink('about-us')): ?>
          <a class="nav-item nav-link" href="<?php echo e(route('about')); ?>"><?php echo e(GetMetaData('page_title','about-us')); ?></a>
          <?php endif; ?>
          <a class="nav-item nav-link" href="<?php echo e(route('product')); ?>"><?php echo e(__('messages.products')); ?></a>
          <a class="nav-item nav-link" href="<?php echo e(route('blog')); ?>"><?php echo e(__('messages.blog')); ?></a>
          
          <?php if(getHeaderLink('how-to')): ?>
          <a class="nav-item nav-link" href="<?php echo e(route('howto')); ?>"><?php echo e(GetMetaData('page_title','how-to')); ?></a>
          <?php endif; ?>
          <?php if(getHeaderLink('Impressum')): ?>
           <a class="nav-item nav-link" href="<?php echo e(route('impresusm')); ?>"><?php echo e(GetMetaData('page_title','Impressum')); ?></a>
          <?php endif; ?>
          <?php if(getHeaderLink('term-condition')): ?>
          <a class="nav-item nav-link" href="<?php echo e(route('termcondition')); ?>"><?php echo e(GetMetaData('page_title','term-condition')); ?></a>
          <?php endif; ?>
          <?php if(getHeaderLink('return-process')): ?>
          <a class="nav-item nav-link" href="<?php echo e(route('returnprocess')); ?>"><?php echo e(GetMetaData('page_title','return-process')); ?></a>
          <?php endif; ?>
          <?php if(getHeaderLink('withdrawal-right')): ?>
          <a class="nav-item nav-link" href="<?php echo e(route('withdrawlrights')); ?>"><?php echo e(GetMetaData('page_title','withdrawal-right')); ?></a>
          <?php endif; ?>
          <?php if(getHeaderLink('gdpr')): ?>
          <a class="nav-item nav-link" href="<?php echo e(route('gdpr')); ?>"><?php echo e(GetMetaData('page_title','gdpr')); ?></a>
          <?php endif; ?>
        </div>
      </div>
      <div class="he-btn-gp">
        <a href="<?php echo e(route('getquote')); ?>" class=" btn primary-btn"><?php echo e(__('messages.get_a_quote')); ?></a>
      
        <button type="submit" class="search-btn" id="search-form">
          <img src="<?php echo e(asset('frontend/images/search-icon.svg')); ?>" alt="Search" style="width: 24px">
        </button>
        <a href="<?php echo e(route('cart.index')); ?>" class="header-icon position-relative">
            <img src="<?php echo e(asset('frontend/images/cart-icon.svg')); ?>" alt="" style="width: 24px">
            <span class="cart-count-badge position-absolute top-0 start-100 translate-middle badge" >
                0
            </span>
        </a>
        <?php if(Auth::check()): ?>
        <a href="<?php echo e(route('user.index')); ?>" class="header-icon user-icon">
          <img src="<?php echo e(asset('frontend/images/user-icon.svg')); ?>" alt="">
        </a>
        <?php else: ?>
        <a href="<?php echo e(route('login')); ?>" class="btn primary-btn"><?php echo e(__('messages.login')); ?></a>
        <?php endif; ?>

      </div>
    </nav>
  </div>
  <div class="modal search-form d-none" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Search</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="search-modal-close"></button>
        </div>
        <div class="modal-body">
          <div class="search-container">
            <form class="search-form">
              <input type="text" class="search-input" placeholder="Search products..." autocomplete="off">
             
            </form>
            <div class="search-results-dropdown"></div>
          </div>
        </div>
    
      </div>
    </div>
  </div>
</header>
<script>
    window.searchRoute = "<?php echo e(route('user.search')); ?>";

    $('#search-form').click(function(){
      $('.search-form').removeClass('d-none');
    })
    $('#search-modal-close').click(function(){
      $('.search-form').addClass('d-none');
    })
</script><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/include/header.blade.php ENDPATH**/ ?>