<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div id="sidebar"></div>
        <div class="col-9 main-dash-left">
            <div class="upper-main-user-navigation">
                <div class="user-manage">
                    <a href="<?php echo e(route('admin.products.index')); ?>">product management</a>
                    <a class="active" href="">Edit Product</a>
                </div>
            </div>

            <div class="add-user-form">
                <h3>Edit Product</h3>
                <form class="row" method="POST" action="<?php echo e(route('admin.products.update', $product->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <label for="product-name" class="form-label">Product Name<span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" placeholder="Enter Product Name"
                                    id="product-name" name="name" value="<?php echo e(old('name', $product->name)); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Product category<span class="text-danger">*</span></label>
                                <input type="hidden" name="category_id" value="<?php echo e($product->category_id); ?>">
                                <select id="category" class="form-select required" name="category_id" disabled>
                                    <option value="">Select Product Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e($product->category_id == $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Product brand<span class="text-danger">*</span></label>
                                <select id="brand" class="form-select required" name="brand_id" >
                                    <option value="">select product brand</option>
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($brand->id); ?>" <?php echo e($product->brand_id == $brand->id ? 'selected' : ''); ?>><?php echo e($brand->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="inputState1" class="form-label multiselect-form">description<span class="text-danger">*</span></label>
                                <textarea class="form-control required" placeholder="Enter Description" 
                                    style="height: 145px; resize:none;" name="description"><?php echo e(old('description', $product->description)); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="comn-input-select">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="railing_type" name="railing_type" value="1" 
                                        <?php if(isset($product) && $product->railing_type): ?> checked <?php endif; ?>>
                                    <label class="form-check-label" for="railing_type">
                                        Railing Type Required <span class="text-danger">*</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="inner-add-color <?php echo e($product->variations->isEmpty() ? 'd-none' : ''); ?>" id="inner-add-color">
                        <div id="variation-container">
                            <?php $__currentLoopData = $product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           
                            <div class="variation-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex cst_slec_size_outer_row">
                                            <div class="main-flex-all">
                                                <div class="comn-input-select cst_slc_input">
                                                    <label for="last-name" class="form-label">size/variation<span class="text-danger">*</span></label>
                                                    <input type="hidden" name="variations[<?php echo e($index); ?>][id]" value="<?php echo e($variation->id); ?>">
                                                    <select class="form-select size-select required" name="variations[<?php echo e($index); ?>][size_id]" required>
                                                        <option value="">Select Size</option>
                                                        <?php if($sizes->isNotEmpty()): ?>
                                                            <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($size->id); ?>" <?php echo e($variation->size_id == $size->id ? 'selected' : ''); ?>>
                                                                    <?php echo e($size->name); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php elseif($variations->isNotEmpty()): ?>
                                                       
                                                            <?php $__currentLoopData = $variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variationOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($variationOption->id); ?>" <?php echo e($variation->variation_id == $variationOption->id ? 'selected' : ''); ?>>
                                                                    <?php echo e($variationOption->name); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>

                                                    </select>
                                                </div>
                                                <div class="comn-input-select">
                                                    <label>quantity<span class="text-danger">*</span>:</label>
                                                </div>
                                                <div class="comn-input-select">
                                                    <label>SKU<span class="text-danger">*</span>:</label>
                                                </div>
                                            </div>
                                            <div class="d-flex comm_slec_size_row">
                                            <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colorIndex => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $option = $variation->options->where('color_id', $color->id)->first();
                                                    // Use color ID as the key for existing variations
                                                    $colorKey = $option ? $option->id : 'color-' . $color->id . '-' . $index;
                                                ?>
                                                <div class="comm_slec_size_col">
                                                    <div class="clr_box" style="background-color: white; color: black">
                                                        <div class="cross remove-color"> <i class="fa-solid fa-xmark"></i> </div>
                                                        <?php echo e($color->name); ?>

                                                        <input type="hidden" name="variations[<?php echo e($index); ?>][colors][<?php echo e($colorKey); ?>][color_id]" value="<?php echo e($color->id); ?>">
                                                        <?php if($option): ?>
                                                            <input type="hidden" name="variations[<?php echo e($index); ?>][colors][<?php echo e($colorKey); ?>][id]" value="<?php echo e($option->id); ?>">
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="comn-input-select">
                                                        <input type="text" class="form-control required" placeholder="Enter Quantity" 
                                                            name="variations[<?php echo e($index); ?>][colors][<?php echo e($colorKey); ?>][quantity]" 
                                                            value="<?php echo e($option->quantity ?? ''); ?>" >
                                                    </div>
                                                    <div class="comn-input-select">
                                                        <input type="text" class="form-control required" placeholder="Enter SKU" 
                                                            name="variations[<?php echo e($index); ?>][colors][<?php echo e($colorKey); ?>][sku]" 
                                                            value="<?php echo e($option->sku ?? ''); ?>" >
                                                    </div>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label for="last-name" class="form-label">Product Weight</label>
                                            <div class="price_icon_input">
                                                <input type="text" class="form-control " placeholder="Enter Product Weight" 
                                                name="variations[<?php echo e($index); ?>][weight]" value="<?php echo e($variation->weight); ?>">
                                                <p>Kg</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label for="inputState" class="form-label">Status<span class="text-danger">*</span></label>
                                            <select class="form-select required" name="variations[<?php echo e($index); ?>][status]">
                                                <option value="in_stock" <?php echo e($variation->status == 'in_stock' ? 'selected' : ''); ?>>In Stock</option>
                                                <option value="out_of_stock" <?php echo e($variation->status == 'out_of_stock' ? 'selected' : ''); ?>>Out of Stock</option>
                                                <option value="pre_order" <?php echo e($variation->status == 'pre_order' ? 'selected' : ''); ?>>Pre-order</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="comn-input-select mb-2">
                                            <label for="inputCity" class="form-label mb-0">Product Dimensions</label>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="comn-input-select">
                                                    <label class="form-label">length</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter length" 
                                                            name="variations[<?php echo e($index); ?>][length]" value="<?php echo e($variation->length); ?>">
                                                        <p>cm</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select">
                                                    <label class="form-label">width</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter Width" 
                                                            name="variations[<?php echo e($index); ?>][width]" value="<?php echo e($variation->width); ?>">
                                                        <p>cm</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select">
                                                    <label class="form-label">height</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter height" 
                                                            name="variations[<?php echo e($index); ?>][height]" value="<?php echo e($variation->height); ?>">
                                                        <p>cm</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label class="form-label">Volume</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Volume" 
                                                    name="variations[<?php echo e($index); ?>][volume]" value="<?php echo e($variation->volume); ?>">
                                                <p>L</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label class="form-label">Max. Load</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Max. Load" 
                                                    name="variations[<?php echo e($index); ?>][max_load]" value="<?php echo e($variation->max_load); ?>">
                                                <p>Kg</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 text-end" id="removeVariationBtn">
                                        <button type="button" class="btn btn-danger remove-variation">Remove Variation</button>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <?php if($product->variations->isNotEmpty()): ?>
                        <button type="button" id="add-variation" class="add-user">Add another size/variation</button>
                        <?php endif; ?>
                    </div>



                    <div class="inner-add-color <?php echo e($product->variations->isEmpty() ? '' : 'd-none'); ?>" id="non-variant-block">
                        <div id="non-variation-container">
                            <div class="non-variation-block">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex cst_slec_size_outer_row">
                                            <div class="main-flex-all">
                                                <div class="comn-input-select cst_slc_input">
                                                    <label for="last-name" class="form-label">size/variation</label>
                                                    <select class="form-select" disabled>
                                                        <option selected>None</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label for="last-name" class="form-label">Product </label>
                                            <div class="price_icon_input">
                                                <input type="text" class="form-control " placeholder="Enter Product Weight" 
                                                    name="weight" value="<?php echo e($product->weight); ?>">
                                                <p>Kg</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label for="inputState" class="form-label">Status<span class="text-danger">*</span></label>
                                            <select class="form-select required" name="status">
                                                <option value="in_stock" <?php echo e($product->status == 'in_stock' ? 'selected' : ''); ?>>In Stock</option>
                                                <option value="out_of_stock" <?php echo e($product->status == 'out_of_stock' ? 'selected' : ''); ?>>Out of Stock</option>
                                                <option value="pre_order" <?php echo e($product->status == 'pre_order' ? 'selected' : ''); ?>>Pre-order</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="comn-input-select mb-2">
                                            <label for="inputCity" class="form-label mb-0">Product Dimensions</label>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="comn-input-select">
                                                    <label class="form-label">length</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter length" 
                                                            name="length" value="<?php echo e($product->length); ?>">
                                                        <p>mm</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select">
                                                    <label class="form-label">width</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter Width" 
                                                            name="width" value="<?php echo e($product->width); ?>">
                                                        <p>mm</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="comn-input-select">
                                                    <label class="form-label">height</label>
                                                    <div class="price_icon_input">
                                                        <input type="text" class="form-control " placeholder="Enter height" 
                                                            name="height" value="<?php echo e($product->height); ?>">
                                                        <p>mm</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label class="form-label">Volume</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Volume" 
                                                    name="volume" value="<?php echo e($product->volume); ?>">
                                                <p>L</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="comn-input-select">
                                            <label class="form-label">Max. Load</label>
                                            <div class="price_icon_input">
                                                <input type="number" class="form-control " placeholder="Enter Max. Load" 
                                                    name="max_load" value="<?php echo e($product->max_load); ?>">
                                                <p>Kg</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    
                    
                    <!-- Other Information Section -->
                    <div class="comn-input-select">
                        <label class="form-label">Other Information<span class="text-danger">*</span></label>
                    </div>
                    <div id="other-info-container">
                    <?php $__currentLoopData = $product->otherInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $infoIndex => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="other-info-block">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="comn-input-select">
                                        <div class="btn-category">
                                            <label class="uplod-file" for="file-up-<?php echo e($infoIndex); ?>">
                                                <i class="fa-solid fa-arrow-up-from-bracket"></i>
                                                <p>Upload image</p>
                                            </label>

                                            
                                            <input type="file" class="form-control uplod-file-inpt " id="file-up-<?php echo e($infoIndex); ?>" name="other_info[<?php echo e($infoIndex); ?>][image]">
                                            <input type="hidden" name="other_info[<?php echo e($infoIndex); ?>][id] required" value="<?php echo e($info->id); ?>">
                                            <input type="text" class="form-control required" placeholder="Enter description here" name="other_info[<?php echo e($infoIndex); ?>][description]" value="<?php echo e($info->description); ?>">
                                            <a class="delete-outline-btn remove-info" href="javascript:void(0)">Delete</a>
                                            <?php if($info->image_path): ?>
                                                <div class="d-flex align-items-center preview-wrapper">
                                                    <img src="<?php echo e(asset('storage/' . $info->image_path)); ?>" width="100" class="me-2 preview-image">
                                                    <input type="hidden" name="other_info[<?php echo e($infoIndex); ?>][existing_image]" value="<?php echo e($info->image_path); ?>">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <button type="button" id="add-info-btn" class="add-user">Add Another Information</button>

                    <!-- Keywords and Related Products -->
                    <div class="row marg-t-b">
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="product-name" class="form-label">Keywords<span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" placeholder="Enter Keywords" 
                                    name="keywords" value="<?php echo e($product->keywords); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Related Product Variants (SKUs) </label>
                                <select id="related-products" class="form-select" name="related_products[]" multiple>
                                    <?php $__currentLoopData = $relatedOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $relatedProduct = $option->variation->product;
                                            $mainPhoto = $relatedProduct->mainPhoto->image_path ?? null;
                                            $sku = $option->sku;
                                        ?>
                                        <option 
                                            value="<?php echo e($option->id); ?>" 
                                            data-image="<?php echo e(asset('storage/' . $mainPhoto)); ?>"
                                            <?php echo e(in_array($option->id, $selectedOptionIds) ? 'selected' : ''); ?>>
                                            <?php echo e($sku); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                               
                            </div>
                        </div>
                    </div>

                    <!-- Available Models Section -->
                    <div class="row marg-t-b">
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="inputAddress2" class="form-label">available models<span class="text-danger">*</span></label>
                                
                                <div class="btn-category models-container flex-direc-column" id="">
                                    <!-- <div id="models-container"> -->
                                        <?php $__currentLoopData = $product->models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modelIndex => $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex-main-avail-model w-100">
                                        <div class="model-row cat w-100 ">
                                            <input type="text" class="form-control mb-3 required" placeholder="enter title here" 
                                                name="models[<?php echo e($modelIndex); ?>][title]" value="<?php echo e($model->title); ?>">
                                            <textarea class="form-control required" placeholder="Enter Description Here" 
                                                style="height: 145px; resize:none;" 
                                                name="models[<?php echo e($modelIndex); ?>][description]"><?php echo e($model->description); ?></textarea>
                                            </div>
                                            <a class="delete-outline-btn remove-model">Delete</a>
                                    </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <button type="button" id="add-model" class="add-user marg-t-30">Add another available model</button>
                            </div>
                        </div>
                    </div>

                    <!-- Images Section -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="upload-photo" class="form-label multiselect-form">Upload Photos<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="upload-photo" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>Add photos</p>
                                    </label>
                                    <input type="file" id="upload-photo" class="d-none" name="gallery_images[]" accept="image/*" multiple>
                                </div>
                                <div id="image-previews" class="d-flex mt-2">
                                    <?php $__currentLoopData = $product->images->where('type', 'gallery'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="preview-item show-one-img p-0" style="position: relative; ">
                                        <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" >

                                        <input type="hidden" name="existing_gallery_images[]" value="<?php echo e($image->id); ?>">
                                        <div class="cross remove-existing-image" data-id="<?php echo e($image->id); ?>">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <p class="support-show">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="main-image" class="form-label multiselect-form">Upload product main Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="main-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>add a photo</p>
                                    </label>
                                    <input type="file" id="main-image" class="d-none" name="main_image" accept="image/*">
                                </div>
                                <div id="main-image-preview" class="d-flex mt-2">
                                <?php if($mainImage = $product->images->where('type', 'main')->first()): ?>
                                <div class="preview-item show-one-img p-0" style="position: relative; ">
                                        <img src="<?php echo e(asset('storage/' . $mainImage->image_path)); ?>" >

                                        <input type="hidden" name="existing_main_image" value="<?php echo e($mainImage->id); ?>">
                                        <div class="cross remove-existing-image" data-id="<?php echo e($mainImage->id); ?>">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="info-image" class="form-label multiselect-form">Upload information Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="info-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>add a photo</p>
                                    </label>
                                    <input type="file" id="info-image" class="d-none" name="info_image" accept="image/*">
                                </div>
                                <div id="info-image-preview" class="d-flex mt-2">
                                <?php if($infoImage = $product->images->where('type', 'info')->first()): ?>
                                <div class="preview-item show-one-img p-0" style="position: relative; ">
                                        <img src="<?php echo e(asset('storage/' . $infoImage->image_path)); ?>" >

                                        <input type="hidden" name="existing_info_image" value="<?php echo e($infoImage->id); ?>">
                                        <div class="cross remove-existing-image" data-id="<?php echo e($infoImage->id); ?>">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-md-3">
                            <div class="comn-input-select mb-0">
                                <label for="home-image" class="form-label multiselect-form">Upload Product Preview Photo<span class="text-danger">*</span></label>
                            </div>
                            <div class="upload-img-show d-flex">
                                <div class="main-inpt">
                                    <label for="home-image" class="upload-img-div">
                                        <i class="fa-solid fa-image"></i>
                                        <p>add a photo</p>
                                    </label>
                                    <input type="file" id="home-image" class="d-none" name="home_image" accept="image/*">
                                </div>
                                <div id="home-image-preview" class="d-flex mt-2">
                                <?php if($homeImage = $product->images->where('type', 'home')->first()): ?>
                                <div class="preview-item show-one-img p-0" style="position: relative; ">
                                        <img src="<?php echo e(asset('storage/' . $homeImage->image_path)); ?>" >
                                        <input type="hidden" name="existing_home_image" value="<?php echo e($homeImage->id); ?>">
                                        <div class="cross remove-existing-image" data-id="<?php echo e($homeImage->id); ?>">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <p class="support-show m-width">Supports JPG, PNG, and WEBP formats</p>
                        </div>
                        <div class="col-12">
                            <div class="upper-main-btn-last-comn d-flex btn-main-upload-edit">
                                <button type="submit" class="add-user">Update product</button>
                                <a href="<?php echo e(route('admin.products.index')); ?>" class="cancel-btn">Cancel</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    $(document).on('click', '.remove-existing-image', function() {
        const imageId = $(this).data('id');
        $(this).closest('.preview-item').remove();
        $('<input>').attr({
            type: 'hidden',
            name: 'removed_images[]',
            value: imageId
        }).appendTo('form');
    });
});
</script>
<script>
$(document).ready(function () {
    $('#related-products').select2({
        maximumSelectionLength: 3,
        placeholder: "Select up to 3 SKUs",
        templateResult: formatOption,
        templateSelection: formatOption
    });

    function formatOption(option) {
        if (!option.id) return option.text;

        const imageUrl = $(option.element).data('image');
        const text = option.text;

        if (imageUrl) {
            return $(`
                <div style="display: flex; align-items: center;">
                    <img src="${imageUrl}" style="width:30px;height:30px;object-fit:cover;margin-right:10px;" />
                    <span>${text}</span>
                </div>
            `);
        }

        return text;
    }
});
$(document).ready(function() {

    function toggleRemoveButton() {
        if ($('.variation-block').length > 1) {
            $('.remove-variation').show();
        } else {
            $('.remove-variation').hide();
        }
    }
    toggleRemoveButton();
   

    

    
    let variationCounter = 1;

    $('#add-variation').click(function () {
    const $original = $('.variation-block').first();
    const $clone = $original.clone();
    const timestamp = Date.now(); // Shared timestamp
    const newVariationId = 'new-' + timestamp;

    // Update all input/select names in the variation block
    $clone.find('input, select').each(function () {
        const name = $(this).attr('name');
        if (name) {
            const updatedName = name.replace(/variations\[(\d+|new-\d+)\]/g, `variations[${newVariationId}]`);
            $(this).attr('name', updatedName);

            if (!$(this).is('[type="hidden"]') && !$(this).hasClass('size-select')) {
                $(this).val('');
            }
        }
    });

    $clone.find('input[name*="[id]"]').val('');
    $clone.find('.comm_slec_size_col').remove(); // Remove old color blocks

    // $clone.find('#removeVariationBtn').before(`
    //     <button type="button" class="btn btn-secondary restore-colors">Restore Colors</button>
    // `);

    $('#variation-container').append($clone);
    toggleRemoveButton();

    restoreColors($clone, timestamp, newVariationId);
});

// Separate restore function so it can be reused
function restoreColors($variationBlock, timestamp, variationId = null) {
    const allColors = <?php echo json_encode($colors, 15, 512) ?>;
    const $colorRow = $variationBlock.find('.comm_slec_size_row');
    const existingColors = $colorRow.find('input[name*="[color_id]"]').map(function () {
        return $(this).val();
    }).get();

    if (!variationId) {
        variationId = $variationBlock.find('input[name*="[id]"]').val() || 'new-' + timestamp;
    }

    allColors.forEach((color, index) => {
        if (!existingColors.includes(color.id.toString())) {
            const colorKey = 'color-' + timestamp + '-' + index;
            const block = `
                <div class="comm_slec_size_col">
                    <div class="clr_box" style="background-color: white; color: black">
                        <div class="cross remove-color"><i class="fa-solid fa-xmark"></i></div>
                        ${color.name}
                        <input type="hidden" name="variations[${variationId}][colors][${colorKey}][color_id]" value="${color.id}">
                    </div>
                    <div class="comn-input-select">
                        <input type="text" class="form-control required" placeholder="Enter Quantity" name="variations[${variationId}][colors][${colorKey}][quantity]">
                    </div>
                    <div class="comn-input-select">
                        <input type="text" class="form-control required" placeholder="Enter SKU" name="variations[${variationId}][colors][${colorKey}][sku]">
                    </div>
                </div>`;
            $colorRow.append(block);
        }
    });
}

// // Optional: still support manual restore
// $(document).on('click', '.restore-colors', function () {
//     const $variationBlock = $(this).closest('.variation-block');
//     const timestamp = Date.now();
//     restoreColors($variationBlock, timestamp);
// });


    $(document).on('click', '.remove-variation', function () {
        if ($('.variation-block').length > 1) {
            $(this).closest('.variation-block').remove();
            toggleRemoveButton();
        }
    });
    
   
    
    $(document).on('click', '.remove-color', function() {
        $(this).closest('.comm_slec_size_col').remove();
    });
    
    let modelCounter = 1;
    
    $('#add-model').click(function() {
        const newRow = `
        <div class="flex-main-avail-model w-100">
        <div class="model-row cat w-100">
            <input type="text" class="form-control mb-3" placeholder="enter title here" name="models[${modelCounter}][title]">
            <textarea class="form-control" placeholder="Enter Description Here" style="height: 145px; resize:none;" name="models[${modelCounter}][description]"></textarea>
            </div>
            <a class="delete-outline-btn remove-model">Delete</a>
        </div>
       `;
        
        $('.models-container').append(newRow);
        modelCounter++;
    });
    
    $(document).on('click', '.remove-model', function() {
        $(this).closest('.flex-main-avail-model').remove();
    });
    
    let infoCounter = <?php echo e(count($product->otherInfo) ?? 0); ?>; // start after existing items

    $('#add-info-btn').click(function () {
        const $original = $('.other-info-block').first();
        const $clone = $original.clone();

        $clone.find('input').each(function () {
            const name = $(this).attr('name');
            if (name) {
                const newName = name.replace(/\[\d+\]/, `[${infoCounter}]`);
                $(this).attr('name', newName);
            }

            // Clear values
            if ($(this).attr('type') === 'file') {
                $(this).val('');
            } else {
                $(this).val('');
            }
        });

        const uniqueId = `file-up-${infoCounter}`;
        $clone.find('.uplod-file-inpt').attr('id', uniqueId);
        $clone.find('label.uplod-file').attr('for', uniqueId);

        $clone.find('img.preview-image, .remove-preview').remove();
        $clone.find('input[name$="[existing_image]"], input[name$="[id]"]').remove();

        $('#other-info-container').append($clone);
        infoCounter++;
    });

    $(document).on('click', '.remove-info', function () {
        if ($('.other-info-block').length > 1) {
            $(this).closest('.other-info-block').remove();
        }
    });



    $('#upload-photo').change(function(e) {
        const files = e.target.files;
        const previewContainer = $('#image-previews');
        previewContainer.empty();
        
        for (let i = 0; i < files.length; i++) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.append(`
                <div class="preview-item show-one-img p-0" style="position: relative;">
                    <img src="${event.target.result}" >
                    <div class="cross remove-preview-mul" data-index="${i}">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(files[i]);
        }
    });
    
    $(document).on('click', '.remove-preview-mul', function() {
        const index = $(this).data('index');
        const input = $('#upload-photo')[0];
        const files = Array.from(input.files);
        
        files.splice(index, 1);
        
        const dataTransfer = new DataTransfer();
        files.forEach(file => dataTransfer.items.add(file));
        input.files = dataTransfer.files;
        
        $('#upload-photo').trigger('change');
    });
    
    $('#main-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#main-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.html(`
                 <div class="preview-item show-one-img p-0" style="position: relative; ">
                    <img src="${event.target.result}">
                    <div class="cross remove-preview-main" >
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });
    
    $(document).on('click', '.remove-preview-main', function() {
        $('#main-image').val('');
        $('#main-image-preview').empty();
    });
    
    $('#info-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#info-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.html(`
                <div class="preview-item show-one-img p-0" style="position: relative; ">
                    <img src="${event.target.result}" >
                    <div class="cross remove-preview-info" >
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });

    $('#home-image').change(function(e) {
        const file = e.target.files[0];
        const previewContainer = $('#home-image-preview');
        previewContainer.empty();
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                previewContainer.html(`
                <div class="preview-item show-one-img p-0" style="position: relative; ">
                    <img src="${event.target.result}" >
                    <div class="cross remove-preview-home" >
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                </div>`);
            }
            reader.readAsDataURL(file);
        }
    });

//     $(document).on('change', '.uplod-file-inpt', function () {
//     let input = this;
//     let wrapper = $(input).closest('.btn-category');
//     wrapper.find('img.preview-image, .remove-preview').remove();

//     if (input.files && input.files[0]) {
//         let reader = new FileReader();
//         reader.onload = function (e) {
//             let img = $('<img class="preview-image">').attr('src', e.target.result).css({ width: '100px', marginTop: '10px' });
//             let btn = $('<button type="button" class="remove-preview btn btn-sm btn-danger ms-2">Remove</button>');
//             btn.on('click', function () {
//                 $(input).val('');
//                 img.remove();
//                 btn.remove();
//             });
//             wrapper.append(img).append(btn);
//         };
//         reader.readAsDataURL(input.files[0]);
//     }
// });

    $(document).on('change', '.uplod-file-inpt', function () {
        let input = this;
        let wrapper = $(input).closest('.btn-category');
        wrapper.find('.preview-wrapper').remove(); // remove previous preview if exists

        if (input.files && input.files[0]) {
            let reader = new FileReader();
            reader.onload = function (e) {
                let previewWrapper = $('<div class="preview-wrapper" style="margin-top:10px;"></div>');
                let img = $(' <img class="preview-image">').attr('src', e.target.result);
                let btn = $('<button type="button" class="cross remove-preview"><i class="fa-solid fa-xmark"></i></button>');

                btn.on('click', function () {
                    $(input).val('');
                    previewWrapper.remove();
                });

                previewWrapper.append(img).append(btn);
                wrapper.append(previewWrapper);
            };
            reader.readAsDataURL(input.files[0]);
        }
    });



    
    $(document).on('click', '.remove-preview-info', function() {
        $('#info-image').val('');
        $('#info-image-preview').empty();
    });
    $(document).on('click', '.remove-preview-home', function() {
        $('#home-image').val('');
        $('#home-image-preview').empty();
    });
});

$(document).ready(function() {
    function initializeValidation() {
        $('.required').each(function() {
            const $input = $(this);
            const $formGroup = $input.closest('.comn-input-select');
            
            if (!$formGroup.find('.invalid-feedback').length) {
                $formGroup.append(`<div class="invalid-feedback">This field is required</div>`);
            }
        });
        
        $('input[name*="[sku]"]').each(function() {
            const $input = $(this);
            const $formGroup = $input.closest('.comn-input-select');
            
            if (!$formGroup.find('.invalid-feedback').length) {
                $input.after(`<div class="invalid-feedback">SKU is required and must be unique</div>`);
            }
        });
    }
    
    $('form').on('submit', function(e) {

        e.preventDefault();
        let isValid = true;
        const $form = $(this);

        $form.removeClass('was-validated');
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').hide();

        $('.required:visible').each(function() {
            const $input = $(this);
            const value = $input.val();

            if (!value || value.trim() === '') {
                $input.addClass('is-invalid');

                const $feedback = $input.closest('.comn-input-select').find('.invalid-feedback');
                if (!$feedback.length) {
                    $input.after(`<div class="invalid-feedback">This field is required</div>`);
                } else {
                    $feedback.show();
                }

                isValid = false;
            }
        });

        let isVariableProduct = !$('#inner-add-color').hasClass('d-none');
       
        if(isVariableProduct){
            $('#inner-add-color').find(':input').prop('disabled', false);
            $('#non-variant-block').find(':input').prop('disabled', true);
            

        const skus = new Set();
        $('input[name*="[sku]"]').each(function() {
            const $input = $(this);
            const sku = $input.val().trim();
            
            if (!sku) {
                $input.addClass('is-invalid');
                $input.closest('.comn-input-select').find('.invalid-feedback').show();
                isValid = false;
            } else if (skus.has(sku)) {
                $input.addClass('is-invalid');
                $input.closest('.comn-input-select').find('.invalid-feedback').text('SKU must be unique').show();
                isValid = false;
            } else {
                skus.add(sku);
            }
        });

        const sizes = new Set();
        $('.size-select').each(function() {
            const $select = $(this);
            const size = $select.val();
            
            if (!size) {
                $select.addClass('is-invalid');
                $select.closest('.comn-input-select').find('.invalid-feedback').show();
                isValid = false;
            } else if (sizes.has(size)) {
                $select.addClass('is-invalid');
                $select.closest('.comn-input-select').find('.invalid-feedback').text('Size must be unique per product').show();
                isValid = false;
            } else {
                sizes.add(size);
            }
        });
        }else{
            $('#non-variant-block').find(':input').prop('disabled', false);
            $('#inner-add-color').find(':input').prop('disabled', true);
        const simpleFields = ['weight', 'status', 'length', 'width', 'height', 'volume', 'max_load'];
        simpleFields.forEach(field => {
            const $input = $(`[name="${field}"]`);
            if ($input.length && $input.hasClass('required') && !$input.val()) {
                $input.addClass('is-invalid');
                $input.closest('.comn-input-select').find('.invalid-feedback').show();
                isValid = false;
            }
        });
        }

        $('.model-row').each(function() {
            const $row = $(this);
            const title = $row.find('input[name*="[title]"]').val().trim();
            const desc = $row.find('textarea[name*="[description]"]').val().trim();
            
            if (!title) {
                $row.find('input[name*="[title]"]').addClass('is-invalid')
                    .closest('.comn-input-select').find('.invalid-feedback').text('Title is required').show();
                isValid = false;
            }
            
            if (!desc) {
                $row.find('textarea[name*="[description]"]').addClass('is-invalid')
                    .closest('.comn-input-select').find('.invalid-feedback').text('Description is required').show();
                isValid = false;
            }
        });

        if (isValid) {
            $form.unbind('submit').submit();
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
            
            $form.addClass('was-validated');
        }
});
    
    $(document).on('input blur', 'input[name*="[sku]"]', function () {
        const $input = $(this);
        const sku = $input.val().trim();
        const $feedback = $input.closest('.comn-input-select').find('.invalid-feedback');
        const currentName = $input.attr('name');
        let error = '';

        if (!sku) {
            error = 'SKU is required';
        } else {
            let isDuplicate = false;
            $('input[name*="[sku]"]').not(`[name="${currentName}"]`).each(function () {
                if ($(this).val().trim() === sku) {
                    isDuplicate = true;
                    return false;
                }
            });
            if (isDuplicate) {
                error = 'SKU must be unique';
            }
        }

        if (error) {
            $input.addClass('is-invalid');
            $feedback.text(error).show();
        } else {
            $input.removeClass('is-invalid');
            $feedback.hide();
        }
    });
    $(document).on('blur', '.required', function () {
        const $input = $(this);
        if ($input.is('input[name*="[sku]"]')) return; // skip SKU fields

        const $feedback = $input.closest('.comn-input-select').find('.invalid-feedback');
        if (!$input.val().trim()) {
            $input.addClass('is-invalid');
            $feedback.show();
        } else {
            $input.removeClass('is-invalid');
            $feedback.hide();
        }
    });
    
    $(document).on('change', '.size-select', function() {
        const $select = $(this);
        const size = $select.val();
        const $feedback = $select.closest('.comn-input-select').find('.invalid-feedback');
        
        if (!size) {
            $select.addClass('is-invalid');
            console.log('invalid size');
            $feedback.text('Size is required').show();
        } else {
            let isDuplicate = false;
            const currentName = $select.attr('name');
            
            $('.size-select').not(`[name="${currentName}"]`).each(function() {
                if ($(this).val() === size) {
                    isDuplicate = true;
                    return false; // break loop
                }
            });
            
            if (isDuplicate) {
                $select.addClass('is-invalid');
                console.log('invalid size');
                $feedback.text('Size must be unique per product').show();
            } else {
                $select.removeClass('is-invalid');
                console.log('valid size');
                $feedback.hide();
            }
        }
    });
    
    initializeValidation();
    
    $(document).on('click', '#add-variation', function() {
        setTimeout(initializeValidation, 100);
    });
    
    $(document).on('click', '#add-model', function() {
        setTimeout(initializeValidation, 100);
    });
    
    $(document).on('click', '#add-info-btn', function() {
        setTimeout(initializeValidation, 100);
    });

    $(document).on('change', '#category', function () {
        setTimeout(initializeValidation, 100);
    });
    
});





</script>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/product/edit_product_detail.blade.php ENDPATH**/ ?>