<div class="inner-data-detail">
    <div class="head-roof-box">
        <h3><?php echo e($product->brand->name); ?> <?php echo e($product->name); ?></h3>
    </div>
    

    <div class="price-detail-main">
        <div class="price-big d-flex">
            <h3><?php echo e($product->first_price  ?? 'N/A'); ?></h3>
            <a href="javascript:void()" data-bs-toggle="modal" data-bs-target="#exampleModal"><?php echo e(__('messages.view_price_breakdown')); ?></a>
        </div>
        <p><?php echo e(__('messages.per_day_incl_vat')); ?></p>
    </div>

    <div class="pick-location">
        <h3><?php echo e(__('messages.pickup_location')); ?></h3>
        <div class="pick-locati-name-icon d-flex">
            <img src="<?php echo e(asset('frontend/images/loct.png')); ?>" alt="">
            <select class="form-select" id="vendor_select" name="vendor_select">
                <option value ="admin">Esperantostr. 10, 70197 Stuttgart</option>
            <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($vendor->id); ?>"><?php echo e($vendor->street . ' ' . $vendor->zip_code . ' ' . $vendor->city); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
    <div class="choose-car">
        <h3><?php echo e(__('messages.choose_your_car')); ?></h3>
        <form id="car-form">
            <div class="row">
                <div class="col-md-6 inner-main-input">
                    <label><?php echo e(__('messages.manufacturer')); ?></label>
                    <select class="form-select" id="manufacturer" name="manufacturer">
                        <option selected disabled><?php echo e(__('messages.select')); ?></option>
                        <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($manufacturer); ?>"><?php echo e($manufacturer); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 inner-main-input">
                    <label><?php echo e(__('messages.model')); ?></label>
                    <select class="form-select" id="model" name="model" disabled></select>
                </div>

                <div class="col-md-6 inner-main-input">
                    <label><?php echo e(__('messages.year_of_make')); ?></label>
                    <select class="form-select" id="year" name="year" disabled></select>
                </div>

              

                <div class="col-md-6 inner-main-input">
                    <label><?php echo e(__('messages.trailer_hitch')); ?></label>
                    <select class="form-select" id="trailer_hitch" name="trailer_hitch" 
                            data-product-name="<?php echo e($product->name); ?>">
                        <option value="" selected disabled>Select</option>
                        <option value="yes"><?php echo e(__('messages.yes')); ?></option>
                        <option value="no"><?php echo e(__('messages.no')); ?></option>
                    </select>
                </div>
            </div>

            <div id="result" class="mt-3"></div>
        </form>
    </div>
    <input id="railing_type" hidden value="<?php echo e($product->railing_type); ?>" />
    <?php if($product->railing_type): ?>
    <div class="railing-type">
        <h3><?php echo e(__('messages.railing_type')); ?></h3>
        <p><?php echo e(__('messages.railing_type_description')); ?></p>
    </div>
    
    <div id="roof-types-container" style="display: none;">
        <?php $__currentLoopData = $roofTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roofType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="roof-name-detail" id="roof-type-<?php echo e(Str::slug($roofType)); ?>">
                <figure>
                    <?php
                        $imageName = strtolower(str_replace(' ', '-', $roofType)) . '.jpg';
                    ?>
                    <img src="<?php echo e(asset('frontend/images/' . $imageName)); ?>" alt="<?php echo e($roofType); ?>">
                </figure>
                <h4><?php echo e(__('messages.' .($roofType))); ?></h4>
                    <?php if($roofType == 'Normal Roof'): ?>
                    <p><?php echo e(__('messages.normal')); ?></p>
                    <?php elseif($roofType == 'Normal roof without glass roof'): ?>
                    <p><?php echo e(__('messages.normal')); ?></p>
                    <?php elseif($roofType == 'Normal Roof with glass roof'): ?>
                    <p><?php echo e(__('messages.normal_glass')); ?></p>
                    <?php elseif($roofType == 'Fixpoints'): ?>
                    <p><?php echo e(__('messages.fixpoints')); ?></p>
                    <?php elseif($roofType == 'Fixpoints without glass roof'): ?>
                    <p><?php echo e(__('messages.fixpoints')); ?></p>
                    <?php elseif($roofType == 'Fixpoints with glass roof'): ?>
                    <p><?php echo e(__('messages.fixpoints_glass')); ?></p>
                    <?php elseif($roofType == 'Integrated Roof Railing'): ?>
                    <p><?php echo e(__('messages.integrated_rails')); ?></p>
                    <?php elseif($roofType == 'Elevated Roof Rails'): ?>
                    <p><?php echo e(__('messages.elevated_rails')); ?></p>
                    <?php elseif($roofType == 'T-Profile'): ?>
                    <p><?php echo e(__('messages.t_profile')); ?></p>
                    <?php elseif($roofType == 'Raingutter'): ?>
                    <p><?php echo e(__('messages.raingutter')); ?></p>
                    <?php endif; ?>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>
    <div class="choose-rental-period">
        <h3><?php echo e(__('messages.choose_rental_period')); ?></h3>
        <p><?php echo e(__('messages.add_rental_period_description')); ?></p>
        <form class=" email-login">
            <div class="row">
                <div class="col-md-6 inner-main-input">
                    <label for="inputEmail4" class="form-label"><?php echo e(__('messages.from')); ?></label>
                    <input class="form-control"  id="rental_from">
                </div>
                <div class="col-md-6 inner-main-input">
                    <label for="inputEmail4" class="form-label"><?php echo e(__('messages.to')); ?></label>
                    <input class="form-control"  id="rental_to">

                    
                </div>
            </div>
        </form>


        
    </div>
    <input type="hidden" name="insurance_selected" id="insurance_selected" value="0">
    <input type="hidden" name="roof_rack_selected" id="roof_rack_selected" value="0">
    <?php
        $preferredOrder = ['Schwarz', 'Titan', 'Silber', 'Anthrazit', 'Weiß'];
        $sortedColors = collect($preferredOrder)
            ->map(fn($name) => $colors->firstWhere('name', $name))
            ->filter(); // remove nulls if any color is missing
    ?>
    <div class="choose-color">
        <div class="choose-car">
            <h3 class="mb-2"><?php echo e(__('messages.choose_color')); ?></h3>
            <form class="email-login">
                <div class="row">
                    <div class="col-md-6 inner-main-input">
                        <select class="form-select" id="color-select" aria-label="Default select example">
                            <option selected>Select</option>
                            <?php $__currentLoopData = $sortedColors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($color->id); ?>" 
                                        data-color-name="<?php echo e($color->name); ?>">
                                    <?php echo e($color->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </form>
        </div>
    </div>
  
    <div class="size-cards">
        <h3><?php echo e(__('messages.size_variations')); ?></h3>
        <div class="row row-gap-4" id="size-container">
           
        </div>
    </div>
    <div class="select-main-detail d-flex mt-4">
        <div class="">
             
            <?php if($product->name == 'Roof Box' || $product->name == 'Roof Bike Carrier' || $product->name  =='Dachbox' || $product->name  =='Dachfahrradträger'): ?>
            <div class="form-check mb-1">
                <input class="form-check-input" type="checkbox" id="roof_rack_checkbox" checked>
                <label class="form-check-label" for="gridCheck">
                    <?php echo e(__('messages.roof_rack_included')); ?>

                </label>
            </div>
            <?php endif; ?>
           
            <div class="form-check">
                <input class="form-check-input" type="checkbox"  id="insurance_checkbox" checked>
                <label class="form-check-label" for="gridCheck1">
                    <?php echo e(__('messages.insurance_label')); ?>

                </label>
            </div>
        </div>
    </div>
    <div class="calculated-rent">
        <div class="row align-items-end">
            <div class="col-md-6">
                <h3><?php echo e(__('messages.calculated_rent')); ?></h3>

                <p class="text-calc-rent " id="withinsurance">(<?php echo e(__('messages.calculated_rent_with_insurance')); ?>)
                </p>
                <p class="text-calc-rent d-none" id="withoutinsurance">(<?php echo e(__('messages.calculated_rent_without_insurance')); ?>)
                </p>
            </div>
            <div class="col-md-6">
                <div class="inner-number-days">
                    <p><?php echo e(__('messages.number_of_days')); ?>: <span> </span>

                    </p>
                    <p class="mb-0"><?php echo e(__('messages.total_rent')); ?>: <span></span></p>
                </div>
            </div>
        </div>
    </div>
    
    <div id="errorMessage" class=""></div>
    <input type="hidden" id="booking_item_ids" >

    
    <form id="bookingForm" action="<?php echo e(route('cart.add')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>" id="product_id">
        <input type="hidden" name="product_name" value="<?php echo e($product->name); ?>" id="product_name">
        <input type="hidden" name="manufacturer" id="hidden_manufacturer">
        <input type="hidden" name="car_year" id="hidden_car_year">
        <input type="hidden" name="model" id="hidden_model">
        <input type="hidden" name="trailer_hitch" id="hidden_trailer_hitch">
        <input type="hidden" name="roof_type" id="hidden_roof_type">
        <input type="hidden" name="color_id" id="hidden_color_id">
        <input type="hidden" name="color_name" id="hidden_color_name">
        <input type="hidden" name="size_id" id="hidden_size_id">
        <input type="hidden" name="size_name" id="hidden_size_name">
        <input type="hidden" name="rental_from" id="hidden_rental_from">
        <input type="hidden" name="rental_to" id="hidden_rental_to">
        <input type="hidden" name="days" id="hidden_days">
        <input type="hidden" name="calculated_rent" id="hidden_calculated_rent">
        <input type="hidden" name="is_carrier_included" id="hidden_is_carrier_included">
        <input type="hidden" name="is_insured" id="hidden_is_insured">
        
        <button type="submit" class="mt-4 w-100 btn primary-btn"><?php echo e(__('messages.rent_now')); ?></button>
    </form>
    
</div><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/booking/partials/carrier_foot.blade.php ENDPATH**/ ?>