<!DOCTYPE html>
<html>
<head>
    <title>Vouchers PDF</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h2>All Vouchers</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Code</th>
                <th>Start Date</th>
                <th>Expiration Date</th>
                <th>Min Order Value</th>
                <th>Max Discount</th>
                <th>Voucher Value</th>
                <th>Voucher Type</th>
                <th>No. Of Times Redeemed</th>

            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($voucher->id); ?></td>
                    <td><?php echo e($voucher->name); ?></td>
                    <td><?php echo e($voucher->code); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($voucher->start_date)->format('d.m.Y')); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($voucher->expiration_date)->format('d.m.Y')); ?></td>
                    <td><?php echo e(number_format($voucher->min_order_value, 2, ',', '.')); ?> €</td>
                    <td><?php echo e(number_format($voucher->max_discount, 2, ',', '.')); ?> €</td>
                    <td><?php echo e(number_format($voucher->voucher_value,2,',','.')); ?>€</td>
                    <td><?php echo e($voucher->type == '1' ? 'Fixed' : 'Percentage'); ?></td>
                    <td><?php echo e($voucher->times_redeemed); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/voucher/voucher-pdf.blade.php ENDPATH**/ ?>