<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo app('translator')->get('messages.booking_request.title'); ?></title>
</head>

<body style="margin:0; padding:0; font-family: Arial, sans-serif; background-color:#ffffff;">
    <table align="center" width="100%" cellpadding="0" cellspacing="0" border="0" style="max-width:700px;">
        <!-- Email Banner -->
         <tr>
            <td align="center" valign="top">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="center" valign="top" style=" width:100%; height:60px;">
                    
                    <!-- Spacer to push logo down -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" height="27">
                      <tr>
                        <td></td>
                      </tr>
                    </table>

                    <!-- Logo -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td align="center">
                          <img src="<?php echo e(asset('frontend/images/logo.png')); ?>" width="240" style="max-width:240px; width:100%; display:block; border:0;" alt="Logo">
                        </td>
                      </tr>
                    </table>

                  </td>
                </tr>
              </table>
            </td>
          </tr>

        <!-- Email Body -->
        <tr>
            <td style="padding:50px 30px; font-family:Arial, sans-serif;">
                <h2 style="font-family:Arial, sans-serif; font-weight:700; font-size:24px; line-height:100%; text-align:center; margin:0;">
                    <?php echo app('translator')->get('messages.booking_request.booking_request'); ?>
                </h2>
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; text-align:center; margin:30px 0 30px 0; color:#111111;">
                    <?php echo app('translator')->get('messages.booking_request.dear', ['title' => $title, 'first_name' => $first_name, 'last_name' => $last_name]); ?><br>
                </p>
                <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111;">
                    <?php echo app('translator')->get('messages.booking_request.thank_you_message'); ?>
                </p>

                <!-- Request Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.booking_request.request_details'); ?>:</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.request_id'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($booking_request_id); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.pickup_location'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($vendorstreet); ?>,  <br> <?php echo e($vendorzipCode); ?> <?php echo e($vendorcityName); ?>, <br>
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.rental_period'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e(\Carbon\Carbon::parse($rental_from)->format('d.m.Y')); ?> - <?php echo e(\Carbon\Carbon::parse($rental_to)->format('d.m.Y')); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.unavailable_components'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e(ucwords($unavailable_components)); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.carrier_length'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($carrier_length); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.foot_sku'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($foot_sku); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.footkit_sku'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($footkit_sku); ?>

                        </td>
                    </tr>
                </table>

                <!-- Product Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.booking_request.product_details'); ?>:</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.product_name'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($product_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.quantity'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            1
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.size_variation'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($size_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.color'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($color_name); ?>

                        </td>
                    </tr>
                </table>

                <!-- Car Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.booking_request.car_details'); ?>:</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.brand'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($manufacturer); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.year'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($car_year); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.model'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($car_model); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.trailer_hitch'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($trailer_hitch ? __('messages.yes') : __('messages.no')); ?>

                        </td>
                        
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.roof_type'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($roof_type ? ucwords($roof_type) : ''); ?>

                        </td>
                    </tr>
                </table>

                <!-- Customer Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b><?php echo app('translator')->get('messages.booking_request.customer_details'); ?>:</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.customer_name'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($first_name); ?> <?php echo e($last_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.address'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($street); ?>, <br> <?php echo e($zipcode); ?>  <?php echo e($city); ?>, <br> <?php echo e($state); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.email_address'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($email); ?>

                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            <?php echo app('translator')->get('messages.booking_request.phone_number'); ?>
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            <?php echo e($phone); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            <?php echo app('translator')->get('messages.booking_request.message'); ?>
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            <?php echo e($messages); ?>

                        </td>
                    </tr>
                </table>

                <!-- Closing Paragraph -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#000000; margin-top:30px;">
                    <?php echo app('translator')->get('messages.booking_request.closing_message'); ?><br><br>
                    <?php echo app('translator')->get('messages.booking_request.best_regards'); ?><br>
                    <?php echo app('translator')->get('messages.booking_request.team_signature'); ?>
                </p>
            </td>
        </tr>

        <!-- Footer -->
   <tr>
            <td bgcolor="#111111" style="padding:31px 45px 0px 45px; border-bottom:unset;" align="center">
                <img src="<?php echo e(asset('frontend/images/logo.png')); ?>" alt="" width="220" style="display:block; margin:0 auto;">
               

                <!-- Social Section -->
                <table border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr>
                        <td align="center" valign="top" style="padding:0 15px; margin: 15px 0;">
                            <img src="<?php echo e(asset('frontend/images/Message.png')); ?>" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">cs@dachboxit.de</p>
                        </td>
                        <td align="center" valign="top" style="padding:0 15px; margin: 15px 0; ">
                            <img src="<?php echo e(asset('frontend/images/Mobile.png')); ?>" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">+4915172876293</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="height: 20px; background: #111111;"></td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="background: #111111;">
                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin: 0px 0 20px 0;">
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/gdpr" style="color:#ffffff; text-decoration:none; margin:15px 5px;">
                        <?php echo e(__('messages.payment_link_email.privacy_policy')); ?>

                    </a>
                    |
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/term-condition" style="color:#ffffff; text-decoration:none; margin:0 5px;">
                        <?php echo e(__('messages.payment_link_email.terms_conditions')); ?>

                    </a>
                </p>
            </td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="height: 20px; background: #111111;"></td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="background: #111111;">

                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:0;">
                    Rerent Esperantostrasse 10, 70197 Stuttgart, Deutschland<br>Usatzsteuer-ID: DE300067568
                </p>
            </td>

        </tr>
        <!-- Copyright -->
        <tr>
            <td bgcolor="#111111" style="padding:15px 30px; text-align:center;">
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:14px; line-height:24px; color:#fff; margin:0;">
                    <?php echo app('translator')->get('messages.booking_request.copyright', ['year' => date('Y')]); ?>
                </p>
            </td>
        </tr>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/email/request_booking_email.blade.php ENDPATH**/ ?>