<?php $__env->startSection('content'); ?>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('admin.booking.index')); ?>">Booking management</a>
            <a class="active" href="">View Booking Details</a>
        </div>
        <?php if($booking->payment_status !== 'paid' && 
            (!empty($booking->last_payment_link_sent_at) && now()->diffInHours($booking->last_payment_link_sent_at) >= 24)): ?>
            <div class="mt-4 resend-payment">
                <form action="<?php echo e(route('admin.booking.resend-payment-link', $booking->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="add-notification-btn mb-3">Resend Payment Link</button>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <div class="add-user-form">
        <h2 class="head-mian-all-payment">View Booking Details</h2>
        <div class="main-show-detail-viwe">

            <!-- User Details Section -->
            <div class="inner-pack-view">
                <h3>User Details:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Customer ID</h5>
                        <p>#<?php echo e($booking->user_id ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Customer Name</h5>
                        <p>
                            <?php if($booking->userDetails): ?>
                                <?php echo e(trim($booking->userDetails->first_name . ' ' . $booking->userDetails->last_name) ?: 'N/A'); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Street, House Number</h5>
                        <p><?php echo e($booking->userDetails->address ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Zip Code</h5>
                        <p><?php echo e($booking->userDetails->zip ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>City</h5>
                        <p><?php echo e($booking->userDetails->city ?? 'N/A'); ?></p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>Country</h5>
                        <p><?php echo e($booking->userDetails->country ?? 'N/A'); ?></p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>Email Address</h5>
                        <p style="text-transform: lowercase;"><?php echo e($booking->userDetails->email ?? 'N/A'); ?></p>


                    </div>
                    <div class="patient-anme-view">
                        <h5>Phone Number</h5>
                        <p><?php echo e($booking->userDetails->phone ?? 'N/A'); ?></p>
                    </div>
                </div>

                <div class="patient-anme-view">
                    <h5>Note</h5>
                    <p><?php echo e($booking->notes ?? 'N/A'); ?></p>
                </div>
            </div>

            <!-- Loop Booking Items -->
            <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!$item->related_item): ?>
            <div class="car-details-wrap">

                <!-- Car Details -->
                <div class="inner-pack-view">
                    <h3>Car Details:</h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>Brand</h5>
                            <p><?php echo e($item->car_name ? explode(' ', $item->car_name)[0] : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Year</h5>
                            <p><?php echo e($item->car_year ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Model</h5>
                            <p><?php echo e($item->model ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Trailer Hitch</h5>
                            <p><?php echo e(isset($item->trailer_hitch) ? ($item->trailer_hitch ? 'Yes' : 'No') : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Roof Type</h5>
                            <p><?php echo e($item->roof_type ?? 'N/A'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Product Details -->
                <div class="inner-pack-view">
                    <h3>Product Details:</h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>Product ID</h5>
                            <p>#<?php echo e($item->product_id ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Product Name</h5>
                            <p><?php echo e($item->product_name ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Size / Variation</h5>
                            <p><?php echo e($item->size ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Color</h5>
                            <p><?php echo e($item->color ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Quantity</h5>
                            <p><?php echo e($item->quantity ?? 1); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Insurance</h5>
                            <p><?php echo e(isset($item->is_insured) ? ($item->is_insured ? 'Yes' : 'No') : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Roof Rack Included</h5>
                            <p><?php echo e(isset($item->is_carrier_included) ? ($item->is_carrier_included ? 'Yes' : 'No') : 'N/A'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Booking Details -->
                <div class="inner-pack-view">
                    <h3>Booking Details:</h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>Booking No.</h5>
                            <p>#<?php echo e($booking->id ?? 'N/A'); ?>

                                <?php if(!empty($item->vendor_id)): ?>
                                    <span class="text-secondary me-1" title="Includes vendor item"><i class="fa-solid fa-flag"></i></span>
                                <?php endif; ?>
                                <?php if($item->user_timing==1): ?>
                                    <span class="text-primary me-1" title="Customer requested timing change"><i class="fa-solid fa-flag"></i></span>
                                <?php endif; ?>
                                <?php if($booking->delay || $item->damage == 1): ?>
                                    <span class="text-danger me-1" title="Delay or Damage reported"><i class="fa-solid fa-flag"></i></span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Rental Period</h5>
                            <p>
                                <?php echo e($item->pickup_date ? $item->pickup_date->format('d.m.Y') : 'N/A'); ?> -
                                <?php echo e($item->dropoff_date ? $item->dropoff_date->format('d.m.Y') : 'N/A'); ?>

                            </p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Rental Days</h5>
                            <p><?php echo e($item->days ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Pick-Up Date/Time</h5>
                            <p>
                                <?php echo e($item->pickup_date ? $item->pickup_date->format('d.m.Y') : 'N/A'); ?> |
                                <?php echo e(!empty($item->pickup_time) ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : 'N/A'); ?>

                            </p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Drop-off Date/Time</h5>
                            <p>
                                <?php echo e($item->dropoff_date ? $item->dropoff_date->format('d.m.Y') : 'N/A'); ?> |
                                <?php echo e(!empty($item->dropoff_time) ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : 'N/A'); ?>

                            </p>
                        </div>
                    </div>

                    <div class="patient-anme-view" style="margin-bottom : 30px">
                        <h5>SA/SPO Change Reason</h5>
                        <p><?php echo e($item->change_reason ?? 'N/A'); ?></p>
                    </div>

                    <div class="patient-age-name d-flex mt-3">
                        <div class="patient-anme-view">
                            <h5>Roof Rack Information</h5>
                            <p>
                                Length: <?php echo e(!empty($item->carrier_length) ? preg_replace('/\s*mm$/i', '', $item->carrier_length) : 'N/A'); ?>

                                <?php if(!empty($item->foot_sku)): ?>
                                    Foot: <?php echo e($item->foot_sku); ?>

                                <?php endif; ?>
                                <?php if(!empty($item->footkit_sku)): ?>
                                    <span>Foot Kit: <?php echo e($item->footkit_sku); ?></span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Payment Method</h5>
                            <p><?php echo e($booking->payment_method ? ($booking->payment_method === 'stripe' ? 'Credit Card' : ucfirst($booking->payment_method)) : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Payment Status</h5>
                            <p><?php echo e($booking->payment_status ? ucfirst($booking->payment_status) : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Booking Status</h5>
                            <p><?php echo e($booking->status ? ucfirst($booking->status) : 'N/A'); ?></p>
                        </div>
                    </div>

                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>Total Amount</h5>
                            <p>€<?php echo e(number_format($booking->total ?? 0, 2, ',' , '.')); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Discount</h5>
                            <p>€<?php echo e(number_format($booking->discount ?? 0, 2 , ',' , '.')); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>PickUp Location</h5>
                            <?php 
                                $pickupAddress = 'N/A';
                                $vendorId = (int) ($item->vendor_id ?? 0);
                                if ($vendorId) {
                                    $v = $vendors->where('id', $vendorId)->first();
                                    if ($v) {
                                        $pickupAddress = "{$v->street} {$v->zip_code} {$v->city}";
                                    }
                                } else {
                                    $pickupAddress = 'Esperantostr. 10, 70197 Stuttgart';
                                }
                            ?>
                            <p><?php echo e($pickupAddress ?? 'N/A'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Return Info -->
                <div class="inner-pack-view mt-4">
                    <h3>Return Information:</h3>
                    <?php
                        $hasAlreadyBooked = $booking->items->contains(fn($i) => !empty($i->already_booked) && $i->already_booked == true);
                    ?>
                    <?php if($hasAlreadyBooked): ?>
                        <p style="color: red;">A booking has already been made against this booking. To avoid issues kindly check it.</p>
                    <?php endif; ?>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>Damaged Product(s)</h5>
                            <p>
                                <?php
                                    $damagedProducts = $booking->items->where('damage', 1)->pluck('product_name')->toArray();
                                ?>
                                <?php echo e(!empty($damagedProducts) ? implode(', ', $damagedProducts) : 'N/A'); ?>

                            </p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>New Drop-off Date</h5>
                            <p><?php echo e($booking->new_dropoff_date ? \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y') : 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>New Drop-off Time</h5>
                            <p><?php echo e(!empty($booking->items->first()->new_dropoff_time) ? \Carbon\Carbon::parse($booking->items->first()->new_dropoff_time)->format('H:i') : 'N/A'); ?></p>
                        </div>
                        
                        <div class="patient-anme-view">
                            <h5>Delay Fees</h5>
                            <p>€<?php echo e(number_format($booking->delay_fees ?? 0, 2, ',', '.')); ?></p>
                        </div>
                        
                        <div class="patient-anme-view">
                            <h5>Additional Days</h5>
                            <p><?php echo e($booking->additional_days ?? 'N/A'); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Additional Days Rent</h5>
                            <p>€<?php echo e(number_format($booking->additional_days_rent ?? 0, 2, ',', '.')); ?></p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>Extra Costs Paid</h5>
                            <p>
                                <?php if(($booking->additional_days_rent + $booking->delay_fees) == 0): ?>
                                    N/A
                                <?php elseif(isset($booking->delay_fees_paid)): ?>
                                    <?php echo e($booking->delay_fees_paid ? 'Paid' : 'Pending'); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>

            </div>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="upper-main-btn-last-comn d-flex">
            <a href="<?php echo e(route('admin.edit.booking.detail', $booking)); ?>" class="add-user ">
                Edit Booking
            </a>
            <a href="<?php echo e(route('admin.booking.index')); ?>" class="cancel-btn">
                Back to List
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/booking/booking_detail.blade.php ENDPATH**/ ?>