<div class="row">
    <div class="sidebar col-3" id="sidebar">
        <div class="toggl-main" onclick="toggleSidebar()">
            <i class="fa-solid fa-bars"></i>
        </div>
        <div class="sidebar-wrapper d-flex">
            <div class="sidebar-content">
                <div class="sidebar-logo">
                    <figure class="text-center"><img src="<?php echo e(asset('admin/images/logo.png')); ?>"></figure>
                </div>

                <ul class="slide-navli">
                    <li>
                        <a href="<?php echo e(route('admin.dashboard')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.dashboard') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/side.png')); ?>" alt="">
                                <p>Dashboard</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.user.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.user.*') || Request::routeIs('admin.add.user.view') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/side1.png')); ?>" alt="">
                                <p>User Management</p>
                            </div>
                        </a>
                    </li>

                    <?php
                        $productRoutes = ['admin.product.index', 'admin.category.index', 'admin.size.index', 'admin.variation.index', 'admin.brand.index', 'admin.color.index'];
                        $productActive = collect($productRoutes)->contains(fn($route) => Request::routeIs($route));
                    ?>
                    <li>
                        <div class="inner-slide-li <?php echo e($productActive ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.product.index')); ?>" class="d-flex inner-drop">
                                <img src="<?php echo e(asset('admin/images/side2.png')); ?>" alt="">
                                <p>Product Management</p>
                            </a>
                            <i class="fa-solid fa-chevron-down"></i>
                        </div>

                        <div class="inner-list-oper <?php echo e($productActive ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.brand.index')); ?>">
                                <div class="inner-slide-li <?php echo e(Request::routeIs('admin.brand.index') ? 'active' : ''); ?>">
                                    <img src="<?php echo e(asset('frontend/images/brand.png')); ?>" alt="">
                                    <p>Brand Management</p>
                                </div>
                            </a>
                            <a href="<?php echo e(route('admin.category.index')); ?>">
                                <div class="inner-slide-li <?php echo e(Request::routeIs('admin.category.index') ? 'active' : ''); ?>">
                                    <img src="<?php echo e(asset('frontend/images/cat.png')); ?>" alt="">
                                    <p>Category Management</p>
                                </div>
                            </a>
                            <a href="<?php echo e(route('admin.size.index')); ?>">
                                <div class="inner-slide-li <?php echo e(Request::routeIs('admin.size.index') ? 'active' : ''); ?>">
                                    <img src="<?php echo e(asset('frontend/images/size.png')); ?>" alt="">
                                    <p>Size Management</p>
                                </div>
                            </a>
                            <a href="<?php echo e(route('admin.variation.index')); ?>">
                                <div class="inner-slide-li <?php echo e(Request::routeIs('admin.variation.index') ? 'active' : ''); ?>">
                                    <img src="<?php echo e(asset('frontend/images/variation.png')); ?>" alt="">
                                    <p>Variation Management</p>
                                </div>
                            </a>
                            <a href="<?php echo e(route('admin.color.index')); ?>">
                                <div class="inner-slide-li <?php echo e(Request::routeIs('admin.color.index') ? 'active' : ''); ?>">
                                    <img src="<?php echo e(asset('frontend/images/color.png')); ?>" alt="">
                                    <p>Color Management</p>
                                </div>
                            </a>
                            
                        </div>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.bundle.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.bundle.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/content-manage.png')); ?>" alt="">
                                <p>Bundle Management</p>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.price.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.price.index') || Request::routeIs('admin.price.show') || Request::routeIs('admin.price.edit') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/side2.png')); ?>" alt="">
                                <p>Pricing Management</p>
                            </div>
                        </a>
                   
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.booking.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.booking.index') || Request::routeIs('admin.view.booking.detail') || Request::routeIs('admin.edit.booking.detail') || Request::routeIs('admin.add.booking') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/side3.png')); ?>" alt="">
                                <p>Booking Management</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.calendar.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.calendar.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/side4.png')); ?>" alt="">
                                <p>Calendar Management</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.payment.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.payment.index') || Request::routeIs('admin.view.payment.history')  ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/payment-manage.png')); ?>" alt="">
                                <p>Payment Management</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.voucher.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.voucher.index') || Request::routeIs('admin.create.voucher') || Request::routeIs('admin.view.voucher') || Request::routeIs('admin.edit.voucher') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/voucher-manage.png')); ?>" alt="">
                                <p>Voucher Management</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.blog.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.blog.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/blog-manage.png')); ?>" alt="">
                                <p>Blog Management</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.content.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.content.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/content-manage.png')); ?>" alt="">
                                <p>Content Management</p>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.spo.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.spo.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/content-manage.png')); ?>" alt="">
                                <p>SPO Management</p>
                            </div>
                        </a>
                    </li>
                   

                    <li>
                        <a href="<?php echo e(route('admin.report.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.report.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/repost.png')); ?>" alt="">
                                <p>Reports & Analytics</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('admin.settings.index')); ?>">
                            <div class="inner-slide-li <?php echo e(Request::routeIs('admin.settings.index') ? 'active' : ''); ?>">
                                <img src="<?php echo e(asset('admin/images/setting.png')); ?>" alt="">
                                <p>Settings</p>
                            </div>
                        </a>
                    </li>

                    <li>
                        <div class="inner-slide-li" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                            <img src="<?php echo e(asset('admin/images/log-out.png')); ?>" alt="">
                            <p>Log Out</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    
    <div class="modal fade modal-delete-logout" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="p-0 modal-body">
                    <div class="inner-body-delete-logout">
                        <h4>Are you sure you want to logout?</h4>
                        <div class="upper-btns-modal-pair">
                            <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                            <form action="<?php echo e(route('admin.logout.submit')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


<script>
    document.querySelectorAll('.fa-chevron-down, .fa-chevron-up').forEach(icon => {
        icon.addEventListener('click', () => {
            const container = icon.closest('li');
            const list = container.querySelector('.inner-list-oper');
            list.classList.toggle('active');
            icon.classList.toggle('fa-chevron-down');
            icon.classList.toggle('fa-chevron-up');
        });
    });
</script>
<?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>