<!DOCTYPE html>
<html>
<head>
    <title>Users Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Users Report</h1>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Address</th>
                <th>Confirmed + Completed Bookings</th>
                <th>Cancelled Bookings</th>
                <th>Marketing Agreement </th>
                <th>Status</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>#<?php echo e($user->id); ?></td>
                <td><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></td>
                <td><?php echo e($user->email); ?></td>
                <td><?php echo e($user->country_code); ?> <?php echo e($user->number); ?></td>
                <td><?php echo e($user->street); ?>, <?php echo e($user->zip_code); ?> ,<?php echo e($user->city); ?>, <?php echo e($user->region); ?>, <?php echo e($user->country); ?> </td>
                <td><?php echo e($user->bookings()->whereIn('status', ['confirmed', 'completed'])->count()); ?></td>
                <td><?php echo e($user->bookings()->where('status', 'cancelled')->count()); ?></td>
                <td><?php echo e($user->marketing_aggrement == 1 ? 'Yes' : 'No'); ?></td>
                <td><?php echo e($user->status ? 'Active' : 'Blocked'); ?></td>
                <td><?php echo e($user->created_at->format('d.m.Y')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/user/pdf.blade.php ENDPATH**/ ?>