<!DOCTYPE html>
<html>
<head>
    <title>Vouchers PDF</title>
    <style>
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 6px; border: 1px solid #ddd; font-size: 12px; }
        th { background: #f4f4f4; }
    </style>
</head>
<body>
    <h2>All Vouchers</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Code</th>
                <th>Start Date</th>
                <th>Expiration Date</th>
                <th>Min Order Value</th>
                <th>Max Discount</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($voucher->id); ?></td>
                    <td><?php echo e($voucher->name); ?></td>
                    <td><?php echo e($voucher->code); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($voucher->start_date)->format('d.m.Y')); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($voucher->expiration_date)->format('d.m.Y')); ?></td>
                    <td><?php echo e(number_format($voucher->min_order_value, 2, ',', '.')); ?> €</td>
                    <td><?php echo e(number_format($voucher->max_discount, 2, ',', '.')); ?> €</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/voucher/voucher-pdf.blade.php ENDPATH**/ ?>