<?php $__env->startSection('content'); ?>

<main>

    <div class="navigation-main">
        <div class="container">
            <div class="navigat">
                <a href="/"><?php echo e(__('messages.home')); ?></a>
                <a href="/product"><?php echo e($product->name); ?></a>
                <a class="prod-name active" href=""><?php echo e(($product->brand->name ?? '') . ' ' . ($product->name ?? '')); ?></a>

                
            </div>
        </div>
    </div>

    <section class="detail-show-all comn-padd-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="inner-crousel-product">
                        <div class="slider-main-left">
                            <div class="slider-inner-detail row">
                                <?php
                                    $mainImage = $product->images->firstWhere('type', 'main');
                                    $galleryImages = $product->images->where('type', 'gallery');
                                    $infoImage = $product->images->firstWhere('type','info');
                                    $allImages = collect();
                                    if ($mainImage) {
                                        $allImages->push($mainImage);
                                    }
                                    $allImages = $allImages->merge($galleryImages);
                                ?>
                            
                                <div class="col-2 p-0 padd-st">
                                    <div class="slider-nav">
                                        <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="main-img-slider-nav">
                                                <figure>
                                                    <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" alt="Product Thumbnail">
                                                </figure>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                
                                <div class="col-10">
                                    <div class="slider-for main-slider-for">
                                        <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="main-img-slider-for">
                                                <figure>
                                                    <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" alt="Product Image">
                                                </figure>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- <div class="insuranc-show-all">
                        <?php $__currentLoopData = $product->otherInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="main-show-insuranc mb-0">
                                <img src="<?php echo e(asset('storage/' . $info->image_path)); ?>" alt="Other Info Image">
                                <p><?php echo e($info->description); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div> -->
                    <div class="insuranc-show-all">
                        <?php $__currentLoopData = $product->otherInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!empty($info->description) && !empty($info->image_path)): ?>
                                <div class="main-show-insuranc mb-0">
                                    <img src="<?php echo e(asset('storage/' . $info->image_path)); ?>" alt="Other Info Image">
                                    <p><?php echo e($info->description); ?></p>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <?php if(!empty($infoImage) && !empty($infoImage->image_path)): ?>
                    <div class="main-img-detail-one">
                        <figure>
                            <img src="<?php echo e(asset('storage/' . $infoImage->image_path)); ?>" alt="Info Thumbnail">
                        </figure>
                    </div>
                <?php endif; ?>

                </div>
                <div class="col-lg-6">
                    <div class="inner-data-detail">
                        <div class="head-disc">
                            <h3><?php echo e($product->name); ?></h3>
                            <h6 class="brand-name-detail"><?php echo e(__('messages.brand')); ?> : <?php echo e($product->brand->name??''); ?></h6>
                            <p><?php echo e($product->description ?? 'N/A'); ?></p>
                        </div>

                        <div class="price-detail-main">
                            <div class="price-big d-flex">
                                <h3><?php echo e($product->first_price  ?? 'N/A'); ?></h3>
                                <a href="javascript:void()" data-bs-toggle="modal" data-bs-target="#exampleModal"><?php echo e(__('messages.view_price_breakdown')); ?></a>
                            </div>
                            <p><?php echo e(__('messages.per_day_incl_vat')); ?></p>
                        </div>

                        <div class="pick-location">
                            <h3><?php echo e(__('messages.pickup_location')); ?></h3>
                            <div class="pick-locati-name-icon d-flex">
                                <img src="<?php echo e(asset('frontend/images/loct.png')); ?>" alt="">
                                <select class="form-select" id="vendor_select" name="vendor_select">
                                    <option value ="admin">Esperantostr. 10, 70197 Stuttgart</option>
                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($vendor->id); ?>"><?php echo e($vendor->street . ' ' . $vendor->zip_code . ' ' . $vendor->city); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="choose-car">
                            <h3><?php echo e(__('messages.choose_your_car')); ?></h3>
                            <form id="car-form">
                                <div class="row">
                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.manufacturer')); ?></label>
                                        <select class="form-select" id="manufacturer" name="manufacturer">
                                            <option selected disabled><?php echo e(__('messages.select')); ?></option>
                                            <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($manufacturer); ?>"><?php echo e($manufacturer); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.model')); ?></label>
                                        <select class="form-select" id="model" name="model" disabled></select>
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.year_of_make')); ?></label>
                                        <select class="form-select" id="year" name="year" disabled></select>
                                    </div>

                                  

                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.trailer_hitch')); ?></label>
                                        <select class="form-select" id="trailer_hitch" name="trailer_hitch" 
                                                data-product-name="<?php echo e($product->name); ?>">
                                            <option value="" selected disabled><?php echo e(__('messages.select')); ?></option>
                                            <option value="yes"><?php echo e(__('messages.yes')); ?></option>
                                            <option value="no"><?php echo e(__('messages.no')); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div id="result" class="mt-3"></div>
                            </form>
                        </div>
                        <input id="railing_type" hidden value="<?php echo e($product->railing_type); ?>" />
                        <?php if($product->railing_type): ?>
                        <div class="railing-type">
                            <h3><?php echo e(__('messages.railing_type')); ?></h3>
                            <p><?php echo e(__('messages.railing_type_description')); ?></p>
                        </div>
                        
                        <div id="roof-types-container" style="display: none;">
                            <?php $__currentLoopData = $roofTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roofType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="roof-name-detail" id="roof-type-<?php echo e(Str::slug($roofType)); ?>">
                                    <figure>
                                        <?php
                                            $imageName = strtolower(str_replace(' ', '-', $roofType)) . '.jpg';
                                        ?>
                                        <img src="<?php echo e(asset('frontend/images/' . $imageName)); ?>" alt="<?php echo e($roofType); ?>">
                                    </figure>
                                    <h4><?php echo e(__('messages.' .($roofType))); ?></h4>
                                    <?php if($roofType == 'Normal Roof'): ?>
                                    <p><?php echo e(__('messages.normal')); ?></p>
                                    <?php elseif($roofType == 'Normal roof without glass roof'): ?>
                                    <p><?php echo e(__('messages.normal')); ?></p>
                                    <?php elseif($roofType == 'Normal Roof with glass roof'): ?>
                                    <p><?php echo e(__('messages.normal_glass')); ?></p>
                                    <?php elseif($roofType == 'Fixpoints'): ?>
                                    <p><?php echo e(__('messages.fixpoints')); ?></p>
                                    <?php elseif($roofType == 'Fixpoints without glass roof'): ?>
                                    <p><?php echo e(__('messages.fixpoints')); ?></p>
                                    <?php elseif($roofType == 'Fixpoints with glass roof'): ?>
                                    <p><?php echo e(__('messages.fixpoints_glass')); ?></p>
                                    <?php elseif($roofType == 'Integrated Roof Railing'): ?>
                                    <p><?php echo e(__('messages.integrated_rails')); ?></p>
                                    <?php elseif($roofType == 'Elevated Roof Rails'): ?>
                                    <p><?php echo e(__('messages.elevated_rails')); ?></p>
                                    <?php elseif($roofType == 'T-Profile'): ?>
                                    <p><?php echo e(__('messages.t_profile')); ?></p>
                                    <?php elseif($roofType == 'Raingutter'): ?>
                                    <p><?php echo e(__('messages.raingutter')); ?></p>
                                    <?php endif; ?>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>

                        <div id="roof-details-box" style="display: none; margin-top: 20px;"></div>

                        <div class="choose-rental-period">
                            <h3><?php echo e(__('messages.choose_rental_period')); ?></h3>
                            <p><?php echo e(__('messages.add_rental_period_description')); ?></p>
                            <form class=" email-login">
                                <div class="row">
                                    <div class="col-md-12 inner-main-input">
                                        <label for="inputEmail4" class="form-label"><?php echo e(__('messages.from')); ?></label>
                                        <input class="form-control"  id="rental_from">
                                    </div>
                                    <div class="col-md-12 inner-main-input">
                                        <label for="inputEmail4" class="form-label"><?php echo e(__('messages.to')); ?></label>
                                        <input class="form-control"  id="rental_to">
                   
                                        
                                    </div>
                                </div>
                            </form>


                            
                        </div>
                        <input type="hidden" name="insurance_selected" id="insurance_selected" value="0">
                        <input type="hidden" name="roof_rack_selected" id="roof_rack_selected" value="0">
                        
                      
                        
                        <div class="select-main-detail d-flex mt-4">
                            <div class="">
                                 
                                <?php if($product->name == 'Roof Box' || $product->name == 'Roof Bike Carrier'  || $product->name =='Dachbox'  || $product->name =='Dachfahrradträger'): ?>
                                <div class="form-check mb-1">
                                    <input class="form-check-input" type="checkbox" id="roof_rack_checkbox" checked>
                                    <label class="form-check-label" for="gridCheck">
                                        <?php echo e(__('messages.roof_rack_included')); ?>

                                    </label>
                                </div>
                                <?php endif; ?>
                               
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox"  id="insurance_checkbox" checked>
                                    <label class="form-check-label" for="gridCheck1">
                                        <?php echo e(__('messages.insurance_label')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="calculated-rent">
                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <h3><?php echo e(__('messages.calculated_rent')); ?></h3>

                                    <p class="text-calc-rent " id="withinsurance">(<?php echo e(__('messages.calculated_rent_with_insurance')); ?>)
                                    </p>
                                    <p class="text-calc-rent d-none" id="withoutinsurance">(<?php echo e(__('messages.calculated_rent_without_insurance')); ?>)
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <div class="inner-number-days">
                                        <p><?php echo e(__('messages.number_of_days')); ?>: <span> </span>

                                        </p>
                                        <p class="mb-0"><?php echo e(__('messages.total_rent')); ?>: <span></span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div id="errorMessage" class=""></div>
                        
                        <form id="bookingForm" action="<?php echo e(route('cart.add')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>" id="product_id">
                            <input type="hidden" name="product_name" value="<?php echo e($product->name); ?>" id="product_name">
                            <input type="hidden" name="manufacturer" id="hidden_manufacturer">
                            <input type="hidden" name="car_year" id="hidden_car_year">
                            <input type="hidden" name="model" id="hidden_model">
                            <input type="hidden" name="trailer_hitch" id="hidden_trailer_hitch">
                            <input type="hidden" name="roof_type" id="hidden_roof_type">
                            <input type="hidden" name="color_id" id="hidden_color_id">
                            <input type="hidden" name="color_name" id="hidden_color_name">
                            <input type="hidden" name="size_id" id="hidden_size_id">
                            <input type="hidden" name="size_name" id="hidden_size_name">
                            <input type="hidden" name="rental_from" id="hidden_rental_from">
                            <input type="hidden" name="rental_to" id="hidden_rental_to">
                            <input type="hidden" name="days" id="hidden_days">
                            <input type="hidden" name="calculated_rent" id="hidden_calculated_rent">
                            <input type="hidden" name="is_carrier_included" id="hidden_is_carrier_included">
                            <input type="hidden" name="is_insured" id="hidden_is_insured">
                            

                            <button type="submit" id="rentNowButton" class="mt-4 w-100 btn primary-btn"><?php echo e(__('messages.rent_now')); ?></button>

                            <button type="button" id="requestButton" class="mt-4 w-100 btn primary-btn d-none" data-bs-toggle="modal" data-bs-target="#requestModal">
                                <?php echo e(__('messages.send_request')); ?>

                            </button>
                        </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="comn-padd-100 faq-detail">
        <div class="inner-privacy-content">
            <div class="container">
                <div class="inner-faq">
                    <h2 class="head-faq"><?php echo e(__('messages.additional_info')); ?></h2>
                    <div class="accordion" id="accordionExample">
                        <!-- Available Models Section -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    <?php echo e(__('messages.available_models')); ?>

                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <?php $__currentLoopData = $product->models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <h6><?php echo e($index + 1); ?>. <?php echo e($model['title'] ?? ''); ?></h6>
                                            <p><?php echo e($model['description'] ?? ''); ?></p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Dimensions -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    <?php echo e(__('messages.dimensions')); ?>

                                </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="dimensionsText"><?php echo e(__('messages.select_size_dimensions')); ?></p>
                                        <ul id="dimensionsList" style="display:none;">
                                            <li><?php echo e(__('messages.length')); ?>: <span id="dimensionLength"></span> cm</li>
                                            <li><?php echo e(__('messages.width')); ?>: <span id="dimensionWidth"></span> cm</li>
                                            <li><?php echo e(__('messages.height')); ?>: <span id="dimensionHeight"></span> cm</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Weight -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    <?php echo e(__('messages.weight')); ?>

                                </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="weightText"><?php echo e(__('messages.select_size_weight')); ?></p>
                                        <ul id="weightList" style="display:none;">
                                            <li><?php echo e(__('messages.weight')); ?>: <span id="weightValue"></span> kg</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Volume -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                    <?php echo e(__('messages.volume')); ?>

                                </button>
                            </h2>
                            <div id="collapsefour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="volumeText"><?php echo e(__('messages.select_size_volume')); ?></p>
                                        <ul id="volumeList" style="display:none;">
                                            <li><?php echo e(__('messages.volume')); ?>: <span id="volumeValue"></span> liters</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Max Load -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    <?php echo e(__('messages.max_load')); ?>

                                </button>
                            </h2>
                            <div id="collapsefive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="maxLoadText"><?php echo e(__('messages.select_size_max_load')); ?></p>
                                        <ul id="maxLoadList" style="display:none;">
                                            <li><?php echo e(__('messages.max_load')); ?>: <span id="maxLoadValue"></span> kg</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                    </div> <!-- .accordion -->
                </div> <!-- .inner-faq -->
            </div>
        </div>
    </section>

    <?php echo $__env->make('frontend.include.subscribe_news', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="comn-padd-100 related-product-detail">
        <div class="container">
            <div class="products-main-wrapper">
                <h2 class="related-prod"><?php echo e(__('messages.related_products')); ?></h2>
                <div class="row row-gap-4">
                    <?php $__empty_1 = true; $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                                $mainImage = $relatedProduct->images->first();

                        ?>
                       
                        
                        <div class="col-lg-4">
                            <div class="product-main-one">
                                <div class="upper-imag-product-card">
                                    <figure>
                                        <?php if($mainImage): ?>
                                            <img src="<?php echo e(asset('storage/' . $mainImage->image_path)); ?>" alt="<?php echo e($relatedProduct->name); ?>">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('frontend/images/default-product.png')); ?>" alt="Default product image">
                                        <?php endif; ?>
                                    </figure>
                                </div>
                                <div class="product-detail-name-card">
                                    <h3><?php echo e($relatedProduct->name); ?></h3>
                                    <p><?php echo e(__('messages.from')); ?> <?php echo e($relatedProduct->first_price); ?></p>
                                    <a href="<?php echo e(route('product.details', ['slug' => $relatedProduct->category->slug ?? 'default'])); ?>" class="btn rent-btn">
                                        <?php echo e(__('messages.rent_now')); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <p><?php echo e(__('messages.no_related_products')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    
    <section class="touch-with-us comn-padd">
        <div class="container">
            <div class="inner-touch-contact product-detail-touch">
                <div class="row">
                    <div class="col-md-7">
                        <div class="inner-form-touch">
                            <h2><?php echo e(__('messages.get_in_touch')); ?></h2>
                            <form class="row" id="contactForm" method="post" action="<?php echo e(route('contact.store')); ?>">
                                <?php echo csrf_field(); ?>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="name" class="form-label"><?php echo e(__('messages.name')); ?></label>
                                        <input type="text" name="name" id="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.enter_your_name')); ?>" value="<?php echo e(old('name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="email" class="form-label"><?php echo e(__('messages.email')); ?></label>
                                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.enter_your_email')); ?>" id="email" name="email" value="<?php echo e(old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="contact-number" class="form-label"><?php echo e(__('messages.contact_number')); ?></label>
                                        <input type="tel" class="form-control <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.enter_your_contact_number')); ?>" id="contact-number" name="number" value="<?php echo e(old('number')); ?>">
                                        <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="message" class="form-label"><?php echo e(__('messages.message')); ?></label>
                                        <textarea class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.leave_a_comment')); ?>" id="message" name="message" style="height: 135px"><?php echo e(old('message')); ?></textarea>
                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('messages.send_message')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="inner-figure-contact">
                            <figure class="fig-main-img-touch">
                                <img src="<?php echo e(asset('frontend/images/touch.png')); ?>" alt="">
                            </figure>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" id="booking_item_ids" >
    </section>
    
</main>


<div class="modal fade" id="requestModal" tabindex="-1" aria-labelledby="requestModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="requestModalLabel"><?php echo e(__('messages.product_request')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(__('messages.request_modal_message')); ?></p>
                
                <!-- Display selected product details -->
                <div class="selected-product-details mb-4 p-3 border rounded">
                    <h6><?php echo e(__('messages.product_details')); ?></h6>
                    <div id="requestProductDetails">
                        <!-- Will be populated by JavaScript -->
                    </div>
                </div>
                
                <form id="requestForm">
                    <div class="form-full">
                    <div class="col-md-6">
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                                <label class="form-label"><?php echo e(__('messages.title')); ?></label>
                                <select class="form-select" name="title" id="title">
                                    <option value=""><?php echo e(__('messages.select')); ?></option>
                                    <option value="Mr." <?php echo e(old('title') == 'Mr.' ? 'selected' : ''); ?>><?php echo e(__('messages.title_mr')); ?></option>
                                    <option value="Mrs." <?php echo e(old('title') == 'Mrs.' ? 'selected' : ''); ?>> <?php echo e(__('messages.title_mrs')); ?></option>
                                </select>
                                <div class="invalid-feedback"><?php echo e(__('messages.select_title_error')); ?></div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                                <input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" value="<?php echo e(old('first_name')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.first_name_error')); ?></div>
                            </div>
                        </div>
                    </div>
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.last_name')); ?></label>
                            <input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?php echo e(__('messages.enter_surname')); ?>" value="<?php echo e(old('last_name')); ?>">
                            <div class="invalid-feedback"><?php echo e(__('messages.last_name_error')); ?></div>
                        </div>
                    </div>
                </div>
                    
                <div class="form-full">
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.email')); ?></label>
                            <input type="email" class="form-control" name="email" id="requestEmail" placeholder="<?php echo e(__('messages.email')); ?>" value="<?php echo e(old('email')); ?>">
                            <div class="invalid-feedback"><?php echo e(__('messages.email_error')); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><?php echo e(__('messages.country_code')); ?></label>
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                               
                                
                                <select name="country_code" class="form-select country_code_custom" id="country_code">
                                    <option value="+49" data-image="https://flagcdn.com/16x12/de.png" <?php echo e(old('country_code') == '+49' ? 'selected' : ''); ?>>+49</option>
                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e(old('country_code') == '+43' ? 'selected' : ''); ?>>+93</option>
                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  <?php echo e(old('country_code') == '+41' ? 'selected' : ''); ?>>+41</option>
                                </select>
                                <div class="invalid-feedback"><?php echo e(__('messages.select_country_code_error')); ?></div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <input type="text" class="form-control" name="contact_number" id="requestPhone" placeholder="<?php echo e(__('messages.phone_placeholder')); ?>" value="<?php echo e(old('contact_number')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.phone_error')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label"><?php echo e(__('messages.street')); ?></label>
                        <input type="text" class="form-control" name="street" id="street" placeholder="<?php echo e(__('messages.enter_address')); ?>" value="<?php echo e(old('street')); ?>">
                        <div class="invalid-feedback"><?php echo e(__('messages.street_error')); ?></div>
                    </div>
                </div>
                <div class="form-full">
                <div class="col-md-6">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label"><?php echo e(__('messages.zip_code')); ?></label>
                        <input type="text" class="form-control" name="zipcode" id="zipcode" placeholder="<?php echo e(__('messages.enter_zip_code')); ?>" value="<?php echo e(old('zipcode')); ?>">
                        <div class="invalid-feedback"><?php echo e(__('messages.zip_code_error')); ?></div>
                    </div>
                </div>
                    
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.city')); ?></label>
                            <input type="text" class="form-control" name="city" id="city" placeholder="<?php echo e(__('messages.enter_city')); ?>" value="<?php echo e(old('city')); ?>">
                            <div class="invalid-feedback"><?php echo e(__('messages.city_error')); ?></div>
                        </div>
                    </div>
                </div>
                    
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.state_region')); ?></label>
                            <select class="form-select" name="state" id="state">
                                <option value=""><?php echo e(__('messages.select_state')); ?></option>

                                <?php $__currentLoopData = __('messages.regions'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php echo e(old('state') == $key ? 'selected' : ''); ?>>
                                        <?php echo e($label); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="invalid-feedback"><?php echo e(__('messages.state_error')); ?></div>

                            
                        </div>
                    </div>
                
                 
                
                    

                    <div class="mb-3">
                        <label for="requestMessage" class="form-label"><?php echo e(__('messages.message')); ?></label>
                        <textarea class="form-control" id="requestMessage" rows="3" placeholder="<?php echo e(__('messages.specific_requirements')); ?>"></textarea>
                    </div>
                    
                    <!-- Hidden fields to store product information -->
                    <input type="hidden" id="requestProductId">
                    <input type="hidden" id="requestProductName">
                    <input type="hidden" id="requestColorId">
                    <input type="hidden" id="requestColorName">
                    <input type="hidden" id="requestSizeId">
                    <input type="hidden" id="requestSizeName">
                    <input type="hidden" id="requestVariationId">
                    <input type="hidden" id="requestVariationName">
                    <input type="hidden" id="requestRentalFrom">
                    <input type="hidden" id="requestRentalTo">
                    <input type="hidden" id="requestCarrierLength">
                    <input type="hidden" id="requestFootSku">
                    <input type="hidden" id="requestFootkitSku">
                    <input type="hidden" id="requestRoofType">
                    <input type="hidden" id="requestUnavailableComponents">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn  primary-outline-btn" data-bs-dismiss="modal"><?php echo e(__('messages.cancel')); ?></button>
                <button type="button" class="btn primary-btn" id="submitRequest"><?php echo e(__('messages.submit_request')); ?></button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade modal-not-book" id="railingType" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel"><?php echo e(__('messages.attention')); ?></h5>
                <p><?php echo e(__('messages.please_check_railing_type')); ?></p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal"><?php echo e(__('messages.ok')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel"><?php echo e(__('messages.not_bookable_title')); ?></h5>
                <p><?php echo e(__('messages.not_bookable_message')); ?></p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal"><?php echo e(__('messages.ok')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier"><?php echo e(__('messages.carrier_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.carrier_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn"><?php echo e(__('messages.rent_carrier')); ?></button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn"><?php echo e(__('messages.bring_own_carrier')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance"><?php echo e(__('messages.insurance_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.insurance_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn"><?php echo e(__('messages.yes_insure_me')); ?></button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn"><?php echo e(__('messages.no_insurance')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title modal-guest"><?php echo e(__('messages.login_modal_title')); ?></h5>
                <a href="javascript:void(0);" class="w-100 btn primary-btn" onclick="saveFormDataAndRedirect('/dachboxmiete-phase-2/public/login')">
                    <?php echo e(__('messages.login_modal_title')); ?>

                </a>
                <div class="">
                    <div class="dont-acount">
                        <p><?php echo e(__('messages.dont_have_account')); ?></p>
                    </div>
                    <a href="javascript:void(0);" class="w-100 btn primary-outline-btn" onclick="saveFormDataAndRedirect('/dachboxmiete-phase-2/public/registration')">
                        <?php echo e(__('messages.create_account')); ?>

                    </a>
                </div>
                <div class="dont-acount">
                    <p><?php echo e(__('messages.or')); ?></p>
                </div>
                <button class="w-100 btn primary-outline-btn" data-bs-target="#guestModal" data-bs-toggle="modal">
                    <?php echo e(__('messages.continue_with_guest')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2"><?php echo e(__('messages.guest_title')); ?></h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label"><?php echo e(__('messages.surname')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_surname')); ?>" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label"><?php echo e(__('messages.phone_number')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_phone_number')); ?>" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label"><?php echo e(__('messages.email')); ?></label>
                            <input type="email" class="form-control" placeholder="<?php echo e(__('messages.enter_email')); ?>" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn  primary-outline-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        <?php echo e(__('messages.back')); ?>

                    </button>
                    <button class="btn primary-btn" id="continueAsGuest">
                        <?php echo e(__('messages.continue')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3><?php echo e(__('messages.our_rental_price')); ?></h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th><?php echo e(__('messages.days')); ?></th>
                                <th><?php echo e(__('messages.price')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $dailyPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__('messages.day_label', ['number' => $index + 1])); ?></td>
                                    <td><?php echo e(number_format($price, 2, ',', '.')); ?> €</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-not-book" id="requestSuccessful" tabindex="-1" aria-labelledby="requestSuccessful" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <h5 class="modal-title" id="requestSuccessful"><?php echo e(__('messages.thank_you')); ?></h5>
                <p><?php echo e(__('messages.thank_you_message')); ?></p>
                <button type="button" class="btn primary-btn" id="okayBtn"><?php echo e(__('messages.okay')); ?></button>
            </div>
        </div>
    </div>
</div>
<script>
    let bookingData = {};
    $(document).ready(function() {
        $.get(`${baseUrl}/userCarDetail`, function(data) {
            if (data) {

                bookingData = data.data;
                if (bookingData && Object.keys(bookingData).length > 0) {
                    console.log(bookingData)
                    fillBookingData(bookingData);
                }
                
                
            }

    });
    const waitForOption = (selector, value) => {
        return new Promise(resolve => {
            const interval = setInterval(() => {
                const $option = $(`${selector} option`).filter(function () {
                    return $(this).val().trim() === value.trim();
                });
                if ($option.length) {
                    console.log($option.val(),selector)

                    $(selector).val($option.val()).trigger('change');
                    clearInterval(interval);
                    resolve();
                }
            }, 200);
        });
    };

    async function fillBookingData(data) {
        if (data.manufacturer) {
            await waitForOption("#manufacturer", data.manufacturer);
        }
        
        if (data.car_model) {
            await waitForOption("#model", data.car_model);
        }
        if (data.car_year) {
            await waitForOption("#year", data.car_year);
        }
        if (data) {
            if(data.trailer_hitch == 1){
                data.trailer_hitch = 'yes';
            }else{
                data.trailer_hitch = 'no'
            }
            await waitForOption("#trailer_hitch", data.trailer_hitch.toLowerCase());
        }
    }
    });

</script>

<script>
     var baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";
    let carrier_length = null;
    let foot_sku = null;
    let footkit_sku = null;

    let user = <?php echo json_encode(auth()->user(), 15, 512) ?>;

    if(user) {
        $('#title').val(user.title);
        $('#first_name').val(user.first_name);
        $('#last_name').val(user.last_name);
        $('#requestEmail').val(user.email);
        $('#country_code').val(user.country_code);
        $('#requestPhone').val(user.number);
        $('#street').val(user.street);
        $('#zipcode').val(user.zip_code);
        $('#city').val(user.city);
        $('#state').val(user.region);
    }

    window.unavailableComponents = [];

    $(document).on('click', '#okayBtn', function() {
        location.reload();
    });


    function toggleRentButton(isAvailable) {
        if (isAvailable) {
            $('#rentNowButton').removeClass('d-none');
            $('#requestButton').addClass('d-none');
        } else {
            $('#rentNowButton').addClass('d-none');
            $('#requestButton').removeClass('d-none');
        }
    }

    function populateRequestForm() {
        // Get all relevant product information
        const productId = $('#product_id').val();
        const productName = $('#product_name').val();
       
        const rentalFrom = $('#rental_from').val();
        const rentalTo = $('#rental_to').val();
        const manufacturer = $('#manufacturer').val();
        const model = $('#model').val();
        const year = $('#year').val();
        const trailerHitch = $('#trailer_hitch').val();
        const roofType = selectedRecommendation ? selectedRecommendation.rooftype_eng : '';
        
        // Set hidden field values
        $('#requestProductId').val(productId);
        $('#requestProductName').val(productName);
      
        $('#requestRentalFrom').val(rentalFrom);
        $('#requestRentalTo').val(rentalTo);
        $('#requestCarrierLength').val(selectedRecommendation ? selectedRecommendation.carrier_length : '');
        $('#requestFootSku').val(selectedRecommendation ? selectedRecommendation.foot_sku : '');
        $('#requestFootkitSku').val(selectedRecommendation ? selectedRecommendation.footkit_sku : '');
        $('#requestRoofType').val(roofType);
        
        // Build product details display

        let detailsHtml = `
            <p><strong><?php echo e(__('messages.product')); ?>:</strong> ${productName}</p>
            <p><strong><?php echo e(__('messages.rental_period')); ?>:</strong> ${rentalFrom} <?php echo e(__('messages.to')); ?> ${rentalTo}</p>

        `;
        
        if (manufacturer) {
            detailsHtml += `<p><strong><?php echo e(__('messages.vehicle')); ?>:</strong> ${manufacturer} ${model} (${year})</p>`;
        }
        
        if (trailerHitch) {
            detailsHtml += `<p><strong><?php echo e(__('messages.trailer_hitch')); ?>:</strong> 
                ${trailerHitch == 'yes' ? "<?php echo e(__('messages.yes')); ?>" : "<?php echo e(__('messages.no')); ?>"}
            </p>`;
        }
        
 if (roofType) {
            detailsHtml += `<p><strong><?php echo e(__('messages.roof_type')); ?>: </strong>${roofType}</p>`;
        }
        
        // Add unavailable components if any
      if (window.unavailableComponents && window.unavailableComponents.length > 0) {
           const unique = [...new Set(window.unavailableComponents)];

            const capitalized = unique.map(
                item => item.charAt(0).toUpperCase() + item.slice(1)
            );

            detailsHtml += `<p><strong><?php echo e(__('messages.unavailable_components')); ?>:</strong> ${capitalized.join(', ')}</p>`;
            $('#requestUnavailableComponents').val(capitalized.join(', '));
        }
        
        $('#requestProductDetails').html(detailsHtml);
    }

function parseDMY(dateStr) {
        const [day, month, year] = dateStr.split('.');
        const fullYear = parseInt(year) < 100 ? 2000 + parseInt(year) : parseInt(year);
        return new Date(fullYear, parseInt(month) - 1, parseInt(day));
    }
function saveFormDataAndRedirect(redirectUrl) {

    let rentalFromStr = $('#rental_from').val();
    let rentalToStr = $('#rental_to').val();

    let rentalFrom = parseDMY(rentalFromStr);
    let rentalTo = parseDMY(rentalToStr);

    let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
    let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
    let formData = {
        product_id: $('#product_id').val(),
        product_name: $('#product_name').val(),
        manufacturer: $('#manufacturer').val(),
        car_year: $('#year').val(),
        model: $('#model').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: selectedRecommendation?.rooftype_eng || '',
        carrier_length: selectedRecommendation?.carrier_length || '',
        foot_sku: selectedRecommendation?.foot_sku || '',
        footkit_sku: selectedRecommendation?.footkit_sku || '',
        booking_item_ids: $('#booking_item_ids').val() || '',
        bundle_name: selectedRecommendation?.bundle_name || '',
        rental_from: $('#rental_from').val(),
        rental_to: $('#rental_to').val(),
        days: days,
        calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
        is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
        vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
    };
    formData._token = $('meta[name="csrf-token"]').attr('content');


    $.post(`${baseUrl}/store-rental-form`, formData, function() {
        window.location.href = redirectUrl; 
    });
}

$(document).ready(function() {
    $('#manufacturer').change(function() {
        $('#model').prop('disabled', true).html('<option>Loading...</option>');
        $('#year').prop('disabled', true).html('<option><?php echo e(__('messages.select')); ?></option>');
        
        let manufacturer = $(this).val();

        $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
            $('#model').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
            data.forEach(model => {
                $('#model').append(`<option value="${model}">${model}</option>`);
            });
        });
    });

    $('#model').change(function() {
        $('#year').prop('disabled', true).html('<option>Loading...</option>');
        
        let manufacturer = $('#manufacturer').val();
        let model = $(this).val();

        $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
            $('#year').prop('disabled', false).html('<option selected disabled><?php echo e(__('messages.select')); ?></option>');
            data.forEach(year => {
                $('#year').append(`<option value="${year}">${year}</option>`);
            });
        });
    });

    var railing_type = $('#railing_type').val();
console.log('railing_type',railing_type)
$('#year, #trailer_hitch').change(function() {
    let manufacturer = $('#manufacturer').val();
    let year = $('#year').val();
    let model = $('#model').val();
    let trailer_hitch = $('#trailer_hitch').val();


    const productName = $('#trailer_hitch').data('product-name');
    const selectedValue = $('#trailer_hitch').val();
    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
    if (selectedValue === 'no' && hitchRequired) {
        $('#trailer_hitch').val('');

        const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
        modal.show();
        return ;
    }


    if (manufacturer && year && model && trailer_hitch) {
        $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
            window.currentRecommendation = data;
            window.currentRecommendationMap = {};

            if (data.length === 0) {
                $('#result').html('<p><?php echo e(__('messages.no_recommendations_found')); ?></p>');
                return;
            }

            $('.roof-name-detail').hide();
            $('#roof-types-container').show();

            

            data.forEach((item, index) => {
                const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

               console.log('roofTypeSlug',roofTypeSlug)
                if(railing_type){
                    $(`#roof-type-${roofTypeSlug}`).show();
    
                    window.currentRecommendationMap[roofTypeSlug] = item;
                    $(`#roof-type-${roofTypeSlug}`)
                        .addClass('clickable-roof')
                        .attr('data-rooftype-slug', roofTypeSlug);
                }
            });

            $('#result').html(html);
            highlightRecommendedSizes(data);
        });
    }
});

});




function checkAvailability() {
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    const vendor_id = $('#vendor_select').val();

   
    
    const params = {
        from_date: fromDate,
        to_date: toDate,
        vendor_id : vendor_id,
        carrier_length : carrier_length,
        foot_sku : foot_sku,
        footkit_sku : footkit_sku

    };

    if(!fromDate || !toDate || !vendor_id){
        return; 
    }
    
    $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/roofRack/availability`, params, function(availability) {
        $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            const isAvailable = availability[sizeId] > 0;
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? '' : 'Unavailable');
        });
        const bookingItemIds = {};
        
        if (availability.carrier && availability.carrier.booking_item_ids.length > 0) {
            bookingItemIds.carrier = availability.carrier.booking_item_ids[0];
        }
        
        if (availability.foot && availability.foot.booking_item_ids.length > 0) {
            bookingItemIds.foot = availability.foot.booking_item_ids[0];
        }
        
        if (availability.footkit && availability.footkit.booking_item_ids.length > 0) {
            bookingItemIds.footkit = availability.footkit.booking_item_ids[0];
        }
        
        // Store the dictionary as JSON string
        window.bookingItemIds = JSON.stringify(bookingItemIds);
        
        // Check availability
        const isCarrierAvailable = availability.carrier && availability.carrier.available_units > 0;
        const isFootAvailable = availability.foot && availability.foot.available_units > 0;
        const isFootkitAvailable = availability.footkit && availability.footkit.available_units > 0;
        const isAvailable = isCarrierAvailable && isFootAvailable && isFootkitAvailable;



        $('#booking_item_ids').val(window.bookingItemIds);
        if (!isAvailable) {
            let errorMessage = '';
            const unavailableComponents = [];
            
            // if (!isCarrierAvailable) unavailableComponents.push('carrier');
            // if (!isFootAvailable) unavailableComponents.push('foot');
            // if (!isFootkitAvailable) unavailableComponents.push('footkit');


            // if (!isCarrierAvailable) window.unavailableComponents.push('carrier');
            // if (!isFootAvailable) window.unavailableComponents.push('foot');
            // if (!isFootkitAvailable) window.unavailableComponents.push('footkit');

            if (!isCarrierAvailable) window.unavailableComponents.push('traverse');
            if (!isFootAvailable) window.unavailableComponents.push('fuß');
            if (!isFootkitAvailable) window.unavailableComponents.push('fußkit');


            if (!isCarrierAvailable) unavailableComponents.push('traverse');
            if (!isFootAvailable) unavailableComponents.push('fuß');
            if (!isFootkitAvailable) unavailableComponents.push('fußkit');
            
            errorMessage += unavailableComponents.join(', ');
            
            $('#errorMessage').html(`
                
                
                  <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.size_unavailable_message', ['errorMessage' => '${errorMessage}'])); ?>

                </div>
            `);

            toggleRentButton(isAvailable);
        } else {
            $('#errorMessage').empty();
        }
        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }


        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }
    });
}

$('#vendor_select').on('change',function(){
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    if ( fromDate && toDate) {
        checkAvailability();
    }
})


$('#rental_from, #rental_to').on('change', function() {

        checkAvailability();
   
});



// function highlightRecommendedSizes(recommendation) {
//     $('.inner-size-card').removeClass('recommended-size');
    
//     recommendation.forEach(item => {
//         $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`)
//             .addClass('recommended-size');
//     });
// }



function highlightRecommendedSizes(recommendation) {
        $('.inner-size-card').removeClass('recommended-size');
        $('.recommended').addClass('d-none')
    recommendation.forEach(item => {
        const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
        $card.addClass('recommended-size');
        console.log(item)
        $card.find('.recommended').removeClass('d-none');
            $card.find('.recommended').text('EMPFOHLEN');
    });
}

var railing_type = $('#railing_type').val();
console.log('railing_type',railing_type)
$('#year, #trailer_hitch').change(function() {
    let manufacturer = $('#manufacturer').val();
    let year = $('#year').val();
    let model = $('#model').val();
    let trailer_hitch = $('#trailer_hitch').val();


    const productName = $('#trailer_hitch').data('product-name');
    const selectedValue = $('#trailer_hitch').val();
    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
    if (selectedValue === 'no' && hitchRequired) {
        $('#trailer_hitch').val('');

        const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
        modal.show();
        return ;
    }


    if (manufacturer && year && model && trailer_hitch) {
        $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
            window.currentRecommendation = data;
            window.currentRecommendationMap = {};

            if (data.length === 0) {
                $('#result').html('<p><?php echo e(__('messages.no_recommendations_found')); ?></p>');
                return;
            }

            $('.roof-name-detail').hide();
            $('#roof-types-container').show();

            

            data.forEach((item, index) => {
                const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

               console.log('roofTypeSlug',roofTypeSlug)
                if(railing_type){
                    $(`#roof-type-${roofTypeSlug}`).show();
    
                    window.currentRecommendationMap[roofTypeSlug] = item;
                    $(`#roof-type-${roofTypeSlug}`)
                        .addClass('clickable-roof')
                        .attr('data-rooftype-slug', roofTypeSlug);
                }
            });

         
            highlightRecommendedSizes(data);
        });
    }
});

let selectedRecommendation = null;


$(document).on('click', '.clickable-roof', function () {
    $('.clickable-roof').removeClass('selected');
    $(this).addClass('selected');

    const slug = $(this).data('rooftype-slug');
    selectedRecommendation = window.currentRecommendationMap[slug];


    console.log(selectedRecommendation);

    $('#roof-types-container .invalid-feedback').remove();

    if (selectedRecommendation) {
        const html = `
            <div class="roof-info-card" style="padding: 15px; border: 1px solid #ccc; border-radius: 8px; background: #f9f9f9;">
                 <h4><?php echo e(__('messages.bundle_name')); ?> : ${selectedRecommendation.bundle_name}</h4>
                <ul style="list-style: none; padding-left: 0;">
                    <li><strong><?php echo e(__('messages.carrier_length')); ?>:</strong> ${selectedRecommendation.carrier_length || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.foot_sku')); ?>:</strong> ${selectedRecommendation.foot_sku || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.footkit_sku')); ?>:</strong> ${selectedRecommendation.footkit_sku || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.recommended_roofbox_size')); ?>:</strong> ${selectedRecommendation.recommended_roofbox_size || 'N/A'}</li>
                    <li><strong><?php echo e(__('messages.roof_type')); ?>:</strong> ${selectedRecommendation.rooftype_ger || 'N/A'}</li>
                </ul>
            </div>
        `;
        carrier_length = selectedRecommendation.carrier_length;
        foot_sku = selectedRecommendation.foot_sku;
        footkit_sku = selectedRecommendation.footkit_sku;
        $('#roof-details-box').html(html).fadeIn();
    } else {
        $('#roof-details-box').hide();
    }
});



$(document).on('click', '.inner-size-card', function () {

    const colorId = $('#color-select').val();
    const colorName = $('#color-select').find('option:selected').data('color-name');
    if (!colorName) {
        $('#errorMessage').html(`
            <div class="text-danger mt-2">
                <?php echo e(__('messages.select_color_first')); ?>

            </div>
        `);
        return;
    }


    const $card = $(this);
    const isAvailable = $card.hasClass('available');
    const isUnavailable = $card.hasClass('unavailable');

    $('.inner-size-card').removeClass('selected');
    $('#errorMessage').empty();

    $card.addClass('selected');

    if (isUnavailable) {
        const message = `
             <div class="size-unavailable-message text-danger mt-2">
                    <?php echo e(__('messages.product_not_available_message')); ?>

            </div>
        `;
        $('#errorMessage').html(message);
    }

    const sizeId = $(this).data('size-id');
    const variationId = $(this).data('variation-id');
    const sizeName = $(this).data('size-name');

    $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/size-details`, {
        size_id: sizeId,
        variation_id: variationId
    }, function(data) {
        if (data) {
            if (data.length && data.width && data.height) {
                $('#dimensionsText').hide();
                $('#dimensionsList').show();
                $('#dimensionLength').text(data.length);
                $('#dimensionWidth').text(data.width);
                $('#dimensionHeight').text(data.height);
            } else {
                $('#dimensionsText').show().text("<?php echo e(__('messages.dimensions_not_available')); ?>");
                $('#dimensionsList').hide();
            }

            if (data.weight) {
                $('#weightText').hide();
                $('#weightList').show();
                $('#weightValue').text(data.weight);
            } else {
                    $('#weightText').show().text("<?php echo e(__('messages.weight_not_available')); ?>");
                    $('#weightList').hide();
                }

            if (data.volume) {
                $('#volumeText').hide();
                $('#volumeList').show();
                $('#volumeValue').text(data.volume);
            } else {
                    $('#volumeText').show().text("<?php echo e(__('messages.volume_not_available')); ?>");
                    $('#volumeList').hide();
                } 

            if (data.max_load) {
                $('#maxLoadText').hide();
                $('#maxLoadList').show();
                $('#maxLoadValue').text(data.max_load);
            } else {
                    $('#maxLoadText').show().text("<?php echo e(__('messages.max_load_not_available')); ?>");
                    $('#maxLoadList').hide();
                } 
        } else {
            $('#dimensionsText').show().text("<?php echo e(__('messages.product_details_not_available')); ?>");
            $('#dimensionsList').hide();
            $('#weightText').show().text("<?php echo e(__('messages.product_details_not_available')); ?>");
            $('#weightList').hide();
            $('#volumeText').show().text("<?php echo e(__('messages.product_details_not_available')); ?>");
            $('#volumeList').hide();
            $('#maxLoadText').show().text("<?php echo e(__('messages.product_details_not_available')); ?>");
            $('#maxLoadList').hide();
        }
            }).fail(function() {
            $('#dimensionsText').show().text("<?php echo e(__('messages.error_loading_product_details')); ?>");
            $('#weightText').show().text("<?php echo e(__('messages.error_loading_product_details')); ?>");
            $('#volumeText').show().text("<?php echo e(__('messages.error_loading_product_details')); ?>");
            $('#maxLoadText').show().text("<?php echo e(__('messages.error_loading_product_details')); ?>");
        });

});

$('.roof-name-detail').hide();
$('#roof-types-container').hide();
    const dailyPrices = <?php echo json_encode($dailyPrices, 15, 512) ?>;
    const roofRackPrices = <?php echo json_encode($roofRackPrices, 15, 512) ?>; 
    const insuranceFlatFee = 25.00;
  

    function calculateRent() {
        // const from = new Date($('#rental_from').val());
        // const to = new Date($('#rental_to').val());


        const from = parseDMY($('#rental_from').val());
        const to = parseDMY($('#rental_to').val());

        if (isNaN(from) || isNaN(to) || to < from) return;

        const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

        let totalRent = 0;

        for (let i = 0; i < days && i < dailyPrices.length; i++) {
            totalRent += dailyPrices[i];

            if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                console.log('totalRent', totalRent)
                totalRent += roofRackPrices[i];
            }
        }

        if ($('#insurance_checkbox').is(':checked')) {
            totalRent += insuranceFlatFee;
            $('#withinsurance').removeClass('d-none');
            $('#withoutinsurance').addClass('d-none');
        }else{
            $('#withoutinsurance').removeClass('d-none');
            $('#withinsurance').addClass('d-none');
        }

        $('.inner-number-days span:first').text(days);
        $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
    }

    $('#rental_from, #rental_to').on('change', calculateRent);


</script>

<script>
    $('#insurance_checkbox').on('change', function () {
        $('#insurance_selected').val(this.checked ? 1 : 0);
    });

    $('#roof_rack_checkbox').on('change', function () {
        $('#roof_rack_selected').val(this.checked ? 1 : 0);
    });



    $(document).ready(function() {

        $('#roof_rack_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#insurance_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#rentCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', true).trigger('change');
            $('#notCarrier').modal('hide');
        });

        $('#bringOwnCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', false);
            $('#notCarrier').modal('hide');
            calculateRent(); 
        });

        $('#wantInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', true).trigger('change');
            $('#notInsurance').modal('hide');
        });

        $('#noInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', false);
            $('#notInsurance').modal('hide');
            calculateRent(); 
        });
    function validateForm() {
        let isValid = true;

        // Reset all error states
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        // Validate required fields
        if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), "<?php echo e(__('messages.enter_manufacturer')); ?>");

            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), "<?php echo e(__('messages.enter_year')); ?>");

            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), "<?php echo e(__('messages.enter_model')); ?>");

            isValid = false;
        }
        
        // Trailer hitch validation
        const productName = $('#trailer_hitch').data('product-name');
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
        if (hitchRequired && !$('#trailer_hitch').val()) {
            showError($('#trailer_hitch'), "<?php echo e(__('messages.select_trailer_hitch')); ?>");
            isValid = false;
        }
        
       
        
       
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), "<?php echo e(__('messages.enter_start_date')); ?>");
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), "<?php echo e(__('messages.enter_end_date')); ?>");
            isValid = false;
        } 
        
        if ($('#rental_from').val() && $('#rental_to').val()) {
            

            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());
            if (to < from) {
                showError($('#rental_to'), "<?php echo e(__('messages.end_date_after_start')); ?>");
                isValid = false;
            }
        }

        if($('#errorMessage').text()){
            isValid = false;
        }
        
        return isValid;
    }

    function showError(element, message) {
        element.addClass('is-invalid');
        if (element.is('select')) {
            element.parent().append(`<div class="invalid-feedback">${message}</div>`);
        } else {
            element.after(`<div class="invalid-feedback">${message}</div>`);
        }
    }

    $('#manufacturer, #year, #model, #trailer_hitch, #rental_from, #rental_to').on('input change', function() {
        $(this).removeClass('is-invalid');
        $(this).next('.invalid-feedback').remove();
        $(this).parent().find('.invalid-feedback').remove();
    });
    $('.inner-size-card').on('click', function() {
        $('.invalid-feedback.d-block').remove();
    });


    $('#requestButton').click(function() {
        populateRequestForm();
    });

    $('#submitRequest').click(function() {
        const $btn = $(this); // reference to the button

        $btn.prop('disabled', true).text('Submitting...');
        let isValid = true;
        $('#requestForm .is-invalid').removeClass('is-invalid');

        function showError(id) {
            $(`#${id}`).addClass('is-invalid');
            isValid = false;
        }
    const formData = {
        title : $('#title').val(),
        first_name : $('#first_name').val(),
        last_name : $('#last_name').val(),
        street : $('#street').val(),
        zipcode : $('#zipcode').val(),
        city : $('#city').val(),
        email: $('#requestEmail').val(),
        state : $('#state').val(),
        country_code :$('#country_code').val(),
        phone: $('#requestPhone').val(),
        message: $('#requestMessage').val(),
        product_id: $('#requestProductId').val(),
        product_name: $('#requestProductName').val(),
        rental_from: $('#requestRentalFrom').val(),
        rental_to: $('#requestRentalTo').val(),
        manufacturer: $('#manufacturer').val(),
        car_model: $('#model').val(),
        car_year: $('#year').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: $('#requestRoofType').val(),
        carrier_length: $('#requestCarrierLength').val(),
        foot_sku: $('#requestFootSku').val(),
        footkit_sku: $('#requestFootkitSku').val(),
        unavailable_components: $('#requestUnavailableComponents').val(),
        pickup_location : $('#vendor_select option:selected').text(),
        _token: $('meta[name="csrf-token"]').attr('content')
    };
    
    if (!formData.title) showError('title');
        if (!formData.first_name) showError('first_name');
        if (!formData.last_name) showError('last_name');
        if (!formData.email) showError('requestEmail');
        if (!formData.phone) showError('requestPhone');
        if (!formData.street) showError('street');
        if (!formData.zipcode) showError('zipcode');
        if (!formData.city) showError('city');
        if (!formData.state) showError('state');
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (formData.email && !emailPattern.test(formData.email)) showError('requestEmail');
        if (!isValid) {
            $btn.prop('disabled', false).text('Submit');
            return;
        }
    
    $.post(`${baseUrl}/product/request`, formData, function(response) {
        if (response.success) {
            $('#requestModal').modal('hide');
            
            $('#requestForm')[0].reset();
            $('#requestSuccessful').modal('show');
        } else {
            alert('There was an error submitting your request. Please try again.');
        }
    }).fail(function() {
        alert('There was an error submitting your request. Please try again.');
    }).always(function() {
        $btn.prop('disabled', false).text('Submit');
    });
});

    $('#bookingForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        <?php if(auth()->guard()->check()): ?>
        if (validateForm()) {
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                booking_item_ids: $('#booking_item_ids').val() || '',

                bundle_name: selectedRecommendation?.bundle_name || '',
                
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
            };

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        for (const field in errors) {
                            showError($(`#${field}`), errors[field][0]);
                        }
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
        }
        <?php else: ?>
            if(validateForm()){
                e.preventDefault();
                $('#guestOptionsModal').modal('show');

            }
        <?php endif; ?>
    });

    $('#continueAsGuest').click(function() {
        const name = $('#firstname').val().trim();
        const surname = $('#surname').val().trim();
        const email = $('#firstemail').val().trim();
        const number = $('#number').val();

      let isValid = true;

      $('#firstname, #surname, #firstemail,#number').removeClass('is-invalid');

      if (name === '') {
        $('#firstname').addClass('is-invalid');
        isValid = false;
      }

      
      if (surname === '') {
        $('#surname').addClass('is-invalid');
        isValid = false;
      }

      if(number === ''){
        $('#number').addClass('is-invalid');
        isValid = false;
      }

      const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (email === '' || !emailPattern.test(email)) {
        $('#firstemail').addClass('is-invalid');
        isValid = false;
      }

      if (isValid) {
      
        // $('#guestModal').modal('hide');

      }
        // $('#guestModal').modal('hide');
        let rentalFromStr = $('#rental_from').val();
        let rentalToStr = $('#rental_to').val();

        let rentalFrom = parseDMY(rentalFromStr);
        let rentalTo = parseDMY(rentalToStr);

        let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
        let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
        let formData = {
                is_guest: 1,
                name: $('#firstname').val(),
                surname: $('#surname').val(),
                email: $('#firstemail').val(),
                number : $('#number').val(),
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                booking_item_ids: $('#booking_item_ids').val() || '',

                bundle_name: selectedRecommendation?.bundle_name || '',                
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
            };
        $.ajax({
            url: "<?php echo e(route('cart.add')); ?>",
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if(response.status ==  false){
                    $('#guestError')
                .removeClass('d-none')
                .text(response.message || 'Something went wrong. Please try again.');
                }else{
                    $('#guestModal').modal('hide');
                    $('#guestError').addClass('d-none');
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                }
             
            }
        });
    });
});
</script>
<script>

    $(function () {
         $.datepicker.regional['de'] = {
            closeText: 'Schließen',
            prevText: 'Zurück',
            nextText: 'Weiter',
            currentText: 'Heute',
            monthNames: ['Januar','Februar','März','April','Mai','Juni',
                'Juli','August','September','Oktober','November','Dezember'],
            monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
                'Jul','Aug','Sep','Okt','Nov','Dez'],
            dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
            dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa'],
            weekHeader: 'KW',
            dateFormat: 'dd.mm.yy',
            firstDay: 1,
            isRTL: false,
        };
        $.datepicker.setDefaults($.datepicker.regional['de']);
              let holidaysRaw = <?php echo json_encode($holidays, 15, 512) ?>;
        let holidays = Array.isArray(holidaysRaw) ? holidaysRaw : Object.values(holidaysRaw);        console.log(holidays);
        let nonworkingDays = <?php echo json_encode($nonworkingDays, 15, 512) ?>; 
        let dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

        let closedDays = nonworkingDays.map(day => dayMap[day]);
        function disableWeekendsAndHolidays(date) {
            let day = date.getDay();
            let formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            let isWeekend = closedDays.includes(day);
            let isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        function initDatePickers() {
            $("#rental_from, #rental_to").datepicker("destroy"); // reset old pickers

            $("#rental_from").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    const productName = $('#trailer_hitch').data('product-name');
                    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
                    if (!selectedRecommendation && !hitchRequired) {
                            const modal = new bootstrap.Modal(document.getElementById('railingType'));
                            modal.show();
                       
                        $(this).val(''); 
                        return ;
                    } 
                   
                        checkAvailability();
                    
                    calculateRent();
                }
            });

            $("#rental_to").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                   
                        checkAvailability();
                   
                    calculateRent();
                }
            });
        }

    
        initDatePickers();

   
   


        $('#vendor_select').on('change', function () {


            let vendorId = $(this).val();
            $.ajax({
                url: "<?php echo e(route('vendor.calendar.data')); ?>",
                type: 'GET',
                data: { vendor_id: vendorId },
                success: function (response) {
                    holidays = response.holidays;
                    nonworkingDays = response.nonworkingDays;
                    closedDays = nonworkingDays.map(day => dayMap[day]);
                    initDatePickers();
                }
            });
        });
    });
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });



</script>

<style>

.clickable-roof {
    border: 2px solid transparent;
    cursor: pointer;
    transition: 0.2s;
}
.clickable-roof:hover {
    border-color: #007bff;
}
.clickable-roof.selected {
    border-color: #007bff;
    background-color: #e9f5ff;
}

</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/pages/product/roof_rack_detail.blade.php ENDPATH**/ ?>