<!-- Rental Price Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3><?php echo e(__('messages.our_rental_price')); ?></h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th><?php echo e(__('messages.days')); ?></th>
                                <th><?php echo e(__('messages.price')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $dailyPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__('messages.day_label', ['number' => $index + 1])); ?></td>
                                    <td><?php echo e(number_format($price, 2, ',', '.')); ?> €</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-not-book" id="railingType" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel"><?php echo e(__('messages.attention')); ?></h5>
                <p><?php echo e(__('messages.please_check_railing_type')); ?></p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal"><?php echo e(__('messages.ok')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel"><?php echo e(__('messages.not_bookable_title')); ?></h5>
                <p><?php echo e(__('messages.not_bookable_message')); ?></p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal"><?php echo e(__('messages.ok')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier"><?php echo e(__('messages.carrier_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.carrier_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn"><?php echo e(__('messages.rent_carrier')); ?></button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn"><?php echo e(__('messages.bring_own_carrier')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance"><?php echo e(__('messages.insurance_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.insurance_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn"><?php echo e(__('messages.yes_insure_me')); ?></button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn"><?php echo e(__('messages.no_insurance')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title modal-guest"><?php echo e(__('messages.login_modal_title')); ?></h5>
                <a href="javascript:void(0);" class="w-100 btn primary-btn" onclick="saveFormDataAndRedirectRoofRack('/dachboxmiete-phase-2/public/login')">
                    <?php echo e(__('messages.login')); ?>

                </a>
                <div class="">
                    <div class="dont-acount">
                        <p><?php echo e(__('messages.dont_have_account')); ?></p>
                    </div>
                    <a href="javascript:void(0);" class="w-100 btn primary-outline-btn" onclick="saveFormDataAndRedirectRoofRack('/dachboxmiete-phase-2/public/registration')">
                        <?php echo e(__('messages.create_account')); ?>

                    </a>
                </div>
                <div class="dont-acount">
                    <p><?php echo e(__('messages.or')); ?></p>
                </div>
                <button class="w-100 btn primary-outline-btn" data-bs-target="#guestModal" data-bs-toggle="modal">
                    <?php echo e(__('messages.continue_with_guest')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2"><?php echo e(__('messages.guest_title')); ?></h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label"><?php echo e(__('messages.surname')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_surname')); ?>" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label"><?php echo e(__('messages.phone_number')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_phone_number')); ?>" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label"><?php echo e(__('messages.email')); ?></label>
                            <input type="email" class="form-control" placeholder="<?php echo e(__('messages.enter_email')); ?>" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn  primary-outline-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        <?php echo e(__('messages.back')); ?>

                    </button>
                    <button class="btn primary-btn" id="continueAsGuest">
                        <?php echo e(__('messages.continue')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="requestModal" tabindex="-1" aria-labelledby="requestModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="requestModalLabel"><?php echo e(__('messages.product_request')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(__('messages.request_modal_message')); ?></p>
                
                <!-- Display selected product details -->
                <div class="selected-product-details mb-4 p-3 border rounded">
                    <h6><?php echo e(__('messages.product_details')); ?></h6>
                    <div id="requestProductDetails">
                        <!-- Will be populated by JavaScript -->
                    </div>
                </div>
                
                <form id="requestForm">
                    <div class="form-full">
                    <div class="col-md-6">
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                                <label class="form-label"><?php echo e(__('messages.title')); ?></label>
                                <select class="form-select" name="title" id="title">
                                    <option value="">Select</option>
                                    <option value="Mr." <?php echo e(old('title') == 'Mr.' ? 'selected' : ''); ?>>Mr.</option>
                                    <option value="Mrs." <?php echo e(old('title') == 'Mrs.' ? 'selected' : ''); ?>>Mrs.</option>
                                    <option value="Miss" <?php echo e(old('title') == 'Miss' ? 'selected' : ''); ?>>Miss</option>
                                </select>
                                <div class="invalid-feedback"><?php echo e(__('messages.select_title_error')); ?></div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                                <input type="text" class="form-control" name="first_name" id="first_name" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" value="<?php echo e(old('first_name')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.first_name_error')); ?></div>
                            </div>
                        </div>
                    </div>
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.last_name')); ?></label>
                            <input type="text" class="form-control" name="last_name" id="last_name" placeholder="<?php echo e(__('messages.enter_surname')); ?>" value="<?php echo e(old('last_name')); ?>">
                            <div class="invalid-feedback"><?php echo e(__('messages.last_name_error')); ?></div>
                        </div>
                    </div>
                </div>
                    
                <div class="form-full">
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.email')); ?></label>
                            <input type="email" class="form-control" name="email" id="requestEmail" placeholder="<?php echo e(__('messages.email')); ?>" value="<?php echo e(old('email')); ?>">
                            <div class="invalid-feedback"><?php echo e(__('messages.email_error')); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label"><?php echo e(__('messages.country_code')); ?></label>
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                               
                                
                                <select name="country_code" class="form-select country_code_custom" id="country_code">
                                    <option value="+49" data-image="https://flagcdn.com/16x12/de.png" <?php echo e(old('country_code') == '+49' ? 'selected' : ''); ?>>+49</option>
                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e(old('country_code') == '+43' ? 'selected' : ''); ?>>+93</option>
                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  <?php echo e(old('country_code') == '+41' ? 'selected' : ''); ?>>+41</option>
                                </select>
                                <div class="invalid-feedback"><?php echo e(__('messages.select_country_code_error')); ?></div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <input type="text" class="form-control" name="contact_number" id="requestPhone" placeholder="<?php echo e(__('messages.phone_placeholder')); ?>" value="<?php echo e(old('contact_number')); ?>">
                                <div class="invalid-feedback"><?php echo e(__('messages.phone_error')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label"><?php echo e(__('messages.street')); ?></label>
                        <input type="text" class="form-control" name="street" id="street" placeholder="<?php echo e(__('messages.enter_address')); ?>" value="<?php echo e(old('street')); ?>">
                        <div class="invalid-feedback"><?php echo e(__('messages.street_error')); ?></div>
                    </div>
                </div>
                <div class="form-full">
                <div class="col-md-6">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label"><?php echo e(__('messages.zip_code')); ?></label>
                        <input type="text" class="form-control" name="zipcode" id="zipcode" placeholder="<?php echo e(__('messages.enter_zip_code')); ?>" value="<?php echo e(old('zipcode')); ?>">
                        <div class="invalid-feedback"><?php echo e(__('messages.zip_code_error')); ?></div>
                    </div>
                </div>
                    
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.city')); ?></label>
                            <input type="text" class="form-control" name="city" id="city" placeholder="<?php echo e(__('messages.enter_city')); ?>" value="<?php echo e(old('city')); ?>">
                            <div class="invalid-feedback"><?php echo e(__('messages.city_error')); ?></div>
                        </div>
                    </div>
                </div>
                    
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label"><?php echo e(__('messages.state_region')); ?></label>
                            <select class="form-select" name="state" id="state">
                                <option value=""><?php echo e(__('messages.select_state')); ?></option>
                                <option value="Baden-Württemberg" <?php echo e(old('state') == 'Baden-Württemberg' ? 'selected' : ''); ?>>Baden-Württemberg</option>
                                <option value="Bavaria" <?php echo e(old('state') == 'Bavaria' ? 'selected' : ''); ?>>Bavaria</option>
                                <option value="Berlin" <?php echo e(old('state') == 'Berlin' ? 'selected' : ''); ?>>Berlin</option>
                                <option value="Brandenburg" <?php echo e(old('state') == 'Brandenburg' ? 'selected' : ''); ?>>Brandenburg</option>
                                <option value="Bremen" <?php echo e(old('state') == 'Bremen' ? 'selected' : ''); ?>>Bremen</option>
                                <option value="Hamburg" <?php echo e(old('state') == 'Hamburg' ? 'selected' : ''); ?>>Hamburg</option>
                                <option value="Hesse" <?php echo e(old('state') == 'Hesse' ? 'selected' : ''); ?>>Hesse</option>
                                <option value="Lower Saxony" <?php echo e(old('state') == 'Lower Saxony' ? 'selected' : ''); ?>>Lower Saxony</option>
                                <option value="Mecklenburg-Vorpommern" <?php echo e(old('state') == 'Mecklenburg-Vorpommern' ? 'selected' : ''); ?>>Mecklenburg-Vorpommern</option>
                                <option value="North Rhine-Westphalia" <?php echo e(old('state') == 'North Rhine-Westphalia' ? 'selected' : ''); ?>>North Rhine-Westphalia</option>
                                <option value="Rhineland-Palatinate" <?php echo e(old('state') == 'Rhineland-Palatinate' ? 'selected' : ''); ?>>Rhineland-Palatinate</option>
                                <option value="Saarland" <?php echo e(old('state') == 'Saarland' ? 'selected' : ''); ?>>Saarland</option>
                                <option value="Saxony" <?php echo e(old('state') == 'Saxony' ? 'selected' : ''); ?>>Saxony</option>
                                <option value="Saxony-Anhalt" <?php echo e(old('state') == 'Saxony-Anhalt' ? 'selected' : ''); ?>>Saxony-Anhalt</option>
                                <option value="Schleswig-Holstein" <?php echo e(old('state') == 'Schleswig-Holstein' ? 'selected' : ''); ?>>Schleswig-Holstein</option>
                                <option value="Thuringia" <?php echo e(old('state') == 'Thuringia' ? 'selected' : ''); ?>>Thuringia</option>
                            </select>
                            <div class="invalid-feedback"><?php echo e(__('messages.state_error')); ?></div>

                            
                        </div>
                    </div>
                
                 
                
                    

                    <div class="mb-3">
                        <label for="requestMessage" class="form-label"><?php echo e(__('messages.message')); ?></label>
                        <textarea class="form-control" id="requestMessage" rows="3" placeholder="<?php echo e(__('messages.specific_requirements')); ?>"></textarea>
                    </div>
                    
                    <!-- Hidden fields to store product information -->
                    <input type="hidden" id="requestProductId">
                    <input type="hidden" id="requestProductName">
                    <input type="hidden" id="requestColorId">
                    <input type="hidden" id="requestColorName">
                    <input type="hidden" id="requestSizeId">
                    <input type="hidden" id="requestSizeName">
                    <input type="hidden" id="requestVariationId">
                    <input type="hidden" id="requestVariationName">
                    <input type="hidden" id="requestRentalFrom">
                    <input type="hidden" id="requestRentalTo">
                    <input type="hidden" id="requestCarrierLength">
                    <input type="hidden" id="requestFootSku">
                    <input type="hidden" id="requestFootkitSku">
                    <input type="hidden" id="requestRoofType">
                    <input type="hidden" id="requestUnavailableComponents">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn  primary-outline-btn" data-bs-dismiss="modal"><?php echo e(__('messages.cancel')); ?></button>
                <button type="button" class="btn primary-btn" id="submitRequest"><?php echo e(__('messages.submit_request')); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-not-book" id="requestSuccessful" tabindex="-1" aria-labelledby="requestSuccessful" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <h5 class="modal-title" id="requestSuccessful"><?php echo e(__('messages.thank_you')); ?></h5>
                <p><?php echo e(__('messages.thank_you_message')); ?></p>
                <button type="button" class="btn primary-btn" id="okayBtn"><?php echo e(__('messages.okay')); ?></button>
            </div>
        </div>
    </div>
</div><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/pages/product/partials/roofRackModal.blade.php ENDPATH**/ ?>