<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Revenue Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 9px; }
        table { width: 100%; border-collapse: collapse; table-layout: fixed; }
        th, td { border: 1px solid #000; padding: 4px; text-align: left; word-wrap: break-word; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Revenue Report</h2>
    <p>From: <?php echo e($fromDate ?? 'Start'); ?> To: <?php echo e($toDate ?? 'End'); ?></p>

    <table>
        <thead>
            <tr>
                <?php $__currentLoopData = (new \App\Exports\RevenueReportExport())->headings(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $heading): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($heading); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $item = $booking->items->first();
                $user = $booking->userDetails;
            
                $taxRate = 0.19;
                $insuranceFlatRate = 25.0;
            
                // --- Insurance calculations ---
                $insuranceNet = 0;
                $insuranceTax = 0;
                if ($item->is_insured) {
                    $insuranceNet = $insuranceFlatRate / (1 + $taxRate);
                    $insuranceTax = $insuranceFlatRate - $insuranceNet;
                }
            
                // --- Rent part calculations ---
                $taxableAmount = $item->is_insured ? $item->calculated_rent - $insuranceFlatRate : $item->calculated_rent;
            
                // Apply discount proportionally to the rental part
                $totalRentalGrossBeforeDiscount = $taxableAmount;
                $discountAmount = $booking->discount; // assume discount applies to rental only
                $itemRentalGrossAfterDiscount = max($taxableAmount - $discountAmount, 0);
            
                // Calculate net and tax
                $net = $itemRentalGrossAfterDiscount / (1 + $taxRate);
                $tax = $itemRentalGrossAfterDiscount - $net;
            
                // --- Final totals ---
                $subtotal = $net + $tax; // subtotal of rental part
                $total = $subtotal + $insuranceNet + $insuranceTax; // add insurance net/tax

                $newDropOffDate = optional($booking->new_dropoff_date ? \Carbon\Carbon::parse($booking->new_dropoff_date) : null)->format('d.m.Y');

                $newPickupTime = optional($item->new_dropoff_time ? \Carbon\Carbon::parse($item->new_dropoff_time) : null)->format('H:i');
            
            ?>
            
                <tr>
                    <td><?php echo e($booking->id); ?></td>
                    <td><?php echo e($booking->created_at->format('d.m.Y')); ?></td>
                    <td><?php echo e($user->first_name ?? ''); ?> <?php echo e($user->last_name ?? ''); ?></td>
                    <td><?php echo e($user->address ?? ''); ?>, <?php echo e($user->zip ?? ''); ?>, <?php echo e($user->city ?? ''); ?>, <?php echo e($user->country ?? ''); ?></td>
                    <td><?php echo e($user->email ?? ''); ?></td>
                    <td><?php echo e($user->phone ?? ''); ?></td>
                    <td><?php echo e($item->car_name ?? ''); ?></td>
                    <td><?php echo e($item->model ?? ''); ?></td>
                    <td><?php echo e($item->car_year ?? ''); ?></td>
                    <td><?php echo e($item->roof_type ?? ''); ?></td>
                    <td><?php echo e($item->trailer_hitch ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e($item->days); ?> days</td>
                    <?php
                        $pickupDateTime = \Carbon\Carbon::parse($item->pickup_date->format('Y-m-d') . ' ' . $item->pickup_time);
                        $dropoffDateTime = \Carbon\Carbon::parse($item->dropoff_date->format('Y-m-d') . ' ' . $item->dropoff_time);
                    ?>
                    <td><?php echo e($pickupDateTime->format('d.m.Y H:i')); ?></td>
                    <td><?php echo e($dropoffDateTime->format('d.m.Y H:i')); ?></td>              
                    <td><?php echo e($item->product_name ?? ''); ?></td>
                    <td><?php echo e($item->is_carrier_included ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e($item->is_insured ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e(number_format($booking->subtotal, 2 , ',' , '.')); ?></td>
                    <td><?php echo e(number_format($booking->discount, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($insuranceNet, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($net, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($tax + $insuranceTax, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($total, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($booking->refund_amount, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($booking->delay_fees, 2, ',' , '.')); ?></td>
                    <td><?php echo e(number_format($booking->additional_days_rent, 2, ',' , '.')); ?></td>
                    <td><?php echo e($booking->status == 'cancelled' ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e($item->damage ? 'Yes': 'No'); ?></td>
                    <td><?php echo e($item->delay  ? 'Yes' : 'No'); ?></td>
                    <td><?php echo e($item->additional_days); ?> </td>
                    <td><?php echo e($newDropOffDate); ?> </td>
                    <td><?php echo e($newPickupTime); ?> </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/report/revenue_pdf.blade.php ENDPATH**/ ?>