<?php $__env->startSection('content'); ?>
<style>
    .working-hours-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    .working-hours-table th, 
    .working-hours-table td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }
    .working-hours-table th {
        background-color: #f8f9fa;
        font-weight: 600;
    }
    .closed-day {
        color: #dc3545;
        font-weight: 500;
    }
    .holiday-list {
        margin-top: 20px;
    }
    .holiday-item {
        display: flex;
        justify-content: space-between;
        padding: 10px 15px;
        border-bottom: 1px solid #eee;
        align-items: center;
    }
    .holiday-name {
        font-weight: 500;
    }
    .holiday-date {
        color: #6c757d;
    }
    .profile-image-container {
        width: 150px;
        height: 150px;
        border-radius: 50%;
        overflow: hidden;
        margin-bottom: 20px;
        border: 3px solid #f1f1f1;
    }
    .profile-image-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .detail-section {
        margin-bottom: 30px;
        padding-bottom: 20px;
        border-bottom: 1px solid #eee;
    }
    .detail-section h2 {
        margin-bottom: 20px;
        color: #333;
        font-weight: 600;
    }
    .detail-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
    }
    .detail-item {
        margin-bottom: 15px;
    }
    .detail-item h5 {
        font-size: 14px;
        color: #6c757d;
        margin-bottom: 5px;
    }
    .detail-item p {
        font-size: 16px;
        color: #333;
        font-weight: 500;
    }
    .status-active {
        color: #28a745;
        font-weight: 500;
    }
    .status-inactive {
        color: #dc3545;
        font-weight: 500;
    }
</style>

<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('admin.spo.index')); ?>">SPO Management</a>
            <a class="active">View SPO</a>
        </div>
    </div>
    
    <div class="add-user-form sora-font">
        <div class="main-show-detail-viwe">
            <!-- Profile Section -->
            <div class="detail-section">
                <h2>Profile Information</h2>
                <div class="d-flex align-items-center gap-4">
                    <div class="profile-image-container">
                        <img src="<?php echo e($vendor->profile_image ? asset('storage/' . $vendor->profile_image) : ''); ?>" alt="">
                    </div>
                    <div class="user-data">
                        <div class="spo-name">
                            <h2>SPO Name</h2>
                            <h4><?php echo e(ucfirst($vendor->title)); ?>. <?php echo e($vendor->first_name); ?> <?php echo e($vendor->last_name); ?></h4>
                        </div>
                        <div class="spo-id">
                            <h2>SPO ID</h2>
                            <h4>#<?php echo e($vendor->id); ?></h4>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Basic Information -->
            

            
            
            <!-- Contact Information -->
            <div class="detail-section">
                <h2>Address</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <h5>Street, House Number</h5>
                        <p><?php echo e($vendor->street ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Zip Code</h5>
                        <p><?php echo e($vendor->zip_code ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>City</h5>
                        <p><?php echo e($vendor->city ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Country</h5>
                        <p><?php echo e($vendor->country ?? 'Germany'); ?></p>
                    </div>
                </div>
            </div>

            <div class="detail-section">
                <h2>SPO Details</h2>
                <div class="detail-grid">

                    <div class="detail-item">
                        <h5>Email Address</h5>
                        <p><?php echo e($vendor->email ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Phone Number</h5>
                        <p><?php echo e(($vendor->country_code ?? '') . ' ' . ($vendor->number ?? 'N/A')); ?></p>
                    </div>
                </div>
            </div>

           
            
            
            <!-- Business Information -->
            <div class="detail-section">
                <h2>Business Information</h2>
                <div class="detail-grid">
                     <div class="detail-item">
                        <h5>New In Business</h5>
                        <p><?php echo e($vendor->new_in_business ? 'Yes' : 'No'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Business Type</h5>
                          <p>
                            <?php echo e($vendor->business_type ? __('messages.' . $vendor->business_type) : 'N/A'); ?>

                        </p>
                    </div>
                    <div class="detail-item">
                        <h5>Business Model</h5>
                        <p><?php echo e($vendor->business_model ? __('messages.' . $vendor->business_model) :  'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Contact Type</h5>
                        <p><?php echo e($vendor->contact_person  ? __('messages.' . $vendor->contact_person) :  'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Size of Location</h5>
                        <p><?php echo e($vendor->size_of_location ? __('messages.' . $vendor->size_of_location) :  'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Status</h5>
                        <p class="
                            <?php if($vendor->status === 'active'): ?> status-active
                            <?php elseif($vendor->status === 'inactive'): ?> status-inactive
                            <?php elseif($vendor->status === 'closed'): ?> status-closed
                            <?php else: ?> '' <?php endif; ?>
                        ">
                            <?php echo e(ucfirst($vendor->status)); ?>

                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-12 mt-3 detail-section">
                <h2 class="mb-5">Conditions:</h2>
                <table class="table table-bordered" id="existingCommissionTable">
                    <thead>
                        <tr>
                            <th>Sales Tier</th>
                            
                            <th>Commission %</th>
                            <th>Shop Fee </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($vendor->commission_rate) && is_array($vendor->commission_rate)): ?>
                            <?php $__currentLoopData = $vendor->commission_rate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $range => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $parts = explode('-', $range);
                                $from = $parts[0];
                                $to = $parts[1] ?? 'Above';
                                $commission = $data['commission'] ?? '';
                                $shop_fee = $data['shop_fee'] ?? '';
                            ?>
                               <tr>
                                    <td><?php echo e(number_format($from, 2, ',', '.')); ?>€ - <?php echo e(number_format($to, 2, ',', '.')); ?>€</td>
                                    <td><?php echo e($commission); ?>%</td>
                                    <td><?php echo e(number_format($shop_fee, 2, ',', '.')); ?>€</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Tax & Banking Information -->
            <div class="detail-section">
                <h2>Bank Details</h2>
                <div class="detail-grid">
                    
                    <div class="detail-item">
                        <h5>Bank Name</h5>
                        <p><?php echo e($vendor->bank_name ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Bank Account Number</h5>
                        <p><?php echo e($vendor->account_number ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>IBAN Number</h5>
                        <p><?php echo e($vendor->iban_number ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Bank Account Owner</h5>
                        <p><?php echo e($vendor->account_owner ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>BIC Number</h5>
                        <p><?php echo e($vendor->bic_number ?? 'N/A'); ?></p>
                    </div>
                    
                   
                </div>
            </div>

            <div class="detail-section">
                <h2>Tax Related Information</h2>
                <div class="detail-grid">
                    <div class="detail-item">
                        <h5>Tax Number</h5>
                        <p><?php echo e($vendor->tax_number ?? 'N/A'); ?></p>
                    </div>
                    <div class="detail-item">
                        <h5>Tax ID (UMSt.-ID)</h5>
                        <p><?php echo e($vendor->tax_id ?? 'N/A'); ?></p>
                    </div>
                    
                   
                </div>
            </div>
            
            <!-- Working Hours -->
            <div class="detail-section">
                <h2>Working Hours</h2>
                <table class="working-hours-table">
                    <thead>
                        <tr>
                            <th>Day</th>
                            <th>Opening Time</th>
                            <th>Closing Time</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $days = [
                                'mo' => 'Monday',
                                'di' => 'Tuesday',
                                'mi' => 'Wednesday',
                                'do' => 'Thursday',
                                'fr' => 'Friday',
                                'sa' => 'Saturday',
                                'so' => 'Sunday'
                            ];
                        ?>
                        
                        <?php $__currentLoopData = $vendor->workingHours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workingHour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($days[$workingHour->day]); ?></td>
                                <td><?php echo e($workingHour->is_closed ? '-' : ($workingHour->open_time ? \Carbon\Carbon::parse($workingHour->open_time)->format('H:i') : '-')); ?></td>
                                <td><?php echo e($workingHour->is_closed ? '-' : ($workingHour->close_time ? \Carbon\Carbon::parse($workingHour->close_time)->format('H:i') : '-')); ?></td>
                                <td>
                                    <?php if($workingHour->is_closed): ?>
                                        <span class="closed-day">Closed</span>
                                    <?php else: ?>
                                        <span>Open</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Holidays/Absent Days -->
            <div class="detail-section">
                <h2>Holidays/Absent Days</h2>
                <?php if($vendor->holidays->count() > 0): ?>
                    <div class="holiday-list">
                        <?php $__currentLoopData = $vendor->holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="holiday-item">
                                <div>
                                    <span class="holiday-name"><?php echo e($holiday->name); ?></span>
                                    <span class="holiday-date ml-2">
                                        (<?php echo e(\Carbon\Carbon::parse($holiday->date)->format('d.m.Y')); ?>)
                                    </span>
                                </div>
                                <div>
                                    <?php
                                        $today = \Carbon\Carbon::today();
                                        $holidayDate = \Carbon\Carbon::parse($holiday->date);
                                        $daysLeft = $today->diffInDays($holidayDate, false);
                                    ?>
                                    
                                    <?php if($daysLeft > 0): ?>
                                        <span class="text-success">in <?php echo e($daysLeft); ?> days</span>
                                    <?php elseif($daysLeft === 0): ?>
                                        <span class="text-primary">Today</span>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(abs($daysLeft)); ?> days ago</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p>No holidays/absent days scheduled.</p>
                <?php endif; ?>
            </div>
            
            <div class="upper-main-btn-last-comn d-flex">
                <a href="<?php echo e(route('admin.spo.edit', $vendor)); ?>">
                    <button type="button" class="add-user">Edit SPO</button>
                </a>
                <a href="<?php echo e(route('admin.spo.index')); ?>">
                    <button type="button" class="cancel-btn">Back to List</button>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/spo/details.blade.php ENDPATH**/ ?>