<!DOCTYPE html>
<html>
<head>
    <title>Bundles Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Bundles Report</h1>
    <table>
        <thead>
            <tr>
                <th>Bundle ID</th>
                <th>Bundle Name</th>
                <th>Product Category</th>
                <th>Roof Type</th>
                <th>Carrier SKU</th>
                <th>Foot SKU</th>
                <th>FootKit SKU</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bundles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>#<?php echo e($bundle->id); ?></td>
                <td><?php echo e($bundle->bundle_name); ?></td>
                <td><?php echo e($bundle->category); ?></td>
                <td><?php echo e($bundle->rooftype_eng); ?></td>
                <td><?php echo e($bundle->carrier_length); ?></td>
                <td><?php echo e($bundle->foot_sku); ?></td>
                <td><?php echo e($bundle->footkit_sku); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/bundle/pdf.blade.php ENDPATH**/ ?>