<!DOCTYPE html>
<html>
<head>
    <title>Bookings Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Bookings Report</h1>
        <div class="filter-info">
            <strong>Time Filter:</strong> <?php echo e(ucfirst($timeFilter)); ?> |
            <strong>Status Filter:</strong> <?php echo e($statusFilter === 'all' ? 'All Statuses' : ucfirst($statusFilter)); ?>

        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Customer Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Rental Period</th>
                <th>Days</th>
                <th>Status</th>
                <th>Subtotal</th>
                <th>Tax</th>
                <th>Total</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>#<?php echo e($booking->id); ?></td>
                <td>
                    <?php if($booking->userDetails): ?>
                        <?php echo e($booking->userDetails->first_name); ?> <?php echo e($booking->userDetails->last_name); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($booking->userDetails): ?>
                        <?php echo e($booking->userDetails->phone); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($booking->userDetails): ?>
                        <?php echo e($booking->userDetails->email); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($booking->items->isNotEmpty()): ?>
                        <?php echo e($booking->items->first()->pickup_date->format('d.m.Y')); ?> - 
                        <?php echo e($booking->items->first()->dropoff_date->format('d.m.Y')); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($booking->items->isNotEmpty()): ?>
                        <?php echo e($booking->items->first()->days); ?> Days
                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
                <td><?php echo e(ucfirst($booking->status)); ?></td>
                <td><?php echo e(number_format($booking->subtotal, 2, ',', '.')); ?> €</td>
                <td><?php echo e(number_format($booking->tax, 2, ',', '.')); ?> €</td>
                <td><?php echo e(number_format($booking->total, 2, ',', '.')); ?> €</td>
                <td><?php echo e($booking->created_at->format('d.m.Y H:i')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/booking/pdf.blade.php ENDPATH**/ ?>