<?php $__env->startSection('content'); ?>
<style>
    .chart-wrap{
        height: 200px;
    }
    .ing-sec-acrd-dash {
    display: flex;
    align-items: center;
    gap: 15px;
}
.name-head {
    margin-bottom: 10px !important;
}
nav.navbar {
    margin-bottom: 0.7rem;
}
</style>
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>analytics</h2>
            <select class="form-select select-main-head" id="main-filter" aria-label="Default select example">
                <option value="year" selected>Year</option>
                <option value="month">Month</option>
                <option value="week">Week</option>
                <option value="day">Day</option>
            </select>

        </div>
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/dash1.png')); ?>" alt="">
                            </figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Rental Revenue</p>
                                    <h4>6.568 € </h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/white-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/dash2.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Number of Guest Customers</p>
                                    <h4>10</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/orange-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/dash3.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Cancellation Rate</p>
                                    <h4>3%</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/parot-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-pink">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="<?php echo e(asset('admin/images/dash4.png')); ?>" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>Number of Customers With Account</p>
                                    <h4>431</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="<?php echo e(asset('admin/images/pink-line.png')); ?>" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="graphs-all">
            <div class="row mb-4">
                <div class="col-md-7">
                    <div class="back-comn-graph">

                        <div class="name-head">
                            <h2>revenue Report </h2>
                            <select class="form-select select-main-head" id="revenue-filter">
                                <option value="year" selected>Year</option>
                                <option value="month">Month</option>
                                <option value="week">Week</option>
                                <option value="day">Day</option>
                            </select>
                        </div>
                        <div class="chart-wrap">

                            <canvas id="myChart1" style="height: 200px" height="200"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="back-comn-graph">
                        <div class="name-head">
                            <h2>Top Products</h2>
                        </div>
                        <div class="upper-graph-main">
                            <div class="chart-wrap">

                                <canvas id="myChart5"></canvas>
                            </div>
                        </div>
                    </div>
                </div>





            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="back-comn-graph">
                        <div class="name-head">
                            <h2>total revenue incl. tax</h2>
                        </div>
                        <div class="chart-wrap">

                            <canvas id="myChart2"></canvas>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="back-comn-graph">
                        <div class="name-head">
                            <h2>cancellation report</h2>
                        </div>
                        <div class="chart-wrap">

                            <canvas id="myChart3"></canvas>
                        </div>
                    </div>
                </div>


                <div class="col-md-3">
                    <div class="back-comn-graph">
                        <div class="name-head">
                            <h2>Payment method</h2>
                        </div>
                        <div class="chart-wrap">

                            <canvas id="myChart4"></canvas>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </div>
</div>
</div>
</div>
<script>
    
    var baseUrl = "<?php echo e(rtrim(config('app.url'), '/')); ?>";
let chartInstance;
let cardValues = {};
let currentFilter = 'year'; // Default filter

document.addEventListener("DOMContentLoaded", function () {
    loadAllData(currentFilter);
    loadChartData(currentFilter);
    document.getElementById("main-filter").addEventListener("change", function() {
        currentFilter = this.value;
        loadAllData(currentFilter);
    });
    
    document.getElementById('revenue-filter').addEventListener('change', function() {
        loadChartData(this.value);
    });
});

function loadAllData(filter) {
    fetch(`${baseUrl}/admin/dashboard-cards?type=${filter}`)
        .then(res => res.json())
        .then(data => {
            cardValues = data;
            updateCardsUI();
            
            loadRevenueBreakdown(filter);
            loadCancellationReport(filter);
            loadPaymentMethodBreakdown(filter);
            loadTopProductsChart(filter);
        });
}

function updateCardsUI() {
    const formattedRevenue = new Intl.NumberFormat('de-DE', {
        style: 'currency',
        currency: 'EUR',
        minimumFractionDigits: 2
    }).format(cardValues.rental_revenue);

    document.querySelector('.back-purple h4').textContent = formattedRevenue;
    document.querySelector('.back-yellow h4').textContent = `${cardValues.conversion_rate}`;
    document.querySelector('.back-parrot h4').textContent = `${cardValues.cancelation_rate}%`;
    document.querySelector('.back-pink h4').textContent = cardValues.total_customers;
}

function loadChartData(type = 'year') {
    const ctx = document.getElementById("myChart1").getContext("2d");
    
    fetch(`${baseUrl}/admin/revenue-chart-data?type=${type}`)
        .then(res => res.json())
        .then(data => {
            if (chartInstance) chartInstance.destroy();
            
            const gradient = ctx.createLinearGradient(0, 0, 0, 300);
            gradient.addColorStop(0, "#5bc0de6c");
            gradient.addColorStop(0.35, "#5bc0de2f");
            gradient.addColorStop(1, "#5bc0de00");

            chartInstance = new Chart(ctx, {
                type: "line",
                data: {
                    labels: data.labels,
                    datasets: [{
                        label: "Revenue",
                        fill: true,
                        backgroundColor: gradient,
                        pointBackgroundColor: "#5BC0DEAD",
                        borderColor: "#5BC0DEAD",
                        data: data.data,
                        tension: 0.2,
                        borderWidth: 2,
                        pointRadius: 2
                    }]
                },
                options: {
                    layout: { padding: 10 },
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false } },
                    scales: {
                        x: {
                            grid: { display: false },
                            ticks: { padding: 5, autoSkip: false, maxRotation: 0, minRotation: 0 }
                        },
                        y: {
                            grid: { display: true, color: "rgba(80, 102, 120, 0.25)" },
                            ticks: { beginAtZero: false, suggestedMin: 0, padding: 10 }
                        }
                    }
                }
            });
        });
}
const formatEuro = (value) => {
    return new Intl.NumberFormat('de-DE', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2,
    }).format(value) + ' €';
};

// Revenue Breakdown Chart
function loadRevenueBreakdown(filter) {
    fetch(`${baseUrl}/admin/revenue-breakdown?type=${filter}`)
        .then(res => res.json())
        .then(data => {
            const ctx = document.getElementById('myChart2').getContext('2d');
            
            if (window.revenueBreakdownChart) {
                window.revenueBreakdownChart.destroy();
            }
            
            window.revenueBreakdownChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ["Tax", "Rental"],
                    datasets: [{
                        data: [data.tax, data.rental],
                        backgroundColor: ['#9B6EF3', '#55C1D8'],
                        borderWidth: 3,
                        borderRadius: 50,
                    }]
                },
                options: {
                    responsive: true,
                    cutout: '75%',
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'right',
                            labels: {
                                color: '#666666',
                                textAlign: 'left',
                                font: { size: 13 },
                                usePointStyle: true,
                                pointStyle: 'circle',
                                generateLabels: function (chart) {
                                    const dataset = chart.data.datasets[0];
                                    return chart.data.labels.map((label, i) => ({
                                        text: `${label}: ${formatEuro(dataset.data[i])}`,
                                        fillStyle: 'transparent',
                                        strokeStyle: dataset.backgroundColor[i],
                                        borderWidth: 4,
                                        pointStyle: 'circle',
                                        hidden: false,
                                        index: i
                                    }));
                                }
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: (tooltipItem) => {
                                    const value = tooltipItem.raw;
                                    return `${tooltipItem.label}: ${formatEuro(value)}`;
                                }
                            }
                        }
                    }
                }
            });

        });
}

// Cancellation Report Chart
function loadCancellationReport(filter) {
    fetch(`${baseUrl}/admin/cancellation-report?type=${filter}`)
        .then(res => res.json())
        .then(data => {
            const ctx = document.getElementById('myChart3').getContext('2d');
            
            // Destroy existing chart if it exists
            if (window.cancellationChart) {
                window.cancellationChart.destroy();
            }
            
            window.cancellationChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: data.labels,
                    datasets: [{
                        data: data.data,
                        backgroundColor: '#5BC0DE',
                        borderColor: '#5BC0DE',
                        borderWidth: 0,
                        borderRadius: 50,
                        barThickness: 10
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            ticks: {
                                stepSize: 10,
                                beginAtZero: true
                            }
                        },
                        x: {
                            grid: {
                                drawBorder: false,
                                drawOnChartArea: false,
                                drawTicks: false
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: (tooltipItem) => {
                                    const value = tooltipItem.raw;
                                    return `${tooltipItem.label}: ${value}`;
                                }
                            }
                        }
                    }
                }
            });
        });
}

// Payment Method Breakdown Chart
function loadPaymentMethodBreakdown(filter) {
    fetch(`${baseUrl}/admin/payment-method-chart?type=${filter}`)
        .then(res => res.json())
        .then(data => {
            const ctx = document.getElementById('myChart4').getContext('2d');
            
            // Destroy existing chart if it exists
            if (window.paymentMethodChart) {
                window.paymentMethodChart.destroy();
            }
            
            window.paymentMethodChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: data.labels,
                    datasets: [{
                        data: data.data,
                        backgroundColor: ['#5B93FF', '#FFD66B', '#FF8F6B', '#FF6BF0'],
                        borderWidth: 0,
                        borderRadius: 50,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '75%',
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                color: '#666666',
                                textAlign: 'center',
                                font: { size: 12 },
                                boxWidth: 15,
                                boxHeight: 15
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: (tooltipItem) => {
                                    const value = tooltipItem.raw;
                                    return `${tooltipItem.label}: ${value}`;
                                }
                            }
                        }
                    }
                },
                plugins: [{
                    afterDraw: (chart) => {
                        const ctx = chart.ctx;
                        const chartArea = chart.chartArea;
                        const centerX = (chartArea.left + chartArea.right) / 2;
                        const centerY = (chartArea.top + chartArea.bottom) / 2;

                        const total = data.total || 1;
                        const valueSum = data.data.reduce((a, b) => a + b, 0);
                        const percent = `${Math.round((valueSum / total) * 100)}%`;

                        ctx.save();

                        // Draw large percent text
                        ctx.font = 'bold 24px Arial';
                        ctx.fillStyle = '#030229';
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'middle';
                        ctx.fillText(percent, centerX, centerY - 10);

                        // Draw smaller "Transaction" text
                        ctx.font = 'normal 14px Arial';
                        ctx.fillText('Transaction', centerX, centerY + 14);

                        ctx.restore();
                    }
                }]
            });
        });
}

// Top Products Chart
function loadTopProductsChart(filter) {
    fetch(`${baseUrl}/admin/top-products-chart?type=${filter}`)
        .then(res => res.json())
        .then(data => {
            const ctx = document.getElementById('myChart5').getContext('2d');
            
            // Destroy existing chart if it exists
            if (window.topProductsChart) {
                window.topProductsChart.destroy();
            }
            
            var total = data.data.reduce((acc, val) => acc + val, 0);

            window.topProductsChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: data.labels,
                    datasets: [{
                        data: data.data,
                        backgroundColor: ['#71CCE7', '#EFB0F4', '#C6B5F1', '#F1DBA5', '#C1ECA7'],
                        borderWidth: 7,
                        borderRadius: 10
                    }]
                },
                options: {
                    responsive: true,
                    cutout: '60%',
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                color: '#666666',
                                textAlign: 'center',
                                font: { size: 13 },
                                boxWidth: 15,
                                boxHeight: 15,
                                generateLabels: function (chart) {
                                    const dataset = chart.data.datasets[0];
                                    const total = dataset.data.reduce((sum, val) => sum + val, 0);
                                    return chart.data.labels.map((label, i) => {
                                        const value = dataset.data[i];
                                        const percentage = ((value / total) * 100).toFixed(0);
                                        return {
                                            text: `${label} (${percentage}%)`,
                                            fillStyle: dataset.backgroundColor[i],
                                            strokeStyle: dataset.backgroundColor[i],
                                            borderWidth: 1,
                                            pointStyle: 'circle',
                                            hidden: false,
                                            index: i
                                        };
                                    });
                                }
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function (tooltipItem) {
                                    const value = tooltipItem.raw;
                                    const percentage = ((value / total) * 100).toFixed(0);
                                    return `${tooltipItem.label} (${percentage}%)`;
                                }
                            }
                        }
                    }
                }
            });
        });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/dashboard/index.blade.php ENDPATH**/ ?>