<!-- resources/views/emails/booking_cancellation.blade.php -->
<?php $__env->startComponent('mail::message'); ?>
# Booking Cancellation Confirmation

Dear <?php echo e($userDetails->first_name); ?> <?php echo e($userDetails->last_name); ?>,

We hereby confirm the cancellation of your booking with order number **<?php echo e($booking->invoice_number); ?>** placed on **<?php echo e($booking->created_at->format('d.m.Y')); ?>**.

<?php if($booking->payment_status === 'paid'): ?>
If you have already made a payment, the corresponding amount will be refunded shortly via the original payment method.  
Please note that the refund may take up to 14 business days depending on your payment provider.
<?php endif; ?>

**Summary of your cancelled booking:**  
- Booking Number: <?php echo e($booking->invoice_number); ?>  
- Cancellation Date: <?php echo e($cancellationDate->format('d.m.Y H:i')); ?>  
- Item(s): 
<?php $__currentLoopData = $bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  - <?php echo e($item->product_name); ?> (<?php echo e($item->size); ?>)
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
- Total Amount: <?php echo e(number_format($booking->total, 2, ',', '.')); ?> EUR

We're sorry the booking couldn't be completed.

If you have any questions regarding the cancellation or would like to place a new booking, our customer service team will be happy to assist you.

Best regards,  
The Dachboxmiete Team

<?php $__env->startComponent('mail::panel'); ?>
Dachboxmiete Ltd.  
<?php echo GetMetaData('address','contact-us'); ?>  
Email: <?php echo e(GetMetaData('email','contact-us')); ?>    
Phone:  <?php echo e(GetMetaData('number','contact-us')); ?>   
Website: <?php echo e(env('APP_URL')); ?>

<?php echo $__env->renderComponent(); ?>
<?php echo $__env->renderComponent(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/email/booking_cancellation.blade.php ENDPATH**/ ?>