<?php $__env->startSection('content'); ?>
<main>
<section class="banner-back-img-howto">
    <div class="inner-main-img">
        <div class="container">
            <div class="inner-banner-comn">
                <h1>Get a quote</h1>
            </div>
        </div>
    </div>
</section>

<section class="detail-show-all comn-padd-100 roof-box-main">
    <div class="container">
        <div class="select-product">
            <div class="heading-select-prod">
                <h3><?php echo e(__('messages.select_the_product')); ?></h3>
                <p><?php echo e(__('messages.select_product_description')); ?></p>
            </div>
            
            <div class="cards-select-product">
                <div class="row">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 
                        <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-2">
                                <div class="first-check-box">
                                    <input class="form-check-input product-radio" 
                                           type="radio" 
                                           name="product" 
                                           id="product-<?php echo e($product->id); ?>" 
                                           value="<?php echo e($product->id); ?>"
                                           <?php echo e($loop->first && $loop->parent->first ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="product-<?php echo e($product->id); ?>">
                                        <div class="inner-img-select-heading">
                                            <div class="inner-image-roof">
                                                <figure>
                                                    <?php if($product->images->where('type', 'main')->first()): ?>
                                                        <img src="<?php echo e(asset('storage/' . $product->images->where('type', 'main')->first()->image_path)); ?>" alt="<?php echo e($product->name); ?>">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('frontend/images/placeholder.png')); ?>" alt="No image">
                                                    <?php endif; ?>
                                                </figure>
                                            </div>
                                            <h4><?php echo e($product->brand->name); ?> <?php echo e($product->name); ?></h4>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>



        <div id="product-details-container">
            <?php echo $__env->make('frontend.pages.product.partials.product_details', [
                'product' => $firstProduct,
                'priceRecord' => $priceRecord,
                'colors' => $colors,
                'sizes' => $sizes,
                'variations' => $variations,
                'roofTypes' => $roofTypes,
                'dailyPrices' => $dailyPrices,
                'roofRackPrices' => $roofRackPrices,
                'manufacturers' => $manufacturers
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</section>

<?php echo $__env->make('frontend.include.subscribe_news', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</main>


<script>
function parseDMY(dateStr) {
    const [day, month, year] = dateStr.split('.');
    const fullYear = parseInt(year) < 100 ? 2000 + parseInt(year) : parseInt(year);
    return new Date(fullYear, parseInt(month) - 1, parseInt(day));
}
var baseUrl = '';
$(document).ready(function() {
    let product_id = $('.product-radio').val();
    $('.product-radio').change(function() {
        const productId = $(this).val();
        product_id = productId;
        
        $.ajax({
            url: "<?php echo e(route('product.get-details')); ?>",
            method: 'GET',
            data: { product_id: productId },
            success: function(response) {
                $('#product-details-container').html(response.view);
                
                initializeProductDetailJS(product_id);
            },
            error: function(xhr) {
                console.error('Error loading product details');
            }
        });
    });
    initializeProductDetailJS(product_id);
});

let selectedRecommendation = null;

$(document).on('click', '.clickable-roof', function () {
    $('.clickable-roof').removeClass('selected');
    $(this).addClass('selected');

    const slug = $(this).data('rooftype-slug');
    selectedRecommendation = window.currentRecommendationMap[slug];

    $('#roof-types-container .invalid-feedback').remove();
});


function saveFormDataAndRedirect(redirectUrl) {

    let rentalFromStr = $('#rental_from').val();
    let rentalToStr = $('#rental_to').val();

    let rentalFrom = parseDMY(rentalFromStr);
    let rentalTo = parseDMY(rentalToStr);

    let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
    let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;

    let formData = {
        product_id: $('#product_id').val(),
        product_name: $('#product_name').val(),
        manufacturer: $('#manufacturer').val(),
        car_year: $('#year').val(),
        model: $('#model').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: selectedRecommendation?.rooftype_eng || '',
        carrier_length: selectedRecommendation?.carrier_length || '',
        foot_sku: selectedRecommendation?.foot_sku || '',
        footkit_sku: selectedRecommendation?.footkit_sku || '',
        bundle_name: selectedRecommendation?.bundle_name || '',
        color_id: $('#color-select').val(),
        color_name: $('#color-select option:selected').data('color-name'),
        size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
        size_name: $('.inner-size-card.selected').data('size-name'),
        rental_from: $('#rental_from').val(),
        rental_to: $('#rental_to').val(),
        days: days,
        calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
        is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
        is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0
    };
    formData._token = $('meta[name="csrf-token"]').attr('content');


    $.post(`${baseUrl}/store-rental-form`, formData, function() {
        window.location.href = redirectUrl; 
    });
}
function initializeProductDetailJS(product_id) {
    

    $('#manufacturer').change(function() {
        $('#model').prop('disabled', true).html('<option>Loading...</option>');
        $('#year').prop('disabled', true).html('<option>Select</option>');
        
        let manufacturer = $(this).val();

        $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
            $('#model').prop('disabled', false).html('<option selected disabled>Select</option>');
            data.forEach(model => {
                $('#model').append(`<option value="${model}">${model}</option>`);
            });
        });
    });

    $('#model').change(function() {
        $('#year').prop('disabled', true).html('<option>Loading...</option>');
        
        let manufacturer = $('#manufacturer').val();
        let model = $(this).val();

        $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
            $('#year').prop('disabled', false).html('<option selected disabled>Select</option>');
            data.forEach(year => {
                $('#year').append(`<option value="${year}">${year}</option>`);
            });
        });
    });





    // $('#color-select').change(function() {
    //     const colorId = $(this).val();
    //     const colorName = $(this).find('option:selected').data('color-name');
        
    //     if (!colorId) {
    //         $('.inner-size-card').removeClass('available unavailable');
    //         $('.inner-size-card .badge')
    //             .removeClass('bg-success bg-danger')
    //             .addClass('bg-secondary')
    //             .text('Select color first');
    //         return;
    //     }

        
    //     $.get(`${baseUrl}/product/${product_id}/availability`, { color_id: colorId }, function(availability) {
    //         $('.inner-size-card').each(function() {
    //             const $card = $(this);
    //             const sizeName = $card.data('size-name');
    //             const sizeId = $card.data('size-id') || $card.data('variation-id');
    //             const isAvailable = availability[sizeId] > 0;
                
    //             $card.toggleClass('available', isAvailable)
    //                 .toggleClass('unavailable', !isAvailable);
                    
    //             const $badge = $card.find('.badge');
    //             $badge.removeClass('bg-secondary bg-success bg-danger')
    //                 .addClass(isAvailable ? '' : 'bg-danger')
    //                 .text(isAvailable ? '' : 'Unavailable');
    //         });
            
    //         if (window.currentRecommendation) {
    //             highlightRecommendedSizes(window.currentRecommendation);
    //         }
    //     });
    // });
    function checkAvailability(colorId,colorName) {
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    
    const params = {
        color_id: colorId,
        from_date: fromDate,
        to_date: toDate,
        color_name : colorName
    };

    if(!fromDate || !toDate ||  !colorId){
        return; 
    }
    
    $.get(`${baseUrl}/product/${product_id}/availability`, params, function(availability) {
        $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            const isAvailable = availability[sizeId] > 0;
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? '' : 'Unavailable');
        });
        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }
    });
}

$('#rental_from, #rental_to').on('change', function() {

    const colorId = $('#color-select').val();
    const colorName = $('#color-select option:selected').data('color-name');
    console.log(colorId)
    if (colorId && colorId !== 'Select') {
        checkAvailability(colorId,colorName);
    }
});

// Update color select change handler
$('#color-select').on('change', function() {
    const colorId = $(this).val();
    const colorName = $('#color-select option:selected').data('color-name');
    console.log(colorName)
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    $('#errorMessage').empty();
    if (colorId && colorId !== 'Select' && fromDate && toDate) {
        checkAvailability(colorId,colorName);
    }
});
// function highlightRecommendedSizes(recommendation) {
//     $('.inner-size-card').removeClass('recommended-size');
    
//     recommendation.forEach(item => {
//         $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`)
//             .addClass('recommended-size');
//     });
// }





function highlightRecommendedSizes(recommendation) {
        $('.inner-size-card').removeClass('recommended-size');
        $('.recommended').addClass('d-none')
    recommendation.forEach(item => {
        const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
        $card.addClass('recommended-size');
        console.log(item)
        $card.find('.recommended').removeClass('d-none');
            $card.find('.recommended').text('Recommended');
    });
}
var railing_type = $('#railing_type').val();
    $('#year, #trailer_hitch').change(function() {
        let manufacturer = $('#manufacturer').val();
        let year = $('#year').val();
        let model = $('#model').val();
        let trailer_hitch = $('#trailer_hitch').val();


        const productName = $('#trailer_hitch').data('product-name');
        const selectedValue = $('#trailer_hitch').val();
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier');
        if (selectedValue === 'no' && hitchRequired) {
            $('#trailer_hitch').val('');

            const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
            modal.show();
            return ;
        }


        if (manufacturer && year && model && trailer_hitch) {
            $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
                window.currentRecommendation = data;
                window.currentRecommendationMap = {};

                if (data.length === 0) {
                    $('#result').html('<p>No recommendations found.</p>');
                    return;
                }

                $('.roof-name-detail').hide();
                $('#roof-types-container').show();

                

                data.forEach((item, index) => {
                    const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

                   
                    if(railing_type){
                    $(`#roof-type-${roofTypeSlug}`).show();

                    window.currentRecommendationMap[roofTypeSlug] = item;
                    $(`#roof-type-${roofTypeSlug}`)
                        .addClass('clickable-roof')
                        .attr('data-rooftype-slug', roofTypeSlug);
                    }
                });

                $('#result').html(html);
                highlightRecommendedSizes(data);
            });
        }
    });




    $(document).on('click', '.inner-size-card', function () {

        const colorId = $('#color-select').val();
        const colorName = $('#color-select').find('option:selected').data('color-name');
        if (!colorName) {
            $('#errorMessage').html(`
                <div class="text-danger mt-2">
                    Please select a color first.
                </div>
            `);
            return;
        }


        const $card = $(this);
        const isAvailable = $card.hasClass('available');
        const isUnavailable = $card.hasClass('unavailable');

        $('.inner-size-card').removeClass('selected');
        $('#errorMessage').empty();

        $card.addClass('selected');

        if (isUnavailable) {
            const message = `
                <div class="size-unavailable-message text-danger mt-2">
                    The product you have selected is currently unavailable, but you can send a request and we will let you know when it is available.
                </div>
            `;
            $('#errorMessage').html(message);
        }
    });

    $('.roof-name-detail').hide();
    $('#roof-types-container').hide();

    const dailyPrices = <?php echo json_encode($dailyPrices, 15, 512) ?>;
    const roofRackPrices = <?php echo json_encode($roofRackPrices, 15, 512) ?>; 
    const insuranceFlatFee = 25.00;

    function calculateRent() {
        // const from = new Date($('#rental_from').val());
        // const to = new Date($('#rental_to').val());

        const from = parseDMY($('#rental_from').val());
        const to = parseDMY($('#rental_to').val());

        if (isNaN(from) || isNaN(to) || to < from) return;

        const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

        let totalRent = 0;

        for (let i = 0; i < days && i < dailyPrices.length; i++) {
            totalRent += dailyPrices[i];

            if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                console.log('totalRent', totalRent)
                totalRent += roofRackPrices[i];
            }
        }

        if ($('#insurance_checkbox').is(':checked')) {
            totalRent += insuranceFlatFee;
            $('#withinsurance').removeClass('d-none');
            $('#withoutinsurance').addClass('d-none');
        }else{
            $('#withoutinsurance').removeClass('d-none');
            $('#withinsurance').addClass('d-none');
        }

        $('.inner-number-days span:first').text(days);
        $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
    }

    $('#rental_from, #rental_to').on('change', calculateRent);



    $('#insurance_checkbox').on('change', function () {
        $('#insurance_selected').val(this.checked ? 1 : 0);
    });

    $('#roof_rack_checkbox').on('change', function () {
        $('#roof_rack_selected').val(this.checked ? 1 : 0);
    });



    $(document).ready(function() {
        $('#roof_rack_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#insurance_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#rentCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', true).trigger('change');
            $('#notCarrier').modal('hide');
        });

        $('#bringOwnCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', false);
            $('#notCarrier').modal('hide');
            calculateRent(); 
        });

        $('#wantInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', true).trigger('change');
            $('#notInsurance').modal('hide');
        });

        $('#noInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', false);
            $('#notInsurance').modal('hide');
            calculateRent(); 
        });
    function validateForm() {
        let isValid = true;

        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), 'Please enter Manufacturer ');
            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), 'Please enter Year ');
            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), 'Please enter Model ');
            isValid = false;
        }
        
        const productName = $('#trailer_hitch').data('product-name');
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier');
        if (hitchRequired && !$('#trailer_hitch').val()) {
            showError($('#trailer_hitch'), 'Trailer hitch selection is required for this product');
            isValid = false;
        }
        
        // Color validation
        if (!$('#color-select').val()) {
            showError($('#color-select'), 'Please enter Color ');
            isValid = false;
        }
        
        // Size validation
        if (!$('.inner-size-card.selected').length) {
            $('#size-container').after('<div class="invalid-feedback d-block">Please enter Size </div>');
            isValid = false;
        }
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), 'Please enter Start date ');
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), 'Please enter End date ');
            isValid = false;
        } 
        
        if ($('#rental_from').val() && $('#rental_to').val()) {

            // const from = new Date($('#rental_from').val());
            // const to = new Date($('#rental_to').val());

            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());
            if (to < from) {
                showError($('#rental_to'), 'End date must be after start date');
                isValid = false;
            }
        }
        
        return isValid;
    }

    function showError(element, message) {
        element.addClass('is-invalid');
        if (element.is('select')) {
            element.parent().append(`<div class="invalid-feedback">${message}</div>`);
        } else {
            element.after(`<div class="invalid-feedback">${message}</div>`);
        }
    }

    $('#manufacturer, #year, #model, #trailer_hitch, #color-select, #rental_from, #rental_to').on('input change', function() {
        $(this).removeClass('is-invalid');
        $(this).next('.invalid-feedback').remove();
        $(this).parent().find('.invalid-feedback').remove();
    });
    $('.inner-size-card').on('click', function() {
        $('.invalid-feedback.d-block').remove();
    });

    $('#bookingForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        <?php if(auth()->guard()->check()): ?>
        if (validateForm()) {
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                bundle_name: selectedRecommendation?.bundle_name || '',
                color_id: $('#color-select').val(),
                color_name: $('#color-select option:selected').data('color-name'),
                size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                size_name: $('.inner-size-card.selected').data('size-name'),
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0
            };

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        for (const field in errors) {
                            showError($(`#${field}`), errors[field][0]);
                        }
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
        }
        <?php else: ?>
            if(validateForm()){
                e.preventDefault();
                $('#guestOptionsModal').modal('show');

            }
        <?php endif; ?>
    });

    $('#continueAsGuest').click(function() {
        const name = $('#name').val().trim();
        const surname = $('#surname').val().trim();
        const email = $('#email').val().trim();
        const number = $('#number').val();

      let isValid = true;

      $('#name, #surname, #email').removeClass('is-invalid');

      if (name === '') {
        $('#name').addClass('is-invalid');
        isValid = false;
      }

      
      if (surname === '') {
        $('#surname').addClass('is-invalid');
        isValid = false;
      }

      if(number === ''){
        $('#number').addClass('is-invalid');
        isValid = false;
      }

      const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (email === '' || !emailPattern.test(email)) {
        $('#email').addClass('is-invalid');
        isValid = false;
      }

      if (isValid) {
      
        // $('#guestModal').modal('hide');

      }
        // $('#guestModal').modal('hide');
        let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
        let formData = {
                is_guest: 1,
                name: $('#name').val(),
                surname: $('#surname').val(),
                email: $('#email').val(),
                number : $('#number').val(),
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                bundle_name: selectedRecommendation?.bundle_name || '',
                color_id: $('#color-select').val(),
                color_name: $('#color-select option:selected').data('color-name'),
                size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                size_name: $('.inner-size-card.selected').data('size-name'),
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0
            };
        $.ajax({
            url: "<?php echo e(route('cart.add')); ?>",
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if(response.status ==  false){
                    $('#guestError')
                .removeClass('d-none')
                .text(response.message || 'Something went wrong. Please try again.');
                }else{
                    $('#guestModal').modal('hide');
                    $('#guestError').addClass('d-none');
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                }
             
                // window.location.href = '<?php echo e(route("cart.guest_time-selection")); ?>';
            }
        });
    });
});


// $(function() {
//         function disableWeekends(date) {
//             const day = date.getDay();
//             return [(day !== 0 && day !== 6), ''];
//         }

//         $("#rental_from, #rental_to").datepicker({
//             dateFormat: 'yy-mm-dd',
//             minDate: 0, 
//             beforeShowDay: disableWeekends,
//             onSelect: function () {
//                 var colorId = $('#color-select').val();
//                 var colorName = $('#color-select option:selected').data('color-name');
//                 if (colorId && colorId !== 'Select') {
//                     checkAvailability(colorId,colorName);
//                 }
//                 calculateRent();
//             }
//         });
//     });

$(function () {
        const holidays = <?php echo json_encode($holidays, 15, 512) ?>;
        const nonworkingDays = <?php echo json_encode($nonworkingDays, 15, 512) ?>; 
        const dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

    const closedDays = nonworkingDays.map(day => dayMap[day]);

        function disableWeekendsAndHolidays(date) {
            const day = date.getDay();
            const formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            const isWeekend = closedDays.includes(day);
            const isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        $("#rental_from").datepicker({
            dateFormat: 'dd.mm.yy',
            minDate: 0,
            firstDay: 1,
            beforeShowDay: disableWeekendsAndHolidays,
            onSelect: function (selectedDate) {
                const startDate = $(this).datepicker('getDate');
                // Set minDate of end date to startDate
                $("#rental_to").datepicker("option", "minDate", startDate);

                var colorId = $('#color-select').val();
                var colorName = $('#color-select option:selected').data('color-name');
                if (colorId && colorId !== 'Select') {
                    checkAvailability(colorId, colorName);
                }
                calculateRent();
            }
        });

        $("#rental_to").datepicker({
            dateFormat: 'dd.mm.yy',
            minDate: 0,
            firstDay: 1,
            beforeShowDay: disableWeekendsAndHolidays,
            onSelect: function () {
                var colorId = $('#color-select').val();
                var colorName = $('#color-select option:selected').data('color-name');
                if (colorId && colorId !== 'Select') {
                    checkAvailability(colorId, colorName);
                }
                calculateRent();
            }
        });
    });
    
}
</script>
<style>

    .clickable-roof {
        border: 2px solid transparent;
        cursor: pointer;
        transition: 0.2s;
    }
    .clickable-roof:hover {
        border-color: #007bff;
    }
    .clickable-roof.selected {
        border-color: #007bff;
        background-color: #e9f5ff;
    }
    
    </style>

<?php echo $__env->make('frontend.pages.product.partials.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/pages/product/quote.blade.php ENDPATH**/ ?>