<?php $__env->startSection('content'); ?>

<div class="col-9 main-dash-left sora-font">
    <div class="analytics">

        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>SPO Product Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For SPO" type="text" id="searchUser" class="form-control" value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                   
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="sortFilterDropdown"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-sort"></i>
                                <?php echo e(request('status') == '' ? 'All' : (request('status') == 'active' ? 'Active' : 'Blocked')); ?>

                            </button>
                            <ul class="dropdown-menu" aria-labelledby="statusFilterDropdown">
                                <li><a class="dropdown-item status-option <?php echo e(request('status') == '' ? 'active' : ''); ?>" href="?">All</a></li>
                                <li><a class="dropdown-item status-option <?php echo e(request('status') == 'active' ? 'active' : ''); ?>" href="?status=active">Active</a></li>
                                <li><a class="dropdown-item status-option <?php echo e(request('status') == 'inactive' ? 'active' : ''); ?>" href="?status=inactive">Blocked</a></li>
                            </ul>
                        </div>
                    </div>
                    <form id="sortForm" method="GET">
                        <input type="hidden" name="sort_by" id="sortInput" value="<?php echo e(request('sort_by', 'desc')); ?>">
                    </form>
                    <div class="sownload-cv-pdf">
                        <a href="#" class="download-csv" onclick="exportData('csv')">Download CSV</a>
                        <a href="#" class="download-pdf" onclick="exportData('pdf')">Download PDF</a>
                    </div>
                    <form id="exportForm" method="GET" action="" style="display: none;">
                        <input type="hidden" name="search" id="exportSearch">
                        <input type="hidden" name="sort_by" id="exportSort">
                    </form>
                </div>
            </div>
            
            <div class="notification-table pt-0">
                <table id="productTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>SPO ID</th>
                            <th>SPO Name</th>
                            <th>City</th>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($product->name); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>#<?php echo e($vendor->id); ?></td>
                                <td><?php echo e($vendor->first_name . ' ' . $vendor->last_name); ?></td>
                                <td><?php echo e($vendor->city); ?></td>
            
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $key = $vendor->id . '-' . $product->id;
                                        $sum = $quantities[$key]->total_quantity ?? 0;
                                    ?>
                                    <td><?php echo e($sum); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
                                <td>
                                    <div class="upper-delete-btns d-flex">
                                        <a class="view-btn-eye" href="<?php echo e(route('admin.spo.product.detail', $vendor)); ?>">
                                            <i class="fa-solid fa-eye"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($vendors->links()); ?>

            </div>
        </div>
    </div>
</div>

<!-- Status Change Modal -->
<div class="modal fade modal-delete-logout" id="changestatus" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="status-text">Are you sure you want to change status?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" class="comn-modal-btns-transparent btn btn-primary" data-bs-dismiss="modal" onclick="resetStatusSelect()">No</button>
                        <form id="status-change-form" method="POST" action="<?php echo e(route('admin.spo.status')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="user-id">
                            <input type="hidden" name="new_status" id="new-status">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade modal-delete-logout" id="deleteuser" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete this SPO?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-user-form" method="POST" action="<?php echo e(route('admin.spo.destroy')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_id" id="delete-user-id">
                            <button type="submit" class="comn-modal-btns-blue btn add-user">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    // $(document).ready(function() {
    //     document.getElementById('timeFilter').addEventListener('change', function() {
    //         const timeFilter = this.value;
    //         const url = new URL(window.location.href);
    //         url.searchParams.set('time_filter', timeFilter);
    //         window.location.href = url.toString();
    //     });
    // });

    $(document).ready(function () {
        $('#productTable').DataTable({
        paging: true,
        searching: true, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
            },
            dom: '<"top"lf>rt<"bottom"ip><"clear">'
        });

        $('#searchUser').on('keyup', function() {
            $('#productTable').DataTable().search(this.value).draw();
            // filterPaymentTable();
        });
    });

    document.querySelectorAll('.sort-option').forEach(item => {
        item.addEventListener('click', function (e) {
            e.preventDefault();
            const sortValue = this.getAttribute('data-value');
            document.getElementById('sortInput').value = sortValue;
            document.getElementById('sortForm').submit();
        });
    });
    
    let statusSelectEl = null;
    
    function openStatusChangeModal(userId, newStatus, selectEl) {
        statusSelectEl = selectEl;
        const statusText = newStatus === 'Active'
            ? 'Are you sure you want to activate this SPO?'
            : 'Are you sure you want to block this SPO?';

        document.getElementById('status-text').innerText = statusText;
        document.getElementById('user-id').value = userId;
        document.getElementById('new-status').value = newStatus;

        const modal = new bootstrap.Modal(document.getElementById('changestatus'));
        modal.show();
    }

    function resetStatusSelect() {
        if (statusSelectEl) {
            const current = statusSelectEl.getAttribute('data-current-status');
            statusSelectEl.value = current;
        }
    }

    function openDeleteModal(userId) {
        document.getElementById('delete-user-id').value = userId;
        const modal = new bootstrap.Modal(document.getElementById('deleteuser'));
        modal.show();
    }

    $(document).ready(function() {
        $('#searchUser').on('keyup', function() {
            let searchQuery = $(this).val().toLowerCase();  
            $('.download-pdf, .download-csv').each(function() {
                let href = $(this).attr('href').split('?')[0];
                $(this).attr('href', href + '?search=' + encodeURIComponent(searchQuery));
            });
            
            $('#userResults tr').each(function() {  
                let rowText = $(this).text().toLowerCase();  
                $(this).toggle(rowText.indexOf(searchQuery) > -1);
            });
        });
    });
    
    function exportData(type) {
        $('#exportSearch').val($('#searchUser').val());
        $('#exportSort').val("<?php echo e(request('sort_by', 'desc')); ?>");
        
        let action = type === 'csv' 
            ? "<?php echo e(route('admin.spoProduct.download.csv')); ?>" 
            : "<?php echo e(route('admin.spoProduct.download.pdf')); ?>";
        $('#exportForm').attr('action', action);
        $('#exportForm').submit();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/spoProduct/index.blade.php ENDPATH**/ ?>