<div class="comm_renting_dt_row">
    <h3 class="rnt_head"><?php echo e(__('messages.previous_booked_slot')); ?>: <span><?php echo e(__('messages.booking_id')); ?>: <?php echo e($booking->id); ?></span></h3>

    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
        <?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="comm_detail_list_col">
                <h5><?php echo e(__('messages.from')); ?>:</h5>
                <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?></h6>
            </div>
            <div class="comm_detail_list_col">
                <h5><?php echo e(__('messages.to')); ?>:</h5>
                <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?></h6>
            </div>
            <div class="comm_detail_list_col">
                <h5><?php echo e(__('messages.pickup_datetime')); ?>:</h5>
                <h6><?php echo e(\Carbon\Carbon::parse($item->pickup_date)->format('d/m/Y')); ?> | <?php echo e(\Carbon\Carbon::parse($item->pickup_time)->format('h:i A')); ?></h6>
            </div>
            <div class="comm_detail_list_col">
                <h5><?php echo e(__('messages.dropoff_datetime')); ?>:</h5>
                <h6><?php echo e(\Carbon\Carbon::parse($item->dropoff_date)->format('d/m/Y')); ?> | <?php echo e(\Carbon\Carbon::parse($item->dropoff_time)->format('h:i A')); ?></h6>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<p class="default-text mt-3 mb-3"><?php echo e(__('messages.unable_to_change_notice')); ?></p>

<h3 class="main-head-pro"><?php echo e(__('messages.change_your_appointment')); ?></h3>

<div class="cst_calender">
    <div id="calendar-box"></div>
</div>

<div class="row my_appiont_date_row">
    <div class="col-md-6">
        <div class="my_appiont_date_col">
            <div class="inner-main-input">
                <label for="pickupDate" class="form-label"><?php echo e(__('messages.pickup_date')); ?></label>
                <input class="form-control date-input" type="text" id="pickupDate" placeholder="<?php echo e(__('messages.select_date_calendar')); ?>" readonly>
            </div>
            <p class="avail_slots_text"><?php echo e(__('messages.available_slot')); ?></p>
            <ul class="available_slots_row" id="from-slots"></ul>
        </div>
    </div>
    <div class="col-md-6">
        <div class="my_appiont_date_col">
            <div class="inner-main-input">
                <label for="dropoffDate" class="form-label"><?php echo e(__('messages.dropoff_date')); ?></label>
                <input class="form-control date-input" type="text" id="dropoffDate" placeholder="<?php echo e(__('messages.select_date_calendar')); ?>" readonly>
            </div>
            <p class="avail_slots_text"><?php echo e(__('messages.available_slot')); ?></p>
            <ul class="available_slots_row" id="to-slots"></ul>
        </div>
    </div>
</div>

<p class="default_text mt-4"><?php echo e(__('messages.custom_request_notice')); ?></p>

<div id="newSlotPreview"></div>

<div class="text-center mt-4">
    <button class="btn primary-btn" id="saveChangesBtn" disabled><?php echo e(__('messages.save_new_slot')); ?></button>
</div>

<div class="d-flex align-items-center text-center my_app_bott_cnt_sec">
    <p class="default_text"><?php echo e(__('messages.no_slot_found_notice')); ?></p>
    <button class="btn primary-btn" data-bs-toggle="modal" data-bs-target="#contactModal"><?php echo e(__('messages.contact_us')); ?></button>
</div>


<!-- Contact Us Modal -->
<?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/user/appointment/details.blade.php ENDPATH**/ ?>