<?php $__env->startSection('content'); ?>
    <div class="col-9 main-dash-left">
        <div class="upper-main-user-navigation">
            <div class="user-manage">
                <a href="<?php echo e(route('vendor.profile')); ?>">My profile</a>
                <a class="active">Profile</a>
            </div>
        </div>

        <div class="add-user-form">
            <div class="profile-img-btn d-flex justify-content-between align-items-center">
                <div class="profile-pic my-profile-img">
                    <figure class="profile-img"><img src="<?php echo e(asset('storage/' . $vendor->image)); ?>" alt=""></figure>
                </div>
                <a class="add-notification-btn" href="<?php echo e(route('vendor.edit.profile')); ?>">Edit profile</a>
            </div>
            <div class="name-profile-holder">
                <h3><?php echo e($vendor->first_name . ' ' . $vendor->last_name); ?></h3>
            </div>
            <div class="profile-detai-all">
                <div class="inner-detail-profile">
                    <div class="name-profile-detail">
                        <h6>Phone Number :</h6>
                        <?php $__currentLoopData = $country_code; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($code['dial_code'] == $vendor->country_code): ?>
                                <p><?php echo e($code['emoji']); ?><?php echo e($code['dial_code']); ?> <?php echo e($vendor->number); ?></p>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="pair-streetmain d-flex">
                        <div class="inner-pair-street">
                            <div class="name-profile-detail">
                                <h6>Street, House Number:</h6>
                                <p><?php echo e($vendor->street); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>City:</h6>
                                <p><?php echo e($vendor->city); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Email Address :</h6>
                                <p><?php echo e($vendor->email); ?></p>
                            </div>
                           
                            <div class="name-profile-detail">
                                <h6>Working Hours:</h6>
                                <div class="time-profile-all">
                                    <?php $__currentLoopData = $time; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($availability->open_time && $availability->close_time): ?>
                                            <p><span><?php echo e($availability->day); ?>:</span><?php echo e(\Carbon\Carbon::parse($availability->open_time)->format('H:i')); ?>

                                                - <?php echo e(\Carbon\Carbon::parse($availability->close_time)->format('H:i')); ?></p>
                                        <?php else: ?>
                                            <p><span><?php echo e($availability->day); ?>:</span>Closed</p>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="inner-pair-street">
                            <div class="name-profile-detail">
                                <h6>Zip Code:</h6>
                                <p><?php echo e($vendor->zip_code); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Country:</h6>
                                <p><?php echo e($vendor->country); ?></p>
                            </div>
                        
                           
                            <div class="name-profile-detail">
                                <h6>Name Of The Contract:</h6>
                                <p><?php echo e($vendor->contact_person); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Business Type:</h6>
                                <p><?php echo e($vendor->business_type); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Business Model:</h6>
                                <p><?php echo e($vendor->business_model); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Size Of Location:</h6>
                                <p><?php echo e($vendor->size_of_location); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Status:</h6>
                                <p><?php echo e($vendor->status); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>No. Of Employees:</h6>
                                <p><?php echo e($vendor->employees); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Tax Number:</h6>
                                <p><?php echo e($vendor->tax_number); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Tax-ID:</h6>
                                <p><?php echo e($vendor->tax_id); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Bank Name:</h6>
                                <p><?php echo e($vendor->bank_name); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Bank Account Owner:</h6>
                                <p><?php echo e($vendor->account_owner); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Bank Account Owner:</h6>
                                <p><?php echo e($vendor->account_owner); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>Bank Account Number:</h6>
                                <p><?php echo e($vendor->account_number); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>BIC Number:</h6>
                                <p><?php echo e($vendor->bic_number); ?></p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>IBAN:</h6>
                                <p><?php echo e($vendor->iban_number); ?></p>
                            </div>


                        </div>
                    </div>

                    <div class="abcent-days">
                        <div class="head-abcent-days">
                            <h3>Absent Days:</h3>
                            
                        </div>

                        <div class="modal add-holiday-modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true" style="display: none;">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h1 class="modal-title" id="exampleModalLabel">Add Holiday</h1>
                                        <!-- <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button> -->
                                    </div>
                                    <div class="modal-body">
                                        <form id="holiday_add_form" action=""
                                            method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="mb-3 comn-input-select">
                                                <label for="holiday_name" class="col-form-label">Holiday Name:</label>
                                                <input type="text" class="form-control" id="holiday_name"
                                                    name="holiday_name" required>
                                            </div>
                                            <div class="mb-3 comn-input-select">
                                                <label for="date_text" class="col-form-label">Date:</label>
                                                <input class="form-control" id="date_text" type="date"
                                                    name="holiday_date" required>
                                            </div>
                                            <div class="upper-main-btn-last-comn d-flex">
                                                <button type="button" class="add-user"
                                                    data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="cancel-btn">Save</button>
        
                                            </div>
                                    </div>
                                   
                                    </form>

                                </div>
                            </div>
                        </div>
                        <div class="table-abcent-list">
                            <table>
                                <?php if($holidays->isEmpty()): ?>
                                    <tr>
                                        <td colspan="4" class="text-center">No Holidays Available</td>
                                    </tr>
                                <?php else: ?>
                                    <?php $__currentLoopData = $holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="abcent-name"><?php echo e($holiday->name); ?></td>
                                            <td class="abcent-date"
                                                data-date="<?php echo e(\Carbon\Carbon::parse($holiday->date)->format('Y-m-d')); ?>">
                                                <?php echo e(\Carbon\Carbon::parse($holiday->date)->format('d-m-Y')); ?>

                                            </td>
                                            <td class="abcent-total"></td>
                                            <td class="delete-last">
                                                
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                
                               
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let today = new Date();
            today.setHours(0, 0, 0, 0);

            document.querySelectorAll(".abcent-date").forEach(function(element) {
                let holidayDateStr = element.getAttribute("data-date");
                let holidayDate = new Date(holidayDateStr + "T00:00:00");
                holidayDate.setHours(0, 0, 0, 0);

                let timeDiff = holidayDate - today;
                let daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));

                let daysLeftCell = element.closest("tr").querySelector(".abcent-total");
                daysLeftCell.textContent = daysLeft > 0 ? `in ${daysLeft} Tagen` : daysLeft === 0 ?
                    "Today" : `vor ${Math.abs(daysLeft)} Tagen`;
            });
        });
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".delete-ico").forEach(function(deleteButton) {
                deleteButton.addEventListener("click", function() {
                    let holidayId = this.getAttribute("data-id");
                    let deleteRoute = this.getAttribute("data-route");
                    let row = this.closest("tr");
                    if (confirm("Are you sure you want to delete this holiday?")) {
                        fetch(deleteRoute, {
                                method: "DELETE",
                                headers: {
                                    "X-CSRF-TOKEN": document.querySelector(
                                        'meta[name="csrf-token"]').getAttribute("content"),
                                    "Content-Type": "application/json",
                                },
                            })
                            .then(response => response.json())
                            .then(data => {
                                if (data.success) {
                                    row.remove();
                                    Swal.fire({
                                        title: "Deleted Successfully",
                                        icon: "success",
                                        draggable: true
                                    });
                                } else {
                                    alert("Error deleting holiday.");
                                }
                            })
                            .catch(error => console.error("Error:", error));
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/vendor/auth/profile.blade.php ENDPATH**/ ?>