<?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr>
    <td>#<?php echo e($booking->id); ?></td>
    <td>
        <?php if($booking->userDetails): ?>
            <?php echo e($booking->userDetails->first_name); ?> <?php echo e($booking->userDetails->last_name); ?>

        <?php else: ?>
            N/A
        <?php endif; ?>
    </td>
    <td>
        <?php if($booking->userDetails): ?>
            <?php echo e($booking->userDetails->phone); ?>

        <?php else: ?>
            N/A
        <?php endif; ?>
    </td>
    <td>
        <?php if($booking->userDetails): ?>
            <?php echo e($booking->userDetails->email); ?>

        <?php else: ?>
            N/A
        <?php endif; ?>
    </td>
    <td>
        <?php if($booking->items->isNotEmpty()): ?>
            <?php echo e($booking->items->first()->pickup_date->format('d.m.Y')); ?> - 
            <?php echo e($booking->items->first()->dropoff_date->format('d.m.Y')); ?>

        <?php else: ?>
            N/A
        <?php endif; ?>
    </td>
    <td>
        <?php if($booking->items->isNotEmpty()): ?>
            <?php echo e($booking->items->first()->days); ?> Days
        <?php else: ?>
            N/A
        <?php endif; ?>
    </td>
    <td>
        <select class="form-select select-active-block" 
        id="statusSelect<?php echo e($booking->id); ?>" 
        aria-label="Default select example">
    <option value="pending" <?php echo e($booking->status == 'pending' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">pending</option>
    <option value="cancel" <?php echo e($booking->status == 'cancel' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">cancel</option>
    <option value="confirmed" <?php echo e($booking->status == 'confirmed' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">confirmed</option>
    <option value="completed" <?php echo e($booking->status == 'completed' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">completed</option>
</select>
    </td>
    <td>
        <div class="upper-delete-btns d-flex">
            <a class="view-btn-eye" href="<?php echo e(route('admin.view.booking.detail', [$booking->id])); ?>">
                <i class="fa-solid fa-eye"></i>
            </a>
            <a class="edit-btn-eye" href="<?php echo e(route('admin.edit.booking.detail', $booking->id)); ?>">
                <i class="fa-solid fa-pen-to-square"></i>
            </a>
        </div>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/admin/booking/search_booking_user.blade.php ENDPATH**/ ?>