<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Bootstrap demo</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

    <!-- ===============owl============ -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="./assets/css/style.css">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/responsive.css')); ?>">
</head>

<body>


    <section>
        <div class="inner-login">
            <div class="row">
                <div class="col-lg-6">
                    <div class="inner-login-img">
                        <figure>
                            <img src="<?php echo e(asset('admin/images/login.png')); ?>" alt="">
                        </figure>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="upper-high-main">
                        <div class="inner-login-input-form">
                            <div class="inner-login-page">
                                <div class="inner-login-wrapper">
                                    <div class="logo-login">
                                        <img src="<?php echo e(asset('admin/images/login-logo.png')); ?>" alt="">
                                    </div>
                                    <h2>Login to your Account</h2>
                                </div>
                                <form class=" email-login" method="Post" action="<?php echo e(route('admin.login.submit')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-12 inner-main-input">
                                            <label for="email" class="form-label">Email Address</label>
                                            <input type="email" class="form-control"
                                                placeholder="Enter email address" id="email" name="email" >
                                        </div>
                                        <div class="col-md-12 inner-main-input mb-3">
                                            <label for="password" class="form-label">Password</label>
                                            <input type="password" class="form-control"
                                                placeholder="Enter Password" id="password" name="password">
                                        </div>
                                    </div>
                                    <div class=" remember-main-marg d-flex">
                                        <div class="">
                                            <div class="form-check check-s">
                                                <input class="form-check-input" type="checkbox" id="gridCheck">
                                                <label class="form-check-label" for="gridCheck">
                                                    Remember Me
                                                </label>
                                            </div>
                                        </div>
                                        <div class="">
                                            <div class="">
                                                <a class="forgot-pass" href="<?php echo e(route('admin.forgot.password.view')); ?>">Forgot Password?</a>
                                            </div>
                                        </div>
                                    </div>


                                    <button class="btn primary-btn w-100" type="submit">
                                        Login
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>



    <!-- jQuery -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <!-- jQuery Validation Plugin -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<script>
    $(document).ready(function () {
        $(".email-login").validate({
            rules: {
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                    minlength: 6
                }
            },
            messages: {
                email: {
                    required: "Please enter your email address",
                    email: "Please enter a valid email address"
                },
                password: {
                    required: "Please enter your password",
                    minlength: "Your password must be at least 8 characters long"
                }
            },
            errorElement: "span",
            errorPlacement: function (error, element) {
                error.addClass("text-danger");
                element.closest(".inner-main-input").append(error);
            },
            highlight: function (element) {
                $(element).addClass("is-invalid");
            },
            unhighlight: function (element) {
                $(element).removeClass("is-invalid");
            }
        });
    });
</script>


</body>

</html><?php /**PATH /home/deftsoft/Desktop/dachboxmiete/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>