<div class="inner-login">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="<?php echo e(asset('frontend/images/forget.png')); ?>" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="<?php echo e(asset('frontend/images/login-logo.png')); ?>" alt="">
                            </div>
                            <h2>Forget Your Password?</h2>
                            <p class="pls-enter">
                                Please enter your email address. You will receive a link to create a new password via email.
                            </p>
                        </div>
                        <form class="email-login" id="login-form" method="Post" action="<?php echo e(route('forgot.password')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-12 inner-main-input">
                                    <label for="inputEmail4" class="form-label">Email Address</label>
                                    <input type="email" class="form-control" name="email" placeholder="Enter email address" id="inputEmail4">
                                </div>
                            </div>
                            <button type="submit" class="btn primary-btn w-100">
                                Reset Password
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- jQuery and Plugins -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

<!-- Form Validation -->
<script>
    $(document).ready(function() {
        if (typeof $.fn.validate !== "undefined") {
            $("#login-form").validate({
                rules: {
                    email: {
                        required: true,
                        email: true,
                        remote: {
                            url: "<?php echo e(route('check.email')); ?>",
                            type: "GET",
                            data: {
                                email: function() {
                                    return $("input[name='email']").val();
                                }
                            }
                        }
                    }
                },
                messages: {
                    email: {
                        required: "Please enter your email address",
                        email: "Please enter a valid email address",
                         remote: "This email is not registered with us."
                    }
                },
                errorElement: "div",
                errorPlacement: function(error, element) {
                    error.addClass("invalid-feedback");
                    element.closest(".inner-main-input").append(error);
                },
                highlight: function(element) {
                    $(element).addClass("is-invalid");
                },
                unhighlight: function(element) {
                    $(element).removeClass("is-invalid");
                }
            });
        } else {
            console.error("jQuery Validation Plugin is not loaded!");
        }

        // Initialize Owl Carousel if present
        if ($.fn.owlCarousel) {
            $(".owl-carousel").owlCarousel({
                loop: true,
                margin: 10,
                nav: true,
                items: 1
            });
        } else {
            console.error("Owl Carousel is not loaded!");
        }
    });
</script>

<?php echo $__env->make('frontend.include.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/auth/forgot-password.blade.php ENDPATH**/ ?>