<?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<?php $__currentLoopData = $booking->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if(!$item->related_item): ?>

    <tr>
        <td>
            <?php if($item->vendor_id): ?>
                <span class="text-secondary me-1" title="Includes vendor items">
                    <i class="fa-solid fa-flag"></i>
                </span>
            <?php endif; ?>
            <?php echo e($item->booking_id ?? 'N/A'); ?>

            
             <?php if($item->user_timing): ?>
                <span class="text-primary me-1" title="Customer requested timing change">
                    <i class="fa-solid fa-flag"></i>
                </span>
            <?php endif; ?>

            <?php if($booking->delay || $item->damage): ?>
                <span class="text-danger me-1" title="Delay or Damage reported">
                    <i class="fa-solid fa-flag"></i>
                </span>
            <?php endif; ?>
        </td>
       
        <td><?php echo e($booking->userDetails->first_name . ' ' . $booking->userDetails->last_name ?? 'N/A'); ?></td>
        <td><?php echo e(preg_replace('/^(\+\d{0,2})(\d+)/', '$1 $2', $booking->userDetails->phone) ?? 'N/A'); ?></td>
        <td><?php echo e($booking->userDetails->email); ?></td>
        <td><?php echo e($activityCounts[$booking->id] ?? 0); ?></td>
        <td>
            <?php
                $reasons = \App\Models\ActivityLog::where('action', 'appointment_change')
                        ->where('description', 'like', '%booking #' . $booking->id . '%')
                        ->orderByDesc('created_at')
                        ->pluck('details');


            ?>
            
    
            <?php if($reasons->isNotEmpty()): ?>
                <?php echo $reasons->map(fn($r) => e($r))->implode(' / '); ?>

            <?php else: ?>
                -
            <?php endif; ?>
        </td>
        <td>
            <?php echo e($item->pickup_date ? \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') : '-'); ?> /
            <?php echo e($item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '-'); ?>

        </td>
        <td>
            <?php echo e($item->dropoff_date ? \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') : '-'); ?> /
            <?php echo e($item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '-'); ?>

        </td>
        <td>
            <?php echo e($item->new_dropoff_date ? \Carbon\Carbon::parse($item->new_dropoff_date)->format('d.m.Y') : '-'); ?> /
            <?php echo e($item->new_dropoff_time ? \Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i') : '-'); ?>

        </td>
        
        <td>
            <div class="upper-delete-btns d-flex">
                <a class="view-btn-eye" href="<?php echo e(route('admin.view.booking.detail', [$booking->id])); ?>">
                    <i class="fa-solid fa-eye"></i>
                </a>
                <a class="edit-btn-eye" href="<?php echo e(route('admin.edit.booking.detail', $booking->id)); ?>">
                    <i class="fa-solid fa-pen-to-square"></i>
                </a>
            </div>
        </td>
        <td>
            <select class="form-select select-active-block" 
            id="statusSelect<?php echo e($booking->id); ?>" 
            aria-label="Default select example" data-current-status="<?php echo e($booking->status); ?>"  <?php echo e($booking->refund_amount ? 'disabled' : ''); ?> disabled>
                <option value="pending" class="pending-op" <?php echo e($booking->status == 'pending' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">pending</option>
                <option value="cancelled" class="cancel-op" <?php echo e($booking->status == 'cancelled' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">Cancelled</option>
                <option value="confirmed" class="confirmed-op" <?php echo e($booking->status == 'confirmed' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">confirmed</option>
                <option value="completed" class="completed-op"  <?php echo e($booking->status == 'completed' ? 'selected' : ''); ?> data-previous-value="<?php echo e($booking->status); ?>">completed</option>
            </select>
        </td>
    </tr>
    <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
    <td colspan="7" class="text-center">No bookings found for selected date</td>
</tr>
<?php endif; ?>
<?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/admin/calendar/partials/booking_table.blade.php ENDPATH**/ ?>