<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>SPO Product List</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; 
            margin: 10mm; 
        }
    </style>
</head>
<body>


    <h1><?php echo app('translator')->get('messages.vendor_product_analytics_report'); ?></h1>
    <h2><?php echo e($vendor->business_name); ?></h2>
    <p><?php echo app('translator')->get('messages.generated_on'); ?>: <?php echo e(now()->format('d.m.Y')); ?></p>

    <table class="table">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('messages.id'); ?></th>
                <th><?php echo app('translator')->get('messages.product_name'); ?></th>
                <th><?php echo app('translator')->get('messages.category'); ?></th>
                <th><?php echo app('translator')->get('messages.sku'); ?></th>
                <th><?php echo app('translator')->get('messages.size_variation'); ?></th>
                <th><?php echo app('translator')->get('messages.color'); ?></th>
                <th><?php echo app('translator')->get('messages.total_quantity'); ?></th>
                <th><?php echo app('translator')->get('messages.remaining_quantity'); ?></th>
                <th><?php echo app('translator')->get('messages.dimensions'); ?></th>
                <th><?php echo app('translator')->get('messages.weight'); ?></th>
                <th><?php echo app('translator')->get('messages.volume'); ?></th>
                <th><?php echo app('translator')->get('messages.max_load'); ?></th>
                <th><?php echo app('translator')->get('messages.status'); ?></th>
                <th><?php echo app('translator')->get('messages.variant_status'); ?></th>
            </tr>

           
        </thead>
        <tbody>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($product->variations->isEmpty()): ?>
                    <tr>
                        <td><?php echo e($product->id); ?></td>
                        <td><?php echo e($product->name); ?></td>
                        <td><?php echo e($product->category->name ?? '-'); ?></td>
                        <td><?php echo e($product->sku ?? '-'); ?></td>
                        <td>-</td>
                        <td><?php echo e($product->color->name ?? '-'); ?></td>
                        <td>-</td>
                        <td><?php echo e($product->quantity ?? 0); ?></td>
                        <td><?php echo e($product->total_quantity ?? $product->quantity ?? 0); ?></td>
                        <td><?php echo e($product->length.'x'.$product->width.'x'.$product->height); ?></td>
                        <td><?php echo e($product->weight); ?></td>
                        <td><?php echo e($product->volume); ?></td>
                        <td><?php echo e($product->max_load); ?></td>
                        <td><?php echo e($product->status); ?></td>
                        <td>-</td>
                    </tr>
                <?php else: ?>
                    <?php $__currentLoopData = $product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $variation->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $vendorQty = $option->vendorQuantities->firstWhere('vendor_id', $vendor->id);
                                $isDisabled = in_array($variation->id, $disabledVariants);
                            ?>
                            <tr>
                                <td><?php echo e($product->id); ?></td>
                                <td><?php echo e($product->name); ?></td>
                                <td><?php echo e($product->category->name ?? '-'); ?></td>
                                <td><?php echo e($option->sku); ?></td>
                                <td><?php echo e($variation->size->name ?? $variation->variation->name ?? '-'); ?></td>
                                <td><?php echo e($option->color->name ?? '-'); ?></td>
                                <td><?php echo e($option->quantity ?? 0); ?></td>
                                <td><?php echo e($option->total_quantity ?? $option->quantity ?? 0); ?></td>
                                
                                <td><?php echo e($variation->length.'x'.$variation->width.'x'.$variation->height); ?></td>
                                <td><?php echo e($variation->weight); ?></td>
                                <td><?php echo e($variation->volume); ?></td>
                                <td><?php echo e($variation->max_load); ?></td>
                                <td><?php echo e($variation->status); ?></td>
                                <td><?php echo e($isDisabled ? 'Disabled' : 'Enabled'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/vendor/product/pdf.blade.php ENDPATH**/ ?>