<?php $__env->startSection('content'); ?>

<main>

    <div class="navigation-main">
        <div class="container">
            <div class="navigat">
                <a href="/"><?php echo e(__('messages.home')); ?></a>
                <a href="/product"><?php echo e($product->name); ?></a>
                <a class="prod-name active" href=""><?php echo e(($product->brand->name ?? '') . ' ' . ($product->name ?? '')); ?></a>

                
            </div>
        </div>
    </div>

    <section class="detail-show-all comn-padd-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="inner-crousel-product">
                        <div class="slider-main-left">
                            <div class="slider-inner-detail row">
                                <?php
                                    $mainImage = $product->images->firstWhere('type', 'main');
                                    $galleryImages = $product->images->where('type', 'gallery');
                                    $infoImage = $product->images->firstWhere('type','info');
                                    $allImages = collect();
                                    if ($mainImage) {
                                        $allImages->push($mainImage);
                                    }
                                    $allImages = $allImages->merge($galleryImages);
                                ?>
                            
                                <div class="col-2 p-0 padd-st">
                                    <div class="slider-nav">
                                        <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="main-img-slider-nav">
                                                <figure>
                                                    <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" alt="Product Thumbnail">
                                                </figure>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                
                                <div class="col-10">
                                    <div class="slider-for main-slider-for">
                                        <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="main-img-slider-for">
                                                <figure>
                                                    <img src="<?php echo e(asset('storage/' . $image->image_path)); ?>" alt="Product Image">
                                                </figure>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="insuranc-show-all">
                        <?php $__currentLoopData = $product->otherInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="main-show-insuranc mb-0">
                                <img src="<?php echo e(asset('storage/' . $info->image_path)); ?>" alt="Other Info Image">
                                <p><?php echo e($info->description); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <?php if(!empty($infoImage) && !empty($infoImage->image_path)): ?>
                    <div class="main-img-detail-one">
                        <figure>
                            <img src="<?php echo e(asset('storage/' . $infoImage->image_path)); ?>" alt="Info Thumbnail">
                        </figure>
                    </div>
                <?php endif; ?>

                </div>
                <div class="col-lg-6">
                    <div class="inner-data-detail">
                        <div class="head-disc">
                            <h3><?php echo e($product->name); ?></h3>
                            <h6 class="brand-name-detail"><?php echo e(__('messages.brand')); ?> : <?php echo e($product->brand->name??''); ?></h6>
                            <p><?php echo e($product->description ?? 'N/A'); ?></p>
                        </div>

                        <div class="price-detail-main">
                            <div class="price-big d-flex">
                                <h3><?php echo e($product->first_price); ?></h3>
                                <a href="javascript:void()" data-bs-toggle="modal" data-bs-target="#exampleModal"><?php echo e(__('messages.view_price_breakdown')); ?></a>
                            </div>
                            <p><?php echo e(__('messages.per_day_incl_vat')); ?></p>
                        </div>

                        <div class="pick-location">
                            <h3><?php echo e(__('messages.pickup_location')); ?></h3>
                            <div class="pick-locati-name-icon d-flex">
                                <img src="<?php echo e(asset('frontend/images/loct.png')); ?>" alt="">
                                <p>Esperantostr. 10, 70197 Stuttgart</p>
                            </div>
                        </div>
                        <div class="choose-car">
                            <h3><?php echo e(__('messages.choose_your_car')); ?></h3>
                            <form id="car-form">
                                <div class="row">
                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.manufacturer')); ?></label>
                                        <select class="form-select" id="manufacturer" name="manufacturer">
                                            <option selected disabled><?php echo e(__('messages.select')); ?></option>
                                            <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($manufacturer); ?>"><?php echo e($manufacturer); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.model')); ?></label>
                                        <select class="form-select" id="model" name="model" disabled></select>
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.year_of_make')); ?></label>
                                        <select class="form-select" id="year" name="year" disabled></select>
                                    </div>

                                  

                                    <div class="col-md-6 inner-main-input">
                                        <label><?php echo e(__('messages.trailer_hitch')); ?></label>
                                        <select class="form-select" id="trailer_hitch" name="trailer_hitch" 
                                                data-product-name="<?php echo e($product->name); ?>">
                                            <option value="" selected disabled>Select</option>
                                            <option value="yes"><?php echo e(__('messages.yes')); ?></option>
                                            <option value="no"><?php echo e(__('messages.no')); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div id="result" class="mt-3"></div>
                            </form>
                        </div>
                        <input id="railing_type" hidden value="<?php echo e($product->railing_type); ?>" />
                        <?php if($product->railing_type): ?>
                        <div class="railing-type">
                            <h3><?php echo e(__('messages.railing_type')); ?></h3>
                            <p><?php echo e(__('messages.railing_type_description')); ?></p>
                        </div>
                        
                        <div id="roof-types-container" style="display: none;">
                            <?php $__currentLoopData = $roofTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roofType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="roof-name-detail" id="roof-type-<?php echo e(Str::slug($roofType)); ?>">
                                    <figure>
                                        <?php
                                            $imageName = strtolower(str_replace(' ', '-', $roofType)) . '.jpg';
                                        ?>
                                        <img src="<?php echo e(asset('frontend/images/' . $imageName)); ?>" alt="<?php echo e($roofType); ?>">
                                    </figure>
                                    <h4><?php echo e($roofType); ?></h4>
                                    <?php if($roofType == 'Normal Roof'): ?>
                                    <p>A smooth roof surface without side mounts or rails</p>
                                    <?php elseif($roofType == 'Normal roof without glass roof'): ?>
                                    <p>A smooth roof surface without side mounts or rails</p>
                                    <?php elseif($roofType == 'Normal Roof with glass roof'): ?>
                                    <p>A smooth roof surface without side mounts or rails and with a glass roof</p>
                                    <?php elseif($roofType == 'Fixpoints'): ?>
                                    <p>A car roof with fixed points has integrated mounting points for roof racks</p>
                                    <?php elseif($roofType == 'Fixpoints without glass roof'): ?>
                                    <p>A car roof with fixed points has integrated mounting points for roof racks</p>
                                    <?php elseif($roofType == 'Fixpoints with glass roof'): ?>
                                    <p>A car roof with fixed points has integrated mounting points for roof racks and with a glass roof</p>
                                    <?php elseif($roofType == 'Integrated Roof Railing'): ?>
                                    <p>A car roof with flush roof rails features low-profile, seamlessly integrated rails</p>
                                    <?php elseif($roofType == 'Elevated Roof Rails'): ?>
                                    <p>A car roof with open rails has mounted roof rails raised above the roof surface </p>
                                    <?php elseif($roofType == 'T-Profile'): ?>
                                    <p>A car roof with a T-slot profile has integrated T-slots for mounting roof racks </p>
                                    <?php elseif($roofType == 'Raingutter'): ?>
                                    <p>A car roof with a rain gutter has side channels for water drainage and roof rack mounting</p>
                                    <?php endif; ?>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                        <div class="choose-rental-period">
                            <h3><?php echo e(__('messages.choose_rental_period')); ?></h3>
                            <p><?php echo e(__('messages.add_rental_period_description')); ?></p>
                            <form class=" email-login">
                                <div class="row">
                                    <div class="col-md-12 inner-main-input">
                                        <label for="inputEmail4" class="form-label"><?php echo e(__('messages.from')); ?></label>
                                        <input class="form-control"  id="rental_from">
                                    </div>
                                    <div class="col-md-12 inner-main-input">
                                        <label for="inputEmail4" class="form-label"><?php echo e(__('messages.to')); ?></label>
                                        <input class="form-control"  id="rental_to">
                   
                                        
                                    </div>
                                </div>
                            </form>


                            
                        </div>
                        <input type="hidden" name="insurance_selected" id="insurance_selected" value="0">
                        <input type="hidden" name="roof_rack_selected" id="roof_rack_selected" value="0">
                        <?php
                            $preferredOrder = ['Black', 'Titan', 'Silver', 'Anthrazite', 'White'];
                            $sortedColors = collect($preferredOrder)
                                ->map(fn($name) => $colors->firstWhere('name', $name))
                                ->filter(); // remove nulls if any color is missing
                        ?>
                        <div class="choose-color">
                            <div class="choose-car">
                                <h3 class="mb-2"><?php echo e(__('messages.choose_color')); ?></h3>
                                <form class="email-login">
                                    <div class="row">
                                        <div class="col-md-12 inner-main-input">
                                            <select class="form-select" id="color-select" aria-label="Default select example">
                                                <option selected>Select</option>
                                                <?php $__currentLoopData = $sortedColors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($color->id); ?>" 
                                                            data-color-name="<?php echo e($color->name); ?>">
                                                        <?php echo e($color->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                      
                        <div class="size-cards">
                            <h3><?php echo e(__('messages.size_variations')); ?></h3>
                            <div class="row row-gap-4" id="size-container">
                                <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4">
                                        <div class="inner-size-card" 
                                             data-size-id="<?php echo e($size->id); ?>"
                                             data-size-name="<?php echo e($size->name); ?>">
                                            <div class="upper-img-sunroof">
                                                <?php if($product->name == 'Roof Box'): ?>
                                                <figure>
                                                    <img src="<?php echo e(asset('frontend/images/' . $size->name . '.png')); ?>" alt="">
                                                </figure>
                                                <?php elseif($product->name == 'Rear Box'): ?>
                                                <figure>
                                                    <img src="<?php echo e(asset('frontend/images/rear-box.png')); ?>" alt="">
                                                </figure>
                                                <?php endif; ?>
                                            </div>
                                            <div class="size-sunreef">
                                                <?php 
                                                    if($size->name == 'S'){
                                                        $text = ' >400l';
                                                    }else if($size->name == 'M'){
                                                        $text = ' 400l - 420l';
                                                    }else if($size->name == 'L'){
                                                        $text = ' 450l - 480l';
                                                    }else if($size->name == 'XL'){
                                                        $text = ' 500l - 524l';
                                                    }else{
                                                        $text = ' 600l';
                                                    }
                                                ?>
                                                <p><?php echo e($size->name . $text); ?></p>
                                                <span class="badge bg-secondary"><?php echo e(__('messages.select_color_first')); ?></span>
                                                <span class="recommended bg-secondary d-none"></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4">
                                        <div class="inner-size-card" 
                                             data-variation-id="<?php echo e($variation->id); ?>"
                                             data-size-name="<?php echo e($variation->name); ?>">
                                             <div class="upper-img-sunroof">
                                                <?php if($product->name == 'Roof Bike Carrier'): ?>
                                                <figure>
                                                    <img src="<?php echo e(asset('frontend/images/roof-bike.png')); ?>" alt="">
                                                </figure>
                                                <?php elseif($product->name == 'Clutch Bike Carrier'): ?>
                                                <figure>
                                                    <img src="<?php echo e(asset('frontend/images/' . $variation->name . '.png')); ?>" alt="">
                                                </figure>
                                                <?php endif; ?>
                                            </div>
                                            <div class="size-sunreef">
                                                <p><?php echo e($variation->name); ?></p>
                                                <span class="badge bg-secondary"><?php echo e(__('messages.select_color_first')); ?></span>
                                                <span class="recommended bg-secondary d-none"></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="select-main-detail d-flex mt-4">
                            <div class="">
                                 
                                <?php if($product->name == 'Roof Box' || $product->name == 'Roof Bike Carrier'): ?>
                                <div class="form-check mb-1">
                                    <input class="form-check-input" type="checkbox" id="roof_rack_checkbox" checked>
                                    <label class="form-check-label" for="gridCheck">
                                        <?php echo e(__('messages.roof_rack_included')); ?>

                                    </label>
                                </div>
                                <?php endif; ?>
                               
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox"  id="insurance_checkbox" checked>
                                    <label class="form-check-label" for="gridCheck1">
                                        <?php echo e(__('messages.insurance_label')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="calculated-rent">
                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <h3><?php echo e(__('messages.calculated_rent')); ?></h3>

                                    <p class="text-calc-rent d-none" id="withinsurance">(<?php echo e(__('messages.calculated_rent_with_insurance')); ?>)
                                    </p>
                                    <p class="text-calc-rent" id="withoutinsurance">(<?php echo e(__('messages.calculated_rent_without_insurance')); ?>)
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <div class="inner-number-days">
                                        <p><?php echo e(__('messages.number_of_days')); ?>: <span> </span>

                                        </p>
                                        <p class="mb-0"><?php echo e(__('messages.total_rent')); ?>: <span></span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div id="errorMessage" class=""></div>
                        
                        <form id="bookingForm" action="<?php echo e(route('cart.add')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>" id="product_id">
                            <input type="hidden" name="product_name" value="<?php echo e($product->name); ?>" id="product_name">
                            <input type="hidden" name="manufacturer" id="hidden_manufacturer">
                            <input type="hidden" name="car_year" id="hidden_car_year">
                            <input type="hidden" name="model" id="hidden_model">
                            <input type="hidden" name="trailer_hitch" id="hidden_trailer_hitch">
                            <input type="hidden" name="roof_type" id="hidden_roof_type">
                            <input type="hidden" name="color_id" id="hidden_color_id">
                            <input type="hidden" name="color_name" id="hidden_color_name">
                            <input type="hidden" name="size_id" id="hidden_size_id">
                            <input type="hidden" name="size_name" id="hidden_size_name">
                            <input type="hidden" name="rental_from" id="hidden_rental_from">
                            <input type="hidden" name="rental_to" id="hidden_rental_to">
                            <input type="hidden" name="days" id="hidden_days">
                            <input type="hidden" name="calculated_rent" id="hidden_calculated_rent">
                            <input type="hidden" name="is_carrier_included" id="hidden_is_carrier_included">
                            <input type="hidden" name="is_insured" id="hidden_is_insured">
                            
                            <button type="submit" class="mt-4 w-100 btn primary-btn"><?php echo e(__('messages.rent_now')); ?></button>
                        </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="comn-padd-100 faq-detail">
        <div class="inner-privacy-content">
            <div class="container">
                <div class="inner-faq">
                    <h2 class="head-faq"><?php echo e(__('messages.additional_info')); ?></h2>
                    <div class="accordion" id="accordionExample">
                        <!-- Available Models Section -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    <?php echo e(__('messages.available_models')); ?>

                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <?php $__currentLoopData = $product->models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <h6><?php echo e($index + 1); ?>. <?php echo e($model['title'] ?? ''); ?></h6>
                                            <p><?php echo e($model['description'] ?? ''); ?></p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Dimensions -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    <?php echo e(__('messages.dimensions')); ?>

                                </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="dimensionsText"><?php echo e(__('messages.select_size_dimensions')); ?></p>
                                        <ul id="dimensionsList" style="display:none;">
                                            <li><?php echo e(__('messages.length')); ?>: <span id="dimensionLength"></span> cm</li>
                                            <li><?php echo e(__('messages.width')); ?>: <span id="dimensionWidth"></span> cm</li>
                                            <li><?php echo e(__('messages.height')); ?>: <span id="dimensionHeight"></span> cm</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Weight -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    <?php echo e(__('messages.weight')); ?>

                                </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="weightText"><?php echo e(__('messages.select_size_weight')); ?></p>
                                        <ul id="weightList" style="display:none;">
                                            <li><?php echo e(__('messages.weight')); ?>: <span id="weightValue"></span> kg</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Volume -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                    <?php echo e(__('messages.volume')); ?>

                                </button>
                            </h2>
                            <div id="collapsefour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="volumeText"><?php echo e(__('messages.select_size_volume')); ?></p>
                                        <ul id="volumeList" style="display:none;">
                                            <li><?php echo e(__('messages.volume')); ?>: <span id="volumeValue"></span> liters</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Max Load -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    <?php echo e(__('messages.max_load')); ?>

                                </button>
                            </h2>
                            <div id="collapsefive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="maxLoadText"><?php echo e(__('messages.select_size_max_load')); ?></p>
                                        <ul id="maxLoadList" style="display:none;">
                                            <li><?php echo e(__('messages.max_load')); ?>: <span id="maxLoadValue"></span> kg</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                    </div> <!-- .accordion -->
                </div> <!-- .inner-faq -->
            </div>
        </div>
    </section>

    <?php echo $__env->make('frontend.include.subscribe_news', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="comn-padd-100 related-product-detail">
        <div class="container">
            <div class="products-main-wrapper">
                <h2 class="related-prod"><?php echo e(__('messages.related_products')); ?></h2>
                <div class="row row-gap-4">
                    <?php $__empty_1 = true; $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $mainImage = $relatedProduct->images->firstWhere('type', 'main');
                        ?>
                        
                        <div class="col-lg-4">
                            <div class="product-main-one">
                                <div class="upper-imag-product-card">
                                    <figure>
                                        <?php if($mainImage): ?>
                                            <img src="<?php echo e(asset('storage/' . $mainImage->image_path)); ?>" alt="<?php echo e($relatedProduct->name); ?>">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('frontend/images/default-product.png')); ?>" alt="Default product image">
                                        <?php endif; ?>
                                    </figure>
                                </div>
                                <div class="product-detail-name-card">
                                    <h3><?php echo e($relatedProduct->name); ?></h3>
                                    <p><?php echo e(__('messages.from')); ?> <?php echo e($relatedProduct->first_price); ?></p>
                                    <a href="<?php echo e(route('product.details', ['slug' => $relatedProduct->category->slug ?? 'default'])); ?>" class="btn rent-btn">
                                        <?php echo e(__('messages.rent_now')); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <p><?php echo e(__('messages.no_related_products')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    
    <section class="touch-with-us comn-padd">
        <div class="container">
            <div class="inner-touch-contact product-detail-touch">
                <div class="row">
                    <div class="col-md-7">
                        <div class="inner-form-touch">
                            <h2><?php echo e(__('messages.get_in_touch')); ?></h2>
                            <form class="row" id="contactForm" method="post" action="<?php echo e(route('contact.store')); ?>">
                                <?php echo csrf_field(); ?>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="name" class="form-label"><?php echo e(__('messages.name')); ?></label>
                                        <input type="text" name="name" id="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.enter_your_name')); ?>" value="<?php echo e(old('name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="email" class="form-label"><?php echo e(__('messages.email')); ?></label>
                                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.enter_your_email')); ?>" id="email" name="email" value="<?php echo e(old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="contact-number" class="form-label"><?php echo e(__('messages.contact_number')); ?></label>
                                        <input type="tel" class="form-control <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.enter_your_contact_number')); ?>" id="contact-number" name="number" value="<?php echo e(old('number')); ?>">
                                        <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="message" class="form-label"><?php echo e(__('messages.message')); ?></label>
                                        <textarea class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('messages.leave_a_comment')); ?>" id="message" name="message" style="height: 135px"><?php echo e(old('message')); ?></textarea>
                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
    
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('messages.send_message')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="inner-figure-contact">
                            <figure class="fig-main-img-touch">
                                <img src="<?php echo e(asset('frontend/images/touch.png')); ?>" alt="">
                            </figure>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
</main>



<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel"><?php echo e(__('messages.not_bookable_title')); ?></h5>
                <p><?php echo e(__('messages.not_bookable_message')); ?></p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal"><?php echo e(__('messages.ok')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier"><?php echo e(__('messages.carrier_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.carrier_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn"><?php echo e(__('messages.rent_carrier')); ?></button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn"><?php echo e(__('messages.bring_own_carrier')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance"><?php echo e(__('messages.insurance_disclaimer_title')); ?></h5>
                <p><?php echo e(__('messages.insurance_disclaimer_message')); ?></p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn"><?php echo e(__('messages.yes_insure_me')); ?></button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn"><?php echo e(__('messages.no_insurance')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title modal-guest"><?php echo e(__('messages.login_modal_title')); ?></h5>
                <a href="javascript:void(0);" class="w-100 btn primary-btn" onclick="saveFormDataAndRedirect('/login')">
                    <?php echo e(__('messages.login_modal_title')); ?>

                </a>
                <div class="">
                    <div class="dont-acount">
                        <p><?php echo e(__('messages.dont_have_account')); ?></p>
                    </div>
                    <a href="javascript:void(0);" class="w-100 btn primary-outline-btn" onclick="saveFormDataAndRedirect('/registration')">
                        <?php echo e(__('messages.create_account')); ?>

                    </a>
                </div>
                <div class="dont-acount">
                    <p><?php echo e(__('messages.or')); ?></p>
                </div>
                <button class="w-100 btn primary-outline-btn" data-bs-target="#guestModal" data-bs-toggle="modal">
                    <?php echo e(__('messages.continue_with_guest')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2"><?php echo e(__('messages.guest_title')); ?></h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label"><?php echo e(__('messages.first_name')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_first_name')); ?>" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label"><?php echo e(__('messages.surname')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_surname')); ?>" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label"><?php echo e(__('messages.phone_number')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(__('messages.enter_phone_number')); ?>" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label"><?php echo e(__('messages.email')); ?></label>
                            <input type="email" class="form-control" placeholder="<?php echo e(__('messages.enter_email')); ?>" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn primary-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        <?php echo e(__('messages.back')); ?>

                    </button>
                    <button class="btn primary-outline-btn" id="continueAsGuest">
                        <?php echo e(__('messages.continue')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3><?php echo e(__('messages.our_rental_price')); ?></h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th><?php echo e(__('messages.days')); ?></th>
                                <th><?php echo e(__('messages.price')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $dailyPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__('messages.day_label', ['number' => $index + 1])); ?></td>
                                    <td><?php echo e(number_format($price, 2, ',', '.')); ?> €</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
var baseUrl = '';
function parseDMY(dateStr) {
        const [day, month, year] = dateStr.split('.');
        const fullYear = parseInt(year) < 100 ? 2000 + parseInt(year) : parseInt(year);
        return new Date(fullYear, parseInt(month) - 1, parseInt(day));
    }
function saveFormDataAndRedirect(redirectUrl) {

    let rentalFromStr = $('#rental_from').val();
    let rentalToStr = $('#rental_to').val();

    let rentalFrom = parseDMY(rentalFromStr);
    let rentalTo = parseDMY(rentalToStr);

    let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
    let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
    let formData = {
        product_id: $('#product_id').val(),
        product_name: $('#product_name').val(),
        manufacturer: $('#manufacturer').val(),
        car_year: $('#year').val(),
        model: $('#model').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: selectedRecommendation?.rooftype_eng || '',
        carrier_length: selectedRecommendation?.carrier_length || '',
        foot_sku: selectedRecommendation?.foot_sku || '',
        footkit_sku: selectedRecommendation?.footkit_sku || '',
        bundle_name: selectedRecommendation?.bundle_name || '',
        color_id: $('#color-select').val(),
        color_name: $('#color-select option:selected').data('color-name'),
        size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
        size_name: $('.inner-size-card.selected').data('size-name'),
        rental_from: $('#rental_from').val(),
        rental_to: $('#rental_to').val(),
        days: days,
        calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
        is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
        is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0
    };
    formData._token = $('meta[name="csrf-token"]').attr('content');


    $.post(`${baseUrl}/store-rental-form`, formData, function() {
        window.location.href = redirectUrl; 
    });
}

$('#manufacturer').change(function() {
    $('#model').prop('disabled', true).html('<option>Loading...</option>');
    $('#year').prop('disabled', true).html('<option>Select</option>');
    
    let manufacturer = $(this).val();

    $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
        $('#model').prop('disabled', false).html('<option selected disabled>Select</option>');
        data.forEach(model => {
            $('#model').append(`<option value="${model}">${model}</option>`);
        });
    });
});

$('#model').change(function() {
    $('#year').prop('disabled', true).html('<option>Loading...</option>');
    
    let manufacturer = $('#manufacturer').val();
    let model = $(this).val();

    $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
        $('#year').prop('disabled', false).html('<option selected disabled>Select</option>');
        data.forEach(year => {
            $('#year').append(`<option value="${year}">${year}</option>`);
        });
    });
});



// $('#color-select').change(function() {
//     const colorId = $(this).val();
//     const colorName = $(this).find('option:selected').data('color-name');
    
//     if (!colorId) {
//         $('.inner-size-card').removeClass('available unavailable');
//         $('.inner-size-card .badge')
//             .removeClass('bg-success bg-danger')
//             .addClass('bg-secondary')
//             .text('Select color first');
//         return;
//     }
    
//     $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/availability`, { color_id: colorId }, function(availability) {
//         $('.inner-size-card').each(function() {
//             const $card = $(this);
//             const sizeName = $card.data('size-name');
//             const sizeId = $card.data('size-id') || $card.data('variation-id');
//             const isAvailable = availability[sizeId] > 0;
            
//             $card.toggleClass('available', isAvailable)
//                  .toggleClass('unavailable', !isAvailable);
                 
//             const $badge = $card.find('.badge');
//             $badge.removeClass('bg-secondary bg-success bg-danger')
//                   .addClass(isAvailable ? '' : 'bg-danger')
//                   .text(isAvailable ? '' : 'Unavailable');
//         });
        
//         if (window.currentRecommendation) {
//             highlightRecommendedSizes(window.currentRecommendation);
//         }
//     });
// });
function checkAvailability(colorId,colorName) {
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    
    const params = {
        color_id: colorId,
        from_date: fromDate,
        to_date: toDate,
        color_name : colorName
    };

    if(!fromDate || !toDate ||  !colorId){
        return; 
    }
    
    $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/availability`, params, function(availability) {
        $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            const isAvailable = availability[sizeId] > 0;
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? '' : 'Unavailable');
        });
        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }
    });
}

$('#rental_from, #rental_to').on('change', function() {

    const colorId = $('#color-select').val();
    const colorName = $('#color-select option:selected').data('color-name');
    console.log(colorId)
    if (colorId && colorId !== 'Select') {
        checkAvailability(colorId,colorName);
    }
});

// Update color select change handler
$('#color-select').on('change', function() {
    const colorId = $(this).val();
    const colorName = $('#color-select option:selected').data('color-name');
    console.log(colorName)
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    $('#errorMessage').empty();
    if (colorId && colorId !== 'Select' && fromDate && toDate) {
        checkAvailability(colorId,colorName);
    }
});

// function highlightRecommendedSizes(recommendation) {
//     $('.inner-size-card').removeClass('recommended-size');
    
//     recommendation.forEach(item => {
//         $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`)
//             .addClass('recommended-size');
//     });
// }



function highlightRecommendedSizes(recommendation) {
        $('.inner-size-card').removeClass('recommended-size');
        $('.recommended').addClass('d-none')
    recommendation.forEach(item => {
        const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
        $card.addClass('recommended-size');
        console.log(item)
        $card.find('.recommended').removeClass('d-none');
            $card.find('.recommended').text('Recommended');
    });
}

var railing_type = $('#railing_type').val();
console.log('railing_type',railing_type)
$('#year, #trailer_hitch').change(function() {
    let manufacturer = $('#manufacturer').val();
    let year = $('#year').val();
    let model = $('#model').val();
    let trailer_hitch = $('#trailer_hitch').val();


    const productName = $('#trailer_hitch').data('product-name');
    const selectedValue = $('#trailer_hitch').val();
    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier');
    if (selectedValue === 'no' && hitchRequired) {
        $('#trailer_hitch').val('');

        const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
        modal.show();
        return ;
    }


    if (manufacturer && year && model && trailer_hitch) {
        $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
            window.currentRecommendation = data;
            window.currentRecommendationMap = {};

            if (data.length === 0) {
                $('#result').html('<p>No recommendations found.</p>');
                return;
            }

            $('.roof-name-detail').hide();
            $('#roof-types-container').show();

            

            data.forEach((item, index) => {
                const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

               console.log('roofTypeSlug',roofTypeSlug)
                if(railing_type){
                    $(`#roof-type-${roofTypeSlug}`).show();
    
                    window.currentRecommendationMap[roofTypeSlug] = item;
                    $(`#roof-type-${roofTypeSlug}`)
                        .addClass('clickable-roof')
                        .attr('data-rooftype-slug', roofTypeSlug);
                }
            });

            $('#result').html(html);
            highlightRecommendedSizes(data);
        });
    }
});

let selectedRecommendation = null;

$(document).on('click', '.clickable-roof', function () {
    $('.clickable-roof').removeClass('selected');
    $(this).addClass('selected');

    const slug = $(this).data('rooftype-slug');
    selectedRecommendation = window.currentRecommendationMap[slug];

    $('#roof-types-container .invalid-feedback').remove();
});



$(document).on('click', '.inner-size-card', function () {

    const colorId = $('#color-select').val();
    const colorName = $('#color-select').find('option:selected').data('color-name');
    if (!colorName) {
        $('#errorMessage').html(`
            <div class="text-danger mt-2">
                Please select a color first.
            </div>
        `);
        return;
    }


    const $card = $(this);
    const isAvailable = $card.hasClass('available');
    const isUnavailable = $card.hasClass('unavailable');

    $('.inner-size-card').removeClass('selected');
    $('#errorMessage').empty();

    $card.addClass('selected');

    if (isUnavailable) {
        const message = `
            <div class="size-unavailable-message text-danger mt-2">
                The product you have selected is currently unavailable, but you can send a request and we will let you know when it is available.
            </div>
        `;
        $('#errorMessage').html(message);
    }

    const sizeId = $(this).data('size-id');
    const variationId = $(this).data('variation-id');
    const sizeName = $(this).data('size-name');

    $.get(`${baseUrl}/product/<?php echo e($product->id); ?>/size-details`, {
        size_id: sizeId,
        variation_id: variationId
    }, function(data) {
        if (data) {
            if (data.length && data.width && data.height) {
                $('#dimensionsText').hide();
                $('#dimensionsList').show();
                $('#dimensionLength').text(data.length);
                $('#dimensionWidth').text(data.width);
                $('#dimensionHeight').text(data.height);
            } else {
                $('#dimensionsText').show().text('Dimensions not available for this size');
                $('#dimensionsList').hide();
            }

            if (data.weight) {
                $('#weightText').hide();
                $('#weightList').show();
                $('#weightValue').text(data.weight);
            } else {
                $('#weightText').show().text('Weight not available for this size');
                $('#weightList').hide();
            }

            if (data.volume) {
                $('#volumeText').hide();
                $('#volumeList').show();
                $('#volumeValue').text(data.volume);
            } else {
                $('#volumeText').show().text('Volume not available for this size');
                $('#volumeList').hide();
            }

            if (data.max_load) {
                $('#maxLoadText').hide();
                $('#maxLoadList').show();
                $('#maxLoadValue').text(data.max_load);
            } else {
                $('#maxLoadText').show().text('Max load not available for this size');
                $('#maxLoadList').hide();
            }
        } else {
            $('#dimensionsText').show().text('Product details not available for this size');
            $('#dimensionsList').hide();
            $('#weightText').show().text('Product details not available for this size');
            $('#weightList').hide();
            $('#volumeText').show().text('Product details not available for this size');
            $('#volumeList').hide();
            $('#maxLoadText').show().text('Product details not available for this size');
            $('#maxLoadList').hide();
        }
    }).fail(function() {
        $('#dimensionsText').show().text('Error loading product details');
        $('#weightText').show().text('Error loading product details');
        $('#volumeText').show().text('Error loading product details');
        $('#maxLoadText').show().text('Error loading product details');
    });

});

$('.roof-name-detail').hide();
$('#roof-types-container').hide();
    const dailyPrices = <?php echo json_encode($dailyPrices, 15, 512) ?>;
    const roofRackPrices = <?php echo json_encode($roofRackPrices, 15, 512) ?>; 
    const insuranceFlatFee = 25.00;
  

    function calculateRent() {
        // const from = new Date($('#rental_from').val());
        // const to = new Date($('#rental_to').val());


        const from = parseDMY($('#rental_from').val());
        const to = parseDMY($('#rental_to').val());

        if (isNaN(from) || isNaN(to) || to < from) return;

        const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

        let totalRent = 0;

        for (let i = 0; i < days && i < dailyPrices.length; i++) {
            totalRent += dailyPrices[i];

            if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                console.log('totalRent', totalRent)
                totalRent += roofRackPrices[i];
            }
        }

        if ($('#insurance_checkbox').is(':checked')) {
            totalRent += insuranceFlatFee;
            $('#withinsurance').removeClass('d-none');
            $('#withoutinsurance').addClass('d-none');
        }else{
            $('#withoutinsurance').removeClass('d-none');
            $('#withinsurance').addClass('d-none');
        }

        $('.inner-number-days span:first').text(days);
        $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
    }

    $('#rental_from, #rental_to').on('change', calculateRent);


</script>

<script>
    $('#insurance_checkbox').on('change', function () {
        $('#insurance_selected').val(this.checked ? 1 : 0);
    });

    $('#roof_rack_checkbox').on('change', function () {
        $('#roof_rack_selected').val(this.checked ? 1 : 0);
    });



    $(document).ready(function() {

        $('#roof_rack_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#insurance_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#rentCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', true).trigger('change');
            $('#notCarrier').modal('hide');
        });

        $('#bringOwnCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', false);
            $('#notCarrier').modal('hide');
            calculateRent(); 
        });

        $('#wantInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', true).trigger('change');
            $('#notInsurance').modal('hide');
        });

        $('#noInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', false);
            $('#notInsurance').modal('hide');
            calculateRent(); 
        });
    function validateForm() {
        let isValid = true;

        // Reset all error states
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        // Validate required fields
        if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), 'Please enter Manufacturer');
            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), 'Please enter Year ');
            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), 'Please enter Model ');
            isValid = false;
        }
        
        // Trailer hitch validation
        const productName = $('#trailer_hitch').data('product-name');
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier');
        if (hitchRequired && !$('#trailer_hitch').val()) {
            showError($('#trailer_hitch'), 'Trailer hitch selection is required for this product');
            isValid = false;
        }
        
        // Color validation
        if (!$('#color-select').val()) {
            showError($('#color-select'), 'Please enter Color ');
            isValid = false;
        }
        
        // Size validation
        if (!$('.inner-size-card.selected').length) {
            $('#size-container').after('<div class="invalid-feedback d-block">Please enter Size </div>');
            isValid = false;
        }
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), 'Please enter Start date ');
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), 'Please enter End date ');
            isValid = false;
        } 
        
        if ($('#rental_from').val() && $('#rental_to').val()) {
            // const from = new Date($('#rental_from').val());
            // const to = new Date($('#rental_to').val());

            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());
            if (to < from) {
                showError($('#rental_to'), 'End date must be after start date');
                isValid = false;
            }
        }

        if($('#errorMessage').text()){
            isValid = false;
        }
        
        return isValid;
    }

    function showError(element, message) {
        element.addClass('is-invalid');
        if (element.is('select')) {
            element.parent().append(`<div class="invalid-feedback">${message}</div>`);
        } else {
            element.after(`<div class="invalid-feedback">${message}</div>`);
        }
    }

    $('#manufacturer, #year, #model, #trailer_hitch, #color-select, #rental_from, #rental_to').on('input change', function() {
        $(this).removeClass('is-invalid');
        $(this).next('.invalid-feedback').remove();
        $(this).parent().find('.invalid-feedback').remove();
    });
    $('.inner-size-card').on('click', function() {
        $('.invalid-feedback.d-block').remove();
    });

    $('#bookingForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        <?php if(auth()->guard()->check()): ?>
        if (validateForm()) {
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                bundle_name: selectedRecommendation?.bundle_name || '',
                color_id: $('#color-select').val(),
                color_name: $('#color-select option:selected').data('color-name'),
                size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                size_name: $('.inner-size-card.selected').data('size-name'),
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0
            };

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        for (const field in errors) {
                            showError($(`#${field}`), errors[field][0]);
                        }
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
        }
        <?php else: ?>
            if(validateForm()){
                e.preventDefault();
                $('#guestOptionsModal').modal('show');

            }
        <?php endif; ?>
    });

    $('#continueAsGuest').click(function() {
        const name = $('#firstname').val().trim();
        const surname = $('#surname').val().trim();
        const email = $('#firstemail').val().trim();
        const number = $('#number').val();

      let isValid = true;

      $('#firstname, #surname, #firstemail,#number').removeClass('is-invalid');

      if (name === '') {
        $('#firstname').addClass('is-invalid');
        isValid = false;
      }

      
      if (surname === '') {
        $('#surname').addClass('is-invalid');
        isValid = false;
      }

      if(number === ''){
        $('#number').addClass('is-invalid');
        isValid = false;
      }

      const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (email === '' || !emailPattern.test(email)) {
        $('#firstemail').addClass('is-invalid');
        isValid = false;
      }

      if (isValid) {
      
        // $('#guestModal').modal('hide');

      }
        // $('#guestModal').modal('hide');
        let rentalFromStr = $('#rental_from').val();
        let rentalToStr = $('#rental_to').val();

        let rentalFrom = parseDMY(rentalFromStr);
        let rentalTo = parseDMY(rentalToStr);

        let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
        let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
        let formData = {
                is_guest: 1,
                name: $('#firstname').val(),
                surname: $('#surname').val(),
                email: $('#firstemail').val(),
                number : $('#number').val(),
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                bundle_name: selectedRecommendation?.bundle_name || '',
                color_id: $('#color-select').val(),
                color_name: $('#color-select option:selected').data('color-name'),
                size_id: $('.inner-size-card.selected').data('size-id') || $('.inner-size-card.selected').data('variation-id'),
                size_name: $('.inner-size-card.selected').data('size-name'),
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_carrier_included: $('#roof_rack_checkbox').is(':checked') ? 1 : 0,
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0
            };
        $.ajax({
            url: "<?php echo e(route('cart.add')); ?>",
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if(response.status ==  false){
                    $('#guestError')
                .removeClass('d-none')
                .text(response.message || 'Something went wrong. Please try again.');
                }else{
                    $('#guestModal').modal('hide');
                    $('#guestError').addClass('d-none');
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                }
             
                // window.location.href = '<?php echo e(route("cart.guest_time-selection")); ?>';
            }
        });
    });
});
</script>
<script>
    // $(function() {
    //     function disableWeekends(date) {
    //         const day = date.getDay();
    //         return [(day !== 0 && day !== 6), ''];
    //     }

    //     $("#rental_from, #rental_to").datepicker({
    //         dateFormat: 'yy-mm-dd',
    //         minDate: 0, 
    //         beforeShowDay: disableWeekends,
    //         onSelect: function () {
    //             var colorId = $('#color-select').val();
    //             var colorName = $('#color-select option:selected').data('color-name');
    //             if (colorId && colorId !== 'Select') {
    //                 checkAvailability(colorId,colorName);
    //             }
    //             calculateRent();
    //         }
    //     });

    // });

    $(function () {
        const holidays = <?php echo json_encode($holidays, 15, 512) ?>;
        const nonworkingDays = <?php echo json_encode($nonworkingDays, 15, 512) ?>; 
        const dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

    const closedDays = nonworkingDays.map(day => dayMap[day]);
        function disableWeekendsAndHolidays(date) {
            const day = date.getDay();
            const formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            const isWeekend = closedDays.includes(day);
            const isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        $("#rental_from").datepicker({
            dateFormat: 'dd.mm.yy',
            minDate: 0,
            firstDay: 1,
            beforeShowDay: disableWeekendsAndHolidays,
            onSelect: function (selectedDate) {
                const startDate = $(this).datepicker('getDate');
                // Set minDate of end date to startDate
                $("#rental_to").datepicker("option", "minDate", startDate);

                var colorId = $('#color-select').val();
                var colorName = $('#color-select option:selected').data('color-name');
                if (colorId && colorId !== 'Select') {
                    checkAvailability(colorId, colorName);
                }
                calculateRent();
            }
        });

        $("#rental_to").datepicker({
            dateFormat: 'dd.mm.yy',
            minDate: 0,
            firstDay: 1,
            beforeShowDay: disableWeekendsAndHolidays,
            onSelect: function () {
                var colorId = $('#color-select').val();
                var colorName = $('#color-select option:selected').data('color-name');
                if (colorId && colorId !== 'Select') {
                    checkAvailability(colorId, colorName);
                }
                calculateRent();
            }
        });
    });



</script>

<style>

.clickable-roof {
    border: 2px solid transparent;
    cursor: pointer;
    transition: 0.2s;
}
.clickable-roof:hover {
    border-color: #007bff;
}
.clickable-roof.selected {
    border-color: #007bff;
    background-color: #e9f5ff;
}

</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/pages/product/details.blade.php ENDPATH**/ ?>