<!DOCTYPE html>
<html>
<head>
    <title>Your Customer Account Details</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #f8f8f8;
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid #e7e7e7;
        }
        .content {
            padding: 20px;
        }
        .footer {
            margin-top: 20px;
            padding: 20px;
            font-size: 12px;
            color: #777;
            text-align: center;
            border-top: 1px solid #e7e7e7;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #3490dc;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>Your Account Has Been Created</h2>
    </div>
    
    <div class="content">
        <p>Hello,</p>
        
        <p>Your customer account has been successfully created with the following details:</p>
        
        <p><strong>Email:</strong> <?php echo e($email); ?></p>
        <p><strong>Temporary Password:</strong> <?php echo e($password); ?></p>
        
        <p>For security reasons, we recommend changing your password after your first login.</p>
        
        <center>
            <a href="<?php echo e(route('login')); ?>" class="button">Login to Your Account</a>
        </center>
        
        <p>If you did not request this account or need any assistance, please contact our support team.</p>
    </div>
    
    <div class="footer">
        <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        <p>
            <a href="<?php echo e(url('/privacy')); ?>">Privacy Policy</a> | 
            <a href="<?php echo e(url('/terms')); ?>">Terms of Service</a>
        </p>
    </div>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete/resources/views/email/guest-account.blade.php ENDPATH**/ ?>