<!DOCTYPE html>
<html>
<head>
    <title>Payment Link for Your Booking</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .booking-info {
            background-color: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .payment-button {
            display: inline-block;
            padding: 12px 25px;
            background-color: #6772E5;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-weight: bold;
            margin: 20px 0;
            text-align: center;
        }
        .footer {
            margin-top: 30px;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #eee;
            padding-top: 15px;
        }
        .info-item {
            margin-bottom: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Payment link for your booking at Dachboxmiete</h2>
        </div>
        
        <p>Dear <?php echo e($customer['first_name']); ?> <?php echo e($customer['last_name']); ?>,</p>
        
        <p>Thank you for your booking with Dachboxmiete!</p>
        
        <p>To complete your payment conveniently online, please use the following payment link:</p>
        
        <div style="text-align: center; margin: 25px 0;">
            <a href="<?php echo e($payment_link); ?>" style="
            display: inline-block;
            padding: 10px 20px;
            background-color: #6772E5;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-weight: bold;
            margin: 20px 0;
        " class="payment-button">PAY NOW</a>
        </div>
        
        <div class="booking-info">
            <p><strong>Please note:</strong></p>
            <p>This payment link is valid for 24 hours and will expire automatically if payment is not completed within that time.</p>
            
            <p><strong>Booking Details:</strong></p>
            <div class="info-item">• Booking Number: <?php echo e('BO' . str_pad($booking->id, 6, '0', STR_PAD_LEFT)); ?></div>
            <div class="info-item">• Booking Date: <?php echo e($booking->created_at->format('d.m.Y')); ?></div>
             <div class="info-item">• Total Amount: €<?php echo e(number_format($booking->total, 2, ',', '.')); ?></div>
        </div>
        
        <p>If the link has expired or if you experience any issues with the payment, please don't hesitate to contact us - we're happy to assist you.</p>
        
        <p>Best regards,</p>
        <p>Your Dachboxmiete Team</p>
        
        <div class="footer">
            <p>Dachboxmiete Ltd.</p>
            <p><?php echo GetMetaData('address','contact-us'); ?></p>
            <p>Email: <?php echo e(GetMetaData('email','contact-us')); ?></p>
            <p>Phone: <?php echo e(GetMetaData('number','contact-us')); ?></p>
            <p>Website: <?php echo e(env('APP_URL')); ?></p>
        </div>
    </div>
</body>
</html><?php /**PATH /var/www/html/dachboxmiete/resources/views/email/admin-booking-payment-link.blade.php ENDPATH**/ ?>