<section class="news-letter-back">
    <div class="back-imges">
        <img class="left-arow-news" src="<?php echo e(asset('frontend/images/LEFT-AROW.png')); ?>" alt="">
        <img class="right-arow-news" src="<?php echo e(asset('frontend/images/right-arrow.png')); ?>" alt="">
    </div>
    <div class="container">
        <div class="inner-news-lettr">
            <h3>Subscribe newsletter</h3>
            <p>Melde dich an für unser Newsletter, damit du unsere Angebote und Informationen zu neuen Produkten nicht verpasst.</p>
                <form class="row comm_form profile_newsletter_form" method="POST" action="<?php echo e(route('user.newsletter.subscribe')); ?>">
                    <?php echo csrf_field(); ?>
            <div class="input-subscribe p-0">
                <input type="text" name="email" placeholder="Enter your email here">
                <button type="submit" class="subscribe-btn"> Subscribe</button>
            </div>
            <div id="newsletter-error" class="text-danger text-center" style="display: none;"></div>
        </form>
        </div>
    </div>
</section>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.querySelector('.profile_newsletter_form');
        const emailInput = form.querySelector('input[name="email"]');
        const errorContainer = document.getElementById('newsletter-error');
    
        form.addEventListener('submit', function (e) {
            const emailValue = emailInput.value.trim();
    
            emailInput.classList.remove('is-invalid');
            errorContainer.style.display = 'none';
            errorContainer.textContent = '';
    
            if (!emailValue) {
                e.preventDefault();
                emailInput.classList.add('is-invalid');
                errorContainer.textContent = 'Please enter your email address';
                errorContainer.style.display = 'block';
                return;
            }
    
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(emailValue)) {
                e.preventDefault();
                emailInput.classList.add('is-invalid');
                errorContainer.textContent = 'Please enter a valid email address';
                errorContainer.style.display = 'block';
            }
        });
    });
    </script><?php /**PATH /var/www/html/dachboxmiete/resources/views/frontend/include/subscribe_news.blade.php ENDPATH**/ ?>