<?php $__env->startComponent('mail::message'); ?>
# Invoice <?php echo e($invoiceNumber); ?>


**Subject:** Your invoice for order at Dachboxit  

**Issuer Details:**  
<?php echo e($issuer['name']); ?>  
<?php echo e($issuer['address']); ?>  
Tax Number: <?php echo e($issuer['tax_number']); ?>  
VAT ID: <?php echo e($issuer['vat_number']); ?>  

**Recipient Details:**  
<?php echo e($recipient['name']); ?>  
<?php echo e($recipient['address']); ?>  
<?php echo e($recipient['zip']); ?> <?php echo e($recipient['city']); ?>  
<?php echo e($recipient['country']); ?>  

**Invoice Date:** <?php echo e($invoiceDate->format('d.m.Y')); ?>  
**Invoice Number:** <?php echo e($invoiceNumber); ?>  
**Booking Date:** <?php echo e($booking->created_at->format('d.m.Y')); ?>  

### Product Details
<?php $__env->startComponent('mail::table'); ?>
| Product          | Car Details               | Insurance | Carrier | Pickup Date & Time | Dropoff Date & Time | Quantity | Net Price |
|------------------|---------------------------|-----------|---------|--------------------|---------------------|----------|-----------|
<?php $__currentLoopData = $bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
| <?php echo e($item->product_name); ?> (<?php echo e($item->size); ?>) | <?php echo e($item->car_name); ?> <?php echo e($item->car_year); ?> <?php echo e($item->model); ?> | <?php echo e($item->is_insured ? 'Yes' : 'No'); ?> | <?php echo e($item->is_carrier_included ? 'Yes' : 'No'); ?> | <?php echo e($item->pickup_date->format('d.m.y')); ?> <?php echo e($item->pickup_time ? 'at ' . \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : ''); ?> | <?php echo e($item->dropoff_date->format('d.m.y')); ?> <?php echo e($item->dropoff_time ? 'at ' . \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : ''); ?> | 1 | <?php echo e(number_format($item->calculated_rent, 2, ',', '.')); ?>€ |
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php echo $__env->renderComponent(); ?>


### Price Overview
- **Subtotal (Net):** <?php echo e(number_format($subtotal, 2, ',', '.')); ?>€
<?php if($booking->discount > 0): ?>
- **Discount:** -<?php echo e(number_format($booking->discount, 2, ',', '.')); ?>€
<?php endif; ?>
- **VAT (19%):** <?php echo e(number_format($tax, 2, ',', '.')); ?>€
- **Total Amount:** **<?php echo e(number_format($total, 2, ',', '.')); ?>€**

**Payment Method:** <?php echo e(ucfirst($paymentMethod)); ?>  

**Terms and Conditions:**  
Please find attached our general terms and conditions, right of withdrawal, and data protection policy.  

<?php $__env->startComponent('mail::button', ['url' => route('login')]); ?>
View Your Booking
<?php echo $__env->renderComponent(); ?>

Best regards,  
The Dachboxit Team
<?php echo $__env->renderComponent(); ?><?php /**PATH /var/www/html/dachboxmiete/resources/views/email/invoice.blade.php ENDPATH**/ ?>